/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOperations$Write$;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaOptions$;
import org.apache.spark.sql.delta.DeltaWriteOptions;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Metadata$;
import org.apache.spark.sql.delta.commands.CreateDeltaTableCommand$;
import org.apache.spark.sql.delta.commands.TableCreationModes;
import org.apache.spark.sql.delta.commands.TableCreationModes$Create$;
import org.apache.spark.sql.delta.commands.TableCreationModes$CreateOrReplace$;
import org.apache.spark.sql.delta.commands.TableCreationModes$Replace$;
import org.apache.spark.sql.delta.commands.WriteIntoDelta;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005h\u0001B\u00181\u0001vB\u0001b\u0018\u0001\u0003\u0016\u0004%\t\u0001\u0019\u0005\tO\u0002\u0011\t\u0012)A\u0005C\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\tE\t\u0015!\u0003k\u0011!q\u0007A!f\u0001\n\u0003y\u0007\u0002\u0003;\u0001\u0005#\u0005\u000b\u0011\u00029\t\u0011U\u0004!Q3A\u0005\u0002YD\u0001\u0002\u001f\u0001\u0003\u0012\u0003\u0006Ia\u001e\u0005\ts\u0002\u0011)\u001a!C\u0001u\"I\u0011q\u0001\u0001\u0003\u0012\u0003\u0006Ia\u001f\u0005\u000b\u0003\u0013\u0001!Q3A\u0005\u0002\u0005-\u0001BCA\n\u0001\tE\t\u0015!\u0003\u0002\u000e!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\tI\b\u0001C\u0005\u0003wBq!!#\u0001\t\u0013\tY\tC\u0004\u0002.\u0002!I!a,\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u0011q\u001d\u0001\u0005\n\u0005%\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0005\u0013\u0001A\u0011BA\u0006\u0011%\u0011Y\u0001AA\u0001\n\u0003\u0011i\u0001C\u0005\u0003\u001c\u0001\t\n\u0011\"\u0001\u0003\u001e!I!1\u0007\u0001\u0012\u0002\u0013\u0005!Q\u0007\u0005\n\u0005s\u0001\u0011\u0013!C\u0001\u0005wA\u0011Ba\u0010\u0001#\u0003%\tA!\u0011\t\u0013\t\u0015\u0003!%A\u0005\u0002\t\u001d\u0003\"\u0003B&\u0001E\u0005I\u0011\u0001B'\u0011%\u0011\t\u0006AA\u0001\n\u0003\u0012\u0019\u0006C\u0005\u0003d\u0001\t\t\u0011\"\u0001\u0003f!I!Q\u000e\u0001\u0002\u0002\u0013\u0005!q\u000e\u0005\n\u0005w\u0002\u0011\u0011!C!\u0005{B\u0011Ba#\u0001\u0003\u0003%\tA!$\t\u0013\tE\u0005!!A\u0005B\tMu!\u0003BLa\u0005\u0005\t\u0012\u0001BM\r!y\u0003'!A\t\u0002\tm\u0005bBA\u000bK\u0011\u0005!\u0011\u0016\u0005\n\u0005W+\u0013\u0011!C#\u0005[C\u0011Ba,&\u0003\u0003%\tI!-\t\u0013\t}V%%A\u0005\u0002\t\u001d\u0003\"\u0003BaKE\u0005I\u0011\u0001B'\u0011%\u0011\u0019-JA\u0001\n\u0003\u0013)\rC\u0005\u0003T\u0016\n\n\u0011\"\u0001\u0003H!I!Q[\u0013\u0012\u0002\u0013\u0005!Q\n\u0005\n\u0005/,\u0013\u0011!C\u0005\u00053\u0014qc\u0011:fCR,G)\u001a7uCR\u000b'\r\\3D_6l\u0017M\u001c3\u000b\u0005E\u0012\u0014\u0001C2p[6\fg\u000eZ:\u000b\u0005M\"\u0014!\u00023fYR\f'BA\u001b7\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003oa\nQa\u001d9be.T!!\u000f\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0014aA8sO\u000e\u00011C\u0002\u0001?\u0011B3F\f\u0005\u0002@\r6\t\u0001I\u0003\u0002B\u0005\u00069An\\4jG\u0006d'BA\"E\u0003\u0015\u0001H.\u00198t\u0015\t)E'\u0001\u0005dCR\fG._:u\u0013\t9\u0005IA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA%O\u001b\u0005Q%BA&M\u0003\u001d\u0019w.\\7b]\u0012T!!\u0014\u001b\u0002\u0013\u0015DXmY;uS>t\u0017BA(K\u0005=\u0011VO\u001c8bE2,7i\\7nC:$\u0007CA)U\u001b\u0005\u0011&BA*3\u0003!iW\r^3sS:<\u0017BA+S\u00051!U\r\u001c;b\u0019><w-\u001b8h!\t9&,D\u0001Y\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0005\u001d\u0001&o\u001c3vGR\u0004\"aV/\n\u0005yC&\u0001D*fe&\fG.\u001b>bE2,\u0017!\u0002;bE2,W#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011$\u0015aB2bi\u0006dwnZ\u0005\u0003M\u000e\u0014AbQ1uC2|w\rV1cY\u0016\fa\u0001^1cY\u0016\u0004\u0013\u0001E3ySN$\u0018N\\4UC\ndWm\u00149u+\u0005Q\u0007cA,lC&\u0011A\u000e\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0002#\u0015D\u0018n\u001d;j]\u001e$\u0016M\u00197f\u001fB$\b%\u0001\u0003n_\u0012,W#\u00019\u0011\u0005E\u0014X\"\u0001\u001b\n\u0005M$$\u0001C*bm\u0016lu\u000eZ3\u0002\u000b5|G-\u001a\u0011\u0002\u000bE,XM]=\u0016\u0003]\u00042aV6?\u0003\u0019\tX/\u001a:zA\u0005Iq\u000e]3sCRLwN\\\u000b\u0002wB\u0019A0!\u0001\u000f\u0005utX\"\u0001\u0019\n\u0005}\u0004\u0014A\u0005+bE2,7I]3bi&|g.T8eKNLA!a\u0001\u0002\u0006\ta1I]3bi&|g.T8eK*\u0011q\u0010M\u0001\u000b_B,'/\u0019;j_:\u0004\u0013a\u0003;bE2,')\u001f)bi\",\"!!\u0004\u0011\u0007]\u000by!C\u0002\u0002\u0012a\u0013qAQ8pY\u0016\fg.\u0001\u0007uC\ndWMQ=QCRD\u0007%\u0001\u0004=S:LGO\u0010\u000b\u000f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121EA\u0013!\ti\b\u0001C\u0003`\u001b\u0001\u0007\u0011\rC\u0003i\u001b\u0001\u0007!\u000eC\u0003o\u001b\u0001\u0007\u0001\u000fC\u0003v\u001b\u0001\u0007q\u000fC\u0004z\u001bA\u0005\t\u0019A>\t\u0013\u0005%Q\u0002%AA\u0002\u00055\u0011a\u0001:v]R!\u00111FA%!\u0019\ti#!\u0010\u0002D9!\u0011qFA\u001d\u001d\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001by\u00051AH]8pizJ\u0011!W\u0005\u0004\u0003wA\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u007f\t\tEA\u0002TKFT1!a\u000fY!\r\t\u0018QI\u0005\u0004\u0003\u000f\"$a\u0001*po\"9\u00111\n\bA\u0002\u00055\u0013\u0001D:qCJ\\7+Z:tS>t\u0007cA9\u0002P%\u0019\u0011\u0011\u000b\u001b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002'\u001d,G\u000f\u0015:pm&$W\rZ'fi\u0006$\u0017\r^1\u0015\r\u0005]\u00131MA3!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/e\u00059\u0011m\u0019;j_:\u001c\u0018\u0002BA1\u00037\u0012\u0001\"T3uC\u0012\fG/\u0019\u0005\u0006?>\u0001\r!\u0019\u0005\b\u0003Oz\u0001\u0019AA5\u00031\u00198\r[3nCN#(/\u001b8h!\u0011\tY'a\u001d\u000f\t\u00055\u0014q\u000e\t\u0004\u0003cA\u0016bAA91\u00061\u0001K]3eK\u001aLA!!\u001e\u0002x\t11\u000b\u001e:j]\u001eT1!!\u001dY\u0003=\t7o]3siB\u000bG\u000f[#naRLHCBA?\u0003\u0007\u000b)\tE\u0002X\u0003\u007fJ1!!!Y\u0005\u0011)f.\u001b;\t\u000f\u0005-\u0003\u00031\u0001\u0002N!1\u0011q\u0011\tA\u0002\u0005\f\u0011\u0003^1cY\u0016<\u0016\u000e\u001e5M_\u000e\fG/[8o\u0003a\t7o]3siR\u000b'\r\\3TG\",W.\u0019#fM&tW\r\u001a\u000b\u000b\u0003{\ni)a(\u0002*\u0006-\u0006bBAH#\u0001\u0007\u0011\u0011S\u0001\u0003MN\u0004B!a%\u0002\u001c6\u0011\u0011Q\u0013\u0006\u0005\u0003\u001f\u000b9JC\u0002\u0002\u001ab\na\u0001[1e_>\u0004\u0018\u0002BAO\u0003+\u0013!BR5mKNK8\u000f^3n\u0011\u001d\t\t+\u0005a\u0001\u0003G\u000bA\u0001]1uQB!\u00111SAS\u0013\u0011\t9+!&\u0003\tA\u000bG\u000f\u001b\u0005\u0006?F\u0001\r!\u0019\u0005\b\u0003\u0017\n\u0002\u0019AA'\u0003M1XM]5gsR\u000b'\r\\3NKR\fG-\u0019;b)\u0019\ti(!-\u0002>\"9\u00111\u0017\nA\u0002\u0005U\u0016a\u0001;y]B!\u0011qWA]\u001b\u0005\u0011\u0014bAA^e\t)r\n\u001d;j[&\u001cH/[2Ue\u0006t7/Y2uS>t\u0007BBA`%\u0001\u0007\u0011-A\u0005uC\ndW\rR3tG\u0006aq-\u001a;Pa\u0016\u0014\u0018\r^5p]RA\u0011QYAj\u0003/\fY\u000e\u0005\u0003\u0002H\u00065g\u0002BA\\\u0003\u0013L1!a33\u0003=!U\r\u001c;b\u001fB,'/\u0019;j_:\u001c\u0018\u0002BAh\u0003#\u0014\u0011b\u00149fe\u0006$\u0018n\u001c8\u000b\u0007\u0005-'\u0007C\u0004\u0002VN\u0001\r!a\u0016\u0002\u00115,G/\u00193bi\u0006Dq!!7\u0014\u0001\u0004\ti!\u0001\bjg6\u000bg.Y4fIR\u000b'\r\\3\t\u000f\u0005u7\u00031\u0001\u0002`\u00069q\u000e\u001d;j_:\u001c\b\u0003B,l\u0003C\u0004B!a.\u0002d&\u0019\u0011Q\u001d\u001a\u0003\u0019\u0011+G\u000e^1PaRLwN\\:\u0002\u001bU\u0004H-\u0019;f\u0007\u0006$\u0018\r\\8h)\u0019\ti(a;\u0002n\"1q\u0007\u0006a\u0001\u0003\u001bBQa\u0018\u000bA\u0002\u0005\f!D]3qY\u0006\u001cW-T3uC\u0012\fG/Y%g\u001d\u0016\u001cWm]:bef$\"\"! \u0002t\u0006U\u0018q_A}\u0011\u001d\t\u0019,\u0006a\u0001\u0003kCa!a0\u0016\u0001\u0004\t\u0007bBAo+\u0001\u0007\u0011\u0011\u001d\u0005\b\u0003w,\u0002\u0019AA\u007f\u0003\u0019\u00198\r[3nCB!\u0011q B\u0003\u001b\t\u0011\tAC\u0002\u0003\u0004Q\nQ\u0001^=qKNLAAa\u0002\u0003\u0002\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0015%\u001ch+M,sSR,'/\u0001\u0003d_BLHCDA\r\u0005\u001f\u0011\tBa\u0005\u0003\u0016\t]!\u0011\u0004\u0005\b?^\u0001\n\u00111\u0001b\u0011\u001dAw\u0003%AA\u0002)DqA\\\f\u0011\u0002\u0003\u0007\u0001\u000fC\u0004v/A\u0005\t\u0019A<\t\u000fe<\u0002\u0013!a\u0001w\"I\u0011\u0011B\f\u0011\u0002\u0003\u0007\u0011QB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yBK\u0002b\u0005CY#Aa\t\u0011\t\t\u0015\"qF\u0007\u0003\u0005OQAA!\u000b\u0003,\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005[A\u0016AC1o]>$\u0018\r^5p]&!!\u0011\u0007B\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119DK\u0002k\u0005C\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003>)\u001a\u0001O!\t\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\t\u0016\u0004o\n\u0005\u0012AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0005\u0013R3a\u001fB\u0011\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"Aa\u0014+\t\u00055!\u0011E\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tU\u0003\u0003\u0002B,\u0005Cj!A!\u0017\u000b\t\tm#QL\u0001\u0005Y\u0006twM\u0003\u0002\u0003`\u0005!!.\u0019<b\u0013\u0011\t)H!\u0017\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t\u001d\u0004cA,\u0003j%\u0019!1\u000e-\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tE$q\u000f\t\u0004/\nM\u0014b\u0001B;1\n\u0019\u0011I\\=\t\u0013\te\u0004%!AA\u0002\t\u001d\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0000A1!\u0011\u0011BD\u0005cj!Aa!\u000b\u0007\t\u0015\u0005,\u0001\u0006d_2dWm\u0019;j_:LAA!#\u0003\u0004\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tiAa$\t\u0013\te$%!AA\u0002\tE\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002\u000e\tU\u0005\"\u0003B=G\u0005\u0005\t\u0019\u0001B9\u0003]\u0019%/Z1uK\u0012+G\u000e^1UC\ndWmQ8n[\u0006tG\r\u0005\u0002~KM!QE!(]!5\u0011yJ!*bUB<80!\u0004\u0002\u001a5\u0011!\u0011\u0015\u0006\u0004\u0005GC\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005O\u0013\tKA\tBEN$(/Y2u\rVt7\r^5p]Z\"\"A!'\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001d\u0005e!1\u0017B[\u0005o\u0013ILa/\u0003>\")q\f\u000ba\u0001C\")\u0001\u000e\u000ba\u0001U\")a\u000e\u000ba\u0001a\")Q\u000f\u000ba\u0001o\"9\u0011\u0010\u000bI\u0001\u0002\u0004Y\b\"CA\u0005QA\u0005\t\u0019AA\u0007\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\u0002\u000fUt\u0017\r\u001d9msR!!q\u0019Bh!\u001196N!3\u0011\u0015]\u0013Y-\u00196qon\fi!C\u0002\u0003Nb\u0013a\u0001V;qY\u00164\u0004\"\u0003BiW\u0005\u0005\t\u0019AA\r\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tm\u0007\u0003\u0002B,\u0005;LAAa8\u0003Z\t1qJ\u00196fGR\u0004")
public class CreateDeltaTableCommand
extends LogicalPlan
implements RunnableCommand,
DeltaLogging,
scala.Serializable {
    private final CatalogTable table;
    private final Option<CatalogTable> existingTableOpt;
    private final SaveMode mode;
    private final Option<LogicalPlan> query;
    private final TableCreationModes.CreationMode operation;
    private final boolean tableByPath;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$6() {
        return CreateDeltaTableCommand$.MODULE$.$lessinit$greater$default$6();
    }

    public static TableCreationModes.CreationMode $lessinit$greater$default$5() {
        return CreateDeltaTableCommand$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Tuple6<CatalogTable, Option<CatalogTable>, SaveMode, Option<LogicalPlan>, TableCreationModes.CreationMode, Object>> unapply(CreateDeltaTableCommand createDeltaTableCommand) {
        return CreateDeltaTableCommand$.MODULE$.unapply(createDeltaTableCommand);
    }

    public static boolean apply$default$6() {
        return CreateDeltaTableCommand$.MODULE$.apply$default$6();
    }

    public static TableCreationModes.CreationMode apply$default$5() {
        return CreateDeltaTableCommand$.MODULE$.apply$default$5();
    }

    public static Function1<Tuple6<CatalogTable, Option<CatalogTable>, SaveMode, Option<LogicalPlan>, TableCreationModes.CreationMode, Object>, CreateDeltaTableCommand> tupled() {
        return CreateDeltaTableCommand$.MODULE$.tupled();
    }

    public static Function1<CatalogTable, Function1<Option<CatalogTable>, Function1<SaveMode, Function1<Option<LogicalPlan>, Function1<TableCreationModes.CreationMode, Function1<Object, CreateDeltaTableCommand>>>>>> curried() {
        return CreateDeltaTableCommand$.MODULE$.curried();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CreateDeltaTableCommand createDeltaTableCommand = this;
        synchronized (createDeltaTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public CatalogTable table() {
        return this.table;
    }

    public Option<CatalogTable> existingTableOpt() {
        return this.existingTableOpt;
    }

    public SaveMode mode() {
        return this.mode;
    }

    public Option<LogicalPlan> query() {
        return this.query;
    }

    public TableCreationModes.CreationMode operation() {
        return this.operation;
    }

    public boolean tableByPath() {
        return this.tableByPath;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        CatalogTable catalogTable;
        CatalogTableType catalogTableType = this.table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        Predef$.MODULE$.assert(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2));
        Predef$.MODULE$.assert(this.table().identifier().database().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Database should've been fixed at analysis");
        boolean tableExists = this.existingTableOpt().isDefined();
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Ignore;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && tableExists) {
            return Nil$.MODULE$;
        }
        SaveMode saveMode3 = this.mode();
        SaveMode saveMode4 = SaveMode.ErrorIfExists;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && tableExists) {
            throw new AnalysisException(new StringBuilder(22).append("Table ").append(this.table().identifier().quotedString()).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (tableExists) {
            CatalogTable existingTable = (CatalogTable)this.existingTableOpt().get();
            Option option = this.table().storage().locationUri();
            if (option instanceof Some) {
                Some some = (Some)option;
                URI location = (URI)some.value();
                String string = location.getPath();
                String string2 = existingTable.location().getPath();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String tableName = this.table().identifier().quotedString();
                    throw new AnalysisException(new StringBuilder(86).append("The location of the existing table ").append(tableName).append(" is ").append("`").append(existingTable.location()).append("`. It doesn't match the specified location ").append("`").append(this.table().location()).append("`.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            CatalogStorageFormat x$1 = existingTable.storage();
            CatalogTableType x$2 = existingTable.tableType();
            TableIdentifier x$3 = this.table().copy$default$1();
            StructType x$4 = this.table().copy$default$4();
            Option x$5 = this.table().copy$default$5();
            Seq x$6 = this.table().copy$default$6();
            Option x$7 = this.table().copy$default$7();
            String x$8 = this.table().copy$default$8();
            long x$9 = this.table().copy$default$9();
            long x$10 = this.table().copy$default$10();
            String x$11 = this.table().copy$default$11();
            Map x$12 = this.table().copy$default$12();
            Option x$13 = this.table().copy$default$13();
            Option x$14 = this.table().copy$default$14();
            Option x$15 = this.table().copy$default$15();
            Seq x$16 = this.table().copy$default$16();
            boolean x$17 = this.table().copy$default$17();
            boolean x$18 = this.table().copy$default$18();
            Map x$19 = this.table().copy$default$19();
            Option x$20 = this.table().copy$default$20();
            catalogTable = this.table().copy(x$3, x$2, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        } else if (this.table().storage().locationUri().isEmpty()) {
            CatalogTableType catalogTableType3 = this.table().tableType();
            CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.MANAGED();
            Predef$.MODULE$.assert(!(catalogTableType3 != null ? !catalogTableType3.equals(catalogTableType4) : catalogTableType4 != null));
            URI loc = sparkSession.sessionState().catalog().defaultTablePath(this.table().identifier());
            CatalogStorageFormat x$21 = this.table().storage().copy((Option)new Some((Object)loc), this.table().storage().copy$default$2(), this.table().storage().copy$default$3(), this.table().storage().copy$default$4(), this.table().storage().copy$default$5(), this.table().storage().copy$default$6());
            TableIdentifier x$22 = this.table().copy$default$1();
            CatalogTableType x$23 = this.table().copy$default$2();
            StructType x$24 = this.table().copy$default$4();
            Option x$25 = this.table().copy$default$5();
            Seq x$26 = this.table().copy$default$6();
            Option x$27 = this.table().copy$default$7();
            String x$28 = this.table().copy$default$8();
            long x$29 = this.table().copy$default$9();
            long x$30 = this.table().copy$default$10();
            String x$31 = this.table().copy$default$11();
            Map x$32 = this.table().copy$default$12();
            Option x$33 = this.table().copy$default$13();
            Option x$34 = this.table().copy$default$14();
            Option x$35 = this.table().copy$default$15();
            Seq x$36 = this.table().copy$default$16();
            boolean x$37 = this.table().copy$default$17();
            boolean x$38 = this.table().copy$default$18();
            Map x$39 = this.table().copy$default$19();
            Option x$40 = this.table().copy$default$20();
            catalogTable = this.table().copy(x$22, x$23, x$21, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
        } else {
            CatalogTableType catalogTableType5 = this.table().tableType();
            CatalogTableType catalogTableType6 = CatalogTableType$.MODULE$.EXTERNAL();
            Predef$.MODULE$.assert(!(catalogTableType5 != null ? !catalogTableType5.equals(catalogTableType6) : catalogTableType6 != null));
            catalogTable = this.table();
        }
        CatalogTable tableWithLocation = catalogTable;
        CatalogTableType catalogTableType7 = tableWithLocation.tableType();
        CatalogTableType catalogTableType8 = CatalogTableType$.MODULE$.MANAGED();
        boolean isManagedTable = !(catalogTableType7 != null ? !catalogTableType7.equals(catalogTableType8) : catalogTableType8 != null);
        Path tableLocation = new Path(tableWithLocation.location());
        FileSystem fs = tableLocation.getFileSystem(sparkSession.sessionState().newHadoopConf());
        DeltaLog deltaLog = DeltaLog$.MODULE$.forTable(sparkSession, tableLocation);
        DeltaOptions options = new DeltaOptions((Map<String, String>)this.table().storage().properties(), sparkSession.sessionState().conf());
        return (Seq)this.recordDeltaOperation(deltaLog, "delta.ddl.createTable", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
            block16: {
                Object object;
                Object object2;
                OptimisticTransaction txn;
                block13: {
                    block15: {
                        block14: {
                            txn = deltaLog.startTransaction();
                            if (!this.query().isDefined()) break block13;
                            SaveMode saveMode = this.mode();
                            SaveMode saveMode2 = SaveMode.Ignore;
                            if (!(saveMode == null ? saveMode2 != null : !saveMode.equals(saveMode2))) break block14;
                            SaveMode saveMode3 = this.mode();
                            SaveMode saveMode4 = SaveMode.ErrorIfExists;
                            if (saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) break block15;
                        }
                        Predef$.MODULE$.assert(!tableExists);
                        if (txn.readVersion() > -1L || !fs.exists(deltaLog.logPath())) {
                            this.assertPathEmpty(sparkSession, tableWithLocation);
                        }
                    }
                    if (this.query().get() instanceof RunnableCommand) {
                        object2 = ((RunnableCommand)this.query().get()).run(sparkSession);
                    } else {
                        Dataset data = Dataset$.MODULE$.ofRows(sparkSession, (LogicalPlan)this.query().get());
                        if (!this.isV1Writer()) {
                            this.replaceMetadataIfNecessary(txn, tableWithLocation, options, ((QueryPlan)this.query().get()).schema().asNullable());
                        }
                        Seq<Action> actions = new WriteIntoDelta(deltaLog, this.mode(), options, (Seq<String>)this.table().partitionColumnNames(), (Map<String, String>)this.table().properties(), (Dataset<Row>)data).write(txn, sparkSession);
                        DeltaOperations.Operation op = this.getOperation(txn.metadata(), isManagedTable, (Option<DeltaOptions>)new Some((Object)options));
                        object2 = BoxesRunTime.boxToLong((long)txn.commit(actions, op));
                    }
                    break block16;
                }
                TableCreationModes.CreationMode creationMode = this.operation();
                if (TableCreationModes$Create$.MODULE$.equals(creationMode)) {
                    Predef$.MODULE$.require(!tableExists, (Function0 & Serializable & scala.Serializable)() -> "Can't recreate a table when it exists");
                    this.createTransactionLogOrVerify$1(isManagedTable, sparkSession, tableWithLocation, txn, fs, tableLocation);
                    object = BoxedUnit.UNIT;
                } else if (TableCreationModes$CreateOrReplace$.MODULE$.equals(creationMode) && !tableExists) {
                    if (tableWithLocation.schema().isEmpty()) {
                        throw DeltaErrors$.MODULE$.schemaNotProvidedException();
                    }
                    this.createTransactionLogOrVerify$1(isManagedTable, sparkSession, tableWithLocation, txn, fs, tableLocation);
                    object = BoxedUnit.UNIT;
                } else {
                    if (tableWithLocation.schema().isEmpty()) {
                        throw DeltaErrors$.MODULE$.schemaNotProvidedException();
                    }
                    this.replaceMetadataIfNecessary(txn, tableWithLocation, options, tableWithLocation.schema());
                    long operationTimestamp = System.currentTimeMillis();
                    Seq removes = (Seq)txn.filterFiles().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.removeWithTimestamp(operationTimestamp, x$1.removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
                    DeltaOperations.Operation op = this.getOperation(txn.metadata(), isManagedTable, (Option<DeltaOptions>)None$.MODULE$);
                    object = BoxesRunTime.boxToLong((long)txn.commit((Seq<Action>)removes, op));
                }
                object2 = object;
            }
            StructType x$41 = new StructType();
            Nil$ x$42 = Nil$.MODULE$;
            boolean x$43 = true;
            TableIdentifier x$44 = tableWithLocation.copy$default$1();
            CatalogTableType x$45 = tableWithLocation.copy$default$2();
            CatalogStorageFormat x$46 = tableWithLocation.copy$default$3();
            Option x$47 = tableWithLocation.copy$default$5();
            Option x$48 = tableWithLocation.copy$default$7();
            String x$49 = tableWithLocation.copy$default$8();
            long x$50 = tableWithLocation.copy$default$9();
            long x$51 = tableWithLocation.copy$default$10();
            String x$52 = tableWithLocation.copy$default$11();
            Map x$53 = tableWithLocation.copy$default$12();
            Option x$54 = tableWithLocation.copy$default$13();
            Option x$55 = tableWithLocation.copy$default$14();
            Option x$56 = tableWithLocation.copy$default$15();
            Seq x$57 = tableWithLocation.copy$default$16();
            boolean x$58 = tableWithLocation.copy$default$18();
            Map x$59 = tableWithLocation.copy$default$19();
            Option x$60 = tableWithLocation.copy$default$20();
            CatalogTable tableWithDefaultOptions = tableWithLocation.copy(x$44, x$45, x$46, x$41, x$47, (Seq)x$42, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$43, x$58, x$59, x$60);
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Table is path-based table: ").append(this.tableByPath()).append(". Update catalog with mode: ").append(this.operation()).toString());
            this.updateCatalog(sparkSession, tableWithDefaultOptions);
            return Nil$.MODULE$;
        });
    }

    private Metadata getProvidedMetadata(CatalogTable table, String schemaString) {
        String x$1 = (String)table.comment().orNull(Predef$.MODULE$.$conforms());
        String x$2 = schemaString;
        Seq x$3 = table.partitionColumnNames();
        Map x$4 = table.properties();
        String x$5 = Metadata$.MODULE$.apply$default$1();
        String x$6 = Metadata$.MODULE$.apply$default$2();
        Format x$7 = Metadata$.MODULE$.apply$default$4();
        Option<Object> x$8 = Metadata$.MODULE$.apply$default$8();
        return new Metadata(x$5, x$6, x$1, x$7, x$2, (Seq<String>)x$3, (Map<String, String>)x$4, x$8);
    }

    private void assertPathEmpty(SparkSession sparkSession, CatalogTable tableWithLocation) {
        Path path = new Path(tableWithLocation.location());
        FileSystem fs = path.getFileSystem(sparkSession.sessionState().newHadoopConf());
        if (fs.exists(path) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path))).nonEmpty()) {
            throw new AnalysisException(new StringBuilder(68).append("Cannot create table ('").append(tableWithLocation.identifier()).append("').").append(" The associated location ('").append(tableWithLocation.location()).append("') is not empty.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertTableSchemaDefined(FileSystem fs, Path path, CatalogTable table, SparkSession sparkSession) {
        if (table.schema().isEmpty()) {
            CatalogTableType catalogTableType = table.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                if (fs.exists(path) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path))).nonEmpty()) {
                    throw DeltaErrors$.MODULE$.createExternalTableWithoutLogException(path, table.identifier().quotedString(), sparkSession);
                }
                throw DeltaErrors$.MODULE$.createExternalTableWithoutSchemaException(path, table.identifier().quotedString(), sparkSession);
            }
            throw DeltaErrors$.MODULE$.createManagedTableWithoutSchemaException(table.identifier().quotedString(), sparkSession);
        }
    }

    private void verifyTableMetadata(OptimisticTransaction txn, CatalogTable tableDesc) {
        Metadata existingMetadata = txn.metadata();
        Path path = new Path(tableDesc.location());
        if (txn.readVersion() > -1L) {
            Seq<String> differences;
            if (tableDesc.schema().nonEmpty() && (differences = SchemaUtils$.MODULE$.reportDifferences(existingMetadata.schema(), tableDesc.schema())).nonEmpty()) {
                throw DeltaErrors$.MODULE$.createTableWithDifferentSchemaException(path, tableDesc.schema(), existingMetadata.schema(), differences);
            }
            if (tableDesc.schema().nonEmpty()) {
                Seq seq = tableDesc.partitionColumnNames();
                Seq<String> seq2 = existingMetadata.partitionColumns();
                if (seq == null ? seq2 != null : !seq.equals(seq2)) {
                    throw DeltaErrors$.MODULE$.createTableWithDifferentPartitioningException(path, (Seq<String>)tableDesc.partitionColumnNames(), existingMetadata.partitionColumns());
                }
            }
            if (tableDesc.properties().nonEmpty()) {
                Map map = tableDesc.properties();
                Map<String, String> map2 = existingMetadata.configuration();
                if (map == null ? map2 != null : !map.equals(map2)) {
                    throw DeltaErrors$.MODULE$.createTableWithDifferentPropertiesException(path, (Map<String, String>)tableDesc.properties(), existingMetadata.configuration());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private DeltaOperations.Operation getOperation(Metadata metadata, boolean isManagedTable, Option<DeltaOptions> options) {
        void var4_14;
        boolean bl = false;
        TableCreationModes.CreationMode creationMode = null;
        boolean bl2 = false;
        TableCreationModes.CreationMode creationMode2 = null;
        TableCreationModes.CreationMode creationMode3 = this.operation();
        if (TableCreationModes$Create$.MODULE$.equals(creationMode3)) {
            bl = true;
            creationMode = creationMode3;
            if (this.existingTableOpt().isDefined() && this.query().isDefined()) {
                DeltaOperations.Write write = new DeltaOperations.Write(this.mode(), (Option<Seq<String>>)Option$.MODULE$.apply((Object)this.table().partitionColumnNames()), ((DeltaWriteOptions)options.get()).replaceWhere(), DeltaOperations$Write$.MODULE$.apply$default$4());
                return var4_14;
            }
        }
        if (bl) {
            DeltaOperations.CreateTable createTable = new DeltaOperations.CreateTable(metadata, isManagedTable, this.query().isDefined());
            return var4_14;
        }
        if (TableCreationModes$Replace$.MODULE$.equals(creationMode3)) {
            DeltaOperations.ReplaceTable replaceTable = new DeltaOperations.ReplaceTable(metadata, isManagedTable, false, this.query().isDefined());
            return var4_14;
        }
        if (TableCreationModes$CreateOrReplace$.MODULE$.equals(creationMode3)) {
            bl2 = true;
            creationMode2 = creationMode3;
            if (options.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CreateDeltaTableCommand.$anonfun$getOperation$1(x$2)))) {
                DeltaOperations.Write write = new DeltaOperations.Write(this.mode(), (Option<Seq<String>>)Option$.MODULE$.apply((Object)this.table().partitionColumnNames()), ((DeltaWriteOptions)options.get()).replaceWhere(), DeltaOperations$Write$.MODULE$.apply$default$4());
                return var4_14;
            }
        }
        if (!bl2) throw new MatchError((Object)creationMode3);
        DeltaOperations.ReplaceTable replaceTable = new DeltaOperations.ReplaceTable(metadata, isManagedTable, true, this.query().isDefined());
        return var4_14;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateCatalog(SparkSession spark, CatalogTable table) {
        boolean bl = false;
        TableCreationModes.CreationMode creationMode = null;
        boolean bl2 = false;
        TableCreationModes.CreationMode creationMode2 = null;
        TableCreationModes.CreationMode creationMode3 = this.operation();
        if (this.tableByPath()) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (TableCreationModes$Create$.MODULE$.equals(creationMode3)) {
            spark.sessionState().catalog().createTable(table, this.existingTableOpt().isDefined(), false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (TableCreationModes$Replace$.MODULE$.equals(creationMode3)) {
            bl = true;
            creationMode = creationMode3;
            if (this.existingTableOpt().isDefined()) {
                spark.sessionState().catalog().alterTable(table);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            Identifier ident = Identifier.of((String[])((String[])Option$.MODULE$.option2Iterable(table.identifier().database()).toArray(ClassTag$.MODULE$.apply(String.class))), (String)table.identifier().table());
            throw new CannotReplaceMissingTableException(ident, CannotReplaceMissingTableException$.MODULE$.$lessinit$greater$default$2());
        }
        if (TableCreationModes$CreateOrReplace$.MODULE$.equals(creationMode3)) {
            bl2 = true;
            creationMode2 = creationMode3;
            if (this.existingTableOpt().isDefined()) {
                spark.sessionState().catalog().alterTable(table);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (!bl2) throw new MatchError((Object)creationMode3);
        spark.sessionState().catalog().createTable(table, false, false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    private void replaceMetadataIfNecessary(OptimisticTransaction txn, CatalogTable tableDesc, DeltaOptions options, StructType schema) {
        block3: {
            v0 = this.operation();
            var6_5 = TableCreationModes$CreateOrReplace$.MODULE$;
            if (!(v0 == null ? var6_5 != null : v0.equals(var6_5) == false)) ** GOTO lbl-1000
            v1 = this.operation();
            var7_6 = TableCreationModes$Replace$.MODULE$;
            if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            isReplace = v2;
            v3 = dontOverwriteSchema = options.options().contains(DeltaOptions$.MODULE$.OVERWRITE_SCHEMA_OPTION()) != false && options.canOverwriteSchema() == false;
            if (isReplace && dontOverwriteSchema) {
                throw DeltaErrors$.MODULE$.illegalUsageException(DeltaOptions$.MODULE$.OVERWRITE_SCHEMA_OPTION(), "replacing");
            }
            if (txn.readVersion() <= -1L || !isReplace || dontOverwriteSchema) break block3;
            txn.updateMetadataForNewTable(this.getProvidedMetadata(this.table(), schema.json()));
        }
    }

    private boolean isV1Writer() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace())).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CreateDeltaTableCommand.$anonfun$isV1Writer$1(x$3)));
    }

    public CreateDeltaTableCommand copy(CatalogTable table, Option<CatalogTable> existingTableOpt, SaveMode mode, Option<LogicalPlan> query, TableCreationModes.CreationMode operation, boolean tableByPath) {
        return new CreateDeltaTableCommand(table, existingTableOpt, mode, query, operation, tableByPath);
    }

    public CatalogTable copy$default$1() {
        return this.table();
    }

    public Option<CatalogTable> copy$default$2() {
        return this.existingTableOpt();
    }

    public SaveMode copy$default$3() {
        return this.mode();
    }

    public Option<LogicalPlan> copy$default$4() {
        return this.query();
    }

    public TableCreationModes.CreationMode copy$default$5() {
        return this.operation();
    }

    public boolean copy$default$6() {
        return this.tableByPath();
    }

    public String productPrefix() {
        return "CreateDeltaTableCommand";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.existingTableOpt();
                break;
            }
            case 2: {
                object = this.mode();
                break;
            }
            case 3: {
                object = this.query();
                break;
            }
            case 4: {
                object = this.operation();
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.tableByPath());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateDeltaTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateDeltaTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateDeltaTableCommand createDeltaTableCommand = (CreateDeltaTableCommand)x$1;
        CatalogTable catalogTable = this.table();
        CatalogTable catalogTable2 = createDeltaTableCommand.table();
        if (catalogTable == null) {
            if (catalogTable2 != null) {
                return false;
            }
        } else if (!catalogTable.equals(catalogTable2)) return false;
        Option<CatalogTable> option = this.existingTableOpt();
        Option<CatalogTable> option2 = createDeltaTableCommand.existingTableOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = createDeltaTableCommand.mode();
        if (saveMode == null) {
            if (saveMode2 != null) {
                return false;
            }
        } else if (!saveMode.equals(saveMode2)) return false;
        Option<LogicalPlan> option3 = this.query();
        Option<LogicalPlan> option4 = createDeltaTableCommand.query();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        TableCreationModes.CreationMode creationMode = this.operation();
        TableCreationModes.CreationMode creationMode2 = createDeltaTableCommand.operation();
        if (creationMode == null) {
            if (creationMode2 != null) {
                return false;
            }
        } else if (!creationMode.equals(creationMode2)) return false;
        if (this.tableByPath() != createDeltaTableCommand.tableByPath()) return false;
        if (!createDeltaTableCommand.canEqual(this)) return false;
        return true;
    }

    private final void createTransactionLogOrVerify$1(boolean isManagedTable$1, SparkSession sparkSession$1, CatalogTable tableWithLocation$1, OptimisticTransaction txn$1, FileSystem fs$1, Path tableLocation$1) {
        boolean noExistingMetadata;
        if (isManagedTable$1) {
            this.assertPathEmpty(sparkSession$1, tableWithLocation$1);
        }
        boolean bl = noExistingMetadata = txn$1.readVersion() == -1L || txn$1.metadata().schema().isEmpty();
        if (noExistingMetadata) {
            this.assertTableSchemaDefined(fs$1, tableLocation$1, tableWithLocation$1, sparkSession$1);
            this.assertPathEmpty(sparkSession$1, tableWithLocation$1);
            Metadata newMetadata = this.getProvidedMetadata(this.table(), this.table().schema().json());
            txn$1.updateMetadataForNewTable(newMetadata);
            DeltaOperations.Operation op = this.getOperation(newMetadata, isManagedTable$1, (Option<DeltaOptions>)None$.MODULE$);
            txn$1.commit((Seq<Action>)Nil$.MODULE$, op);
        } else {
            this.verifyTableMetadata(txn$1, tableWithLocation$1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getOperation$1(DeltaOptions x$2) {
        return x$2.replaceWhere().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$isV1Writer$1(StackTraceElement x$3) {
        return x$3.toString().contains(new StringBuilder(1).append(DataFrameWriter.class.getCanonicalName()).append(".").toString());
    }

    public CreateDeltaTableCommand(CatalogTable table, Option<CatalogTable> existingTableOpt, SaveMode mode, Option<LogicalPlan> query, TableCreationModes.CreationMode operation, boolean tableByPath) {
        this.table = table;
        this.existingTableOpt = existingTableOpt;
        this.mode = mode;
        this.query = query;
        this.operation = operation;
        this.tableByPath = tableByPath;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }
}

