/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import com.fasterxml.jackson.module.scala.ScalaObjectMapper;
import java.io.Serializable;
import org.apache.spark.sql.delta.sources.DeltaSourceOffset;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple5;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class DeltaSourceOffset$
implements scala.Serializable {
    public static DeltaSourceOffset$ MODULE$;
    private final int VERSION;

    static {
        new DeltaSourceOffset$();
    }

    public int VERSION() {
        return this.VERSION;
    }

    public DeltaSourceOffset apply(String reservoirId, long reservoirVersion, long index, boolean isStartingVersion) {
        return new DeltaSourceOffset(this.VERSION(), reservoirId, reservoirVersion, index, isStartingVersion);
    }

    public DeltaSourceOffset apply(String reservoirId, Offset offset) {
        DeltaSourceOffset deltaSourceOffset;
        Offset offset2 = offset;
        if (offset2 instanceof DeltaSourceOffset) {
            DeltaSourceOffset deltaSourceOffset2;
            deltaSourceOffset = deltaSourceOffset2 = (DeltaSourceOffset)offset2;
        } else if (offset2 instanceof SerializedOffset) {
            SerializedOffset serializedOffset = (SerializedOffset)offset2;
            this.validateSourceVersion(serializedOffset.json());
            DeltaSourceOffset o = (DeltaSourceOffset)((Object)((ScalaObjectMapper)JsonUtils$.MODULE$.mapper()).readValue(serializedOffset.json(), ManifestFactory$.MODULE$.classType(DeltaSourceOffset.class)));
            String string = o.reservoirId();
            String string2 = reservoirId;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalStateException(new StringBuilder(86).append("Delta table ").append(o.reservoirId()).append(" doesn't exist. ").append("Please delete your streaming query checkpoint and restart.").toString());
            }
            deltaSourceOffset = o;
        } else {
            throw new MatchError((Object)offset2);
        }
        return deltaSourceOffset;
    }

    private void validateSourceVersion(String json) {
        JsonAST.JValue parsedJson = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Option versionOpt = this.jsonOption(package$.MODULE$.jvalue2monadic(parsedJson).$bslash("sourceVersion")).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)DeltaSourceOffset$.$anonfun$validateSourceVersion$1(x0$1)));
        if (versionOpt.isEmpty()) {
            throw new IllegalStateException(new StringBuilder(31).append("Cannot find 'sourceVersion' in ").append(json).toString());
        }
        if (BoxesRunTime.unboxToLong((Object)versionOpt.get()) > (long)this.VERSION()) {
            throw new IllegalStateException(new StringBuilder(77).append("Unsupported format. Expected version is ").append(this.VERSION()).append(" ").append("but was ").append(versionOpt.get()).append(". Please upgrade your Spark.").toString());
        }
    }

    private Option<JsonAST.JValue> jsonOption(JsonAST.JValue json) {
        None$ none$;
        JsonAST.JValue jValue = json;
        JsonAST.JNothing$ jNothing$ = package$.MODULE$.JNothing();
        JsonAST.JValue jValue2 = jValue;
        if (!(jNothing$ != null ? !jNothing$.equals(jValue2) : jValue2 != null)) {
            none$ = None$.MODULE$;
        } else if (jValue != null) {
            JsonAST.JValue jValue3 = jValue;
            none$ = new Some((Object)jValue3);
        } else {
            throw new MatchError((Object)jValue);
        }
        return none$;
    }

    public DeltaSourceOffset apply(long sourceVersion, String reservoirId, long reservoirVersion, long index, boolean isStartingVersion) {
        return new DeltaSourceOffset(sourceVersion, reservoirId, reservoirVersion, index, isStartingVersion);
    }

    public Option<Tuple5<Object, String, Object, Object, Object>> unapply(DeltaSourceOffset x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)x$0.sourceVersion()), (Object)x$0.reservoirId(), (Object)BoxesRunTime.boxToLong((long)x$0.reservoirVersion()), (Object)BoxesRunTime.boxToLong((long)x$0.index()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isStartingVersion())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ long $anonfun$validateSourceVersion$1(JsonAST.JValue x0$1) {
        JsonAST.JValue jValue = x0$1;
        if (!(jValue instanceof JsonAST.JInt)) {
            throw new IllegalStateException(new StringBuilder(26).append("sourceVersion(").append(jValue).append(") is invalid").toString());
        }
        JsonAST.JInt jInt = (JsonAST.JInt)jValue;
        long l = jInt.num().longValue();
        return l;
    }

    private DeltaSourceOffset$() {
        MODULE$ = this;
        this.VERSION = 1;
    }
}

