/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.api;

import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.MultiGetContentsRequest;
import com.dremio.nessie.model.MultiGetContentsResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;

@Consumes(value={"application/json"})
@Path(value="contents")
public interface ContentsApi {
    @GET
    @Produces(value={"application/json"})
    @Path(value="{key}")
    @Operation(summary="Get object content associated with key")
    @APIResponses(value={@APIResponse(responseCode="200", description="Information for table"), @APIResponse(responseCode="404", description="Table not found on ref")})
    public Contents getContents(@Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @Parameter(description="Reference to use. Defaults to default branch if not provided.") @QueryParam(value="ref") String var2) throws NessieNotFoundException;

    @POST
    @Consumes(value={"application/json"})
    @Operation(summary="Get multiple objects' content")
    @APIResponses(value={@APIResponse(responseCode="200", description="Retrieved successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists")})
    public MultiGetContentsResponse getMultipleContents(@Parameter(description="Reference to use. Defaults to default branch if not provided.") @QueryParam(value="ref") String var1, @NotNull @RequestBody(description="Keys to retrieve.") MultiGetContentsRequest var2) throws NessieNotFoundException;

    @POST
    @Path(value="{key}")
    @Consumes(value={"application/json"})
    @Operation(summary="Update object content associated with key")
    @APIResponses(value={@APIResponse(responseCode="204", description="Contents updated successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="412", description="Update conflict")})
    public void setContents(@NotNull @Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @Parameter(description="Branch to change. Defaults to default branch.") @QueryParam(value="branch") String var2, @NotNull @Parameter(description="Expected hash of branch.") @QueryParam(value="hash") String var3, @Parameter(description="Commit message") @QueryParam(value="message") String var4, @NotNull @RequestBody(description="Contents to be upserted") Contents var5) throws NessieNotFoundException, NessieConflictException;

    @DELETE
    @Path(value="{key}")
    @Operation(summary="Delete object content associated with key")
    @APIResponses(value={@APIResponse(responseCode="204", description="Deleted successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="412", description="Delete conflict")})
    public void deleteContents(@Parameter(description="object name to search for") @PathParam(value="key") ContentsKey var1, @Parameter(description="Branch to delete from. Defaults to default branch.") @QueryParam(value="branch") String var2, @Parameter(description="Expected hash of branch.") @QueryParam(value="hash") String var3, @Parameter(description="Commit message") @QueryParam(value="message") String var4) throws NessieNotFoundException, NessieConflictException;
}

