/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client;

import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.EntriesResponse;
import com.dremio.nessie.model.LogResponse;
import com.dremio.nessie.model.Merge;
import com.dremio.nessie.model.Operations;
import com.dremio.nessie.model.Reference;
import com.dremio.nessie.model.Tag;
import com.dremio.nessie.model.Transplant;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;

class ClientTreeApi
implements TreeApi {
    private static final GenericType<List<Reference>> REFERENCE_LIST = new GenericType<List<Reference>>(){};
    private final WebTarget target;

    public ClientTreeApi(WebTarget target) {
        this.target = target;
    }

    @Override
    public List<Reference> getAllReferences() {
        return (List)this.target.path("trees").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(REFERENCE_LIST);
    }

    @Override
    public void createReference(@NotNull Reference reference) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("tree").request().post(Entity.entity((Object)reference, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public Reference getReferenceByName(@NotNull String refName) throws NessieNotFoundException {
        return (Reference)this.target.path("trees").path("tree").path(refName).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(Reference.class);
    }

    @Override
    public void assignTag(@NotNull String tagName, @NotNull String expectedHash, @NotNull Tag tag) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("tag").path(tagName).queryParam("expectedHash", new Object[]{expectedHash}).request().put(Entity.entity((Object)tag, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public void deleteTag(@NotNull String tagName, @NotNull String expectedHash) throws NessieConflictException, NessieNotFoundException {
        this.target.path("trees").path("tag").path(tagName).queryParam("expectedHash", new Object[]{expectedHash}).request().delete();
    }

    @Override
    public void assignBranch(@NotNull String branchName, @NotNull String expectedHash, @NotNull Branch branch) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees").path("branch").path(branchName).queryParam("expectedHash", new Object[]{expectedHash}).request().put(Entity.entity((Object)branch, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public void deleteBranch(@NotNull String branchName, @NotNull String expectedHash) throws NessieConflictException, NessieNotFoundException {
        this.target.path("trees").path("branch").path(branchName).queryParam("expectedHash", new Object[]{expectedHash}).request().delete();
    }

    @Override
    public Branch getDefaultBranch() {
        return (Branch)this.target.path("trees").path("tree").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(Branch.class);
    }

    @Override
    public LogResponse getCommitLog(@NotNull String ref) throws NessieNotFoundException {
        return (LogResponse)this.target.path("trees").path("tree").path(ref).path("log").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(LogResponse.class);
    }

    @Override
    public void transplantCommitsIntoBranch(@NotNull String branchName, @NotNull String expectedHash, String message, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees/branch/{branchName}/transplant").resolveTemplate("branchName", (Object)branchName).queryParam("expectedHash", new Object[]{expectedHash}).queryParam("message", new Object[]{message}).request().put(Entity.entity((Object)transplant, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public void mergeRefIntoBranch(@NotNull String branchName, @NotNull String expectedHash, @NotNull Merge merge) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees/branch/{branchName}/merge").resolveTemplate("branchName", (Object)branchName).queryParam("expectedHash", new Object[]{expectedHash}).request().put(Entity.entity((Object)merge, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    @Override
    public EntriesResponse getEntries(@NotNull String refName) throws NessieNotFoundException {
        return (EntriesResponse)this.target.path("trees").path("tree").path(refName).path("entries").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get().readEntity(EntriesResponse.class);
    }

    @Override
    public void commitMultipleOperations(String branch, @NotNull String expectedHash, String message, @NotNull Operations operations) throws NessieNotFoundException, NessieConflictException {
        this.target.path("trees/branch/{branchName}/commit").resolveTemplate("branchName", (Object)branch).queryParam("expectedHash", new Object[]{expectedHash}).queryParam("message", new Object[]{message}).request().post(Entity.entity((Object)operations, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }
}

