/*
 * Decompiled with CFR 0.152.
 */
package io.delta.tables;

import io.delta.tables.DeltaTable;
import io.delta.tables.execution.DeltaConvert$;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.catalog.DeltaTableV2$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;

public final class DeltaTable$
implements scala.Serializable {
    public static DeltaTable$ MODULE$;

    static {
        new DeltaTable$();
    }

    @Evolving
    public DeltaTable convertToDelta(SparkSession spark, String identifier, StructType partitionSchema) {
        TableIdentifier tableId = spark.sessionState().sqlParser().parseTableIdentifier(identifier);
        return DeltaConvert$.MODULE$.executeConvert(spark, tableId, (Option<StructType>)new Some((Object)partitionSchema), (Option<String>)None$.MODULE$);
    }

    @Evolving
    public DeltaTable convertToDelta(SparkSession spark, String identifier, String partitionSchema) {
        TableIdentifier tableId = spark.sessionState().sqlParser().parseTableIdentifier(identifier);
        return DeltaConvert$.MODULE$.executeConvert(spark, tableId, (Option<StructType>)new Some((Object)StructType$.MODULE$.fromDDL(partitionSchema)), (Option<String>)None$.MODULE$);
    }

    @Evolving
    public DeltaTable convertToDelta(SparkSession spark, String identifier) {
        TableIdentifier tableId = spark.sessionState().sqlParser().parseTableIdentifier(identifier);
        return DeltaConvert$.MODULE$.executeConvert(spark, tableId, (Option<StructType>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    @Evolving
    public DeltaTable forPath(String path) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Could not find active SparkSession");
        });
        return this.forPath(sparkSession, path);
    }

    @Evolving
    public DeltaTable forPath(SparkSession sparkSession, String path) {
        Path hdpPath = new Path(path);
        if (!DeltaTableUtils$.MODULE$.isDeltaTable(sparkSession, hdpPath)) {
            throw DeltaErrors$.MODULE$.notADeltaTableException(new DeltaTableIdentifier((Option<String>)new Some((Object)path), DeltaTableIdentifier$.MODULE$.apply$default$2()));
        }
        return new DeltaTable((Dataset<Row>)sparkSession.read().format("delta").load(path), new DeltaTableV2(sparkSession, hdpPath, DeltaTableV2$.MODULE$.apply$default$3(), DeltaTableV2$.MODULE$.apply$default$4(), DeltaTableV2$.MODULE$.apply$default$5()));
    }

    public DeltaTable forName(String tableOrViewName) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Could not find active SparkSession");
        });
        return this.forName(sparkSession, tableOrViewName);
    }

    public DeltaTable forName(SparkSession sparkSession, String tableName) {
        TableIdentifier tableId = sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        if (!DeltaTableUtils$.MODULE$.isDeltaTable(sparkSession, tableId)) {
            Some x$1 = new Some((Object)tableId);
            Option<String> x$2 = DeltaTableIdentifier$.MODULE$.apply$default$1();
            throw DeltaErrors$.MODULE$.notADeltaTableException(new DeltaTableIdentifier(x$2, (Option<TableIdentifier>)x$1));
        }
        CatalogTable tbl = sparkSession.sessionState().catalog().getTableMetadata(tableId);
        return new DeltaTable((Dataset<Row>)sparkSession.table(tableName), new DeltaTableV2(sparkSession, new Path(tbl.location()), (Option<CatalogTable>)new Some((Object)tbl), (Option<String>)new Some((Object)tableName), DeltaTableV2$.MODULE$.apply$default$5()));
    }

    @Evolving
    public boolean isDeltaTable(SparkSession sparkSession, String identifier) {
        return DeltaTableUtils$.MODULE$.isDeltaTable(sparkSession, new Path(identifier));
    }

    @Evolving
    public boolean isDeltaTable(String identifier) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Could not find active SparkSession");
        });
        return this.isDeltaTable(sparkSession, identifier);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DeltaTable$() {
        MODULE$ = this;
    }
}

