/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import io.delta.sql.DeltaSparkSessionExtension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DocsPath;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.catalog.DeltaCatalog;
import org.apache.spark.sql.delta.commands.DeltaGenerateCommand$;
import org.apache.spark.sql.delta.hooks.PostCommitHook;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.Constraints;
import org.apache.spark.sql.delta.schema.InvariantViolationException;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class DeltaErrors$
implements DocsPath,
DeltaLogging {
    public static DeltaErrors$ MODULE$;
    private final String faqRelativePath;
    private final String EmptyCheckpointErrorMessage;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaErrors$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String baseDocsPath(SparkConf conf) {
        return DocsPath.baseDocsPath$(this, conf);
    }

    @Override
    public void assertValidCallingFunction() {
        DocsPath.assertValidCallingFunction$(this);
    }

    @Override
    public String generateDocsLink(SparkConf conf, String relativePath, boolean skipValidation) {
        return DocsPath.generateDocsLink$(this, conf, relativePath, skipValidation);
    }

    @Override
    public boolean generateDocsLink$default$3() {
        return DocsPath.generateDocsLink$default$3$(this);
    }

    @Override
    public Seq<String> errorsWithDocsLinks() {
        return DocsPath.errorsWithDocsLinks$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String baseDocsPath(SparkSession spark) {
        return this.baseDocsPath(spark.sparkContext().getConf());
    }

    public String faqRelativePath() {
        return this.faqRelativePath;
    }

    public String EmptyCheckpointErrorMessage() {
        return this.EmptyCheckpointErrorMessage;
    }

    public Throwable deltaSourceIgnoreDeleteError(long version, String removedFile) {
        return new UnsupportedOperationException(new StringBuilder(179).append("Detected deleted data (for example ").append(removedFile).append(") from streaming source at ").append("version ").append(version).append(". This is currently not supported. If you'd like to ignore deletes, ").append("set the option 'ignoreDeletes' to 'true'.").toString());
    }

    public Throwable deltaSourceIgnoreChangesError(long version, String removedFile) {
        return new UnsupportedOperationException(new StringBuilder(290).append("Detected a data update (for example ").append(removedFile).append(") in the source table at version ").append(version).append(". This is currently not supported. If you'd like to ignore updates, set the ").append("option 'ignoreChanges' to 'true'. If you would like the data update to be reflected, ").append("please restart this query with a fresh checkpoint directory.").toString());
    }

    public String deltaFileNotFoundHint(String faqPath, String path) {
        Object x$1 = null;
        String x$2 = "delta.error.fileNotFound";
        String x$3 = path;
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        this.recordDeltaEvent(null, x$2, x$4, x$3);
        return new StringBuilder(201).append("A file referenced in the transaction log cannot be found. This occurs when data has been manually deleted from the file system rather than using the table `DELETE` statement. ").append("For more information, see ").append(faqPath).toString();
    }

    public String formatColumn(String colName) {
        return new StringBuilder(2).append("`").append(colName).append("`").toString();
    }

    public String formatColumnList(Seq<String> colNames) {
        return ((TraversableOnce)colNames.map((Function1 & Serializable & scala.Serializable)colName -> MODULE$.formatColumn((String)colName), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
    }

    public String formatSchema(StructType schema) {
        return schema.treeString();
    }

    public AnalysisException analysisException(String msg, Option<Object> line, Option<Object> startPosition, Option<LogicalPlan> plan, Option<Throwable> cause) {
        return new AnalysisException(msg, line, startPosition, plan, cause);
    }

    public Option<Object> analysisException$default$2() {
        return None$.MODULE$;
    }

    public Option<Object> analysisException$default$3() {
        return None$.MODULE$;
    }

    public Option<LogicalPlan> analysisException$default$4() {
        return None$.MODULE$;
    }

    public Option<Throwable> analysisException$default$5() {
        return None$.MODULE$;
    }

    public Throwable notNullColumnMissingException(Constraints.NotNull constraint) {
        return new InvariantViolationException(new StringBuilder(96).append("Column ").append(new UnresolvedAttribute(constraint.column()).name()).append(", which has a NOT NULL constraint, is missing from the data being ").append("written into the table.").toString());
    }

    public AnalysisException nestedNotNullConstraint(String parent, DataType nested, String nestType) {
        return new AnalysisException(new StringBuilder(227).append("The ").append(nestType).append(" type of the field ").append(parent).append(" contains a NOT NULL ").append("constraint. Delta does not support NOT NULL constraints nested within arrays or maps. ").append("To suppress this error and silently ignore the specified constraints, set ").append(DeltaSQLConf$.MODULE$.ALLOW_UNENFORCED_NOT_NULL_CONSTRAINTS().key()).append(" = true.\n").append("Parsed ").append(nestType).append(" type:\n").append(nested.prettyJson()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable incorrectLogStoreImplementationException(SparkConf sparkConf, Throwable cause) {
        return new IOException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(384).append("The error typically occurs when the default LogStore implementation, that\n      | is, HDFSLogStore, is used to write into a Delta table on a non-HDFS storage system.\n      | In order to get the transactional ACID guarantees on table updates, you have to use the\n      | correct implementation of LogStore that is appropriate for your storage system.\n      | See ").append(this.generateDocsLink(sparkConf, "/delta-storage.html", this.generateDocsLink$default$3())).append(" \" for details.\n      ").toString())).stripMargin(), cause);
    }

    public Throwable staticPartitionsNotSupportedException() {
        return new AnalysisException("Specifying static partitions in the partition spec is currently not supported during inserts", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable operationNotSupportedException(String operation, TableIdentifier tableIdentifier) {
        return new AnalysisException(new StringBuilder(61).append("Operation not allowed: `").append(operation).append("` is not supported ").append("for Delta tables: ").append(tableIdentifier).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable operationNotSupportedException(String operation) {
        return new AnalysisException(new StringBuilder(59).append("Operation not allowed: `").append(operation).append("` is not supported for Delta tables").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable emptyDataException() {
        return new AnalysisException("Data used in creating the Delta table doesn't have any columns.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable notADeltaTableException(DeltaTableIdentifier deltaTableIdentifier) {
        return new AnalysisException(new StringBuilder(22).append(deltaTableIdentifier).append(" is not a Delta table.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable notADeltaTableException(String operation, DeltaTableIdentifier deltaTableIdentifier) {
        return new AnalysisException(new StringBuilder(59).append(deltaTableIdentifier).append(" is not a Delta table. ").append(operation).append(" is only supported for Delta tables.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable notADeltaTableException(String operation) {
        return new AnalysisException(new StringBuilder(36).append(operation).append(" is only supported for Delta tables.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable notADeltaSourceException(String command, Option<LogicalPlan> plan) {
        String planName = plan.isDefined() ? plan.toString() : "";
        return new AnalysisException(new StringBuilder(42).append(command).append(" destination only supports Delta sources.\n").append(planName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Option<LogicalPlan> notADeltaSourceException$default$2() {
        return None$.MODULE$;
    }

    public Throwable schemaChangedSinceAnalysis(StructType atAnalysis, StructType latestSchema) {
        Seq schemaDiff = (Seq)SchemaUtils$.MODULE$.reportDifferences(atAnalysis, latestSchema).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.replace("Specified", "Latest"), Seq$.MODULE$.canBuildFrom());
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(312).append("The schema of your Delta table has changed in an incompatible way since your DataFrame or\n         |DeltaTable object was created. Please redefine your DataFrame or DeltaTable object.\n         |Changes:\n").append(schemaDiff.mkString("\n")).append("\n         |This check can be turned off by setting the session configuration key\n         |").append(DeltaSQLConf$.MODULE$.DELTA_SCHEMA_ON_READ_CHECK_ENABLED().key()).append(" to false.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidColumnName(String name) {
        return new AnalysisException(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(118).append("Attribute name \"").append(name).append("\" contains invalid character(s) among \" ,;{}()\\n\\t=\".\n         |Please use alias to rename it.\n       ").toString())).stripMargin().split("\n"))).mkString(" ").trim(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidPartitionColumn(AnalysisException e) {
        String x$1 = "Found partition columns having invalid character(s) among \" ,;{}()\\n\\t=\". Please change the name to your partition columns. This check can be turned off by setting spark.conf.set(\"spark.databricks.delta.partitionColumnValidity.enabled\", false) however this is not recommended as other features of Delta may not work properly.";
        Option x$2 = Option$.MODULE$.apply((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        return new AnalysisException(x$1, x$3, x$4, x$5, x$2);
    }

    public Throwable missingTableIdentifierException(String operationName) {
        return new AnalysisException(new StringBuilder(49).append("Please provide the path or table identifier for ").append(operationName).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable viewInDescribeDetailException(TableIdentifier view) {
        return new AnalysisException(new StringBuilder(57).append(view).append(" is a view. DESCRIBE DETAIL is only supported for tables.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable alterTableChangeColumnException(String oldColumns, String newColumns) {
        return new AnalysisException(new StringBuilder(67).append("ALTER TABLE CHANGE COLUMN is not supported for changing column ").append(oldColumns).append(" to ").append(newColumns).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable notEnoughColumnsInInsert(String table, int query, int target, Option<String> nestedField) {
        String nestedFieldStr = (String)nestedField.map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(28).append("not enough nested fields in ").append((String)f).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "not enough data columns");
        return new AnalysisException(new StringBuilder(86).append("Cannot write to '").append(table).append("', ").append(nestedFieldStr).append("; ").append("target table has ").append(target).append(" column(s) but the inserted data has ").append(query).append(" column(s)").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Option<String> notEnoughColumnsInInsert$default$4() {
        return None$.MODULE$;
    }

    public Throwable cannotInsertIntoColumn(String tableName, String source, String target, String targetType) {
        return new AnalysisException(new StringBuilder(53).append("Struct column ").append(source).append(" cannot be inserted into a ").append(targetType).append(" field ").append(target).append(" in ").append(tableName).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable alterTableReplaceColumnsException(StructType oldSchema, StructType newSchema, String reason) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("Unsupported ALTER TABLE REPLACE COLUMNS operation. Reason: ").append(reason).append("\n         |\n         |Failed to change schema from:\n         |").append(this.formatSchema(oldSchema)).append("\n         |to:\n         |").append(this.formatSchema(newSchema)).toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsetNonExistentPropertyException(String propertyKey, DeltaTableIdentifier deltaTableIdentifier) {
        return new AnalysisException(new StringBuilder(53).append("Attempted to unset non-existent property '").append(propertyKey).append("' in table ").append(deltaTableIdentifier).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable ambiguousPartitionColumnException(String columnName, Seq<StructField> colMatches) {
        return new AnalysisException(new StringBuilder(36).append("Ambiguous partition column ").append(this.formatColumn(columnName)).append(" can be").append(" ").append(this.formatColumnList((Seq<String>)((Seq)colMatches.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())))).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable tableNotSupportedException(String operation) {
        return new AnalysisException(new StringBuilder(54).append("Table is not supported in ").append(operation).append(". Please use a path instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable vacuumBasePathMissingException(Path baseDeltaPath) {
        return new AnalysisException(new StringBuilder(118).append("Please provide the base path (").append(baseDeltaPath).append(") when Vacuuming Delta tables. ").append("Vacuuming specific partitions is currently not supported.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unexpectedDataChangeException(String op) {
        return new AnalysisException(new StringBuilder(78).append("Attempting to change metadata when 'dataChange' option is set").append(" to false during ").append(op).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unknownConfigurationKeyException(String confKey) {
        return new AnalysisException(new StringBuilder(37).append("Unknown configuration was specified: ").append(confKey).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable useDeltaOnOtherFormatPathException(String operation, String path, SparkSession spark) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(419).append("Incompatible format detected.\n        |\n        |You are trying to ").append(operation).append(" `").append(path).append("` using Delta Lake, but there is no\n        |transaction log present. Check the upstream job to make sure that it is writing\n        |using format(\"delta\") and that you are trying to ").append(operation).append(" the table base path.\n        |\n        |To disable this check, SET spark.databricks.delta.formatCheck.enabled=false\n        |To learn more about Delta, see ").append(this.generateDocsLink(spark.sparkContext().getConf(), "/index.html", this.generateDocsLink$default$3())).append("\n        |").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable useOtherFormatOnDeltaPathException(String operation, String deltaRootPath, String path, String format, SparkSession spark) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(391).append("Incompatible format detected.\n        |\n        |A transaction log for Delta Lake was found at `").append(deltaRootPath).append("/_delta_log`,\n        |but you are trying to ").append(operation).append(" `").append(path).append("` using format(\"").append(format).append("\"). You must use\n        |'format(\"delta\")' when reading and writing to a delta table.\n        |\n        |To disable this check, SET spark.databricks.delta.formatCheck.enabled=false\n        |To learn more about Delta, see ").append(this.generateDocsLink(spark.sparkContext().getConf(), "/index.html", this.generateDocsLink$default$3())).append("\n        |").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable pathNotSpecifiedException() {
        return new IllegalArgumentException("'path' is not specified");
    }

    public Throwable pathNotExistsException(String path) {
        return new AnalysisException(new StringBuilder(14).append(path).append(" doesn't exist").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable pathAlreadyExistsException(Path path) {
        return new AnalysisException(new StringBuilder(16).append(path).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable logFileNotFoundException(Path path, long version, Metadata metadata) {
        CalendarInterval logRetention = DeltaConfigs$.MODULE$.LOG_RETENTION().fromMetaData(metadata);
        CalendarInterval checkpointRetention = DeltaConfigs$.MODULE$.CHECKPOINT_RETENTION_DURATION().fromMetaData(metadata);
        return new FileNotFoundException(new StringBuilder(174).append(path).append(": Unable to reconstruct state at version ").append(version).append(" as the ").append("transaction log has been truncated due to manual deletion or the log retention policy ").append("(").append(DeltaConfigs$.MODULE$.LOG_RETENTION().key()).append("=").append(logRetention).append(") and checkpoint retention policy ").append("(").append(DeltaConfigs$.MODULE$.CHECKPOINT_RETENTION_DURATION().key()).append("=").append(checkpointRetention).append(")").toString());
    }

    public Throwable logFileNotFoundExceptionForStreamingSource(FileNotFoundException e) {
        return new FileNotFoundException(new StringBuilder(209).append(e.getMessage()).append(" If you never deleted it, it's ").append("likely your query is lagging behind. Please delete its checkpoint to restart").append(" from scratch. To avoid this happening again, you can update your retention ").append("policy of your Delta table").toString()).initCause(e);
    }

    public Throwable requireProtocolUpgrade(Seq<String> features, Protocol required, Protocol current) {
        String featureList = features.mkString("\t - ", "\n\t -", "\n");
        int readerVersion = package$.MODULE$.max(required.minReaderVersion(), current.minReaderVersion());
        int writerVersion = package$.MODULE$.max(required.minWriterVersion(), current.minWriterVersion());
        return new AnalysisException(new StringBuilder(252).append("The features listed below require a protocol version of ").append(required).append(" ").append("or above, but the protocol version of the Delta table is ").append(current).append(". Please upgrade ").append("the protocol version of the table before setting this config using ").append("`io.delta.table.DeltaTable.upgradeTableProtocol(").append(readerVersion).append(", ").append(writerVersion).append(")`.").append("\n").append(featureList).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable multipleLoadPathsException(Seq<String> paths) {
        throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(468).append("\n        |Delta Lake does not support multiple input paths in the load() API.\n        |paths: ").append(paths.mkString("[", ",", "]")).append(". To build a single DataFrame by loading\n        |multiple paths from the same Delta table, please load the root path of\n        |the Delta table with the corresponding partition filters. If the multiple paths\n        |are from different Delta tables, please use Dataset's union()/unionByName() APIs\n        |to combine the DataFrames generated by separate load() API calls.").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable partitionColumnNotFoundException(String colName, Seq<Attribute> schema) {
        return new AnalysisException(new StringBuilder(40).append("Partition column ").append(this.formatColumn(colName)).append(" not found in schema ").append("[").append(((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("]").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable partitionPathParseException(String fragment) {
        return new AnalysisException(new StringBuilder(93).append("A partition path fragment should be the form like `part1=foo/part2=bar`. ").append("The partition path: ").append(fragment).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable partitionPathInvolvesNonPartitionColumnException(Seq<String> badColumns, String fragment) {
        return new AnalysisException(new StringBuilder(43).append("Non-partitioning column(s) ").append(this.formatColumnList(badColumns)).append(" are specified: ").append(fragment).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nonPartitionColumnAbsentException(boolean colsDropped) {
        String msg = colsDropped ? " Columns which are of NullType have been dropped." : "";
        return new AnalysisException(new StringBuilder(77).append("Data written into Delta needs to contain at least one non-partitioned column.").append(msg).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable replaceWhereMismatchException(String replaceWhere, String badPartitions) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(104).append("Data written out does not match replaceWhere '").append(replaceWhere).append("'.\n         |Invalid data would be written to partitions ").append(badPartitions).append(".").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable illegalDeltaOptionException(String name, String input, String explain) {
        return new IllegalArgumentException(new StringBuilder(32).append("Invalid value '").append(input).append("' for option '").append(name).append("', ").append(explain).toString());
    }

    public Throwable startingVersionAndTimestampBothSetException(String versionOptKey, String timestampOptKey) {
        return new IllegalArgumentException(new StringBuilder(30).append("Please either provide '").append(versionOptKey).append("' or '").append(timestampOptKey).append("'").toString());
    }

    public Throwable unrecognizedLogFile(Path path) {
        return new UnsupportedOperationException(new StringBuilder(22).append("Unrecognized log file ").append(path).toString());
    }

    public Throwable modifyAppendOnlyTableException() {
        return new UnsupportedOperationException(new StringBuilder(154).append("This table is configured to only allow appends. If you would like to permit ").append("updates or deletes, use 'ALTER TABLE <table_name> SET TBLPROPERTIES ").append("(").append(DeltaConfigs$.MODULE$.IS_APPEND_ONLY().key()).append("=false)'.").toString());
    }

    public Throwable missingPartFilesException(long version, Exception ae) {
        return new IllegalStateException(new StringBuilder(56).append("Couldn't find all part files of the checkpoint version: ").append(version).toString(), ae);
    }

    public Throwable deltaVersionsNotContiguousException(SparkSession spark, Seq<Object> deltaVersions) {
        return new IllegalStateException(new StringBuilder(31).append("Versions (").append(deltaVersions).append(") are not contiguous.").toString());
    }

    public Throwable actionNotFoundException(String action, long version) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(222).append("\n         |The ").append(action).append(" of your Delta table couldn't be recovered while Reconstructing\n         |version: ").append(((Object)BoxesRunTime.boxToLong((long)version)).toString()).append(". Did you manually delete files in the _delta_log directory?\n         |Set ").append(DeltaSQLConf$.MODULE$.DELTA_STATE_RECONSTRUCTION_VALIDATION_ENABLED().key()).append("\n         |to \"false\" to skip validation.\n       ").toString())).stripMargin());
    }

    public Throwable schemaChangedException(StructType oldSchema, StructType newSchema) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(343).append("Detected schema change:\n        |old schema: ").append(this.formatSchema(oldSchema)).append("\n        |\n        |new schema: ").append(this.formatSchema(newSchema)).append("\n        |\n        |Please try restarting the query. If this issue repeats across query restarts without making\n        |progress, you have made an incompatible schema change and need to start your query from\n        |scratch using a new checkpoint directory.\n      ").toString())).stripMargin());
    }

    public Throwable streamWriteNullTypeException() {
        return new AnalysisException("Delta doesn't accept NullTypes in the schema for streaming writes.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable schemaNotSetException() {
        return new AnalysisException("Table schema is not set.  Write data into it or use CREATE TABLE to set the schema.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable specifySchemaAtReadTimeException() {
        return new AnalysisException("Delta does not support specifying the schema at read time.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable schemaNotProvidedException() {
        return new AnalysisException("Table schema is not provided. Please provide the schema of the table when using REPLACE table and an AS SELECT query is not provided.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable outputModeNotSupportedException(String dataSource, OutputMode outputMode) {
        return new AnalysisException(new StringBuilder(42).append("Data source ").append(dataSource).append(" does not support ").append(outputMode).append(" output mode").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable updateSetColumnNotFoundException(String col, Seq<String> colList) {
        return new AnalysisException(new StringBuilder(38).append("SET column ").append(this.formatColumn(col)).append(" not found given columns: ").append(this.formatColumnList(colList)).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable updateSetConflictException(Seq<String> cols) {
        return new AnalysisException(new StringBuilder(45).append("There is a conflict from these SET columns: ").append(this.formatColumnList(cols)).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable updateNonStructTypeFieldNotSupportedException(String col, DataType s) {
        return new AnalysisException(new StringBuilder(118).append("Updating nested fields is only supported for StructType, but you are trying to update ").append("a field of ").append(this.formatColumn(col)).append(", which is of type: ").append(s).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable truncateTablePartitionNotSupportedException() {
        return new AnalysisException(new StringBuilder(142).append("Operation not allowed: TRUNCATE TABLE on Delta tables does not support").append(" partition predicates; use DELETE to delete specific partitions or rows.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterOnPartitionColumnNotSupportedException(String name) {
        return new AnalysisException(new StringBuilder(71).append("Creating a bloom filter index on a partitioning column is unsupported: ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterOnNestedColumnNotSupportedException(String name) {
        return new AnalysisException(new StringBuilder(74).append("Creating a bloom filer index on a nested column is currently unsupported: ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterOnColumnTypeNotSupportedException(String name, DataType dataType) {
        return new AnalysisException(new StringBuilder(69).append("Creating a bloom filter index on a column with type ").append(dataType.catalogString()).append(" is unsupported: ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterMultipleConfForSingleColumnException(String name) {
        return new AnalysisException(new StringBuilder(73).append("Multiple bloom filter index configurations passed to command for column: ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterCreateOnNonExistingColumnsException(Seq<String> unknownColumns) {
        return new AnalysisException(new StringBuilder(77).append("Cannot create bloom filter indices for the following non-existent column(s): ").append(unknownColumns.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterInvalidParameterValueException(String message) {
        return new AnalysisException(new StringBuilder(59).append("Cannot create bloom filter index, invalid parameter value: ").append(message).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterDropOnNonIndexedColumnException(String name) {
        return new AnalysisException(new StringBuilder(56).append("Cannot drop bloom filter index on a non indexed column: ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterDropOnNonExistingColumnsException(Seq<String> unknownColumns) {
        return new AnalysisException(new StringBuilder(75).append("Cannot drop bloom filter indices for the following non-existent column(s): ").append(unknownColumns.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable multipleSourceRowMatchingTargetRowInMergeException(SparkSession spark) {
        return new UnsupportedOperationException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(513).append("Cannot perform Merge as multiple source rows matched and attempted to modify the same\n         |target row in the Delta table in possibly conflicting ways. By SQL semantics of Merge,\n         |when multiple source rows match on the same target row, the result may be ambiguous\n         |as it is unclear which source row should be used to update or delete the matching\n         |target row. You can preprocess the source table to eliminate the possibility of\n         |multiple matches. Please refer to\n         |").append(this.generateDocsLink(spark.sparkContext().getConf(), "/delta-update.html#upsert-into-a-table-using-merge", this.generateDocsLink$default$3())).toString())).stripMargin());
    }

    public Throwable subqueryNotSupportedException(String op, Expression cond) {
        return new AnalysisException(new StringBuilder(52).append("Subqueries are not supported in the ").append(op).append(" (condition = ").append(cond.sql()).append(").").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable multiColumnInPredicateNotSupportedException(String operation) {
        return new AnalysisException(new StringBuilder(63).append("Multi-column In predicates are not supported in the ").append(operation).append(" condition.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nestedSubqueryNotSupportedException(String operation) {
        return new AnalysisException(new StringBuilder(51).append("Nested subquery is not supported in the ").append(operation).append(" condition.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nestedFieldNotSupported(String operation, String field) {
        return new AnalysisException(new StringBuilder(49).append("Nested field is not supported in the ").append(operation).append(" (field = ").append(field).append(").").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable inSubqueryNotSupportedException(String operation) {
        return new AnalysisException(new StringBuilder(47).append("In subquery is not supported in the ").append(operation).append(" condition.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable convertMetastoreMetadataMismatchException(Map<String, String> tableProperties, Map<String, String> deltaConfiguration) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(454).append("You are trying to convert a table which already has a delta log where the table\n         |properties in the catalog don't match the configuration in the delta log.\n         |Table properties in catalog: ").append(DeltaErrors$.prettyMap$1(tableProperties)).append("\n         |Delta configuration: ").append(DeltaErrors$.prettyMap$1(deltaConfiguration)).append("\n         |If you would like to merge the configurations (update existing fields and insert new\n         |ones), set the SQL configuration\n         |spark.databricks.delta.convert.metadataCheck.enabled to false.\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createExternalTableWithoutLogException(Path path, String tableName, SparkSession spark) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(350).append("\n         |You are trying to create an external table ").append(tableName).append("\n         |from `").append(path).append("` using Delta Lake, but there is no transaction log present at\n         |`").append(path).append("/_delta_log`. Check the upstream job to make sure that it is writing using\n         |format(\"delta\") and that the path is the root of the table.\n         |\n         |To learn more about Delta, see ").append(this.generateDocsLink(spark.sparkContext().getConf(), "/index.html", this.generateDocsLink$default$3())).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createExternalTableWithoutSchemaException(Path path, String tableName, SparkSession spark) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(223).append("\n         |You are trying to create an external table ").append(tableName).append("\n         |from `").append(path).append("` using Delta Lake, but the schema is not specified when the\n         |input path is empty.\n         |\n         |To learn more about Delta, see ").append(this.generateDocsLink(spark.sparkContext().getConf(), "/index.html", this.generateDocsLink$default$3())).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createManagedTableWithoutSchemaException(String tableName, SparkSession spark) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(174).append("\n         |You are trying to create a managed table ").append(tableName).append("\n         |using Delta Lake, but the schema is not specified.\n         |\n         |To learn more about Delta, see ").append(this.generateDocsLink(spark.sparkContext().getConf(), "/index.html", this.generateDocsLink$default$3())).append("\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createTableWithDifferentSchemaException(Path path, StructType specifiedSchema, StructType existingSchema, Seq<String> diffs) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(408).append("The specified schema does not match the existing schema at ").append(path).append(".\n         |\n         |== Specified ==\n         |").append(specifiedSchema.treeString()).append("\n         |\n         |== Existing ==\n         |").append(existingSchema.treeString()).append("\n         |\n         |== Differences==\n         |").append(((TraversableOnce)diffs.map((Function1 & Serializable & scala.Serializable)x$4 -> new StringOps(Predef$.MODULE$.augmentString("\n")).r().replaceAllIn((CharSequence)x$4, "\n  "), Seq$.MODULE$.canBuildFrom())).mkString("- ", "\n- ", "")).append("\n         |\n         |If your intention is to keep the existing schema, you can omit the\n         |schema from the create table command. Otherwise please ensure that\n         |the schema matches.\n        ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createTableWithDifferentPartitioningException(Path path, Seq<String> specifiedColumns, Seq<String> existingColumns) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(176).append("The specified partitioning does not match the existing partitioning at ").append(path).append(".\n         |\n         |== Specified ==\n         |").append(specifiedColumns.mkString(", ")).append("\n         |\n         |== Existing ==\n         |").append(existingColumns.mkString(", ")).append("\n        ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createTableWithDifferentPropertiesException(Path path, Map<String, String> specifiedProperties, Map<String, String> existingProperties) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(170).append("The specified properties do not match the existing properties at ").append(path).append(".\n         |\n         |== Specified ==\n         |").append(((TraversableOnce)specifiedProperties.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |\n         |== Existing ==\n         |").append(((TraversableOnce)existingProperties.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n")).append("\n        ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable aggsNotSupportedException(String op, Expression cond) {
        String condStr = new StringBuilder(15).append("(condition = ").append(cond.sql()).append(").").toString();
        return new AnalysisException(new StringBuilder(47).append("Aggregate functions are not supported in the ").append(op).append(" ").append(condStr).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nonDeterministicNotSupportedException(String op, Expression cond) {
        String condStr = new StringBuilder(15).append("(condition = ").append(cond.sql()).append(").").toString();
        return new AnalysisException(new StringBuilder(55).append("Non-deterministic functions are not supported in the ").append(op).append(" ").append(condStr).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable noHistoryFound(Path logPath) {
        return new AnalysisException(new StringBuilder(20).append("No commits found at ").append(logPath).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable noReproducibleHistoryFound(Path logPath) {
        return new AnalysisException(new StringBuilder(33).append("No reproducible commits found at ").append(logPath).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable timestampEarlierThanCommitRetention(Timestamp userTimestamp, Timestamp commitTs, String timestampString) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("The provided timestamp (").append(userTimestamp).append(") is before the earliest version available to this\n         |table (").append(commitTs).append("). Please use a timestamp after ").append(timestampString).append(".\n         ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable timestampGreaterThanLatestCommit(Timestamp userTimestamp, Timestamp commitTs, String timestampString) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("The provided timestamp (").append(userTimestamp).append(") is after the latest version available to this\n         |table (").append(commitTs).append("). Please use a timestamp before or at ").append(timestampString).append(".\n         ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable temporallyUnstableInput(Timestamp userTimestamp, Timestamp commitTs, String timestampString, long commitVersion) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(277).append("The provided timestamp: ").append(userTimestamp).append(" is after the latest commit timestamp of\n         |").append(commitTs).append(". If you wish to query this version of the table, please either provide\n         |the version with \"VERSION AS OF ").append(commitVersion).append("\" or use the exact timestamp\n         |of the last commit: \"TIMESTAMP AS OF '").append(timestampString).append("'\".\n       ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable versionNotExistException(long userVersion, long earliest, long latest) {
        throw new AnalysisException(new StringBuilder(69).append("Cannot time travel Delta table to version ").append(userVersion).append(". ").append("Available versions: [").append(earliest).append(", ").append(latest).append("].").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable timeTravelNotSupportedException() {
        return new AnalysisException("Cannot time travel views, subqueries or streams.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable multipleTimeTravelSyntaxUsed() {
        return new AnalysisException("Cannot specify time travel in multiple formats.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable provideOneOfInTimeTravel() {
        return new IllegalArgumentException("Please either provide 'timestampAsOf' or 'versionAsOf' for time travel.");
    }

    public Throwable deltaLogAlreadyExistsException(String path) {
        return new AnalysisException(new StringBuilder(35).append("A Delta Lake log already exists at ").append(path).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable commitAlreadyExistsException(long version, Path logPath) {
        return new IllegalStateException(new StringBuilder(46).append("Commit of version ").append(version).append(" already exists in the log: ").append(logPath.toUri().toString()).toString());
    }

    public Throwable missingProviderForConvertException(String path) {
        return new AnalysisException(new StringBuilder(116).append("CONVERT TO DELTA only supports parquet tables. ").append("Please rewrite your target as parquet.`").append(path).append("` if it's a parquet directory.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable convertNonParquetTablesException(TableIdentifier ident, String sourceName) {
        return new AnalysisException(new StringBuilder(88).append("CONVERT TO DELTA only supports parquet tables, but you are trying to ").append("convert a ").append(sourceName).append(" source: ").append(ident).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unexpectedPartitionColumnFromFileNameException(String path, String parsedCol, String expectedCol) {
        return new AnalysisException(new StringBuilder(85).append("Expecting partition column ").append(this.formatColumn(expectedCol)).append(", but").append(" found partition column ").append(this.formatColumn(parsedCol)).append(" from parsing the file name: ").append(path).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unexpectedNumPartitionColumnsFromFileNameException(String path, Seq<String> parsedCols, Seq<String> expectedCols) {
        return new AnalysisException(new StringBuilder(95).append("Expecting ").append(expectedCols.size()).append(" partition column(s): ").append(this.formatColumnList(expectedCols)).append(", but found ").append(parsedCols.size()).append(" partition column(s): ").append(this.formatColumnList(parsedCols)).append(" from parsing the file name: ").append(path).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable castPartitionValueException(String partitionValue, DataType dataType) {
        return new RuntimeException(new StringBuilder(37).append("Failed to cast partition value `").append(partitionValue).append("` to ").append(dataType).toString());
    }

    public Throwable emptyDirectoryException(String directory) {
        return new FileNotFoundException(new StringBuilder(33).append("No file found in the directory: ").append(directory).append(".").toString());
    }

    public Throwable alterTableSetLocationSchemaMismatchException(StructType original, StructType destination) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("\n        |The schema of the new Delta location is different than the current table schema.\n        |original schema:\n        |  ").append(this.formatSchema(original)).append("\n        |destination schema:\n        |  ").append(this.formatSchema(destination)).append("\n        |\n        |If this is an intended change, you may turn this check off by running:\n        |%sql set spark.databricks.delta.alterLocation.bypassSchemaCheck = true").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable setLocationNotSupportedOnPathIdentifiers() {
        throw new AnalysisException("Cannot change the location of a path based table.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable describeViewHistory() {
        return new AnalysisException("Cannot describe the history of a view.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable copyIntoEncryptionOnlyS3(String scheme) {
        return new IllegalArgumentException(new StringBuilder(76).append("Invalid scheme ").append(scheme).append(". COPY INTO source encryption is only supported for S3 paths.").toString());
    }

    public Throwable copyIntoEncryptionSseCRequired() {
        return new IllegalArgumentException("Invalid encryption type. COPY INTO source encryption must specify 'type' = 'SSE-C'.");
    }

    public Throwable copyIntoEncryptionMasterKeyRequired() {
        return new IllegalArgumentException("Invalid encryption arguments. COPY INTO source encryption must specify a masterKey.");
    }

    public Throwable copyIntoCredentialsOnlyS3(String scheme) {
        return new IllegalArgumentException(new StringBuilder(78).append("Invalid scheme ").append(scheme).append(". COPY INTO source credentials are only supported for S3 paths.").toString());
    }

    public Throwable copyIntoCredentialsAllRequired(Throwable cause) {
        return new IllegalArgumentException("COPY INTO credentials must include awsKeyId, awsSecretKey, and awsSessionToken.", cause);
    }

    public Throwable postCommitHookFailedException(PostCommitHook failedHook, long failedOnCommitVersion, String extraErrorMessage, Throwable error) {
        String errorMessage = new StringBuilder(92).append("Committing to the Delta table version ").append(failedOnCommitVersion).append(" succeeded").append(" but error while executing post-commit hook ").append(failedHook.name()).toString();
        if (extraErrorMessage != null && new StringOps(Predef$.MODULE$.augmentString(extraErrorMessage)).nonEmpty()) {
            errorMessage = new StringBuilder(2).append(errorMessage).append(": ").append(extraErrorMessage).toString();
        }
        return new RuntimeException(errorMessage, error);
    }

    public Throwable unsupportedGenerateModeException(String modeName) {
        String supportedModes = DeltaGenerateCommand$.MODULE$.modeNameToGenerationFunc().keys().toSeq().mkString(", ");
        return new IllegalArgumentException(new StringBuilder(57).append("Specified mode '").append(modeName).append("' is not supported. Supported modes are: ").append(supportedModes).toString());
    }

    public Throwable illegalUsageException(String option, String operation) {
        throw new IllegalArgumentException(new StringBuilder(49).append("The usage of ").append(option).append(" is not allowed when ").append(operation).append(" a Delta table.").toString());
    }

    public Throwable columnNotInSchemaException(String column, StructType schema) {
        throw new AnalysisException(new StringBuilder(26).append("Couldn't find column ").append(column).append(" in:\n").append(schema.treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable metadataAbsentException() {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(144).append("\n         |Couldn't find Metadata while committing the first version of the Delta table. To disable\n         |this check set ").append(DeltaSQLConf$.MODULE$.DELTA_COMMIT_VALIDATION_ENABLED().key()).append(" to \"false\"\n       ").toString())).stripMargin());
    }

    public Throwable addFilePartitioningMismatchException(Seq<String> addFilePartitions, Seq<String> metadataPartitions) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(189).append("\n        |The AddFile contains partitioning schema different from the table's partitioning schema\n        |expected: ").append(this.formatColumnList(metadataPartitions)).append("\n        |actual: ").append(this.formatColumnList(addFilePartitions)).append("\n        |To disable this check set ").append(DeltaSQLConf$.MODULE$.DELTA_COMMIT_VALIDATION_ENABLED().key()).append(" to \"false\"\n      ").toString())).stripMargin());
    }

    public String concurrentModificationExceptionMsg(SparkConf sparkConf, String baseMessage, Option<CommitInfo> commit) {
        return new StringBuilder(28).append(baseMessage).append(commit.map((Function1 & Serializable & scala.Serializable)ci -> new StringBuilder(21).append("\nConflicting commit: ").append(JsonUtils$.MODULE$.toJson(ci, ManifestFactory$.MODULE$.classType(CommitInfo.class))).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\nRefer to ").append(this.generateDocsLink(sparkConf, "/concurrency-control.html", this.generateDocsLink$default$3())).append(" ").append("for more details.").toString();
    }

    public String ignoreStreamingUpdatesAndDeletesWarning(SparkSession spark) {
        String docPage = this.generateDocsLink(spark.sparkContext().getConf(), "/delta-streaming.html#ignoring-updates-and-deletes", this.generateDocsLink$default$3());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append("WARNING: The 'ignoreFileDeletion' option is deprecated. Switch to using one of\n       |'ignoreDeletes' or 'ignoreChanges'. Refer to ").append(docPage).append(" for details.\n         ").toString())).stripMargin();
    }

    public Throwable configureSparkSessionWithExtensionAndCatalog(Throwable originalException) {
        String catalogImplConfig = SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key();
        String x$1 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(401).append("This Delta operation requires the SparkSession to be configured with the\n         |DeltaSparkSessionExtension and the DeltaCatalog. Please set the necessary\n         |configurations when creating the SparkSession as shown below.\n         |\n         |  SparkSession.builder()\n         |    .option(\"spark.sql.extensions\", \"").append(DeltaSparkSessionExtension.class.getName()).append("\")\n         |    .option(\"").append(catalogImplConfig).append("\", \"").append(DeltaCatalog.class.getName()).append("\"\n         |    ...\n         |    .build()\n      ").toString())).stripMargin();
        Some x$2 = new Some((Object)originalException);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option)x$2);
    }

    public Throwable maxCommitRetriesExceededException(int attemptNumber, long attemptVersion, long initAttemptVersion, int numActions, long totalCommitAttemptTime) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(385).append("This commit has failed as it has been tried ").append(attemptNumber).append(" times but did not succeed.\n         |This can be caused by the Delta table being committed continuously by many concurrent\n         |commits.\n         |\n         |Commit started at version: ").append(initAttemptVersion).append("\n         |Commit failed at version: ").append(attemptVersion).append("\n         |Number of actions attempted to commit: ").append(numActions).append("\n         |Total time spent attempting this commit: ").append(totalCommitAttemptTime).append(" ms\n       ").toString())).stripMargin());
    }

    private static final String prettyMap$1(Map m) {
        return ((TraversableOnce)m.map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(1).append(e._1()).append("=").append(e._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
    }

    private DeltaErrors$() {
        MODULE$ = this;
        DocsPath.$init$(this);
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.faqRelativePath = "/delta-intro.html#frequently-asked-questions";
        this.EmptyCheckpointErrorMessage = new StringOps(Predef$.MODULE$.augmentString("\n       |Attempted to write an empty checkpoint without any actions. This checkpoint will not be\n       |useful in recomputing the state of the table. However this might cause other checkpoints to\n       |get deleted based on retention settings.\n     ")).stripMargin();
    }
}

