/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import com.databricks.spark.util.TagDefinitions$TAG_TAHOE_PATH$;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AnalysisHelper$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$$anonfun$;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class DeltaLog$
implements DeltaLogging {
    public static DeltaLog$ MODULE$;
    private final Cache<Path, DeltaLog> deltaLogCache;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaLog$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Cache<Path, DeltaLog> deltaLogCache() {
        return this.deltaLogCache;
    }

    public DeltaLog forTable(SparkSession spark, String dataPath) {
        return this.apply(spark, new Path(dataPath, "_delta_log"), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, File dataPath) {
        return this.apply(spark, new Path(dataPath.getAbsolutePath(), "_delta_log"), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, Path dataPath) {
        return this.apply(spark, new Path(dataPath, "_delta_log"), (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, String dataPath, Clock clock) {
        return this.apply(spark, new Path(dataPath, "_delta_log"), clock);
    }

    public DeltaLog forTable(SparkSession spark, File dataPath, Clock clock) {
        return this.apply(spark, new Path(dataPath.getAbsolutePath(), "_delta_log"), clock);
    }

    public DeltaLog forTable(SparkSession spark, Path dataPath, Clock clock) {
        return this.apply(spark, new Path(dataPath, "_delta_log"), clock);
    }

    public DeltaLog forTable(SparkSession spark, TableIdentifier tableName) {
        return this.forTable(spark, tableName, (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, CatalogTable table) {
        return this.forTable(spark, table, (Clock)new SystemClock());
    }

    public DeltaLog forTable(SparkSession spark, TableIdentifier tableName, Clock clock) {
        return DeltaTableIdentifier$.MODULE$.isDeltaPath(spark, tableName) ? this.forTable(spark, new Path(tableName.table())) : this.forTable(spark, spark.sessionState().catalog().getTableMetadata(tableName), clock);
    }

    public DeltaLog forTable(SparkSession spark, CatalogTable table, Clock clock) {
        return this.apply(spark, new Path(new Path(table.location()), "_delta_log"), clock);
    }

    public DeltaLog forTable(SparkSession spark, DeltaTableIdentifier deltaTable) {
        return deltaTable.path().isDefined() ? this.forTable(spark, (String)deltaTable.path().get()) : this.forTable(spark, (TableIdentifier)deltaTable.table().get());
    }

    public DeltaLog apply(SparkSession spark, Path rawPath, Clock clock) {
        DeltaLog deltaLog;
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = rawPath.getFileSystem(hadoopConf);
        Path path = fs.makeQualified(rawPath);
        try {
            deltaLog = (DeltaLog)this.deltaLogCache().get((Object)path, (Callable)new Callable<DeltaLog>(path, clock){
                private final Path path$1;
                private final Clock clock$1;

                public DeltaLog call() {
                    return (DeltaLog)DeltaLog$.MODULE$.recordDeltaOperation(null, "delta.log.create", (Map<TagDefinition, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TagDefinitions$TAG_TAHOE_PATH$.MODULE$), (Object)this.path$1.getParent().toString())}))), (Function0 & Serializable & scala.Serializable)() -> (DeltaLog)AnalysisHelper$.MODULE$.allowInvokingTransformsInAnalyzer((Function0 & Serializable & scala.Serializable)() -> new DeltaLog($this.path$1, $this.path$1.getParent(), $this.clock$1)));
                }
                {
                    this.path$1 = path$1;
                    this.clock$1 = clock$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$call$1(org.apache.spark.sql.delta.DeltaLog$$anon$3 ), $anonfun$call$2(org.apache.spark.sql.delta.DeltaLog$$anon$3 )}, serializedLambda);
                }
            });
        }
        catch (UncheckedExecutionException e) {
            throw e.getCause();
        }
        return deltaLog;
    }

    public Clock apply$default$3() {
        return new SystemClock();
    }

    public void invalidateCache(SparkSession spark, Path dataPath) {
        try {
            Path rawPath = new Path(dataPath, "_delta_log");
            FileSystem fs = rawPath.getFileSystem(spark.sessionState().newHadoopConf());
            Path path = fs.makeQualified(rawPath);
            this.deltaLogCache().invalidate((Object)path);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public void clearCache() {
        this.deltaLogCache().invalidateAll();
    }

    public Dataset<Row> filterFileList(StructType partitionSchema, Dataset<Row> files, Seq<Expression> partitionFilters, Seq<String> partitionColumnPrefixes) {
        Seq<Expression> rewrittenFilters = this.rewritePartitionFilters(partitionSchema, (Function2<String, String, Object>)files.sparkSession().sessionState().conf().resolver(), partitionFilters, partitionColumnPrefixes);
        Column columnFilter = new Column((Expression)rewrittenFilters.reduceLeftOption((Function2)And$.MODULE$).getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        return files.filter(columnFilter);
    }

    public Seq<String> filterFileList$default$4() {
        return Nil$.MODULE$;
    }

    public Seq<Expression> rewritePartitionFilters(StructType partitionSchema, Function2<String, String, Object> resolver, Seq<Expression> partitionFilters, Seq<String> partitionColumnPrefixes) {
        return (Seq)partitionFilters.map((Function1 & Serializable & scala.Serializable)x$1 -> (Expression)x$1.transformUp((PartialFunction)new scala.Serializable(partitionSchema, resolver, partitionColumnPrefixes){
            public static final long serialVersionUID = 0L;
            private final StructType partitionSchema$1;
            private final Function2 resolver$1;
            private final Seq partitionColumnPrefixes$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Attribute) {
                    Cast cast;
                    Some some;
                    StructField structField;
                    Attribute attribute = (Attribute)A1;
                    String unquoted = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(attribute.name())).stripPrefix("`"))).stripSuffix("`");
                    Option partitionCol = this.partitionSchema$1.find((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$rewritePartitionFilters$1$1.$anonfun$applyOrElse$1(this, unquoted, field)));
                    Option option = partitionCol;
                    if (option instanceof Some && (structField = (StructField)(some = (Some)option).value()) != null) {
                        String name = structField.name();
                        DataType dataType = structField.dataType();
                        cast = new Cast((Expression)new UnresolvedAttribute((Seq)this.partitionColumnPrefixes$1.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionValues", name})), Seq$.MODULE$.canBuildFrom())), dataType, Cast$.MODULE$.apply$default$3());
                    } else if (None$.MODULE$.equals(option)) {
                        DeltaLog$.MODULE$.log().error(new StringBuilder(63).append("Partition filter referenced column ").append(attribute.name()).append(" not in the partition schema").toString());
                        cast = new UnresolvedAttribute((Seq)this.partitionColumnPrefixes$1.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionValues", attribute.name()})), Seq$.MODULE$.canBuildFrom()));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object = cast;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof Attribute;
                return bl;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(anonfun$$nestedInanonfun$rewritePartitionFilters$1$1 $this, String unquoted$1, StructField field) {
                return BoxesRunTime.unboxToBoolean((Object)$this.resolver$1.apply((Object)field.name(), (Object)unquoted$1));
            }
            {
                this.partitionSchema$1 = partitionSchema$1;
                this.resolver$1 = resolver$1;
                this.partitionColumnPrefixes$1 = partitionColumnPrefixes$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.delta.DeltaLog$$anonfun$$nestedInanonfun$rewritePartitionFilters$1$1 java.lang.String org.apache.spark.sql.types.StructField )}, serializedLambda);
            }
        }), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> rewritePartitionFilters$default$4() {
        return Nil$.MODULE$;
    }

    private DeltaLog$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        CacheBuilder builder = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<Path, DeltaLog>(){

            public void onRemoval(RemovalNotification<Path, DeltaLog> removalNotification) {
                DeltaLog log = (DeltaLog)removalNotification.getValue();
                try {
                    log.snapshot().uncache();
                }
                catch (NullPointerException nullPointerException) {}
            }
        });
        package$.MODULE$.props().get("delta.log.cacheSize").flatMap((Function1 & Serializable & scala.Serializable)v -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(v)).toLong()).toOption()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.maximumSize(BoxesRunTime.unboxToLong((Object)x$1)));
        this.deltaLogCache = builder.build();
    }
}

