/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaOptionParser;
import org.apache.spark.sql.delta.DeltaOptions$;
import org.apache.spark.sql.delta.DeltaStartingVersion;
import org.apache.spark.sql.delta.StartingVersion$;
import org.apache.spark.sql.delta.StartingVersionLatest$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001q3qa\u0003\u0007\u0011\u0002\u0007\u0005q\u0003C\u0003#\u0001\u0011\u00051\u0005C\u0004(\u0001\t\u0007I\u0011\u0001\u0015\t\u000f=\u0002!\u0019!C\u0001a!9Q\u0007\u0001b\u0001\n\u00031\u0004b\u0002\u001e\u0001\u0005\u0004%\tA\u000e\u0005\bw\u0001\u0011\r\u0011\"\u00017\u0011\u001da\u0004A1A\u0005\u0002uBqa\u0012\u0001C\u0002\u0013\u0005\u0001\nC\u0004N\u0001\t\u0007I\u0011\u0001(\t\u000bm\u0003A\u0011B\u0012\u0003!\u0011+G\u000e^1SK\u0006$w\n\u001d;j_:\u001c(BA\u0007\u000f\u0003\u0015!W\r\u001c;b\u0015\ty\u0001#A\u0002tc2T!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012AB1qC\u000eDWMC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0001S\"\u0001\u0007\n\u0005\u0005b!!\u0005#fYR\fw\n\u001d;j_:\u0004\u0016M]:fe\u00061A%\u001b8ji\u0012\"\u0012\u0001\n\t\u00033\u0015J!A\n\u000e\u0003\tUs\u0017\u000e^\u0001\u0013[\u0006Dh)\u001b7fgB+'\u000f\u0016:jO\u001e,'/F\u0001*!\rI\"\u0006L\u0005\u0003Wi\u0011aa\u00149uS>t\u0007CA\r.\u0013\tq#DA\u0002J]R\f!#\\1y\u0005f$Xm\u001d)feR\u0013\u0018nZ4feV\t\u0011\u0007E\u0002\u001aUI\u0002\"!G\u001a\n\u0005QR\"\u0001\u0002'p]\u001e\f!#[4o_J,g)\u001b7f\t\u0016dW\r^5p]V\tq\u0007\u0005\u0002\u001aq%\u0011\u0011H\u0007\u0002\b\u0005>|G.Z1o\u00035IwM\\8sK\u000eC\u0017M\\4fg\u0006i\u0011n\u001a8pe\u0016$U\r\\3uKN\fA\"\u001a=dYV$WMU3hKb,\u0012A\u0010\t\u00043)z\u0004C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003!i\u0017\r^2iS:<'B\u0001#\u001b\u0003\u0011)H/\u001b7\n\u0005\u0019\u000b%!\u0002*fO\u0016D\u0018aD:uCJ$\u0018N\\4WKJ\u001c\u0018n\u001c8\u0016\u0003%\u00032!\u0007\u0016K!\ty2*\u0003\u0002M\u0019\t!B)\u001a7uCN#\u0018M\u001d;j]\u001e4VM]:j_:\f\u0011c\u001d;beRLgn\u001a+j[\u0016\u001cH/Y7q+\u0005y\u0005cA\r+!B\u0011\u0011\u000b\u0017\b\u0003%Z\u0003\"a\u0015\u000e\u000e\u0003QS!!\u0016\f\u0002\rq\u0012xn\u001c;?\u0013\t9&$\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,\u001b\u0003a\u0001(o\u001c<jI\u0016|e.Z*uCJ$\u0018N\\4PaRLwN\u001c")
public interface DeltaReadOptions
extends DeltaOptionParser {
    public void org$apache$spark$sql$delta$DeltaReadOptions$_setter_$maxFilesPerTrigger_$eq(Option<Object> var1);

    public void org$apache$spark$sql$delta$DeltaReadOptions$_setter_$maxBytesPerTrigger_$eq(Option<Object> var1);

    public void org$apache$spark$sql$delta$DeltaReadOptions$_setter_$ignoreFileDeletion_$eq(boolean var1);

    public void org$apache$spark$sql$delta$DeltaReadOptions$_setter_$ignoreChanges_$eq(boolean var1);

    public void org$apache$spark$sql$delta$DeltaReadOptions$_setter_$ignoreDeletes_$eq(boolean var1);

    public void org$apache$spark$sql$delta$DeltaReadOptions$_setter_$excludeRegex_$eq(Option<Regex> var1);

    public void org$apache$spark$sql$delta$DeltaReadOptions$_setter_$startingVersion_$eq(Option<DeltaStartingVersion> var1);

    public void org$apache$spark$sql$delta$DeltaReadOptions$_setter_$startingTimestamp_$eq(Option<String> var1);

    public Option<Object> maxFilesPerTrigger();

    public Option<Object> maxBytesPerTrigger();

    public boolean ignoreFileDeletion();

    public boolean ignoreChanges();

    public boolean ignoreDeletes();

    public Option<Regex> excludeRegex();

    public Option<DeltaStartingVersion> startingVersion();

    public Option<String> startingTimestamp();

    private void provideOneStartingOption() {
        if (this.startingTimestamp().isDefined() && this.startingVersion().isDefined()) {
            throw DeltaErrors$.MODULE$.startingVersionAndTimestampBothSetException(DeltaOptions$.MODULE$.STARTING_VERSION_OPTION(), DeltaOptions$.MODULE$.STARTING_TIMESTAMP_OPTION());
        }
    }

    public static /* synthetic */ int $anonfun$maxFilesPerTrigger$1(String str) {
        return BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(str)).toInt()).toOption().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 > 0).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.illegalDeltaOptionException(DeltaOptions$.MODULE$.MAX_FILES_PER_TRIGGER_OPTION(), str, "must be a positive integer");
        }));
    }

    public static /* synthetic */ long $anonfun$maxBytesPerTrigger$1(String str) {
        return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> JavaUtils.byteStringAs((String)str, (ByteUnit)ByteUnit.BYTE)).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$6 -> x$6 > 0L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.illegalDeltaOptionException(DeltaOptions$.MODULE$.MAX_BYTES_PER_TRIGGER_OPTION(), str, "must be a size configuration such as '10g'");
        }));
    }

    private Option liftedTree1$1() {
        Option option;
        try {
            option = this.options().get(DeltaOptions$.MODULE$.EXCLUDE_REGEX_OPTION()).map((Function1 & Serializable & scala.Serializable)x$10 -> new StringOps(Predef$.MODULE$.augmentString(x$10)).r());
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(new StringBuilder(33).append("Please recheck your syntax for '").append(DeltaOptions$.MODULE$.EXCLUDE_REGEX_OPTION()).append("'").toString(), e);
        }
        return option;
    }

    public static void $init$(DeltaReadOptions $this) {
        $this.org$apache$spark$sql$delta$DeltaReadOptions$_setter_$maxFilesPerTrigger_$eq((Option<Object>)$this.options().get(DeltaOptions$.MODULE$.MAX_FILES_PER_TRIGGER_OPTION()).map((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToInteger((int)DeltaReadOptions.$anonfun$maxFilesPerTrigger$1(str))));
        $this.org$apache$spark$sql$delta$DeltaReadOptions$_setter_$maxBytesPerTrigger_$eq((Option<Object>)$this.options().get(DeltaOptions$.MODULE$.MAX_BYTES_PER_TRIGGER_OPTION()).map((Function1 & Serializable & scala.Serializable)str -> BoxesRunTime.boxToLong((long)DeltaReadOptions.$anonfun$maxBytesPerTrigger$1(str))));
        $this.org$apache$spark$sql$delta$DeltaReadOptions$_setter_$ignoreFileDeletion_$eq($this.options().get(DeltaOptions$.MODULE$.IGNORE_FILE_DELETION_OPTION()).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$7, DeltaOptions$.MODULE$.IGNORE_FILE_DELETION_OPTION()))));
        $this.org$apache$spark$sql$delta$DeltaReadOptions$_setter_$ignoreChanges_$eq($this.options().get(DeltaOptions$.MODULE$.IGNORE_CHANGES_OPTION()).exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$8, DeltaOptions$.MODULE$.IGNORE_CHANGES_OPTION()))));
        $this.org$apache$spark$sql$delta$DeltaReadOptions$_setter_$ignoreDeletes_$eq($this.options().get(DeltaOptions$.MODULE$.IGNORE_DELETES_OPTION()).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)$this.toBoolean(x$9, DeltaOptions$.MODULE$.IGNORE_DELETES_OPTION()))));
        $this.org$apache$spark$sql$delta$DeltaReadOptions$_setter_$excludeRegex_$eq((Option<Regex>)$this.liftedTree1$1());
        $this.org$apache$spark$sql$delta$DeltaReadOptions$_setter_$startingVersion_$eq((Option<DeltaStartingVersion>)$this.options().get(DeltaOptions$.MODULE$.STARTING_VERSION_OPTION()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            DeltaStartingVersion deltaStartingVersion = "latest".equals(string) ? StartingVersionLatest$.MODULE$ : (DeltaStartingVersion)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(string)).toLong()).toOption().filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 >= 0L).map((Function1)StartingVersion$.MODULE$).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw DeltaErrors$.MODULE$.illegalDeltaOptionException(DeltaOptions$.MODULE$.STARTING_VERSION_OPTION(), string, "must be greater than or equal to zero");
            });
            return deltaStartingVersion;
        }));
        $this.org$apache$spark$sql$delta$DeltaReadOptions$_setter_$startingTimestamp_$eq((Option<String>)$this.options().get(DeltaOptions$.MODULE$.STARTING_TIMESTAMP_OPTION()));
        $this.provideOneStartingOption();
    }
}

