/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.VersionChecksum;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import scala.Function0;
import scala.Option;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00013qAB\u0004\u0011\u0002\u0007\u0005!\u0003C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0004%\u0001\t\u0007i\u0011A\u0013\t\u000b1\u0001a\u0011\u0003\u0016\t\u0011=\u0002\u0001R1A\u0005\nABQ!\u000f\u0001\u0005\u0012i\u0012aBU3d_J$7\t[3dWN,XN\u0003\u0002\t\u0013\u0005)A-\u001a7uC*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQR$D\u0001\u001c\u0015\tar!\u0001\u0005nKR,'/\u001b8h\u0013\tq2D\u0001\u0007EK2$\u0018\rT8hO&tw-\u0001\u0004%S:LG\u000f\n\u000b\u0002CA\u0011ACI\u0005\u0003GU\u0011A!\u00168ji\u0006AA-\u001a7uC2{w-F\u0001'!\t9\u0003&D\u0001\b\u0013\tIsA\u0001\u0005EK2$\u0018\rT8h+\u0005Y\u0003C\u0001\u0017.\u001b\u0005I\u0011B\u0001\u0018\n\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u00199(/\u001b;feV\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003m%\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005a\u001a$!F\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM]\u0001\u0012oJLG/Z\"iK\u000e\\7/^7GS2,GCA\u0011<\u0011\u0015aT\u00011\u0001>\u0003!\u0019h.\u00199tQ>$\bCA\u0014?\u0013\tytA\u0001\u0005T]\u0006\u00048\u000f[8u\u0001")
public interface RecordChecksum
extends DeltaLogging {
    public DeltaLog deltaLog();

    public SparkSession spark();

    public static /* synthetic */ CheckpointFileManager org$apache$spark$sql$delta$RecordChecksum$$writer$(RecordChecksum $this) {
        return $this.org$apache$spark$sql$delta$RecordChecksum$$writer();
    }

    default public CheckpointFileManager org$apache$spark$sql$delta$RecordChecksum$$writer() {
        return CheckpointFileManager$.MODULE$.create(this.deltaLog().logPath(), this.spark().sessionState().newHadoopConf());
    }

    public static /* synthetic */ void writeChecksumFile$(RecordChecksum $this, Snapshot snapshot) {
        $this.writeChecksumFile(snapshot);
    }

    default public void writeChecksumFile(Snapshot snapshot) {
        if (!BoxesRunTime.unboxToBoolean((Object)this.spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_WRITE_CHECKSUM_ENABLED()))) {
            return;
        }
        long version = snapshot.version();
        VersionChecksum checksum = new VersionChecksum(snapshot.sizeInBytes(), snapshot.numOfFiles(), snapshot.numOfMetadata(), snapshot.numOfProtocol(), snapshot.numOfSetTransactions());
        try {
            this.recordDeltaOperation(this.deltaLog(), "delta.checksum.write", this.recordDeltaOperation$default$3(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                CheckpointFileManager.CancellableFSDataOutputStream stream = this.org$apache$spark$sql$delta$RecordChecksum$$writer().createAtomic(FileNames$.MODULE$.checksumFile(this.deltaLog().logPath(), version), false);
                try {
                    String toWrite = new StringBuilder(1).append(JsonUtils$.MODULE$.toJson(checksum, ManifestFactory$.MODULE$.classType(VersionChecksum.class))).append("\n").toString();
                    stream.write(toWrite.getBytes(StandardCharsets.UTF_8));
                    stream.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to write the checksum for version: ").append(version).toString(), e);
                        stream.cancel();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to write the checksum for version: ").append(version).toString(), e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static void $init$(RecordChecksum $this) {
    }
}

