/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.schema;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.util.control.NonFatal$;

public final class SchemaUtils$ {
    public static SchemaUtils$ MODULE$;
    private final Function2<String, String, Object> DELTA_COL_RESOLVER;
    private final int ARRAY_ELEMENT_INDEX;
    private final int MAP_KEY_INDEX;
    private final int MAP_VALUE_INDEX;

    static {
        new SchemaUtils$();
    }

    public Function2<String, String, Object> DELTA_COL_RESOLVER() {
        return this.DELTA_COL_RESOLVER;
    }

    private int ARRAY_ELEMENT_INDEX() {
        return this.ARRAY_ELEMENT_INDEX;
    }

    private int MAP_KEY_INDEX() {
        return this.MAP_KEY_INDEX;
    }

    private int MAP_VALUE_INDEX() {
        return this.MAP_VALUE_INDEX;
    }

    public Seq<Tuple2<Seq<String>, StructField>> filterRecursively(StructType schema, boolean checkComplexTypes, Function1<StructField, Object> f) {
        return this.recurseIntoComplexTypes$1((DataType)schema, (Seq)Nil$.MODULE$, f, checkComplexTypes);
    }

    public boolean typeExistsRecursively(DataType dt, Function1<DataType, Object> f) {
        boolean bl;
        block4: {
            DataType dataType;
            block5: {
                while (true) {
                    if ((dataType = dt) instanceof StructType) {
                        StructType structType = (StructType)dataType;
                        bl = BoxesRunTime.unboxToBoolean((Object)f.apply((Object)structType)) || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.MODULE$.typeExistsRecursively(field.dataType(), (Function1<DataType, Object>)f)));
                        break block4;
                    }
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        if (!BoxesRunTime.unboxToBoolean((Object)f.apply((Object)arrayType))) {
                            dt = arrayType.elementType();
                            continue;
                        }
                        bl = true;
                        break block4;
                    }
                    if (!(dataType instanceof MapType)) break block5;
                    MapType mapType = (MapType)dataType;
                    if (BoxesRunTime.unboxToBoolean((Object)f.apply((Object)mapType)) || this.typeExistsRecursively(mapType.keyType(), f)) break;
                    dt = mapType.valueType();
                }
                bl = true;
                break block4;
            }
            bl = BoxesRunTime.unboxToBoolean((Object)f.apply((Object)dataType));
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType typeAsNullable(DataType dt) {
        DataType s1;
        boolean bl = false;
        ArrayType arrayType = null;
        boolean bl2 = false;
        MapType mapType = null;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return structType.asNullable();
        }
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType s = arrayType.elementType();
            if (s instanceof StructType) {
                StructType structType = (StructType)s;
                return arrayType.copy((DataType)structType.asNullable(), true);
            }
        }
        if (bl) {
            boolean x$1 = true;
            DataType x$2 = arrayType.copy$default$1();
            return arrayType.copy(x$2, x$1);
        }
        if (dataType instanceof MapType) {
            bl2 = true;
            mapType = (MapType)dataType;
            DataType s12 = mapType.keyType();
            DataType s2 = mapType.valueType();
            if (s12 instanceof StructType) {
                StructType structType = (StructType)s12;
                if (s2 instanceof StructType) {
                    StructType structType2 = (StructType)s2;
                    return mapType.copy((DataType)structType.asNullable(), (DataType)structType2.asNullable(), true);
                }
            }
        }
        if (bl2 && (s1 = mapType.keyType()) instanceof StructType) {
            StructType structType = (StructType)s1;
            StructType x$3 = structType.asNullable();
            boolean x$4 = true;
            DataType x$5 = mapType.copy$default$2();
            return mapType.copy((DataType)x$3, x$5, x$4);
        }
        if (!bl2) return dataType;
        DataType s2 = mapType.valueType();
        if (!(s2 instanceof StructType)) return dataType;
        StructType structType = (StructType)s2;
        StructType x$6 = structType.asNullable();
        boolean x$7 = true;
        DataType x$8 = mapType.copy$default$1();
        return mapType.copy(x$8, (DataType)x$6, x$7);
    }

    public Dataset<Row> dropNullTypeColumns(Dataset<Row> df) {
        StructType schema = df.schema();
        if (!this.typeExistsRecursively((DataType)schema, (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$dropNullTypeColumns$1(x$1)))) {
            return df;
        }
        Seq selectExprs = (Seq)schema.flatMap((Function1 & Serializable & scala.Serializable)f -> f.dataType() instanceof NullType ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)this.generateSelectExpr$1((StructField)f, (Seq)Nil$.MODULE$))), Seq$.MODULE$.canBuildFrom());
        return df.select(selectExprs);
    }

    public Seq<String> explodeNestedFieldNames(StructType schema) {
        return (Seq)this.explode$1(schema).map((Function1 & Serializable & scala.Serializable)x$7 -> new UnresolvedAttribute(x$7).name(), Seq$.MODULE$.canBuildFrom());
    }

    public void checkColumnNameDuplication(StructType schema, String colType) {
        Seq<String> columnNames = this.explodeNestedFieldNames(schema);
        Seq names = (Seq)columnNames.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toLowerCase(), Seq$.MODULE$.canBuildFrom());
        if (((SeqLike)names.distinct()).length() != names.length()) {
            Iterable duplicateColumns = (Iterable)names.groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            object = String.valueOf(x);
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, Seq<String>> x1) {
                    Seq ys;
                    Tuple2<String, Seq<String>> tuple2 = x1;
                    boolean bl = tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                    return bl;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            throw new AnalysisException(new StringBuilder(28).append("Found duplicate column(s) ").append(colType).append(": ").append(duplicateColumns.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public Dataset<Row> normalizeColumnNames(StructType baseSchema, Dataset<?> data) {
        Dataset dataset;
        scala.collection.immutable.Set tableFields;
        StructType dataSchema = data.schema();
        scala.collection.immutable.Set dataFields = this.explodeNestedFieldNames(dataSchema).toSet();
        if (dataFields.subsetOf((GenSet)(tableFields = this.explodeNestedFieldNames(baseSchema).toSet()))) {
            dataset = data.toDF();
        } else {
            Set topLevelDataFields = (Set)dataFields.map((Function1 & Serializable & scala.Serializable)x$9 -> (String)UnresolvedAttribute$.MODULE$.parseAttributeName(x$9).head(), Set$.MODULE$.canBuildFrom());
            if (topLevelDataFields.subsetOf((GenSet)tableFields)) {
                scala.collection.immutable.Set columnsThatNeedRenaming = (scala.collection.immutable.Set)dataFields.$minus$minus((GenTraversableOnce)tableFields);
                throw new AnalysisException(new StringBuilder(75).append("Nested fields need renaming to avoid data loss. ").append("Fields:\n").append(columnsThatNeedRenaming.mkString("[", ", ", "]")).append(".\n").append("Original schema:\n").append(baseSchema.treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            Map<String, StructField> baseFields = this.toFieldMap((Seq<StructField>)baseSchema);
            Seq aliasExpressions = (Seq)dataSchema.map((Function1 & Serializable & scala.Serializable)field -> {
                StructField originalCase = (StructField)baseFields.getOrElse((Object)field.name(), (Function0 & Serializable & scala.Serializable)() -> {
                    throw new AnalysisException(new StringBuilder(25).append("Can't resolve column ").append(field.name()).append(" in ").append(baseSchema.treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                });
                String string = originalCase.name();
                String string2 = field.name();
                return (string == null ? string2 != null : !string.equals(string2)) ? functions$.MODULE$.col(field.name()).as(originalCase.name()) : functions$.MODULE$.col(field.name());
            }, Seq$.MODULE$.canBuildFrom());
            dataset = data.select(aliasExpressions);
        }
        return dataset;
    }

    public boolean isReadCompatible(StructType existingSchema, StructType readSchema) {
        return this.isStructReadCompatible$1(existingSchema, readSchema, existingSchema, readSchema);
    }

    public Seq<String> reportDifferences(StructType existingSchema, StructType specifiedSchema) {
        return this.structDifference$1(existingSchema, specifiedSchema, "");
    }

    public Tuple2<Seq<Object>, Object> findColumnPosition(Seq<String> column, StructType schema, Function2<String, String, Object> resolver) {
        Tuple2 tuple2;
        try {
            tuple2 = this.find$1(column, schema, (Seq)Nil$.MODULE$, resolver);
        }
        catch (IndexOutOfBoundsException i) {
            throw DeltaErrors$.MODULE$.columnNotInSchemaException(i.getMessage(), schema);
        }
        catch (AnalysisException e) {
            throw new AnalysisException(new StringBuilder(2).append(e.getMessage()).append(":\n").append(schema.treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return tuple2;
    }

    public Function2<String, String, Object> findColumnPosition$default$3() {
        return this.DELTA_COL_RESOLVER();
    }

    public String prettyFieldName(Seq<String> columnPath) {
        return new UnresolvedAttribute(columnPath).name();
    }

    /*
     * Unable to fully structure code
     */
    public StructType addColumn(StructType schema, StructField column, Seq<Object> position) {
        block17: {
            block10: {
                block12: {
                    block14: {
                        block16: {
                            block15: {
                                block13: {
                                    block11: {
                                        Predef$.MODULE$.require(position.nonEmpty(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$addColumn$1(org.apache.spark.sql.types.StructField ), ()Ljava/lang/String;)((StructField)column));
                                        slicePosition = BoxesRunTime.unboxToInt((Object)position.head());
                                        if (slicePosition < 0) {
                                            throw new AnalysisException(new StringBuilder(37).append("Index ").append(slicePosition).append(" to add column ").append(column).append(" is lower than 0").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                        }
                                        length = schema.length();
                                        if (slicePosition > length) {
                                            throw new AnalysisException(new StringBuilder(52).append("Index ").append(slicePosition).append(" to add column ").append(column).append(" is larger than struct length: ").append(length).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                        }
                                        if (slicePosition == length) {
                                            if (position.length() > 1) {
                                                throw new AnalysisException(new StringBuilder(29).append("Struct not found at position ").append(slicePosition).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                            }
                                            return StructType$.MODULE$.apply((Seq)schema.$colon$plus((Object)column, Seq$.MODULE$.canBuildFrom()));
                                        }
                                        pre = (Seq)schema.take(slicePosition);
                                        if (position.length() <= 1) break block10;
                                        posTail = (Seq)position.tail();
                                        var11_8 = schema.apply(slicePosition);
                                        if (var11_8 == null) break block11;
                                        name = var11_8.name();
                                        f = var11_8.dataType();
                                        nullable = var11_8.nullable();
                                        metadata = var11_8.metadata();
                                        if (!(f instanceof StructType)) break block11;
                                        var16_13 = (StructType)f;
                                        if (!column.nullable() && nullable) {
                                            throw new AnalysisException("A non-nullable nested field can't be added to a nullable parent. Please set the nullability of the parent column accordingly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                        }
                                        var4_14 = new StructField(name, (DataType)this.addColumn(var16_13, column, (Seq<Object>)posTail), nullable, metadata);
                                        break block12;
                                    }
                                    if (var11_8 == null) break block13;
                                    name = var11_8.name();
                                    var18_16 = var11_8.dataType();
                                    nullable = var11_8.nullable();
                                    metadata = var11_8.metadata();
                                    if (!(var18_16 instanceof ArrayType)) break block13;
                                    var21_19 = (ArrayType)var18_16;
                                    f = var21_19.elementType();
                                    containsNull = var21_19.containsNull();
                                    if (!(f instanceof StructType)) break block13;
                                    var24_22 = (StructType)f;
                                    if (!column.nullable() && nullable) {
                                        throw new AnalysisException("A non-nullable nested field can't be added to a nullable parent. Please set the nullability of the parent column accordingly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                    }
                                    if (BoxesRunTime.unboxToInt((Object)posTail.head()) != this.ARRAY_ELEMENT_INDEX()) {
                                        throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString("Incorrectly accessing an ArrayType. Use arrayname.element.elementname position to\n                 |add to an array.\n               ")).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                    }
                                    var4_14 = new StructField(name, (DataType)new ArrayType((DataType)this.addColumn(var24_22, column, (Seq<Object>)((Seq)posTail.tail())), containsNull), nullable, metadata);
                                    break block12;
                                }
                                if (var11_8 == null) break block14;
                                name = var11_8.name();
                                map = var11_8.dataType();
                                nullable = var11_8.nullable();
                                metadata = var11_8.metadata();
                                if (!(map instanceof MapType)) break block14;
                                var29_27 = (MapType)map;
                                if (!column.nullable() && nullable) {
                                    throw new AnalysisException("A non-nullable nested field can't be added to a nullable parent. Please set the nullability of the parent column accordingly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                }
                                var31_28 = new Tuple2(posTail.head(), (Object)var29_27);
                                if (var31_28 == null) break block15;
                                var32_29 = var31_28._1$mcI$sp();
                                var33_30 = (MapType)var31_28._2();
                                if (this.MAP_KEY_INDEX() != var32_29 || var33_30 == null) break block15;
                                key = var33_30.keyType();
                                v = var33_30.valueType();
                                nullability = var33_30.valueContainsNull();
                                if (!(key instanceof StructType)) break block15;
                                var37_34 = (StructType)key;
                                var5_35 = new MapType((DataType)this.addColumn(var37_34, column, (Seq<Object>)((Seq)posTail.tail())), v, nullability);
                                break block16;
                            }
                            if (var31_28 == null) ** GOTO lbl-1000
                            var38_36 = var31_28._1$mcI$sp();
                            var39_37 = (MapType)var31_28._2();
                            if (this.MAP_VALUE_INDEX() != var38_36 || var39_37 == null) ** GOTO lbl-1000
                            k = var39_37.keyType();
                            value = var39_37.valueType();
                            nullability = var39_37.valueContainsNull();
                            if (value instanceof StructType) {
                                var43_41 = (StructType)value;
                                var5_35 = new MapType(k, (DataType)this.addColumn(var43_41, column, (Seq<Object>)((Seq)posTail.tail())), nullability);
                            } else lbl-1000:
                            // 3 sources

                            {
                                throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(88).append("\n                  |Cannot add ").append(column.name()).append(" because its parent is not a StructType.\n                ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                        }
                        addedMap = var5_35;
                        var4_14 = new StructField(name, (DataType)addedMap, nullable, metadata);
                        break block12;
                    }
                    throw new AnalysisException(new StringBuilder(58).append("Cannot add ").append(column.name()).append(" because its parent is not a ").append("StructType. Found ").append(var11_8.dataType()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                mid = var4_14;
                v0 = StructType$.MODULE$.apply((Seq)((TraversableLike)pre.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{mid})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)schema.slice(slicePosition + 1, length), Seq$.MODULE$.canBuildFrom()));
                break block17;
            }
            v0 = StructType$.MODULE$.apply((Seq)((TraversableLike)pre.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{column})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)schema.slice(slicePosition, length), Seq$.MODULE$.canBuildFrom()));
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<StructType, StructField> dropColumn(StructType schema, Seq<Object> position) {
        Tuple2 tuple2;
        Predef$.MODULE$.require(position.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Don't know where to drop the column");
        int slicePosition = BoxesRunTime.unboxToInt((Object)position.head());
        if (slicePosition < 0) {
            throw new AnalysisException(new StringBuilder(37).append("Index ").append(slicePosition).append(" to drop column is lower than 0").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        int length = schema.length();
        if (slicePosition >= length) {
            throw new AnalysisException(new StringBuilder(65).append("Index ").append(slicePosition).append(" to drop column equals to or is larger than struct length: ").append(length).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Seq pre = (Seq)schema.take(slicePosition);
        if (position.length() > 1) {
            StructField structField = schema.apply(slicePosition);
            if (structField == null) throw new AnalysisException(new StringBuilder(53).append("Can only drop nested columns from StructType. Found: ").append(structField).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            String name = structField.name();
            DataType f = structField.dataType();
            boolean nullable = structField.nullable();
            Metadata metadata = structField.metadata();
            if (!(f instanceof StructType)) throw new AnalysisException(new StringBuilder(53).append("Can only drop nested columns from StructType. Found: ").append(structField).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            StructType structType = (StructType)f;
            Tuple2<StructType, StructField> tuple22 = this.dropColumn(structType, (Seq<Object>)((Seq)position.tail()));
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            StructType dropped = (StructType)tuple22._1();
            StructField original = (StructField)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)dropped, (Object)original);
            Tuple2 tuple24 = tuple23;
            StructType dropped2 = (StructType)tuple24._1();
            StructField original2 = (StructField)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)new StructField(name, (DataType)dropped2, nullable, metadata), (Object)original2);
            Tuple2 tuple26 = tuple25;
            if (tuple26 == null) {
                throw new MatchError((Object)tuple26);
            }
            StructField mid = (StructField)tuple26._1();
            StructField original3 = (StructField)tuple26._2();
            Tuple2 tuple27 = new Tuple2((Object)mid, (Object)original3);
            Tuple2 tuple28 = tuple27;
            StructField mid2 = (StructField)tuple28._1();
            StructField original4 = (StructField)tuple28._2();
            tuple2 = new Tuple2((Object)StructType$.MODULE$.apply((Seq)((TraversableLike)pre.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{mid2})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)schema.slice(slicePosition + 1, length), Seq$.MODULE$.canBuildFrom())), (Object)original4);
            return tuple2;
        } else {
            tuple2 = new Tuple2((Object)StructType$.MODULE$.apply((Seq)pre.$plus$plus((GenTraversableOnce)schema.slice(slicePosition + 1, length), Seq$.MODULE$.canBuildFrom())), (Object)schema.apply(slicePosition));
        }
        return tuple2;
    }

    public Option<String> canChangeDataType(DataType from, DataType to, Function2<String, String, Object> resolver, Seq<String> columnPath) {
        Some some;
        try {
            this.check$1(from, to, columnPath, resolver);
            some = None$.MODULE$;
        }
        catch (AnalysisException e) {
            some = new Some((Object)e.message());
        }
        return some;
    }

    public Seq<String> canChangeDataType$default$4() {
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType changeDataType(DataType from, DataType to, Function2<String, String, Object> resolver) {
        Tuple2 tuple2 = new Tuple2((Object)from, (Object)to);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType fromElement = arrayType.elementType();
                boolean fn = arrayType.containsNull();
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType2;
                    DataType toElement = arrayType2.elementType();
                    return new ArrayType(this.changeDataType(fromElement, toElement, resolver), fn);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType fromKey = mapType.keyType();
                DataType fromValue = mapType.valueType();
                boolean fn = mapType.valueContainsNull();
                if (dataType3 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType3;
                    DataType toKey = mapType2.keyType();
                    DataType toValue = mapType2.valueType();
                    return new MapType(this.changeDataType(fromKey, toKey, resolver), this.changeDataType(fromValue, toValue, resolver), fn);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] toFields = structType2.fields();
                    return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toFields)).map((Function1 & Serializable & scala.Serializable)toField -> (StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fromFields)).find((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$changeDataType$2(resolver, toField, field))).map((Function1 & Serializable & scala.Serializable)fromField -> {
                        StructField qual$1 = (StructField)toField.getComment().map((Function1 & Serializable & scala.Serializable)comment -> fromField.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> fromField);
                        DataType x$1 = MODULE$.changeDataType(fromField.dataType(), toField.dataType(), resolver);
                        boolean x$2 = toField.nullable();
                        String x$3 = qual$1.copy$default$1();
                        Metadata x$4 = qual$1.copy$default$4();
                        return qual$1.copy(x$3, x$1, x$2, x$4);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> toField), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        DataType toDataType = (DataType)tuple2._2();
        return toDataType;
    }

    public StructType mergeSchemas(StructType tableSchema, StructType dataSchema) {
        this.checkColumnNameDuplication(dataSchema, "in the data to save");
        return (StructType)this.merge$1((DataType)tableSchema, (DataType)dataSchema);
    }

    private Map<String, StructField> toFieldMap(Seq<StructField> fields) {
        return CaseInsensitiveMap$.MODULE$.apply(((TraversableOnce)fields.map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), field), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public StructType transformColumns(StructType schema, Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField> tf) {
        return (StructType)SchemaUtils$.transform$1((Seq)Seq$.MODULE$.empty(), (DataType)schema, tf);
    }

    public StructType transformColumnsStructs(StructType schema, String colName, Function3<Seq<String>, StructType, Function2<String, String, Object>, Seq<StructField>> tf) {
        return (StructType)this.transform$2((Seq)Seq$.MODULE$.empty(), (DataType)schema, colName, tf);
    }

    public <E> StructType transformColumns(StructType schema, Seq<Tuple2<Seq<String>, E>> input, Function3<Seq<String>, StructField, Seq<Tuple2<Seq<String>, E>>, StructField> tf) {
        Map inputLookup = input.groupBy((Function1 & Serializable & scala.Serializable)x$25 -> (Seq)((TraversableLike)x$25._1()).map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.toLowerCase(), Seq$.MODULE$.canBuildFrom()));
        return this.transformColumns(schema, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)(Function3 & Serializable & scala.Serializable)(path, field, resolver) -> {
            Seq fullPath = (Seq)path.$colon$plus((Object)field.name(), Seq$.MODULE$.canBuildFrom());
            Seq normalizedFullPath = (Seq)fullPath.map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.toLowerCase(), Seq$.MODULE$.canBuildFrom());
            Seq matches = (Seq)Option$.MODULE$.option2Iterable(inputLookup.get((Object)normalizedFullPath)).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$28 -> (Seq)x$28.filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$transformColumns$7(fullPath, resolver, x$29))), Seq$.MODULE$.canBuildFrom());
            return matches.nonEmpty() ? (StructField)tf.apply(path, field, (Object)matches) : field;
        });
    }

    public void checkFieldNames(Seq<String> names) {
        ParquetSchemaConverter$.MODULE$.checkFieldNames(names);
        names.find((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.contains("\n"))).foreach((Function1 & Serializable & scala.Serializable)col -> {
            throw DeltaErrors$.MODULE$.invalidColumnName((String)col);
        });
    }

    public StructType removeUnenforceableNotNullConstraints(StructType schema, SQLConf conf) {
        boolean allowUnenforceableNotNulls = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.ALLOW_UNENFORCED_NOT_NULL_CONSTRAINTS()));
        return this.transformColumns(schema, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)(Function3 & Serializable & scala.Serializable)(path, f, r) -> this.checkField$1((Seq)path, (StructField)f, (Function2)r, allowUnenforceableNotNulls));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Seq recurseIntoComplexTypes$1(DataType complexType, Seq columnStack, Function1 f$1, boolean checkComplexTypes$1) {
        DataType dataType;
        while (true) {
            if ((dataType = complexType) instanceof StructType) {
                StructType structType = (StructType)dataType;
                return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).flatMap((Function1 & Serializable & scala.Serializable)sf -> {
                    Nil$ includeLevel = BoxesRunTime.unboxToBoolean((Object)f$1.apply(sf)) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)columnStack, sf)})) : Nil$.MODULE$;
                    return (Seq)includeLevel.$plus$plus((GenTraversableOnce)this.recurseIntoComplexTypes$1(sf.dataType(), (Seq)columnStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom()), f$1, checkComplexTypes$1), Seq$.MODULE$.canBuildFrom());
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            if (!checkComplexTypes$1) break;
            complexType = arrayType.elementType();
        }
        if (!(dataType instanceof MapType)) return Nil$.MODULE$;
        MapType mapType = (MapType)dataType;
        if (!checkComplexTypes$1) return Nil$.MODULE$;
        return (Seq)this.recurseIntoComplexTypes$1(mapType.keyType(), (Seq)columnStack.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), f$1, checkComplexTypes$1).$plus$plus((GenTraversableOnce)this.recurseIntoComplexTypes$1(mapType.valueType(), (Seq)columnStack.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom()), f$1, checkComplexTypes$1), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$dropNullTypeColumns$1(DataType x$1) {
        return x$1 instanceof NullType;
    }

    public static final /* synthetic */ boolean $anonfun$dropNullTypeColumns$3(DataType x$2) {
        return x$2 instanceof NullType;
    }

    public static final /* synthetic */ boolean $anonfun$dropNullTypeColumns$4(DataType x$3) {
        return x$3 instanceof NullType;
    }

    private final Column generateSelectExpr$1(StructField sf, Seq nameStack) {
        Column column;
        DataType dataType = sf.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Column[] nested = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).flatMap((Function1 & Serializable & scala.Serializable)f -> f.dataType() instanceof NullType ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)this.generateSelectExpr$1((StructField)f, (Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom())))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            column = functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])nested)).alias(sf.name());
        } else {
            MapType mapType;
            ArrayType arrayType;
            if (dataType instanceof ArrayType && this.typeExistsRecursively((DataType)(arrayType = (ArrayType)dataType), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$dropNullTypeColumns$3(x$2)))) {
                String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom())).name();
                throw new AnalysisException(new StringBuilder(112).append("Found nested NullType in column ").append(colName).append(" which is of ArrayType. Delta doesn't ").append("support writing NullType in complex types.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            if (dataType instanceof MapType && this.typeExistsRecursively((DataType)(mapType = (MapType)dataType), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$dropNullTypeColumns$4(x$3)))) {
                String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom())).name();
                throw new AnalysisException(new StringBuilder(110).append("Found nested NullType in column ").append(colName).append(" which is of MapType. Delta doesn't ").append("support writing NullType in complex types.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom())).name();
            column = functions$.MODULE$.col(colName).alias(sf.name());
        }
        return column;
    }

    private final Seq recurseIntoComplexTypes$2(DataType complexType) {
        Seq seq;
        block4: {
            DataType dataType;
            while (true) {
                if ((dataType = complexType) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    seq = this.explode$1(structType);
                    break block4;
                }
                if (!(dataType instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType;
                complexType = arrayType.elementType();
            }
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                seq = (Seq)((TraversableLike)this.recurseIntoComplexTypes$2(mapType.keyType()).map((Function1 & Serializable & scala.Serializable)x$4 -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"}))).$plus$plus((GenTraversableOnce)x$4, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.recurseIntoComplexTypes$2(mapType.valueType()).map((Function1 & Serializable & scala.Serializable)x$5 -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$plus$plus((GenTraversableOnce)x$5, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            } else {
                seq = Nil$.MODULE$;
            }
        }
        return seq;
    }

    private final Seq explode$1(StructType schema) {
        return (Seq)schema.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                DataType s = structField.dataType();
                if (s instanceof StructType) {
                    StructType structType = (StructType)s;
                    return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))}))).$plus$plus((GenTraversableOnce)this.explode$1(structType).map((Function1 & Serializable & scala.Serializable)nested -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))).$plus$plus((GenTraversableOnce)nested, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType a = structField.dataType();
                if (a instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)a;
                    return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))}))).$plus$plus((GenTraversableOnce)this.recurseIntoComplexTypes$2((DataType)arrayType).map((Function1 & Serializable & scala.Serializable)nested -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))).$plus$plus((GenTraversableOnce)nested, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType m = structField.dataType();
                if (m instanceof MapType) {
                    MapType mapType = (MapType)m;
                    return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))}))).$plus$plus((GenTraversableOnce)this.recurseIntoComplexTypes$2((DataType)mapType).map((Function1 & Serializable & scala.Serializable)nested -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))).$plus$plus((GenTraversableOnce)nested, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                }
            }
            Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{structField.name()}));
            return Nil$.MODULE$.$colon$colon((Object)seq);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final boolean isDatatypeReadCompatible$1(DataType existing, DataType newtype) {
        boolean bl;
        block10: {
            Tuple2 tuple2;
            block11: {
                while (true) {
                    if ((tuple2 = new Tuple2((Object)existing, (Object)newtype)) != null) {
                        DataType e = (DataType)tuple2._1();
                        DataType n = (DataType)tuple2._2();
                        if (e instanceof StructType) {
                            StructType structType = (StructType)e;
                            if (n instanceof StructType) {
                                StructType structType2 = (StructType)n;
                                bl = this.isReadCompatible(structType, structType2);
                                break block10;
                            }
                        }
                    }
                    if (tuple2 != null) {
                        DataType e = (DataType)tuple2._1();
                        DataType n = (DataType)tuple2._2();
                        if (e instanceof ArrayType) {
                            ArrayType arrayType = (ArrayType)e;
                            if (n instanceof ArrayType) {
                                ArrayType arrayType2 = (ArrayType)n;
                                if (arrayType.containsNull() || !arrayType2.containsNull()) {
                                    newtype = arrayType2.elementType();
                                    existing = arrayType.elementType();
                                    continue;
                                }
                                bl = false;
                                break block10;
                            }
                        }
                    }
                    if (tuple2 == null) break block11;
                    DataType e = (DataType)tuple2._1();
                    DataType n = (DataType)tuple2._2();
                    if (!(e instanceof MapType)) break block11;
                    MapType mapType = (MapType)e;
                    if (!(n instanceof MapType)) break block11;
                    MapType mapType2 = (MapType)n;
                    if (!mapType.valueContainsNull() && mapType2.valueContainsNull() || !this.isDatatypeReadCompatible$1(mapType.keyType(), mapType2.keyType())) break;
                    newtype = mapType2.valueType();
                    existing = mapType.valueType();
                }
                bl = false;
                break block10;
            }
            if (tuple2 != null) {
                DataType a = (DataType)tuple2._1();
                DataType b = (DataType)tuple2._2();
                DataType dataType = a;
                DataType dataType2 = b;
                bl = !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null);
            } else {
                throw new MatchError((Object)tuple2);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isReadCompatible$6(SchemaUtils$ $this, StructField newField$1, StructField existingField) {
        String string = existingField.name();
        String string2 = newField$1.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!existingField.nullable()) {
            if (newField$1.nullable()) return false;
        }
        if (!$this.isDatatypeReadCompatible$1(existingField.dataType(), newField$1.dataType())) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$isReadCompatible$5(SchemaUtils$ $this, Map existing$1, StructField newField) {
        return existing$1.get((Object)newField.name()).forall((Function1 & Serializable & scala.Serializable)existingField -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$isReadCompatible$6($this, newField, existingField)));
    }

    private final boolean isStructReadCompatible$1(StructType existing, StructType newtype, StructType existingSchema$1, StructType readSchema$1) {
        Map<String, StructField> existing2 = this.toFieldMap((Seq<StructField>)existingSchema$1);
        scala.collection.immutable.Set existingFieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingSchema$1.fieldNames())).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        Predef$.MODULE$.assert(existingFieldNames.size() == existingSchema$1.length(), (Function0 & Serializable & scala.Serializable)() -> "Delta tables don't allow field names that only differ by case");
        scala.collection.immutable.Set newFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readSchema$1.fieldNames())).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        Predef$.MODULE$.assert(newFields.size() == readSchema$1.length(), (Function0 & Serializable & scala.Serializable)() -> "Delta tables don't allow field names that only differ by case");
        if (!existingFieldNames.subsetOf((GenSet)newFields)) {
            return false;
        }
        return readSchema$1.forall((Function1 & Serializable & scala.Serializable)newField -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$isReadCompatible$5(this, existing2, newField)));
    }

    private static final String canOrNot$1(boolean can) {
        return can ? "can" : "can not";
    }

    private static final String isOrNon$1(boolean b) {
        return b ? "" : "non-";
    }

    private static final String missingFieldsMessage$1(scala.collection.immutable.Set fields) {
        return new StringBuilder(38).append("Specified schema is missing field(s): ").append(fields.mkString(", ")).toString();
    }

    private static final String additionalFieldsMessage$1(scala.collection.immutable.Set fields) {
        return new StringBuilder(42).append("Specified schema has additional field(s): ").append(fields.mkString(", ")).toString();
    }

    private static final String fieldNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(71).append("Field ").append(field).append(" is ").append(SchemaUtils$.isOrNon$1(specified)).append("nullable in specified ").append("schema but ").append(SchemaUtils$.isOrNon$1(existing)).append("nullable in existing schema.").toString();
    }

    private static final String arrayNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(70).append("Array field ").append(field).append(" ").append(SchemaUtils$.canOrNot$1(specified)).append(" contain null in specified schema ").append("but ").append(SchemaUtils$.canOrNot$1(existing)).append(" in existing schema").toString();
    }

    private static final String valueNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(75).append("Map field ").append(field).append(" ").append(SchemaUtils$.canOrNot$1(specified)).append(" contain null values in specified schema ").append("but ").append(SchemaUtils$.canOrNot$1(existing)).append(" in existing schema").toString();
    }

    private static final String metadataDifferentMessage$1(String field, Metadata specified, Metadata existing) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(108).append("Specified metadata for field ").append(field).append(" is different from existing schema:\n         |Specified: ").append(specified).append("\n         |Existing:  ").append(existing).toString())).stripMargin();
    }

    private static final String typeDifferenceMessage$1(String field, DataType specified, DataType existing) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("Specified type for ").append(field).append(" is different from existing schema:\n         |Specified: ").append(specified.typeName()).append("\n         |Existing:  ").append(existing.typeName()).toString())).stripMargin();
    }

    private final Seq structDifference$1(StructType existing, StructType specified, String prefix) {
        scala.collection.immutable.Set specifiedFieldNames;
        scala.collection.immutable.Set existingFieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existing.fieldNames())).toSet();
        scala.collection.immutable.Set missingFields = (scala.collection.immutable.Set)existingFieldNames.diff((GenSet)(specifiedFieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])specified.fieldNames())).toSet()));
        Nil$ missingFieldsDiffs = missingFields.isEmpty() ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.missingFieldsMessage$1((scala.collection.immutable.Set)missingFields.map((Function1 & Serializable & scala.Serializable)x$12 -> new StringBuilder(0).append(prefix).append((String)x$12).toString(), scala.collection.immutable.Set$.MODULE$.canBuildFrom()))}));
        scala.collection.immutable.Set extraFields = (scala.collection.immutable.Set)specifiedFieldNames.diff((GenSet)existingFieldNames);
        Nil$ extraFieldsDiffs = extraFields.isEmpty() ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.additionalFieldsMessage$1((scala.collection.immutable.Set)extraFields.map((Function1 & Serializable & scala.Serializable)x$13 -> new StringBuilder(0).append(prefix).append((String)x$13).toString(), scala.collection.immutable.Set$.MODULE$.canBuildFrom()))}));
        Map<String, StructField> existingFields = this.toFieldMap((Seq<StructField>)existing);
        Map<String, StructField> specifiedFields = this.toFieldMap((Seq<StructField>)specified);
        Set fieldsDiffs = (Set)((TraversableLike)existingFieldNames.intersect((GenSet)specifiedFieldNames)).flatMap((Function1 & Serializable & scala.Serializable)name -> this.fieldDifference$1((StructField)existingFields.apply(name), (StructField)specifiedFields.apply(name), prefix), Set$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)missingFieldsDiffs.$plus$plus((GenTraversableOnce)extraFieldsDiffs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)fieldsDiffs, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq fieldDifference$1(StructField existing, StructField specified, String prefix) {
        String name = new StringBuilder(0).append(prefix).append(existing.name()).toString();
        Nil$ nullabilityDiffs = existing.nullable() == specified.nullable() ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.fieldNullabilityMessage$1(String.valueOf(name), specified.nullable(), existing.nullable())}));
        Metadata metadata = existing.metadata();
        Metadata metadata2 = specified.metadata();
        Nil$ metadataDiffs = !(metadata != null ? !metadata.equals(metadata2) : metadata2 != null) ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.metadataDifferentMessage$1(String.valueOf(name), specified.metadata(), existing.metadata())}));
        Seq typeDiffs = this.typeDifference$1(existing.dataType(), specified.dataType(), name);
        return (Seq)((TraversableLike)nullabilityDiffs.$plus$plus((GenTraversableOnce)metadataDiffs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)typeDiffs, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Seq typeDifference$1(DataType existing, DataType specified, String field) {
        Tuple2 tuple2 = new Tuple2((Object)existing, (Object)specified);
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof StructType) {
                StructType structType = (StructType)e;
                if (s instanceof StructType) {
                    StructType structType2 = (StructType)s;
                    return this.structDifference$1(structType, structType2, new StringBuilder(1).append(field).append(".").toString());
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)e;
                if (s instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)s;
                    return this.arrayDifference$1(arrayType, arrayType2, new StringBuilder(2).append(field).append("[]").toString());
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof MapType) {
                MapType mapType = (MapType)e;
                if (s instanceof MapType) {
                    MapType mapType2 = (MapType)s;
                    return this.mapDifference$1(mapType, mapType2, String.valueOf(field));
                }
            }
        }
        if (tuple2 == null) return Nil$.MODULE$;
        DataType e = (DataType)tuple2._1();
        DataType s = (DataType)tuple2._2();
        DataType dataType = e;
        DataType dataType2 = s;
        if (dataType == null) {
            if (dataType2 == null) return Nil$.MODULE$;
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.typeDifferenceMessage$1(field, s, e)}));
        } else if (dataType.equals(dataType2)) return Nil$.MODULE$;
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.typeDifferenceMessage$1(field, s, e)}));
    }

    private final Seq arrayDifference$1(ArrayType existing, ArrayType specified, String field) {
        Seq elementDiffs = this.typeDifference$1(existing.elementType(), specified.elementType(), field);
        Nil$ nullabilityDiffs = existing.containsNull() == specified.containsNull() ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.arrayNullabilityMessage$1(field, specified.containsNull(), existing.containsNull())}));
        return (Seq)elementDiffs.$plus$plus((GenTraversableOnce)nullabilityDiffs, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq mapDifference$1(MapType existing, MapType specified, String field) {
        Seq keyDiffs = this.typeDifference$1(existing.keyType(), specified.keyType(), new StringBuilder(5).append(field).append("[key]").toString());
        Seq valueDiffs = this.typeDifference$1(existing.valueType(), specified.valueType(), new StringBuilder(7).append(field).append("[value]").toString());
        Nil$ nullabilityDiffs = existing.valueContainsNull() == specified.valueContainsNull() ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{SchemaUtils$.valueNullabilityMessage$1(field, specified.valueContainsNull(), existing.valueContainsNull())}));
        return (Seq)((TraversableLike)keyDiffs.$plus$plus((GenTraversableOnce)valueDiffs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)nullabilityDiffs, Seq$.MODULE$.canBuildFrom());
    }

    private static final /* synthetic */ String columnPath$lzycompute$1(LazyRef columnPath$lzy$1, Seq stack$1, String thisCol$1) {
        String string;
        LazyRef lazyRef = columnPath$lzy$1;
        synchronized (lazyRef) {
            string = columnPath$lzy$1.initialized() ? (String)columnPath$lzy$1.value() : (String)columnPath$lzy$1.initialize((Object)new UnresolvedAttribute((Seq)stack$1.$colon$plus((Object)thisCol$1, Seq$.MODULE$.canBuildFrom())).name());
        }
        return string;
    }

    private static final String columnPath$1(LazyRef columnPath$lzy$1, Seq stack$1, String thisCol$1) {
        return columnPath$lzy$1.initialized() ? (String)columnPath$lzy$1.value() : SchemaUtils$.columnPath$lzycompute$1(columnPath$lzy$1, stack$1, thisCol$1);
    }

    public static final /* synthetic */ boolean $anonfun$findColumnPosition$1(Function2 resolver$1, String thisCol$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)thisCol$1));
    }

    /*
     * Unable to fully structure code
     */
    private final Tuple2 find$1(Seq column, StructType schema, Seq stack, Function2 resolver$1) {
        block14: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block13: {
                                            columnPath$lzy = new LazyRef();
                                            if (column.isEmpty()) {
                                                return new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)schema.size()));
                                            }
                                            thisCol = (String)column.head();
                                            pos = schema.indexWhere((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$findColumnPosition$1$adapted(scala.Function2 java.lang.String org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/Object;)((Function2)resolver$1, (String)thisCol));
                                            if (pos == -1) {
                                                throw new IndexOutOfBoundsException(SchemaUtils$.columnPath$1(columnPath$lzy, stack, thisCol));
                                            }
                                            colTail = (Seq)column.tail();
                                            var16_9 = new Tuple2((Object)colTail, (Object)schema.apply(pos).dataType());
                                            if (var16_9 == null || !((s = (DataType)var16_9._2()) instanceof StructType)) break block13;
                                            var18_11 = (StructType)s;
                                            var6_12 = this.find$1(colTail, var18_11, (Seq)stack.$colon$plus((Object)thisCol, Seq$.MODULE$.canBuildFrom()), resolver$1);
                                            break block14;
                                        }
                                        if (var16_9 == null) break block15;
                                        var19_13 = (Seq)var16_9._1();
                                        var20_14 = (DataType)var16_9._2();
                                        var21_15 = Seq$.MODULE$.unapplySeq(var19_13);
                                        if (var21_15.isEmpty() || var21_15.get() == null || ((SeqLike)var21_15.get()).lengthCompare(1) < 0 || !"element".equals(var22_16 = (String)((SeqLike)var21_15.get()).apply(0)) || !(var20_14 instanceof ArrayType) || !((s = (var23_17 = (ArrayType)var20_14).elementType()) instanceof StructType)) break block15;
                                        var25_19 = (StructType)s;
                                        var27_20 = this.find$1((Seq)colTail.tail(), var25_19, (Seq)stack.$colon$plus((Object)thisCol, Seq$.MODULE$.canBuildFrom()), resolver$1);
                                        if (var27_20 == null) {
                                            throw new MatchError((Object)var27_20);
                                        }
                                        child = (Seq)var27_20._1();
                                        size = var27_20._2$mcI$sp();
                                        var9_23 = new Tuple2((Object)child, (Object)BoxesRunTime.boxToInteger((int)size));
                                        var26_24 = var9_23;
                                        child = (Seq)var26_24._1();
                                        size = var26_24._2$mcI$sp();
                                        var32_27 = this.ARRAY_ELEMENT_INDEX();
                                        var6_12 = new Tuple2(child.$plus$colon((Object)BoxesRunTime.boxToInteger((int)var32_27), Seq$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToInteger((int)size));
                                        break block14;
                                    }
                                    if (var16_9 == null) break block16;
                                    var33_28 = (Seq)var16_9._1();
                                    var34_29 = (DataType)var16_9._2();
                                    var35_30 = Seq$.MODULE$.unapplySeq(var33_28);
                                    if (var35_30.isEmpty() || var35_30.get() == null || ((SeqLike)var35_30.get()).lengthCompare(0) != 0 || !(var34_29 instanceof ArrayType) || !((s = (var36_31 = (ArrayType)var34_29).elementType()) instanceof StructType)) break block16;
                                    var38_33 = (StructType)s;
                                    var6_12 = this.find$1(colTail, var38_33, (Seq)stack.$colon$plus((Object)thisCol, Seq$.MODULE$.canBuildFrom()), resolver$1);
                                    break block14;
                                }
                                if (var16_9 == null) break block17;
                                var39_34 = (Seq)var16_9._1();
                                var40_35 = (DataType)var16_9._2();
                                var41_36 = Seq$.MODULE$.unapplySeq(var39_34);
                                if (var41_36.isEmpty() || var41_36.get() == null || ((SeqLike)var41_36.get()).lengthCompare(0) != 0 || !(var40_35 instanceof ArrayType)) break block17;
                                var6_12 = new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)BoxesRunTime.boxToInteger((int)0));
                                break block14;
                            }
                            if (var16_9 != null && (var42_37 = (DataType)var16_9._2()) instanceof ArrayType) {
                                throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("An ArrayType was found. In order to access elements of an ArrayType, specify\n               |").append(this.prettyFieldName((Seq<String>)((Seq)stack.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{thisCol, "element"})), Seq$.MODULE$.canBuildFrom())))).append("\n               |Instead of ").append(this.prettyFieldName((Seq<String>)((Seq)stack.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{thisCol})), Seq$.MODULE$.canBuildFrom())))).append("\n               ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                            if (var16_9 == null) break block18;
                            var43_38 = (Seq)var16_9._1();
                            var44_39 = (DataType)var16_9._2();
                            var45_40 = Seq$.MODULE$.unapplySeq(var43_38);
                            if (var45_40.isEmpty() || var45_40.get() == null || ((SeqLike)var45_40.get()).lengthCompare(0) != 0 || !(var44_39 instanceof MapType)) break block18;
                            var6_12 = new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)2));
                            break block14;
                        }
                        if (var16_9 == null) break block19;
                        var46_41 = (Seq)var16_9._1();
                        var47_42 = (DataType)var16_9._2();
                        var48_43 = Seq$.MODULE$.unapplySeq(var46_41);
                        if (var48_43.isEmpty() || var48_43.get() == null || ((SeqLike)var48_43.get()).lengthCompare(1) < 0 || !"key".equals(var49_44 = (String)((SeqLike)var48_43.get()).apply(0)) || !(var47_42 instanceof MapType) || !((keyType = (var50_45 = (MapType)var47_42).keyType()) instanceof StructType)) break block19;
                        var52_47 = (StructType)keyType;
                        var54_48 = this.find$1((Seq)colTail.tail(), var52_47, (Seq)stack.$colon$plus((Object)thisCol, Seq$.MODULE$.canBuildFrom()), resolver$1);
                        if (var54_48 == null) {
                            throw new MatchError((Object)var54_48);
                        }
                        child = (Seq)var54_48._1();
                        size = var54_48._2$mcI$sp();
                        var8_51 = new Tuple2((Object)child, (Object)BoxesRunTime.boxToInteger((int)size));
                        var53_52 = var8_51;
                        child = (Seq)var53_52._1();
                        size = var53_52._2$mcI$sp();
                        var59_55 = this.MAP_KEY_INDEX();
                        var6_12 = new Tuple2(child.$plus$colon((Object)BoxesRunTime.boxToInteger((int)var59_55), Seq$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToInteger((int)size));
                        break block14;
                    }
                    if (var16_9 == null) break block20;
                    var60_56 = (Seq)var16_9._1();
                    var61_57 = (DataType)var16_9._2();
                    var62_58 = Seq$.MODULE$.unapplySeq(var60_56);
                    if (var62_58.isEmpty() || var62_58.get() == null || ((SeqLike)var62_58.get()).lengthCompare(1) != 0 || !"key".equals(var63_59 = (String)((SeqLike)var62_58.get()).apply(0)) || !(var61_57 instanceof MapType)) break block20;
                    var6_12 = new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.MAP_KEY_INDEX()})), (Object)BoxesRunTime.boxToInteger((int)0));
                    break block14;
                }
                if (var16_9 == null) break block21;
                var64_60 = (Seq)var16_9._1();
                var65_61 = (DataType)var16_9._2();
                var66_62 = Seq$.MODULE$.unapplySeq(var64_60);
                if (var66_62.isEmpty() || var66_62.get() == null || ((SeqLike)var66_62.get()).lengthCompare(1) < 0 || !"value".equals(var67_63 = (String)((SeqLike)var66_62.get()).apply(0)) || !(var65_61 instanceof MapType) || !((valueType = (var68_64 = (MapType)var65_61).valueType()) instanceof StructType)) break block21;
                var70_66 = (StructType)valueType;
                var72_67 = this.find$1((Seq)colTail.tail(), var70_66, (Seq)stack.$colon$plus((Object)thisCol, Seq$.MODULE$.canBuildFrom()), resolver$1);
                if (var72_67 == null) {
                    throw new MatchError((Object)var72_67);
                }
                child = (Seq)var72_67._1();
                size = var72_67._2$mcI$sp();
                var7_70 = new Tuple2((Object)child, (Object)BoxesRunTime.boxToInteger((int)size));
                var71_71 = var7_70;
                child = (Seq)var71_71._1();
                size = var71_71._2$mcI$sp();
                var77_74 = this.MAP_VALUE_INDEX();
                var6_12 = new Tuple2(child.$plus$colon((Object)BoxesRunTime.boxToInteger((int)var77_74), Seq$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToInteger((int)size));
                break block14;
            }
            if (var16_9 == null) ** GOTO lbl-1000
            var78_75 = (Seq)var16_9._1();
            var79_76 = (DataType)var16_9._2();
            var80_77 = Seq$.MODULE$.unapplySeq(var78_75);
            if (!var80_77.isEmpty() && var80_77.get() != null && ((SeqLike)var80_77.get()).lengthCompare(1) == 0 && "value".equals(var81_78 = (String)((SeqLike)var80_77.get()).apply(0)) && var79_76 instanceof MapType) {
                var6_12 = new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.MAP_VALUE_INDEX()})), (Object)BoxesRunTime.boxToInteger((int)0));
            } else lbl-1000:
            // 2 sources

            {
                if (var16_9 != null && (var82_79 = (DataType)var16_9._2()) instanceof MapType) {
                    throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(369).append("A MapType was found. In order to access the key or value of a MapType, specify one\n               |of:\n               |").append(this.prettyFieldName((Seq<String>)((Seq)stack.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{thisCol, "key"})), Seq$.MODULE$.canBuildFrom())))).append(" or\n               |").append(this.prettyFieldName((Seq<String>)((Seq)stack.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{thisCol, "value"})), Seq$.MODULE$.canBuildFrom())))).append("\n               |followed by the name of the column (only if that column is a struct type).\n               |e.g. mymap.key.mykey\n               |If the column is a basic type, mymap.key or mymap.value is sufficient.\n              ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (var16_9 != null) {
                    o = (DataType)var16_9._2();
                    if (column.length() > 1) {
                        throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(128).append("Expected ").append(SchemaUtils$.columnPath$1(columnPath$lzy, stack, thisCol)).append(" to be a nested data type, but found ").append(o).append(". Was looking for the\n                 |index of ").append(this.prettyFieldName((Seq<String>)column)).append(" in a nested field\n              ").toString())).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    var6_12 = new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0));
                } else {
                    throw new MatchError((Object)var16_9);
                }
            }
        }
        var15_81 = var6_12;
        if (var15_81 == null) {
            throw new MatchError((Object)var15_81);
        }
        children = (Seq)var15_81._1();
        lastSize = var15_81._2$mcI$sp();
        var5_84 = new Tuple2((Object)children, (Object)BoxesRunTime.boxToInteger((int)lastSize));
        var14_85 = var5_84;
        children = (Seq)var14_85._1();
        lastSize = var14_85._2$mcI$sp();
        return new Tuple2(((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{pos}))).$plus$plus((GenTraversableOnce)children, Seq$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToInteger((int)lastSize));
    }

    public static final /* synthetic */ String $anonfun$addColumn$1(StructField column$1) {
        return new StringBuilder(35).append("Don't know where to add the column ").append(column$1).toString();
    }

    private static final void verify$1(boolean cond, Function0 err) {
        if (!cond) {
            throw new AnalysisException((String)err.apply(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private static final void verifyNullability$1(boolean fn, boolean tn, Seq columnPath) {
        SchemaUtils$.verify$1(tn || !fn, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("tightening nullability of ").append(new UnresolvedAttribute(columnPath).name()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$canChangeDataType$3(Function2 resolver$2, StructField toField$1, StructField field) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$2.apply((Object)field.name(), (Object)toField$1.name()));
    }

    public static final /* synthetic */ void $anonfun$canChangeDataType$2(SchemaUtils$ $this, StructField[] fromFields$1, Function2 resolver$2, scala.collection.mutable.Set remainingFields$1, Seq columnPath$3, StructField toField) {
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fromFields$1)).find((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$canChangeDataType$3(resolver$2, toField, field)));
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField fromField = (StructField)some.value();
            remainingFields$1.$minus$eq((Object)fromField);
            Seq newPath = (Seq)columnPath$3.$colon$plus((Object)fromField.name(), Seq$.MODULE$.canBuildFrom());
            SchemaUtils$.verifyNullability$1(fromField.nullable(), toField.nullable(), newPath);
            $this.check$1(fromField.dataType(), toField.dataType(), newPath, resolver$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            SchemaUtils$.verify$1(toField.nullable(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("adding non-nullable column ").append(new UnresolvedAttribute((Seq)columnPath$3.$colon$plus((Object)toField.name(), Seq$.MODULE$.canBuildFrom())).name()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void check$1(DataType fromDt, DataType toDt, Seq columnPath, Function2 resolver$2) {
        Tuple2 tuple2;
        while (true) {
            if ((tuple2 = new Tuple2((Object)fromDt, (Object)toDt)) != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType2 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType fromElement = arrayType.elementType();
                    boolean fn = arrayType.containsNull();
                    if (dataType2 instanceof ArrayType) {
                        ArrayType arrayType2 = (ArrayType)dataType2;
                        DataType toElement = arrayType2.elementType();
                        boolean tn = arrayType2.containsNull();
                        SchemaUtils$.verifyNullability$1(fn, tn, columnPath);
                        toDt = toElement;
                        fromDt = fromElement;
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (!(dataType instanceof MapType)) break;
            MapType mapType = (MapType)dataType;
            DataType fromKey = mapType.keyType();
            DataType fromValue = mapType.valueType();
            boolean fn = mapType.valueContainsNull();
            if (!(dataType3 instanceof MapType)) break;
            MapType mapType2 = (MapType)dataType3;
            DataType toKey = mapType2.keyType();
            DataType toValue = mapType2.valueType();
            boolean tn = mapType2.valueContainsNull();
            SchemaUtils$.verifyNullability$1(fn, tn, columnPath);
            this.check$1(fromKey, toKey, (Seq)columnPath.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), resolver$2);
            columnPath = (Seq)columnPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom());
            toDt = toValue;
            fromDt = fromValue;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] toFields = structType2.fields();
                    scala.collection.mutable.Set remainingFields = (scala.collection.mutable.Set)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fromFields)).to(scala.collection.mutable.Set$.MODULE$.canBuildFrom());
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toFields)).foreach((Function1 & Serializable & scala.Serializable)toField -> {
                        SchemaUtils$.$anonfun$canChangeDataType$2(this, fromFields, resolver$2, remainingFields, columnPath, toField);
                        return BoxedUnit.UNIT;
                    });
                    SchemaUtils$.verify$1(remainingFields.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("dropping column(s) [").append(((TraversableOnce)remainingFields.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.name(), Set$.MODULE$.canBuildFrom())).mkString(", ")).append("]").append((Object)(columnPath.nonEmpty() ? new StringBuilder(6).append(" from ").append(new UnresolvedAttribute(columnPath).name()).toString() : "")).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        DataType fromDataType = (DataType)tuple2._1();
        DataType toDataType = (DataType)tuple2._2();
        DataType dataType = fromDataType;
        DataType dataType5 = toDataType;
        SchemaUtils$.verify$1(!(dataType != null ? !dataType.equals(dataType5) : dataType5 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("changing data type of ").append(new UnresolvedAttribute(columnPath).name()).append(" ").append("from ").append(fromDataType).append(" to ").append(toDataType).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$changeDataType$2(Function2 resolver$3, StructField toField$2, StructField field) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$3.apply((Object)field.name(), (Object)toField$2.name()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DataType merge$1(DataType current, DataType update) {
        DataType dataType;
        Tuple2 tuple2 = new Tuple2((Object)current, (Object)update);
        if (tuple2 != null) {
            DataType dataType2 = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                StructField[] currentFields = structType.fields();
                if (dataType3 instanceof StructType) {
                    StructType structType2 = (StructType)dataType3;
                    StructField[] updateFields = structType2.fields();
                    Map<String, StructField> updateFieldMap = this.toFieldMap((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])updateFields));
                    StructField[] updatedCurrentFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])currentFields)).map((Function1 & Serializable & scala.Serializable)currentField -> {
                        StructField structField;
                        Option option = updateFieldMap.get((Object)currentField.name());
                        if (option instanceof Some) {
                            StructField structField2;
                            Some some = (Some)option;
                            StructField updateField = (StructField)some.value();
                            try {
                                structField2 = new StructField(currentField.name(), this.merge$1(currentField.dataType(), updateField.dataType()), currentField.nullable(), currentField.metadata());
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                                if (!option2.isEmpty()) {
                                    Throwable e = (Throwable)option2.get();
                                    throw new AnalysisException(new StringBuilder(34).append("Failed to merge fields '").append(currentField.name()).append("' ").append("and '").append(updateField.name()).append("'. ").append(e.getMessage()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                }
                                throw throwable;
                            }
                            structField = structField2;
                        } else if (None$.MODULE$.equals(option)) {
                            structField = currentField;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return structField;
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
                    Map<String, StructField> nameToFieldMap = this.toFieldMap((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])currentFields));
                    StructField[] newFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updateFields)).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)nameToFieldMap.contains((Object)f.name())));
                    return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])updatedCurrentFields)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFields)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType4 = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (dataType4 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType4;
                DataType currentElementType = arrayType.elementType();
                boolean currentContainsNull = arrayType.containsNull();
                if (dataType5 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType5;
                    DataType updateElementType = arrayType2.elementType();
                    return new ArrayType(this.merge$1(currentElementType, updateElementType), currentContainsNull);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType6 = (DataType)tuple2._1();
            DataType dataType7 = (DataType)tuple2._2();
            if (dataType6 instanceof MapType) {
                MapType mapType = (MapType)dataType6;
                DataType currentKeyType = mapType.keyType();
                DataType currentElementType = mapType.valueType();
                boolean currentContainsNull = mapType.valueContainsNull();
                if (dataType7 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType7;
                    DataType updateKeyType = mapType2.keyType();
                    DataType updateElementType = mapType2.valueType();
                    return new MapType(this.merge$1(currentKeyType, updateKeyType), this.merge$1(currentElementType, updateElementType), currentContainsNull);
                }
            }
        }
        if (tuple2 != null) {
            DecimalType decimalType;
            Option option;
            DataType dataType8 = (DataType)tuple2._1();
            DataType dataType9 = (DataType)tuple2._2();
            if (dataType8 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType8)).isEmpty()) {
                DecimalType decimalType2;
                Option option2;
                int leftPrecision = ((Tuple2)option.get())._1$mcI$sp();
                int leftScale = ((Tuple2)option.get())._2$mcI$sp();
                if (dataType9 instanceof DecimalType && !(option2 = DecimalType.Fixed$.MODULE$.unapply(decimalType2 = (DecimalType)dataType9)).isEmpty()) {
                    int rightPrecision = ((Tuple2)option2.get())._1$mcI$sp();
                    int rightScale = ((Tuple2)option2.get())._2$mcI$sp();
                    if (leftPrecision == rightPrecision && leftScale == rightScale) return current;
                    if (leftPrecision != rightPrecision && leftScale != rightScale) {
                        throw new AnalysisException(new StringBuilder(77).append("Failed to merge decimal types with incompatible ").append("precision ").append(leftPrecision).append(" and ").append(rightPrecision).append(" & scale ").append(leftScale).append(" and ").append(rightScale).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    if (leftPrecision == rightPrecision) throw new AnalysisException(new StringBuilder(59).append("Failed to merge decimal types with incompatible ").append("scale ").append(leftScale).append(" and ").append(rightScale).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    throw new AnalysisException(new StringBuilder(63).append("Failed to merge decimal types with incompatible ").append("precision ").append(leftPrecision).append(" and ").append(rightPrecision).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
        }
        DataType dataType10 = current;
        DataType dataType11 = update;
        if (dataType10 == null) {
            if (dataType11 == null) return current;
        } else if (dataType10.equals(dataType11)) {
            return current;
        }
        if (tuple2 != null) {
            DataType dataType12 = (DataType)tuple2._1();
            DataType dataType13 = (DataType)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType12) && ShortType$.MODULE$.equals(dataType13)) {
                return ShortType$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType14 = (DataType)tuple2._1();
            DataType dataType15 = (DataType)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType14) && IntegerType$.MODULE$.equals(dataType15)) {
                return IntegerType$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType16 = (DataType)tuple2._1();
            DataType dataType17 = (DataType)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType16) && ByteType$.MODULE$.equals(dataType17)) {
                return ShortType$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType18 = (DataType)tuple2._1();
            DataType dataType19 = (DataType)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType18) && IntegerType$.MODULE$.equals(dataType19)) {
                return IntegerType$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType20 = (DataType)tuple2._1();
            DataType dataType21 = (DataType)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType20) && ShortType$.MODULE$.equals(dataType21)) {
                return IntegerType$.MODULE$;
            }
        }
        if (tuple2 != null) {
            DataType dataType22 = (DataType)tuple2._1();
            DataType dataType23 = (DataType)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType22) && ByteType$.MODULE$.equals(dataType23)) {
                return IntegerType$.MODULE$;
            }
        }
        if (tuple2 != null && NullType$.MODULE$.equals(dataType = (DataType)tuple2._1())) {
            return update;
        }
        if (tuple2 == null) throw new AnalysisException(new StringBuilder(45).append("Failed to merge incompatible data types ").append(current).append(" and ").append(update).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        DataType dataType24 = (DataType)tuple2._2();
        if (!NullType$.MODULE$.equals(dataType24)) throw new AnalysisException(new StringBuilder(45).append("Failed to merge incompatible data types ").append(current).append(" and ").append(update).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        return current;
    }

    private static final DataType transform$1(Seq path, DataType dt, Function3 tf$1) {
        DataType dataType;
        DataType dataType2 = dt;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            dataType = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> {
                StructField newField = (StructField)tf$1.apply((Object)path, field, MODULE$.DELTA_COL_RESOLVER());
                DataType x$1 = SchemaUtils$.transform$1((Seq)path.$colon$plus((Object)newField.name(), Seq$.MODULE$.canBuildFrom()), newField.dataType(), tf$1);
                String x$2 = newField.copy$default$1();
                boolean x$3 = newField.copy$default$3();
                Metadata x$4 = newField.copy$default$4();
                return newField.copy(x$2, x$1, x$3, x$4);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            dataType = new ArrayType(SchemaUtils$.transform$1(path, elementType, tf$1), containsNull);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            dataType = new MapType(SchemaUtils$.transform$1((Seq)path.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), keyType, tf$1), SchemaUtils$.transform$1((Seq)path.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom()), valueType, tf$1), valueContainsNull);
        } else {
            dataType = dataType2;
        }
        DataType newDt = dataType;
        return newDt;
    }

    public static final /* synthetic */ boolean $anonfun$transformColumnsStructs$1(String colName$1, StructField x$24) {
        String string = x$24.name();
        String string2 = colName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final DataType transform$2(Seq path, DataType dt, String colName$1, Function3 tf$2) {
        DataType dataType;
        DataType dataType2 = dt;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            Seq newFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).exists((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$transformColumnsStructs$1(colName$1, x$24))) ? (Seq)tf$2.apply((Object)path, (Object)structType, this.DELTA_COL_RESOLVER()) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).toSeq();
            dataType = StructType$.MODULE$.apply((Seq)newFields.map((Function1 & Serializable & scala.Serializable)field -> {
                DataType x$1 = this.transform$2((Seq)path.$colon$plus((Object)field.name(), Seq$.MODULE$.canBuildFrom()), field.dataType(), colName$1, tf$2);
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$1, x$3, x$4);
            }, Seq$.MODULE$.canBuildFrom()));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            dataType = new ArrayType(this.transform$2((Seq)path.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom()), elementType, colName$1, tf$2), containsNull);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            dataType = new MapType(this.transform$2((Seq)path.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), keyType, colName$1, tf$2), this.transform$2((Seq)path.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom()), valueType, colName$1, tf$2), valueContainsNull);
        } else {
            dataType = dataType2;
        }
        DataType newDt = dataType;
        return newDt;
    }

    public static final /* synthetic */ boolean $anonfun$transformColumns$7(Seq fullPath$1, Function2 resolver$4, Tuple2 x$29) {
        return ((IterableLike)((IterableLike)x$29._1()).zip((GenIterable)fullPath$1, Seq$.MODULE$.canBuildFrom())).forall(resolver$4.tupled());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final StructField checkField$1(Seq path, StructField f, Function2 r, boolean allowUnenforceableNotNulls$1) {
        StructField structField = f;
        if (structField != null) {
            String name = structField.name();
            DataType dataType = structField.dataType();
            boolean nullable = structField.nullable();
            Metadata metadata = structField.metadata();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                DataType nullableElementType = this.typeAsNullable(elementType);
                DataType dataType2 = elementType;
                DataType dataType3 = nullableElementType;
                if (dataType2 == null) {
                    if (dataType3 == null) return new StructField(name, (DataType)new ArrayType(nullableElementType, containsNull), nullable, metadata);
                } else if (dataType2.equals(dataType3)) return new StructField(name, (DataType)new ArrayType(nullableElementType, containsNull), nullable, metadata);
                if (allowUnenforceableNotNulls$1) return new StructField(name, (DataType)new ArrayType(nullableElementType, containsNull), nullable, metadata);
                throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)f.name(), Seq$.MODULE$.canBuildFrom()))), elementType, "element");
            }
        }
        if (structField != null) {
            String name = structField.name();
            DataType dataType = structField.dataType();
            boolean nullable = structField.nullable();
            Metadata metadata = structField.metadata();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean containsNull = mapType.valueContainsNull();
                DataType nullableKeyType = this.typeAsNullable(keyType);
                DataType nullableValueType = this.typeAsNullable(valueType);
                DataType dataType4 = keyType;
                DataType dataType5 = nullableKeyType;
                if ((dataType4 == null ? dataType5 != null : !dataType4.equals(dataType5)) && !allowUnenforceableNotNulls$1) {
                    throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)structField.name(), Seq$.MODULE$.canBuildFrom()))), keyType, "key");
                }
                DataType dataType6 = valueType;
                DataType dataType7 = nullableValueType;
                if (dataType6 == null) {
                    if (dataType7 == null) return new StructField(name, (DataType)new MapType(nullableKeyType, nullableValueType, containsNull), nullable, metadata);
                } else if (dataType6.equals(dataType7)) return new StructField(name, (DataType)new MapType(nullableKeyType, nullableValueType, containsNull), nullable, metadata);
                if (allowUnenforceableNotNulls$1) return new StructField(name, (DataType)new MapType(nullableKeyType, nullableValueType, containsNull), nullable, metadata);
                throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)structField.name(), Seq$.MODULE$.canBuildFrom()))), valueType, "value");
            }
        }
        if (structField == null) throw new MatchError((Object)structField);
        StructField structField2 = structField;
        return structField2;
    }

    private SchemaUtils$() {
        MODULE$ = this;
        this.DELTA_COL_RESOLVER = package$.MODULE$.caseInsensitiveResolution();
        this.ARRAY_ELEMENT_INDEX = 0;
        this.MAP_KEY_INDEX = 0;
        this.MAP_VALUE_INDEX = 1;
    }

    public static final /* synthetic */ Object $anonfun$findColumnPosition$1$adapted(Function2 resolver$1, String thisCol$1, StructField f) {
        return BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findColumnPosition$1(resolver$1, thisCol$1, f));
    }
}

