/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.CheckpointV2$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.SingleAction$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Checkpoints$
implements DeltaLogging {
    public static Checkpoints$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Checkpoints$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CheckpointMetaData writeCheckpoint(SparkSession spark, DeltaLog deltaLog, Snapshot snapshot) {
        LongAccumulator numOfFiles;
        LongAccumulator checkpointSize;
        block9: {
            boolean useRename = deltaLog.store().isPartialWriteVisible(deltaLog.logPath());
            checkpointSize = spark.sparkContext().longAccumulator("checkpointSize");
            numOfFiles = spark.sparkContext().longAccumulator("numOfFiles");
            Path resolvedPath = deltaLog.store().resolveCheckpointPath(snapshot.path());
            String path = FileNames$.MODULE$.checkpointFileSingular(resolvedPath, snapshot.version()).toString();
            Dataset base = snapshot.state().repartition(1).map((Function1 & Serializable & scala.Serializable)action -> {
                block0: {
                    if (action.add() == null) break block0;
                    numOfFiles.add(1L);
                }
                return action;
            }, SingleAction$.MODULE$.encoder()).drop("commitInfo");
            Dataset<Row> chk = this.buildCheckpoint((Dataset<Row>)base, snapshot);
            StructType schema = chk.schema().asNullable();
            ParquetFileFormat format = new ParquetFileFormat();
            Job job = Job.getInstance();
            Tuple2 tuple2 = new Tuple2((Object)format.prepareWrite(spark, job, Predef$.MODULE$.Map().empty(), schema), (Object)new SerializableConfiguration(job.getConfiguration()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OutputWriterFactory factory = (OutputWriterFactory)tuple2._1();
            SerializableConfiguration serConf = (SerializableConfiguration)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)factory, (Object)serConf);
            Tuple2 tuple23 = tuple22;
            OutputWriterFactory factory2 = (OutputWriterFactory)tuple23._1();
            SerializableConfiguration serConf2 = (SerializableConfiguration)tuple23._2();
            RDD qual$1 = chk.queryExecution().executedPlan().execute();
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iter -> {
                String string;
                if (useRename) {
                    Path p = new Path(path);
                    Path tempPath = new Path(p.getParent(), new StringBuilder(6).append(".").append(p.getName()).append(".").append(UUID.randomUUID()).append(".tmp").toString());
                    DeltaFileOperations$.MODULE$.registerTempFileDeletionTaskFailureListener(serConf2.value(), tempPath);
                    string = tempPath.toString();
                } else {
                    string = path;
                }
                String writtenPath = string;
                try {
                    OutputWriter writer = factory2.newInstance(writtenPath, schema, (TaskAttemptContext)new TaskAttemptContextImpl(new JobConf(serConf2.value()), new TaskAttemptID("", 0, TaskType.REDUCE, 0, 0)));
                    iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                        Checkpoints$.$anonfun$writeCheckpoint$3(checkpointSize, writer, row);
                        return BoxedUnit.UNIT;
                    });
                    writer.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileAlreadyExistsException) {
                        FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                        if (!useRename) {
                            Path p = new Path(writtenPath);
                            if (!p.getFileSystem(serConf2.value()).exists(p)) {
                                throw fileAlreadyExistsException;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    throw throwable;
                }
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{writtenPath}));
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            String writtenPath = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(String.class)).collect())).head();
            if (useRename) {
                Path src = new Path(writtenPath);
                Path dest = new Path(path);
                FileSystem fs = dest.getFileSystem(spark.sessionState().newHadoopConf());
                boolean renameDone = false;
                try {
                    if (fs.rename(src, dest)) {
                        renameDone = true;
                        break block9;
                    }
                    throw new IllegalStateException(new StringBuilder(18).append("Cannot rename ").append(src).append(" to ").append(dest).toString());
                }
                finally {
                    if (!renameDone) {
                        fs.delete(src, false);
                    }
                }
            }
        }
        if (!BoxesRunTime.equalsNumObject((Number)numOfFiles.value(), (Object)BoxesRunTime.boxToLong((long)snapshot.numOfFiles()))) {
            throw new IllegalStateException("State of the checkpoint doesn't match that of the snapshot.");
        }
        if (BoxesRunTime.equalsNumObject((Number)checkpointSize.value(), (Object)BoxesRunTime.boxToInteger((int)0))) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> DeltaErrors$.MODULE$.EmptyCheckpointErrorMessage());
        }
        return new CheckpointMetaData(snapshot.version(), Predef$.MODULE$.Long2long(checkpointSize.value()), (Option<Object>)None$.MODULE$);
    }

    public Dataset<Row> buildCheckpoint(Dataset<Row> state, Snapshot snapshot) {
        ArrayBuffer additionalCols = new ArrayBuffer();
        Object object = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.CHECKPOINT_WRITE_STATS_AS_JSON().fromMetaData(snapshot.metadata())) ? additionalCols.$plus$eq((Object)functions$.MODULE$.col("add.stats").as("stats")) : BoxedUnit.UNIT;
        SQLConf sessionConf = state.sparkSession().sessionState().conf();
        boolean includeStructColumns = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.CHECKPOINT_WRITE_STATS_AS_STRUCT().fromMetaData(snapshot.metadata()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)sessionConf.getConf(DeltaSQLConf$.MODULE$.DELTA_CHECKPOINT_V2_ENABLED()))));
        Object object2 = includeStructColumns ? additionalCols.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(CheckpointV2$.MODULE$.extractPartitionValues(snapshot.metadata().partitionSchema()))) : BoxedUnit.UNIT;
        return state.withColumn("add", functions$.MODULE$.when(functions$.MODULE$.col("add").isNotNull(), (Object)functions$.MODULE$.struct((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("add.path"), functions$.MODULE$.col("add.partitionValues"), functions$.MODULE$.col("add.size"), functions$.MODULE$.col("add.modificationTime"), functions$.MODULE$.col("add.dataChange"), functions$.MODULE$.col("add.tags")}))).$plus$plus((GenTraversableOnce)additionalCols, Seq$.MODULE$.canBuildFrom()))));
    }

    public static final /* synthetic */ void $anonfun$writeCheckpoint$3(LongAccumulator checkpointSize$1, OutputWriter writer$1, InternalRow row) {
        checkpointSize$1.add(1L);
        writer$1.write(row);
    }

    private Checkpoints$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }
}

