/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.constraints.Constraints$;
import org.apache.spark.sql.delta.constraints.Invariants$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Protocol$
implements scala.Serializable {
    public static Protocol$ MODULE$;
    private final String MIN_READER_VERSION_PROP;
    private final String MIN_WRITER_VERSION_PROP;

    static {
        new Protocol$();
    }

    public int $lessinit$greater$default$1() {
        return Action$.MODULE$.readerVersion();
    }

    public int $lessinit$greater$default$2() {
        return Action$.MODULE$.writerVersion();
    }

    public String MIN_READER_VERSION_PROP() {
        return this.MIN_READER_VERSION_PROP;
    }

    public String MIN_WRITER_VERSION_PROP() {
        return this.MIN_WRITER_VERSION_PROP;
    }

    public Protocol apply(SparkSession spark, Option<Metadata> metadataOpt) {
        SQLConf conf = spark.sessionState().conf();
        Option minimumOpt = metadataOpt.map((Function1 & Serializable & scala.Serializable)m -> (Protocol)MODULE$.requiredMinimumProtocol(spark, (Metadata)m)._1());
        Map configs = (Map)metadataOpt.map((Function1 & Serializable & scala.Serializable)x$1 -> (Map)x$1.configuration().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.toLowerCase(Locale.ROOT)), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        int readerVersion = BoxesRunTime.unboxToInt((Object)configs.get((Object)this.MIN_READER_VERSION_PROP().toLowerCase(Locale.ROOT)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Protocol$.MODULE$.getVersion(Protocol$.MODULE$.MIN_READER_VERSION_PROP(), x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_PROTOCOL_DEFAULT_READER_VERSION()))));
        int writerVersion = BoxesRunTime.unboxToInt((Object)configs.get((Object)this.MIN_WRITER_VERSION_PROP().toLowerCase(Locale.ROOT)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Protocol$.MODULE$.getVersion(Protocol$.MODULE$.MIN_WRITER_VERSION_PROP(), x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_PROTOCOL_DEFAULT_WRITER_VERSION()))));
        return new Protocol(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)minimumOpt.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.minReaderVersion())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), readerVersion), package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)minimumOpt.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.minWriterVersion())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), writerVersion));
    }

    public int apply$default$1() {
        return Action$.MODULE$.readerVersion();
    }

    public int apply$default$2() {
        return Action$.MODULE$.writerVersion();
    }

    public Protocol forNewTable(SparkSession spark, Metadata metadata) {
        return this.apply(spark, (Option<Metadata>)new Some((Object)metadata));
    }

    private Tuple2<Protocol, Seq<String>> requiredMinimumProtocol(SparkSession spark, Metadata metadata) {
        Protocol minimumRequired;
        ArrayBuffer featuresUsed;
        block2: {
            Map configs;
            featuresUsed = new ArrayBuffer();
            minimumRequired = new Protocol(0, 0);
            if (Invariants$.MODULE$.getFromSchema(metadata.schema(), spark).nonEmpty()) {
                minimumRequired = new Protocol(0, 2);
                featuresUsed.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting column level invariants"}));
            }
            if ((configs = (Map)metadata.configuration().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.toLowerCase(Locale.ROOT)), (Object)v);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).contains((Object)DeltaConfigs$.MODULE$.IS_APPEND_ONLY().key().toLowerCase(Locale.ROOT))) {
                minimumRequired = new Protocol(0, 2);
                featuresUsed.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(21).append("Append only tables (").append(DeltaConfigs$.MODULE$.IS_APPEND_ONLY().key()).append(")").toString()}));
            }
            if (!Constraints$.MODULE$.getCheckConstraints(metadata, spark).nonEmpty()) break block2;
            minimumRequired = new Protocol(0, 3);
            featuresUsed.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting CHECK constraints"}));
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)minimumRequired), (Object)featuresUsed);
    }

    public int getVersion(String key, String value) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(value)).toInt();
        }
        catch (NumberFormatException n2) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Protocol property ").append(key).append(" needs to be an integer. Found ").append(value).toString(), n2);
        }
        return n;
    }

    public Option<Protocol> checkProtocolRequirements(SparkSession spark, Metadata metadata, Protocol current) {
        Predef$.MODULE$.assert(!metadata.configuration().contains((Object)this.MIN_READER_VERSION_PROP()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Should not have the ").append("protocol version (").append(MODULE$.MIN_READER_VERSION_PROP()).append(") as part of table properties").toString());
        Predef$.MODULE$.assert(!metadata.configuration().contains((Object)this.MIN_WRITER_VERSION_PROP()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Should not have the ").append("protocol version (").append(MODULE$.MIN_WRITER_VERSION_PROP()).append(") as part of table properties").toString());
        Tuple2<Protocol, Seq<String>> tuple2 = this.requiredMinimumProtocol(spark, metadata);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Protocol required = (Protocol)tuple2._1();
        Seq features = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)required, (Object)features);
        Tuple2 tuple23 = tuple22;
        Protocol required2 = (Protocol)tuple23._1();
        Seq features2 = (Seq)tuple23._2();
        return current.minWriterVersion() < required2.minWriterVersion() || current.minReaderVersion() < required2.minReaderVersion() ? new Some((Object)required2.copy(package$.MODULE$.max(current.minReaderVersion(), required2.minReaderVersion()), package$.MODULE$.max(current.minWriterVersion(), required2.minWriterVersion()))) : None$.MODULE$;
    }

    public Protocol apply(int minReaderVersion, int minWriterVersion) {
        return new Protocol(minReaderVersion, minWriterVersion);
    }

    public Option<Tuple2<Object, Object>> unapply(Protocol x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2.mcII.sp(x$0.minReaderVersion(), x$0.minWriterVersion()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Protocol$() {
        MODULE$ = this;
        this.MIN_READER_VERSION_PROP = "delta.minReaderVersion";
        this.MIN_WRITER_VERSION_PROP = "delta.minWriterVersion";
    }
}

