/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.catalog;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Protocol$;
import org.apache.spark.sql.delta.catalog.DeltaTableV2$;
import org.apache.spark.sql.delta.catalog.WriteIntoDeltaBuilder;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaDataSource$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tMg\u0001\u0002\u001c8\u0001\u0012C\u0001B\u0010\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tW\u0002\u0011\t\u0012)A\u0005O\"AA\u000e\u0001BK\u0002\u0013\u0005Q\u000e\u0003\u0005w\u0001\tE\t\u0015!\u0003o\u0011!9\bA!f\u0001\n\u0003A\b\"CA\u0004\u0001\tE\t\u0015!\u0003z\u0011)\tI\u0001\u0001BK\u0002\u0013\u0005\u00111\u0002\u0005\u000b\u0003K\u0001!\u0011#Q\u0001\n\u00055\u0001BCA\u0014\u0001\tU\r\u0011\"\u0001\u0002*!Q\u0011Q\u0007\u0001\u0003\u0012\u0003\u0006I!a\u000b\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!a\u0011\u0011\n\u0001\u0011\u0002#\u001d\r\u0015\"\u0003\u0002L!I\u00111\u000e\u0001\t\u0006\u0004%I!\u001c\u0005\u000b\u0003[\u0002\u0001R1A\u0005\n\u0005=\u0004BCA9\u0001!\u0015\r\u0011\"\u0003\u0002*!Q\u00111\u000f\u0001\t\u0006\u0004%\t!!\u001e\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u00111\u0012\u0001\u0005B\u00055\u0005BCAH\u0001!\u0015\r\u0011\"\u0003\u0002*!Q\u0011\u0011\u0013\u0001\t\u0006\u0004%\t!a%\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"9\u00111\u0016\u0001\u0005B\u00055\u0006bBAa\u0001\u0011\u0005\u00131\u0019\u0005\b\u0003#\u0004A\u0011IAj\u0011\u001d\t\t\u000f\u0001C!\u0003GDq!a?\u0001\t\u0003\ti\u0010C\u0005\u0003\f\u0001\t\t\u0011\"\u0001\u0003\u000e!I!\u0011\u0004\u0001\u0012\u0002\u0013\u0005!1\u0004\u0005\n\u0005c\u0001\u0011\u0013!C\u0001\u0005gA\u0011Ba\u000e\u0001#\u0003%\tA!\u000f\t\u0013\tu\u0002!%A\u0005\u0002\t}\u0002\"\u0003B\"\u0001E\u0005I\u0011\u0001B#\u0011%\u0011I\u0005AA\u0001\n\u0003\u0012Y\u0005C\u0005\u0003R\u0001\t\t\u0011\"\u0001\u0003T!I!1\f\u0001\u0002\u0002\u0013\u0005!Q\f\u0005\n\u0005O\u0002\u0011\u0011!C!\u0005SB\u0011Ba\u001e\u0001\u0003\u0003%\tA!\u001f\t\u0013\t\r\u0005!!A\u0005B\t\u0015\u0005\"\u0003BD\u0001\u0005\u0005I\u0011\tBE\u0011%\u0011Y\tAA\u0001\n\u0003\u0012iiB\u0005\u0003\u0012^\n\t\u0011#\u0001\u0003\u0014\u001aAagNA\u0001\u0012\u0003\u0011)\nC\u0004\u00028)\"\tAa)\t\u0013\t\u001d%&!A\u0005F\t%\u0005\"\u0003BSU\u0005\u0005I\u0011\u0011BT\u0011%\u0011\u0019LKI\u0001\n\u0003\u0011I\u0004C\u0005\u00036*\n\n\u0011\"\u0001\u0003@!I!q\u0017\u0016\u0012\u0002\u0013\u0005!Q\t\u0005\n\u0005sS\u0013\u0011!CA\u0005wC\u0011B!3+#\u0003%\tA!\u000f\t\u0013\t-'&%A\u0005\u0002\t}\u0002\"\u0003BgUE\u0005I\u0011\u0001B#\u0011%\u0011yMKA\u0001\n\u0013\u0011\tN\u0001\u0007EK2$\u0018\rV1cY\u00164&G\u0003\u00029s\u000591-\u0019;bY><'B\u0001\u001e<\u0003\u0015!W\r\u001c;b\u0015\taT(A\u0002tc2T!AP \u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0002\u0001'\u001d\u0001Q)\u0014+X;\u000e\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\t1\fgn\u001a\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\tauI\u0001\u0004PE*,7\r\u001e\t\u0003\u001dJk\u0011a\u0014\u0006\u0003qAS!!U\u001e\u0002\u0013\r|gN\\3di>\u0014\u0018BA*P\u0005\u0015!\u0016M\u00197f!\tqU+\u0003\u0002W\u001f\ni1+\u001e9q_J$8o\u0016:ji\u0016\u0004\"\u0001W.\u000e\u0003eS!AW\u001d\u0002\u00115,G/\u001a:j]\u001eL!\u0001X-\u0003\u0019\u0011+G\u000e^1M_\u001e<\u0017N\\4\u0011\u0005y\u000bW\"A0\u000b\u0003\u0001\fQa]2bY\u0006L!AY0\u0003\u000fA\u0013x\u000eZ;diB\u0011a\fZ\u0005\u0003K~\u0013AbU3sS\u0006d\u0017N_1cY\u0016,\u0012a\u001a\t\u0003Q&l\u0011aO\u0005\u0003Un\u0012Ab\u00159be.\u001cVm]:j_:\faa\u001d9be.\u0004\u0013\u0001\u00029bi\",\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f!AZ:\u000b\u0005M|\u0014A\u00025bI>|\u0007/\u0003\u0002va\n!\u0001+\u0019;i\u0003\u0015\u0001\u0018\r\u001e5!\u00031\u0019\u0017\r^1m_\u001e$\u0016M\u00197f+\u0005I\bc\u00010{y&\u00111p\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007u\f\u0019!D\u0001\u007f\u0015\tAtPC\u0002\u0002\u0002m\n\u0001bY1uC2L8\u000f^\u0005\u0004\u0003\u000bq(\u0001D\"bi\u0006dwn\u001a+bE2,\u0017!D2bi\u0006dwn\u001a+bE2,\u0007%A\buC\ndW-\u00133f]RLg-[3s+\t\ti\u0001\u0005\u0003_u\u0006=\u0001\u0003BA\t\u0003?qA!a\u0005\u0002\u001cA\u0019\u0011QC0\u000e\u0005\u0005]!bAA\r\u0007\u00061AH]8pizJ1!!\b`\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011EA\u0012\u0005\u0019\u0019FO]5oO*\u0019\u0011QD0\u0002!Q\f'\r\\3JI\u0016tG/\u001b4jKJ\u0004\u0013!\u0004;j[\u0016$&/\u0019<fY>\u0003H/\u0006\u0002\u0002,A!aL_A\u0017!\u0011\ty#!\r\u000e\u0003eJ1!a\r:\u0005M!U\r\u001c;b)&lW\r\u0016:bm\u0016d7\u000b]3d\u00039!\u0018.\\3Ue\u00064X\r\\(qi\u0002\na\u0001P5oSRtD\u0003DA\u001e\u0003\u007f\t\t%a\u0011\u0002F\u0005\u001d\u0003cAA\u001f\u00015\tq\u0007C\u0003?\u0017\u0001\u0007q\rC\u0003m\u0017\u0001\u0007a\u000eC\u0004x\u0017A\u0005\t\u0019A=\t\u0013\u0005%1\u0002%AA\u0002\u00055\u0001\"CA\u0014\u0017A\u0005\t\u0019AA\u0016\u0003\rAH%M\u000b\u0003\u0003\u001b\u0002\u0002BXA(]\u0006M\u00131F\u0005\u0004\u0003#z&A\u0002+va2,7\u0007\u0005\u0004\u0002V\u0005}\u0013Q\r\b\u0005\u0003/\nYF\u0004\u0003\u0002\u0016\u0005e\u0013\"\u00011\n\u0007\u0005us,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00141\r\u0002\u0004'\u0016\f(bAA/?B9a,a\u001a\u0002\u0010\u0005=\u0011bAA5?\n1A+\u001e9mKJ\n\u0001B]8piB\u000bG\u000f[\u0001\u0011a\u0006\u0014H/\u001b;j_:4\u0015\u000e\u001c;feN,\"!a\u0015\u0002!QLW.\u001a+sCZ,GNQ=QCRD\u0017\u0001\u00033fYR\fGj\\4\u0016\u0005\u0005]\u0004\u0003BA\u0018\u0003sJ1!a\u001f:\u0005!!U\r\u001c;b\u0019><\u0017AG4fiR\u000b'\r\\3JI\u0016tG/\u001b4jKJLe-\u0012=jgR\u001cXCAAA!\u0011q&0a!\u0011\t\u0005\u0015\u0015qQ\u0007\u0002\u007f&\u0019\u0011\u0011R@\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\fAA\\1nKR\u0011\u0011qB\u0001\u000fi&lW\r\u0016:bm\u0016d7\u000b]3d\u0003!\u0019h.\u00199tQ>$XCAAK!\u0011\ty#a&\n\u0007\u0005e\u0015H\u0001\u0005T]\u0006\u00048\u000f[8u\u0003\u0019\u00198\r[3nCR\u0011\u0011q\u0014\t\u0005\u0003C\u000b9+\u0004\u0002\u0002$*\u0019\u0011QU\u001e\u0002\u000bQL\b/Z:\n\t\u0005%\u00161\u0015\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001\u00049beRLG/[8oS:<GCAAX!\u0015q\u0016\u0011WA[\u0013\r\t\u0019l\u0018\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111\u0018)\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003\u007f\u000bILA\u0005Ue\u0006t7OZ8s[\u0006Q\u0001O]8qKJ$\u0018.Z:\u0015\u0005\u0005\u0015\u0007\u0003CAd\u0003\u001b\fy!a\u0004\u000e\u0005\u0005%'bAAf\u0013\u0006!Q\u000f^5m\u0013\u0011\ty-!3\u0003\u00075\u000b\u0007/\u0001\u0007dCB\f'-\u001b7ji&,7\u000f\u0006\u0002\u0002VB1\u0011qYAl\u00037LA!!7\u0002J\n\u00191+\u001a;\u0011\u00079\u000bi.C\u0002\u0002`>\u0013q\u0002V1cY\u0016\u001c\u0015\r]1cS2LG/_\u0001\u0010]\u0016<xK]5uK\n+\u0018\u000e\u001c3feR!\u0011Q]Ay!\u0011\t9/!<\u000e\u0005\u0005%(bAAv!\u0006)qO]5uK&!\u0011q^Au\u000519&/\u001b;f\u0005VLG\u000eZ3s\u0011\u001d\t\u00190\u0007a\u0001\u0003k\fA!\u001b8g_B!\u0011q]A|\u0013\u0011\tI0!;\u0003!1{w-[2bY^\u0013\u0018\u000e^3J]\u001a|\u0017A\u0004;p\u0005\u0006\u001cXMU3mCRLwN\\\u000b\u0003\u0003\u007f\u0004BA!\u0001\u0003\b5\u0011!1\u0001\u0006\u0004\u0005\u000bY\u0014aB:pkJ\u001cWm]\u0005\u0005\u0005\u0013\u0011\u0019A\u0001\u0007CCN,'+\u001a7bi&|g.\u0001\u0003d_BLH\u0003DA\u001e\u0005\u001f\u0011\tBa\u0005\u0003\u0016\t]\u0001b\u0002 \u001c!\u0003\u0005\ra\u001a\u0005\bYn\u0001\n\u00111\u0001o\u0011\u001d98\u0004%AA\u0002eD\u0011\"!\u0003\u001c!\u0003\u0005\r!!\u0004\t\u0013\u0005\u001d2\u0004%AA\u0002\u0005-\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005;Q3a\u001aB\u0010W\t\u0011\t\u0003\u0005\u0003\u0003$\t5RB\u0001B\u0013\u0015\u0011\u00119C!\u000b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0016?\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=\"Q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005kQ3A\u001cB\u0010\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa\u000f+\u0007e\u0014y\"\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0005#\u0006BA\u0007\u0005?\tabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0003H)\"\u00111\u0006B\u0010\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\n\t\u0004\r\n=\u0013bAA\u0011\u000f\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!Q\u000b\t\u0004=\n]\u0013b\u0001B-?\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\fB3!\rq&\u0011M\u0005\u0004\u0005Gz&aA!os\"I\u0011\u0011J\u0012\u0002\u0002\u0003\u0007!QK\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u000e\t\u0007\u0005[\u0012\u0019Ha\u0018\u000e\u0005\t=$b\u0001B9?\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tU$q\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003|\t\u0005\u0005c\u00010\u0003~%\u0019!qP0\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011J\u0013\u0002\u0002\u0003\u0007!qL\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!QK\u0001\ti>\u001cFO]5oOR\u0011!QJ\u0001\u0007KF,\u0018\r\\:\u0015\t\tm$q\u0012\u0005\n\u0003\u0013B\u0013\u0011!a\u0001\u0005?\nA\u0002R3mi\u0006$\u0016M\u00197f-J\u00022!!\u0010+'\u0011Q#qS2\u0011\u001b\te%qT4os\u00065\u00111FA\u001e\u001b\t\u0011YJC\u0002\u0003\u001e~\u000bqA];oi&lW-\u0003\u0003\u0003\"\nm%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8okQ\u0011!1S\u0001\u0006CB\u0004H.\u001f\u000b\r\u0003w\u0011IKa+\u0003.\n=&\u0011\u0017\u0005\u0006}5\u0002\ra\u001a\u0005\u0006Y6\u0002\rA\u001c\u0005\bo6\u0002\n\u00111\u0001z\u0011%\tI!\fI\u0001\u0002\u0004\ti\u0001C\u0005\u0002(5\u0002\n\u00111\u0001\u0002,\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005{\u0013)\r\u0005\u0003_u\n}\u0006C\u00030\u0003B\u001et\u00170!\u0004\u0002,%\u0019!1Y0\u0003\rQ+\b\u000f\\36\u0011%\u00119-MA\u0001\u0002\u0004\tY$A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\fe\u0016\fGMU3t_24X\rF\u0001F\u0001")
public class DeltaTableV2
implements SupportsWrite,
DeltaLogging,
Product,
scala.Serializable {
    private Tuple3<Path, Seq<Tuple2<String, String>>, Option<DeltaTimeTravelSpec>> x$1;
    private Path rootPath;
    private Seq<Tuple2<String, String>> partitionFilters;
    private Option<DeltaTimeTravelSpec> timeTravelByPath;
    private DeltaLog deltaLog;
    private Option<DeltaTimeTravelSpec> timeTravelSpec;
    private Snapshot snapshot;
    private final SparkSession spark;
    private final Path path;
    private final Option<CatalogTable> catalogTable;
    private final Option<String> tableIdentifier;
    private final Option<DeltaTimeTravelSpec> timeTravelOpt;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<DeltaTimeTravelSpec> $lessinit$greater$default$5() {
        return DeltaTableV2$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return DeltaTableV2$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<CatalogTable> $lessinit$greater$default$3() {
        return DeltaTableV2$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple5<SparkSession, Path, Option<CatalogTable>, Option<String>, Option<DeltaTimeTravelSpec>>> unapply(DeltaTableV2 deltaTableV2) {
        return DeltaTableV2$.MODULE$.unapply(deltaTableV2);
    }

    public static Option<DeltaTimeTravelSpec> apply$default$5() {
        return DeltaTableV2$.MODULE$.apply$default$5();
    }

    public static Option<String> apply$default$4() {
        return DeltaTableV2$.MODULE$.apply$default$4();
    }

    public static Option<CatalogTable> apply$default$3() {
        return DeltaTableV2$.MODULE$.apply$default$3();
    }

    public static DeltaTableV2 apply(SparkSession sparkSession, Path path, Option<CatalogTable> option, Option<String> option2, Option<DeltaTimeTravelSpec> option3) {
        return DeltaTableV2$.MODULE$.apply(sparkSession, path, option, option2, option3);
    }

    public static Function1<Tuple5<SparkSession, Path, Option<CatalogTable>, Option<String>, Option<DeltaTimeTravelSpec>>, DeltaTableV2> tupled() {
        return DeltaTableV2$.MODULE$.tupled();
    }

    public static Function1<SparkSession, Function1<Path, Function1<Option<CatalogTable>, Function1<Option<String>, Function1<Option<DeltaTimeTravelSpec>, DeltaTableV2>>>>> curried() {
        return DeltaTableV2$.MODULE$.curried();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, scala.collection.immutable.Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> scala.collection.immutable.Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public Path path() {
        return this.path;
    }

    public Option<CatalogTable> catalogTable() {
        return this.catalogTable;
    }

    public Option<String> tableIdentifier() {
        return this.tableIdentifier;
    }

    public Option<DeltaTimeTravelSpec> timeTravelOpt() {
        return this.timeTravelOpt;
    }

    private Tuple3<Path, Seq<Tuple2<String, String>>, Option<DeltaTimeTravelSpec>> x$1$lzycompute() {
        DeltaTableV2 deltaTableV2 = this;
        synchronized (deltaTableV2) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple3 tuple3;
                Tuple3 tuple32 = tuple3 = this.catalogTable().isDefined() ? new Tuple3((Object)new Path(((CatalogTable)this.catalogTable().get()).location()), (Object)Nil$.MODULE$, (Object)None$.MODULE$) : DeltaDataSource$.MODULE$.parsePathIdentifier(this.spark(), this.path().toString());
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Path rootPath = (Path)tuple3._1();
                Seq partitionFilters = (Seq)tuple3._2();
                Option timeTravelByPath = (Option)tuple3._3();
                Tuple3 tuple33 = new Tuple3((Object)rootPath, (Object)partitionFilters, (Object)timeTravelByPath);
                this.x$1 = tuple33;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple3 x$1() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private Path rootPath$lzycompute() {
        DeltaTableV2 deltaTableV2 = this;
        synchronized (deltaTableV2) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.rootPath = (Path)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.rootPath;
    }

    private Path rootPath() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.rootPath$lzycompute() : this.rootPath;
    }

    private Seq<Tuple2<String, String>> partitionFilters$lzycompute() {
        DeltaTableV2 deltaTableV2 = this;
        synchronized (deltaTableV2) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.partitionFilters = (Seq)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.partitionFilters;
    }

    private Seq<Tuple2<String, String>> partitionFilters() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.partitionFilters$lzycompute() : this.partitionFilters;
    }

    private Option<DeltaTimeTravelSpec> timeTravelByPath$lzycompute() {
        DeltaTableV2 deltaTableV2 = this;
        synchronized (deltaTableV2) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.timeTravelByPath = (Option)this.x$1()._3();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.timeTravelByPath;
    }

    private Option<DeltaTimeTravelSpec> timeTravelByPath() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.timeTravelByPath$lzycompute() : this.timeTravelByPath;
    }

    private DeltaLog deltaLog$lzycompute() {
        DeltaTableV2 deltaTableV2 = this;
        synchronized (deltaTableV2) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.deltaLog = DeltaLog$.MODULE$.forTable(this.spark(), this.rootPath());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.deltaLog;
    }

    public DeltaLog deltaLog() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.deltaLog$lzycompute() : this.deltaLog;
    }

    public Option<TableIdentifier> getTableIdentifierIfExists() {
        return this.tableIdentifier().map((Function1 & Serializable & scala.Serializable)sqlText -> this.spark().sessionState().sqlParser().parseTableIdentifier(sqlText));
    }

    public String name() {
        return (String)this.catalogTable().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.identifier().unquotedString()).orElse((Function0 & Serializable & scala.Serializable)() -> this.tableIdentifier()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("delta.`").append(this.deltaLog().dataPath()).append("`").toString());
    }

    private Option<DeltaTimeTravelSpec> timeTravelSpec$lzycompute() {
        DeltaTableV2 deltaTableV2 = this;
        synchronized (deltaTableV2) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                if (this.timeTravelOpt().isDefined() && this.timeTravelByPath().isDefined()) {
                    throw DeltaErrors$.MODULE$.multipleTimeTravelSyntaxUsed();
                }
                this.timeTravelSpec = this.timeTravelOpt().orElse((Function0 & Serializable & scala.Serializable)() -> this.timeTravelByPath());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.timeTravelSpec;
    }

    private Option<DeltaTimeTravelSpec> timeTravelSpec() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.timeTravelSpec$lzycompute() : this.timeTravelSpec;
    }

    private Snapshot snapshot$lzycompute() {
        DeltaTableV2 deltaTableV2 = this;
        synchronized (deltaTableV2) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.snapshot = (Snapshot)this.timeTravelSpec().map((Function1 & Serializable & scala.Serializable)spec -> {
                    Tuple2<Object, String> tuple2 = DeltaTableUtils$.MODULE$.resolveTimeTravelVersion(this.spark().sessionState().conf(), this.deltaLog(), (DeltaTimeTravelSpec)spec);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long version = tuple2._1$mcJ$sp();
                    String accessType = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)version), (Object)accessType);
                    Tuple2 tuple23 = tuple22;
                    long version2 = tuple23._1$mcJ$sp();
                    String accessType2 = (String)tuple23._2();
                    String source = (String)spec.creationSource().getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown");
                    DeltaLog x$1 = this.deltaLog();
                    String x$2 = new StringBuilder(17).append("delta.timeTravel.").append(source).toString();
                    scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableVersion"), (Object)BoxesRunTime.boxToLong((long)this.deltaLog().snapshot().version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"queriedVersion"), (Object)BoxesRunTime.boxToLong((long)version2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"accessType"), (Object)accessType2)}));
                    scala.collection.immutable.Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                    this.recordDeltaEvent(x$1, x$2, x$4, x$3);
                    return this.deltaLog().getSnapshotAt(version2, this.deltaLog().getSnapshotAt$default$2(), this.deltaLog().getSnapshotAt$default$3());
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.deltaLog().update(true));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.snapshot;
    }

    public Snapshot snapshot() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.snapshot$lzycompute() : this.snapshot;
    }

    public StructType schema() {
        return this.snapshot().schema();
    }

    public Transform[] partitioning() {
        return (Transform[])((TraversableOnce)this.snapshot().metadata().partitionColumns().map((Function1 & Serializable & scala.Serializable)col -> new IdentityTransform((NamedReference)new FieldReference((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{col})))), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Transform.class));
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> properties() {
        void var1_1;
        HashMap<String, String> base = new HashMap<String, String>();
        this.snapshot().metadata().configuration().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = k;
            String string2 = "path";
            BoxedUnit boxedUnit = (string == null ? string2 != null : !string.equals(string2)) ? base.put(k, v) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        base.put("provider", "delta");
        base.put("location", CatalogUtils$.MODULE$.URIToString(this.path().toUri()));
        Option$.MODULE$.apply((Object)this.snapshot().metadata().description()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> base.put("comment", (String)x$4));
        base.put(Protocol$.MODULE$.MIN_READER_VERSION_PROP(), ((Object)BoxesRunTime.boxToInteger((int)this.snapshot().protocol().minReaderVersion())).toString());
        base.put(Protocol$.MODULE$.MIN_WRITER_VERSION_PROP(), ((Object)BoxesRunTime.boxToInteger((int)this.snapshot().protocol().minWriterVersion())).toString());
        return var1_1;
    }

    public java.util.Set<TableCapability> capabilities() {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableCapability[]{TableCapability.ACCEPT_ANY_SCHEMA, TableCapability.BATCH_READ, TableCapability.V1_BATCH_WRITE, TableCapability.OVERWRITE_BY_FILTER, TableCapability.TRUNCATE}))).asJava();
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        return new WriteIntoDeltaBuilder(this.deltaLog(), info.options());
    }

    public BaseRelation toBaseRelation() {
        if (!this.deltaLog().tableExists()) {
            DeltaTableIdentifier id = (DeltaTableIdentifier)this.catalogTable().map((Function1 & Serializable & scala.Serializable)ct -> {
                Some x$1 = new Some((Object)ct.identifier());
                Option<String> x$2 = DeltaTableIdentifier$.MODULE$.apply$default$1();
                return new DeltaTableIdentifier(x$2, (Option<TableIdentifier>)x$1);
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new DeltaTableIdentifier((Option<String>)new Some((Object)this.path().toString()), DeltaTableIdentifier$.MODULE$.apply$default$2()));
            throw DeltaErrors$.MODULE$.notADeltaTableException(id);
        }
        Seq<Expression> partitionPredicates = DeltaDataSource$.MODULE$.verifyAndCreatePartitionFilters(this.path().toString(), this.snapshot(), this.partitionFilters());
        return this.deltaLog().createRelation(partitionPredicates, (Option<Snapshot>)new Some((Object)this.snapshot()), this.timeTravelSpec().isDefined());
    }

    public DeltaTableV2 copy(SparkSession spark, Path path, Option<CatalogTable> catalogTable, Option<String> tableIdentifier, Option<DeltaTimeTravelSpec> timeTravelOpt) {
        return new DeltaTableV2(spark, path, catalogTable, tableIdentifier, timeTravelOpt);
    }

    public SparkSession copy$default$1() {
        return this.spark();
    }

    public Path copy$default$2() {
        return this.path();
    }

    public Option<CatalogTable> copy$default$3() {
        return this.catalogTable();
    }

    public Option<String> copy$default$4() {
        return this.tableIdentifier();
    }

    public Option<DeltaTimeTravelSpec> copy$default$5() {
        return this.timeTravelOpt();
    }

    public String productPrefix() {
        return "DeltaTableV2";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.spark();
                break;
            }
            case 1: {
                object = this.path();
                break;
            }
            case 2: {
                object = this.catalogTable();
                break;
            }
            case 3: {
                object = this.tableIdentifier();
                break;
            }
            case 4: {
                object = this.timeTravelOpt();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeltaTableV2;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeltaTableV2)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeltaTableV2 deltaTableV2 = (DeltaTableV2)x$1;
        SparkSession sparkSession = this.spark();
        SparkSession sparkSession2 = deltaTableV2.spark();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        Path path = this.path();
        Path path2 = deltaTableV2.path();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        Option<CatalogTable> option = this.catalogTable();
        Option<CatalogTable> option2 = deltaTableV2.catalogTable();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.tableIdentifier();
        Option<String> option4 = deltaTableV2.tableIdentifier();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<DeltaTimeTravelSpec> option5 = this.timeTravelOpt();
        Option<DeltaTimeTravelSpec> option6 = deltaTableV2.timeTravelOpt();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!deltaTableV2.canEqual(this)) return false;
        return true;
    }

    public DeltaTableV2(SparkSession spark, Path path, Option<CatalogTable> catalogTable, Option<String> tableIdentifier, Option<DeltaTimeTravelSpec> timeTravelOpt) {
        this.spark = spark;
        this.path = path;
        this.catalogTable = catalogTable;
        this.tableIdentifier = tableIdentifier;
        this.timeTravelOpt = timeTravelOpt;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        Product.$init$((Product)this);
    }
}

