/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.files;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%c!B\t\u0013\u0003\u0003y\u0002\u0002C\r\u0001\u0005\u000b\u0007I\u0011\u0001\u0018\t\u0011M\u0002!\u0011!Q\u0001\n=B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005m!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003>\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015\u0001\u0007A\"\u0001b\u0011\u00151\b\u0001\"\u0011x\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\ti\u0001\u0001C\t\u0003\u001fAq!!\n\u0001\t\u0003\n9\u0003C\u0004\u0002*\u0001!I!a\u000b\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\tqA+\u00195pK\u001aKG.Z%oI\u0016D(BA\n\u0015\u0003\u00151\u0017\u000e\\3t\u0015\t)b#A\u0003eK2$\u0018M\u0003\u0002\u00181\u0005\u00191/\u001d7\u000b\u0005eQ\u0012!B:qCJ\\'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014-\u001b\u0005A#BA\u0015+\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005-2\u0012!C3yK\u000e,H/[8o\u0013\ti\u0003FA\u0005GS2,\u0017J\u001c3fqV\tq\u0006\u0005\u00021c5\ta#\u0003\u00023-\ta1\u000b]1sWN+7o]5p]\u000611\u000f]1sW\u0002\n\u0001\u0002Z3mi\u0006dunZ\u000b\u0002mA\u0011q\u0007O\u0007\u0002)%\u0011\u0011\b\u0006\u0002\t\t\u0016dG/\u0019'pO\u0006IA-\u001a7uC2{w\rI\u0001\u0005a\u0006$\b.F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0002gg*\u0011!IG\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0011{$\u0001\u0002)bi\"\fQ\u0001]1uQ\u0002\na\u0001P5oSRtD\u0003\u0002%K\u00172\u0003\"!\u0013\u0001\u000e\u0003IAQ!G\u0004A\u0002=BQ\u0001N\u0004A\u0002YBQaO\u0004A\u0002u\nA\u0002^1cY\u00164VM]:j_:,\u0012a\u0014\t\u0003CAK!!\u0015\u0012\u0003\t1{gnZ\u0001\ne>|G\u000fU1uQN,\u0012\u0001\u0016\t\u0004+vkdB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tIf$\u0001\u0004=e>|GOP\u0005\u0002G%\u0011ALI\u0001\ba\u0006\u001c7.Y4f\u0013\tqvLA\u0002TKFT!\u0001\u0018\u0012\u0002\u001b5\fGo\u00195j]\u001e4\u0015\u000e\\3t)\r\u0011\u0017\u000e\u001e\t\u0004+v\u001b\u0007C\u00013h\u001b\u0005)'B\u00014\u0015\u0003\u001d\t7\r^5p]NL!\u0001[3\u0003\u000f\u0005#GMR5mK\")!N\u0003a\u0001W\u0006\u0001\u0002/\u0019:uSRLwN\u001c$jYR,'o\u001d\t\u0004+vc\u0007CA7s\u001b\u0005q'BA8q\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005E4\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Mt'AC#yaJ,7o]5p]\")QO\u0003a\u0001W\u0006YA-\u0019;b\r&dG/\u001a:t\u0003%a\u0017n\u001d;GS2,7\u000fF\u0002yyv\u00042!V/z!\t9#0\u0003\u0002|Q\t\u0011\u0002+\u0019:uSRLwN\u001c#je\u0016\u001cGo\u001c:z\u0011\u0015Q7\u00021\u0001l\u0011\u0015)8\u00021\u0001l\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\fWCAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004-\u0005)A/\u001f9fg&!\u00111BA\u0003\u0005)\u0019FO];diRK\b/Z\u0001\rC\n\u001cx\u000e\\;uKB\u000bG\u000f\u001b\u000b\u0004{\u0005E\u0001bBA\n\u001b\u0001\u0007\u0011QC\u0001\u0006G\"LG\u000e\u001a\t\u0005\u0003/\tyB\u0004\u0003\u0002\u001a\u0005m\u0001CA,#\u0013\r\tiBI\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00121\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u!%\u0001\u0005u_N#(/\u001b8h)\t\t)\"A\u0007ueVt7-\u0019;f%&<\u0007\u000e\u001e\u000b\u0007\u0003+\ti#!\r\t\u000f\u0005=r\u00021\u0001\u0002\u0016\u0005)\u0011N\u001c9vi\"9\u00111G\bA\u0002\u0005U\u0012a\u00017f]B\u0019\u0011%a\u000e\n\u0007\u0005e\"EA\u0002J]R\f1bZ3u\u0005\u0006\u001cX\rU1uQR!\u0011qHA#!\u0011\t\u0013\u0011I\u001f\n\u0007\u0005\r#E\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003\u000f\u0002\u0002\u0019A\u001f\u0002\u0011\u0019LG.\u001a)bi\"\u0004")
public abstract class TahoeFileIndex
implements FileIndex {
    private final SparkSession spark;
    private final DeltaLog deltaLog;
    private final Path path;

    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$((FileIndex)this);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public Path path() {
        return this.path;
    }

    public long tableVersion() {
        return this.deltaLog().snapshot().version();
    }

    public Seq<Path> rootPaths() {
        Path path = this.path();
        return Nil$.MODULE$.$colon$colon((Object)path);
    }

    public abstract Seq<AddFile> matchingFiles(Seq<Expression> var1, Seq<Expression> var2);

    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        String timeZone = this.spark().sessionState().conf().sessionLocalTimeZone();
        return ((TraversableOnce)this.matchingFiles(partitionFilters, dataFilters).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.partitionValues()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map partitionValues = (Map)tuple2._1();
            Seq files = (Seq)tuple2._2();
            Object[] rowValues = (Object[])((TraversableOnce)this.partitionSchema().map((Function1 & Serializable & scala.Serializable)p -> {
                Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply(partitionValues.apply((Object)p.name())), p.dataType(), Option$.MODULE$.apply((Object)timeZone));
                InternalRow x$1 = qual$1.eval$default$1();
                return qual$1.eval(x$1);
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
            FileStatus[] fileStats = (FileStatus[])((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)f -> new FileStatus(f.size(), false, 0, 1L, f.modificationTime(), this.absolutePath(f.path())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileStatus.class));
            PartitionDirectory partitionDirectory = new PartitionDirectory((InternalRow)new GenericInternalRow(rowValues), (Seq)Predef$.MODULE$.wrapRefArray((Object[])fileStats));
            return partitionDirectory;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public StructType partitionSchema() {
        return this.deltaLog().snapshot().metadata().partitionSchema();
    }

    public Path absolutePath(String child) {
        Path p = new Path(new URI(child));
        return p.isAbsolute() ? p : new Path(this.path(), p);
    }

    public String toString() {
        String truncatedPath = this.truncateRight(this.path().toString(), 100);
        return new StringBuilder(17).append("Delta[version=").append(this.tableVersion()).append(", ").append(truncatedPath).append("]").toString();
    }

    private String truncateRight(String input, int len) {
        return input.length() > len ? new StringBuilder(4).append("... ").append(new StringOps(Predef$.MODULE$.augmentString(input)).takeRight(len)).toString() : input;
    }

    public Option<Path> getBasePath(Path filePath) {
        return new Some((Object)this.path());
    }

    public TahoeFileIndex(SparkSession spark, DeltaLog deltaLog, Path path) {
        this.spark = spark;
        this.deltaLog = deltaLog;
        this.path = path;
        FileIndex.$init$((FileIndex)this);
    }
}

