/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.files;

import java.io.Serializable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.OptimisticTransactionImpl;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.constraints.Constraint;
import org.apache.spark.sql.delta.constraints.Constraints$;
import org.apache.spark.sql.delta.constraints.DeltaInvariantCheckerExec;
import org.apache.spark.sql.delta.files.DelayedCommitProtocol;
import org.apache.spark.sql.delta.files.SQLMetricsReporting;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.InvariantViolationException;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf!\u0003\t\u0012!\u0003\r\tAHA\\\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015\u0001\u0004A\"\u00012\u0011\u00151\u0004A\"\u00018\u0011\u0015q\u0004A\"\u0005@\u0011\u0015\u0019\u0005A\"\u0005E\u0011\u001dA\u0005\u00011A\u0005\u0012%Cq!\u0014\u0001A\u0002\u0013Ea\nC\u0003R\u0001\u0011E!\u000bC\u0003b\u0001\u0011E!\rC\u0003z\u0001\u0011E!\u0010C\u0004\u0002D\u0001!\t\"!\u0012\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u0011Q\f\u0001\u0005\u0002\u0005U\u0004bBA/\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003;\u0002A\u0011AAS\u0005I!&/\u00198tC\u000e$\u0018n\u001c8bY^\u0013\u0018\u000e^3\u000b\u0005I\u0019\u0012!\u00024jY\u0016\u001c(B\u0001\u000b\u0016\u0003\u0015!W\r\u001c;b\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\u001a\u0012\u0001C7fi\u0016\u0014\u0018N\\4\n\u0005):#\u0001\u0004#fYR\fGj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u0001.!\t\u0001c&\u0003\u00020C\t!QK\\5u\u0003!!W\r\u001c;b\u0019><W#\u0001\u001a\u0011\u0005M\"T\"A\n\n\u0005U\u001a\"\u0001\u0003#fYR\fGj\\4\u0002\u0011A\u0014x\u000e^8d_2,\u0012\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0003wM\tq!Y2uS>t7/\u0003\u0002>u\tA\u0001K]8u_\u000e|G.\u0001\u0005t]\u0006\u00048\u000f[8u+\u0005\u0001\u0005CA\u001aB\u0013\t\u00115C\u0001\u0005T]\u0006\u00048\u000f[8u\u0003!iW\r^1eCR\fW#A#\u0011\u0005e2\u0015BA$;\u0005!iU\r^1eCR\f\u0017A\u00035bg^\u0013\u0018\u000e\u001e;f]V\t!\n\u0005\u0002!\u0017&\u0011A*\t\u0002\b\u0005>|G.Z1o\u00039A\u0017m],sSR$XM\\0%KF$\"!L(\t\u000fA;\u0011\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010J\u0019\u0002\u0019\u001d,GoQ8n[&$H/\u001a:\u0015\u0005M;\u0006C\u0001+V\u001b\u0005\t\u0012B\u0001,\u0012\u0005U!U\r\\1zK\u0012\u001cu.\\7jiB\u0013x\u000e^8d_2DQ\u0001\u0017\u0005A\u0002e\u000b!b\\;uaV$\b+\u0019;i!\tQv,D\u0001\\\u0015\taV,\u0001\u0002gg*\u0011a,G\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0001\\&\u0001\u0002)bi\"\f!#\\1lK>+H\u000f];u\u001dVdG.\u00192mKR\u00111m\u001e\t\u0004I2|gBA3k\u001d\t1\u0017.D\u0001h\u0015\tAW$\u0001\u0004=e>|GOP\u0005\u0002E%\u00111.I\u0001\ba\u0006\u001c7.Y4f\u0013\tigNA\u0002TKFT!a[\u0011\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018aC3yaJ,7o]5p]NT!\u0001^\u000b\u0002\u0011\r\fG/\u00197zgRL!A^9\u0003\u0013\u0005#HO]5ckR,\u0007\"\u0002=\n\u0001\u0004\u0019\u0017AB8viB,H/A\u0007o_Jl\u0017\r\\5{K\u0012\u000bG/\u0019\u000b\u0006w\u0006%\u0011Q\u0006\t\u0005Aqt8-\u0003\u0002~C\t1A+\u001e9mKJ\u00022a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004U\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u000f#V,'/_#yK\u000e,H/[8o\u0011\u001d\tYA\u0003a\u0001\u0003\u001b\tA\u0001Z1uCB\"\u0011qBA\u000e!\u0019\t\t\"a\u0005\u0002\u00185\tQ#C\u0002\u0002\u0016U\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u0002\u001a\u0005mA\u0002\u0001\u0003\r\u0003;\tI!!A\u0001\u0002\u000b\u0005\u0011q\u0004\u0002\u0004?\u0012\n\u0014\u0003BA\u0011\u0003O\u00012\u0001IA\u0012\u0013\r\t)#\t\u0002\b\u001d>$\b.\u001b8h!\r\u0001\u0013\u0011F\u0005\u0004\u0003W\t#aA!os\"9\u0011q\u0006\u0006A\u0002\u0005E\u0012!\u00049beRLG/[8o\u0007>d7\u000f\u0005\u0003eY\u0006M\u0002\u0003BA\u001b\u0003{qA!a\u000e\u0002:A\u0011a-I\u0005\u0004\u0003w\t\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002@\u0005\u0005#AB*ue&twMC\u0002\u0002<\u0005\nacZ3u!\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn\u001d\u000b\bG\u0006\u001d\u0013qKA-\u0011\u001d\tIe\u0003a\u0001\u0003\u0017\nq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011K\u000b\u0002\u000bQL\b/Z:\n\t\u0005U\u0013q\n\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002=\f\u0001\u0004\u0019\u0007BBA.\u0017\u0001\u0007!*A\u0006d_2\u001cHI]8qa\u0016$\u0017AC<sSR,g)\u001b7fgR!\u0011\u0011MA5!\u0011!G.a\u0019\u0011\u0007e\n)'C\u0002\u0002hi\u0012q!\u00113e\r&dW\rC\u0004\u0002\f1\u0001\r!a\u001b1\t\u00055\u0014\u0011\u000f\t\u0007\u0003#\t\u0019\"a\u001c\u0011\t\u0005e\u0011\u0011\u000f\u0003\r\u0003g\nI'!A\u0001\u0002\u000b\u0005\u0011q\u0004\u0002\u0004?\u0012\u0012DCBA1\u0003o\n\u0019\tC\u0004\u0002\f5\u0001\r!!\u001f1\t\u0005m\u0014q\u0010\t\u0007\u0003#\t\u0019\"! \u0011\t\u0005e\u0011q\u0010\u0003\r\u0003\u0003\u000b9(!A\u0001\u0002\u000b\u0005\u0011q\u0004\u0002\u0004?\u0012\u001a\u0004bBAC\u001b\u0001\u0007\u0011qQ\u0001\roJLG/Z(qi&|gn\u001d\t\u0006A\u0005%\u0015QR\u0005\u0004\u0003\u0017\u000b#AB(qi&|g\u000eE\u00024\u0003\u001fK1!!%\u0014\u00051!U\r\u001c;b\u001fB$\u0018n\u001c8t)\u0019\t\t'!&\u0002\"\"9\u00111\u0002\bA\u0002\u0005]\u0005\u0007BAM\u0003;\u0003b!!\u0005\u0002\u0014\u0005m\u0005\u0003BA\r\u0003;#A\"a(\u0002\u0016\u0006\u0005\t\u0011!B\u0001\u0003?\u00111a\u0018\u00135\u0011\u0019\t\u0019K\u0004a\u0001\u0015\u0006Q\u0011n](qi&l\u0017N_3\u0015\u0011\u0005\u0005\u0014qUAZ\u0003kCq!a\u0003\u0010\u0001\u0004\tI\u000b\r\u0003\u0002,\u0006=\u0006CBA\t\u0003'\ti\u000b\u0005\u0003\u0002\u001a\u0005=F\u0001DAY\u0003O\u000b\t\u0011!A\u0003\u0002\u0005}!aA0%k!9\u0011QQ\bA\u0002\u0005\u001d\u0005BBAR\u001f\u0001\u0007!\nE\u00024\u0003sK1!a/\u0014\u0005ey\u0005\u000f^5nSN$\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:LU\u000e\u001d7")
public interface TransactionalWrite
extends DeltaLogging {
    public DeltaLog deltaLog();

    public Protocol protocol();

    public Snapshot snapshot();

    public org.apache.spark.sql.delta.actions.Metadata metadata();

    public boolean hasWritten();

    public void hasWritten_$eq(boolean var1);

    public static /* synthetic */ DelayedCommitProtocol getCommitter$(TransactionalWrite $this, Path outputPath) {
        return $this.getCommitter(outputPath);
    }

    default public DelayedCommitProtocol getCommitter(Path outputPath) {
        return new DelayedCommitProtocol("delta", outputPath.toString(), (Option<Object>)None$.MODULE$);
    }

    public static /* synthetic */ Seq makeOutputNullable$(TransactionalWrite $this, Seq output) {
        return $this.makeOutputNullable((Seq<Attribute>)output);
    }

    default public Seq<Attribute> makeOutputNullable(Seq<Attribute> output) {
        return (Seq)output.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Attribute attribute;
            Attribute attribute2 = x0$1;
            if (attribute2 instanceof AttributeReference) {
                DataType nullableDataType;
                AttributeReference attributeReference = (AttributeReference)attribute2;
                DataType x$1 = nullableDataType = SchemaUtils$.MODULE$.typeAsNullable(attributeReference.dataType());
                boolean x$2 = true;
                String x$3 = attributeReference.copy$default$1();
                Metadata x$4 = attributeReference.copy$default$4();
                ExprId x$5 = attributeReference.exprId();
                Seq x$6 = attributeReference.qualifier();
                attribute = attributeReference.copy(x$3, x$1, x$2, x$4, x$5, x$6);
            } else {
                attribute = attribute2.withNullability(true);
            }
            return attribute;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ Tuple2 normalizeData$(TransactionalWrite $this, Dataset data, Seq partitionCols) {
        return $this.normalizeData(data, (Seq<String>)partitionCols);
    }

    default public Tuple2<QueryExecution, Seq<Attribute>> normalizeData(Dataset<?> data, Seq<String> partitionCols) {
        Dataset<Row> normalizedData = SchemaUtils$.MODULE$.normalizeColumnNames(((OptimisticTransactionImpl)this).metadata().schema(), data);
        Dataset<Row> cleanedData = SchemaUtils$.MODULE$.dropNullTypeColumns(normalizedData);
        StructType structType = cleanedData.schema();
        StructType structType2 = normalizedData.schema();
        QueryExecution queryExecution = (structType == null ? structType2 != null : !structType.equals(structType2)) ? cleanedData.queryExecution() : data.queryExecution();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)queryExecution), this.makeOutputNullable((Seq<Attribute>)cleanedData.queryExecution().analyzed().output()));
    }

    public static /* synthetic */ Seq getPartitioningColumns$(TransactionalWrite $this, StructType partitionSchema, Seq output, boolean colsDropped) {
        return $this.getPartitioningColumns(partitionSchema, (Seq<Attribute>)output, colsDropped);
    }

    default public Seq<Attribute> getPartitioningColumns(StructType partitionSchema, Seq<Attribute> output, boolean colsDropped) {
        Seq partitionColumns = (Seq)partitionSchema.map((Function1 & Serializable & scala.Serializable)col -> (Attribute)output.find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TransactionalWrite.$anonfun$getPartitioningColumns$2(col, f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw DeltaErrors$.MODULE$.partitionColumnNotFoundException(col.name(), output);
        }), Seq$.MODULE$.canBuildFrom());
        if (partitionColumns.nonEmpty() && partitionColumns.length() == output.length()) {
            throw DeltaErrors$.MODULE$.nonPartitionColumnAbsentException(colsDropped);
        }
        return partitionColumns;
    }

    public static /* synthetic */ Seq writeFiles$(TransactionalWrite $this, Dataset data) {
        return $this.writeFiles(data);
    }

    default public Seq<AddFile> writeFiles(Dataset<?> data) {
        return this.writeFiles(data, (Option<DeltaOptions>)None$.MODULE$, false);
    }

    public static /* synthetic */ Seq writeFiles$(TransactionalWrite $this, Dataset data, Option writeOptions) {
        return $this.writeFiles(data, (Option<DeltaOptions>)writeOptions);
    }

    default public Seq<AddFile> writeFiles(Dataset<?> data, Option<DeltaOptions> writeOptions) {
        return this.writeFiles(data, writeOptions, false);
    }

    public static /* synthetic */ Seq writeFiles$(TransactionalWrite $this, Dataset data, boolean isOptimize) {
        return $this.writeFiles(data, isOptimize);
    }

    default public Seq<AddFile> writeFiles(Dataset<?> data, boolean isOptimize) {
        return this.writeFiles(data, (Option<DeltaOptions>)None$.MODULE$, isOptimize);
    }

    public static /* synthetic */ Seq writeFiles$(TransactionalWrite $this, Dataset data, Option writeOptions, boolean isOptimize) {
        return $this.writeFiles(data, (Option<DeltaOptions>)writeOptions, isOptimize);
    }

    default public Seq<AddFile> writeFiles(Dataset<?> data, Option<DeltaOptions> writeOptions, boolean isOptimize) {
        this.hasWritten_$eq(true);
        SparkSession spark = data.sparkSession();
        StructType partitionSchema = ((OptimisticTransactionImpl)this).metadata().partitionSchema();
        Path outputPath = ((OptimisticTransactionImpl)this).deltaLog().dataPath();
        Tuple2<QueryExecution, Seq<Attribute>> tuple2 = this.normalizeData(data, ((OptimisticTransactionImpl)this).metadata().partitionColumns());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        QueryExecution queryExecution = (QueryExecution)tuple2._1();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)queryExecution, (Object)output);
        Tuple2 tuple23 = tuple22;
        QueryExecution queryExecution2 = (QueryExecution)tuple23._1();
        Seq output2 = (Seq)tuple23._2();
        Seq<Attribute> partitioningColumns = this.getPartitioningColumns(partitionSchema, (Seq<Attribute>)output2, output2.length() < data.schema().size());
        DelayedCommitProtocol committer = this.getCommitter(outputPath);
        Seq<Constraint> constraints = Constraints$.MODULE$.getAll(((OptimisticTransactionImpl)this).metadata(), spark);
        SQLExecution$.MODULE$.withNewExecutionId(queryExecution2, SQLExecution$.MODULE$.withNewExecutionId$default$2(), (Function0 & Serializable & scala.Serializable)() -> {
            Set set;
            FileFormatWriter.OutputSpec outputSpec = new FileFormatWriter.OutputSpec(outputPath.toString(), Predef$.MODULE$.Map().empty(), output2);
            DeltaInvariantCheckerExec physicalPlan = new DeltaInvariantCheckerExec(queryExecution2.executedPlan(), constraints, spark);
            ListBuffer statsTrackers = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.DELTA_HISTORY_METRICS_ENABLED()))) {
                BasicWriteJobStatsTracker basicWriteJobStatsTracker = new BasicWriteJobStatsTracker(new SerializableConfiguration(spark.sessionState().newHadoopConf()), BasicWriteJobStatsTracker$.MODULE$.metrics());
                ((SQLMetricsReporting)((Object)this)).registerSQLMetrics(spark, (Map<String, SQLMetric>)basicWriteJobStatsTracker.metrics());
                statsTrackers.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WriteJobStatsTracker[]{basicWriteJobStatsTracker}));
            }
            try {
                set = FileFormatWriter$.MODULE$.write(spark, (SparkPlan)physicalPlan, ((OptimisticTransactionImpl)this).snapshot().fileFormat(), (FileCommitProtocol)committer, outputSpec, spark.sessionState().newHadoopConfWithOptions(((OptimisticTransactionImpl)this).metadata().configuration()), partitioningColumns, (Option)None$.MODULE$, (Seq)statsTrackers, Predef$.MODULE$.Map().empty());
            }
            catch (SparkException s) {
                Throwable violationException = ExceptionUtils.getRootCause((Throwable)s);
                if (violationException instanceof InvariantViolationException) {
                    throw violationException;
                }
                throw s;
            }
            return set;
        });
        return committer.addedStatuses();
    }

    public static /* synthetic */ boolean $anonfun$getPartitioningColumns$2(StructField col$1, Attribute f) {
        String string = f.name();
        String string2 = col$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static void $init$(TransactionalWrite $this) {
        $this.hasWritten_$eq(false);
    }
}

