/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Transplant;

@Consumes(value={"application/json"})
@Path(value="trees")
public interface TreeApi {
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get all references")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned references.")})
    public List<Reference> getAllReferences();

    @GET
    @Produces(value={"application/json"})
    @Path(value="tree")
    @Operation(summary="Get default branch for commits and reads")
    @APIResponses(value={@APIResponse(responseCode="200", description="Found and default bracnh."), @APIResponse(responseCode="404", description="Default branch not found.")})
    public Branch getDefaultBranch() throws NessieNotFoundException;

    @POST
    @Path(value="tree")
    @Operation(summary="Create a new reference")
    @APIResponses(value={@APIResponse(responseCode="204", description="Created successfully."), @APIResponse(responseCode="409", description="Reference already exists")})
    public void createReference(@Valid @NotNull @RequestBody(description="Reference to create.", content={@Content(examples={@ExampleObject(ref="refObj")})}) Reference var1) throws NessieNotFoundException, NessieConflictException;

    @GET
    @Produces(value={"application/json"})
    @Path(value="tree/{ref}")
    @Operation(summary="Fetch details of a reference")
    @APIResponses(value={@APIResponse(responseCode="200", description="Found and returned reference.", content={@Content(examples={@ExampleObject(ref="refObj")})}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="404", description="Ref not found")})
    public Reference getReferenceByName(@NotNull @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") @Parameter(description="name of ref to fetch", examples={@ExampleObject(ref="ref")}) @PathParam(value="ref") @NotNull @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") String var1) throws NessieNotFoundException;

    @GET
    @Produces(value={"application/json"})
    @Path(value="tree/{ref}/entries")
    @Operation(summary="Fetch all entries for a given reference", description="Retrieves objects for a ref, potentially truncated by the backend.\n\nRetrieves up to 'maxRecords' entries for the given named reference (tag or branch) or the given hash. The backend may respect the given 'max' records hint, but return less or more entries. Backends may also cap the returned entries at a hard-coded limit, the default REST server implementation has such a hard-coded limit.\n\nTo implement paging, check 'hasMore' in the response and, if 'true', pass the value returned as 'token' in the next invocation as the 'pageToken' parameter.\n\nThe content and meaning of the returned 'token' is \"private\" to the implementation,treat is as an opaque value.\n\nIt is wrong to assume that invoking this method with a very high 'maxRecords' value will return all commit log entries.")
    @APIResponses(value={@APIResponse(description="all objects for a reference", content={@Content(examples={@ExampleObject(ref="entriesResponse")})}), @APIResponse(responseCode="200", description="Returned successfully."), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="404", description="Ref not found")})
    public EntriesResponse getEntries(@NotNull @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") @Parameter(description="name of ref to fetch from", examples={@ExampleObject(ref="ref")}) @PathParam(value="ref") @NotNull @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") String var1, @Parameter(description="maximum number of entries to return, just a hint for the server") @QueryParam(value="max") Integer var2, @Parameter(description="pagination continuation token, as returned in the previous EntriesResponse.token") @QueryParam(value="pageToken") String var3, @Parameter(description="list of value types to return. Return all if empty", examples={@ExampleObject(ref="types")}) @QueryParam(value="types") List<String> var4) throws NessieNotFoundException;

    @GET
    @Produces(value={"application/json"})
    @Path(value="tree/{ref}/log")
    @Operation(summary="Get commit log for a reference", description="Retrieve the commit log for a ref, potentially truncated by the backend.\n\nRetrieves up to 'maxRecords' commit-log-entries starting at the HEAD of the given named reference (tag or branch) or the given hash. The backend may respect the given 'max' records hint, but return less or more entries. Backends may also cap the returned entries at a hard-coded limit, the default REST server implementation has such a hard-coded limit.\n\nTo implement paging, check 'hasMore' in the response and, if 'true', pass the value returned as 'token' in the next invocation as the 'pageToken' parameter.\n\nThe content and meaning of the returned 'token' is \"private\" to the implementation,treat is as an opaque value.\n\nIt is wrong to assume that invoking this method with a very high 'maxRecords' value will return all commit log entries.")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned commits.", content={@Content(examples={@ExampleObject(ref="logResponse")})}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="404", description="Ref doesn't exists")})
    public LogResponse getCommitLog(@NotNull @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") @Parameter(description="ref to show log from", examples={@ExampleObject(ref="ref")}) @PathParam(value="ref") @NotNull @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") String var1, @Parameter(description="maximum number of commit-log entries to return, just a hint for the server") @QueryParam(value="max") Integer var2, @Parameter(description="pagination continuation token, as returned in the previous LogResponse.token") @QueryParam(value="pageToken") String var3) throws NessieNotFoundException;

    @PUT
    @Path(value="tag/{tagName}")
    @Operation(summary="Set a tag to a specific hash")
    @APIResponses(value={@APIResponse(responseCode="204", description="Assigned successfully"), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="404", description="One or more references don't exist"), @APIResponse(responseCode="412", description="Update conflict")})
    public void assignTag(@NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Tag name to reassign", examples={@ExampleObject(ref="ref")}) @PathParam(value="tagName") @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var1, @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @Parameter(description="Expected previous hash of tag", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String var2, @Valid @NotNull @RequestBody(description="New tag content", content={@Content(examples={@ExampleObject(ref="tagObj")})}) Tag var3) throws NessieNotFoundException, NessieConflictException;

    @DELETE
    @Path(value="tag/{tagName}")
    @Operation(summary="Delete a tag")
    @APIResponses(value={@APIResponse(responseCode="204", description="Deleted successfully."), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="409", description="update conflict")})
    public void deleteTag(@NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Tag to delete", examples={@ExampleObject(ref="ref")}) @PathParam(value="tagName") @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var1, @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @Parameter(description="Expected hash of tag", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String var2) throws NessieConflictException, NessieNotFoundException;

    @PUT
    @Path(value="branch/{branchName}")
    @Operation(summary="Set a branch to a specific hash")
    @APIResponses(value={@APIResponse(responseCode="204", description="Assigned successfully"), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="404", description="One or more references don't exist"), @APIResponse(responseCode="409", description="Update conflict")})
    public void assignBranch(@NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Tag name to reassign", examples={@ExampleObject(ref="ref")}) @PathParam(value="branchName") @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var1, @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @Parameter(description="Expected previous hash of tag", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String var2, @Valid @NotNull @RequestBody(description="New branch content", content={@Content(examples={@ExampleObject(ref="refObj")})}) Branch var3) throws NessieNotFoundException, NessieConflictException;

    @DELETE
    @Path(value="branch/{branchName}")
    @Operation(summary="Delete a branch endpoint")
    @APIResponses(value={@APIResponse(responseCode="204", description="Deleted successfully."), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="409", description="update conflict")})
    public void deleteBranch(@NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Branch to delete", examples={@ExampleObject(ref="ref")}) @PathParam(value="branchName") @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var1, @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @Parameter(description="Expected hash of tag", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String var2) throws NessieConflictException, NessieNotFoundException;

    @POST
    @Path(value="branch/{branchName}/transplant")
    @Operation(summary="transplant commits from mergeRef to ref endpoint")
    @APIResponses(value={@APIResponse(responseCode="204", description="Merged successfully."), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="no merge ref supplied"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="409", description="update conflict")})
    public void transplantCommitsIntoBranch(@NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Branch to transplant into", examples={@ExampleObject(ref="ref")}) @PathParam(value="branchName") @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var1, @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @Parameter(description="Expected hash of tag", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String var2, @Parameter(description="commit message", examples={@ExampleObject(ref="commitMessage")}) @QueryParam(value="message") String var3, @Valid @RequestBody(description="Hashes to transplant", content={@Content(examples={@ExampleObject(ref="transplant")})}) Transplant var4) throws NessieNotFoundException, NessieConflictException;

    @POST
    @Path(value="branch/{branchName}/merge")
    @Operation(summary="merge commits from mergeRef to ref endpoint")
    @APIResponses(value={@APIResponse(responseCode="204", description="Merged successfully."), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="no merge ref supplied"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="409", description="update conflict")})
    public void mergeRefIntoBranch(@NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Branch to merge into", examples={@ExampleObject(ref="ref")}) @PathParam(value="branchName") @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var1, @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @Parameter(description="Expected hash of tag", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String var2, @Valid @NotNull @RequestBody(description="Merge operation", content={@Content(examples={@ExampleObject(ref="merge")})}) Merge var3) throws NessieNotFoundException, NessieConflictException;

    @POST
    @Path(value="branch/{branchName}/commit")
    @Consumes(value={"application/json"})
    @Operation(summary="commit multiple on default branch")
    @APIResponses(value={@APIResponse(responseCode="204", description="Updated successfully."), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="409", description="Update conflict")})
    public void commitMultipleOperations(@NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") @Parameter(description="Branch to change, defaults to default branch.", examples={@ExampleObject(ref="ref")}) @PathParam(value="branchName") @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String var1, @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") @Parameter(description="Expected hash of branch.", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") @NotNull @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String var2, @Valid @NotNull @RequestBody(description="Operations", content={@Content(examples={@ExampleObject(ref="operations")})}) Operations var3) throws NessieNotFoundException, NessieConflictException;
}

