/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.deltalake;

import io.delta.tables.DeltaTable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.util.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.io.TempDir;
import org.projectnessie.client.tests.AbstractSparkTest;
import org.projectnessie.deltalake.NessieLogFileMetaParser;
import org.projectnessie.deltalake.NessieLogStore;
import org.projectnessie.model.Branch;
import org.projectnessie.model.ImmutableMerge;
import org.projectnessie.model.Merge;
import org.projectnessie.model.Reference;
import scala.Tuple2;

class ITDeltaLog
extends AbstractSparkTest {
    @TempDir
    File tempPath;

    ITDeltaLog() {
    }

    @BeforeAll
    protected static void createDelta() {
        conf.set("spark.delta.logStore.class", NessieLogStore.class.getCanonicalName()).set("spark.delta.logFileHandler.class", NessieLogFileMetaParser.class.getCanonicalName()).set("spark.sql.extensions", "io.delta.sql.DeltaSparkSessionExtension").set("spark.sql.catalog.spark_catalog", "org.apache.spark.sql.delta.catalog.DeltaCatalog");
    }

    @Test
    @DisabledIfSystemProperty(named="skip-multi-branch-tests", matches="true")
    void testMultipleBranches() throws Exception {
        String csvSalaries1 = ITDeltaLog.class.getResource("/salaries1.csv").getPath();
        String csvSalaries2 = ITDeltaLog.class.getResource("/salaries2.csv").getPath();
        String csvSalaries3 = ITDeltaLog.class.getResource("/salaries3.csv").getPath();
        String pathSalaries = new File(this.tempPath, "salaries").getAbsolutePath();
        spark.sql(String.format("CREATE TABLE IF NOT EXISTS test_multiple_branches (Season STRING, Team STRING, Salary STRING, Player STRING) USING delta LOCATION '%s'", pathSalaries));
        Dataset salariesDf1 = spark.read().option("header", true).csv(csvSalaries1);
        salariesDf1.write().format("delta").mode("overwrite").save(pathSalaries);
        Dataset count1 = spark.sql("SELECT COUNT(*) FROM test_multiple_branches");
        Assertions.assertEquals((long)15L, (long)((Row)count1.collectAsList().get(0)).getLong(0));
        Reference mainBranch = nessieClient.getTreeApi().getReferenceByName("main");
        Reference devBranch = nessieClient.getTreeApi().createReference((Reference)Branch.of((String)"testMultipleBranches", (String)mainBranch.getHash()));
        spark.sparkContext().getConf().set("spark.hadoop.nessie.ref", devBranch.getName());
        spark.sparkContext().hadoopConfiguration().set("nessie.ref", devBranch.getName());
        Dataset salariesDf2 = spark.read().option("header", true).csv(csvSalaries2);
        salariesDf2.write().format("delta").mode("append").save(pathSalaries);
        Dataset count2 = spark.sql("SELECT COUNT(*) FROM test_multiple_branches");
        Assertions.assertEquals((long)30L, (long)((Row)count2.collectAsList().get(0)).getLong(0));
        spark.sparkContext().getConf().set("spark.hadoop.nessie.ref", "main");
        spark.sparkContext().hadoopConfiguration().set("nessie.ref", "main");
        Dataset salariesDf3 = spark.read().option("header", true).csv(csvSalaries3);
        salariesDf3.write().format("delta").mode("append").save(pathSalaries);
        Dataset count3 = spark.sql("SELECT COUNT(*) FROM test_multiple_branches");
        Assertions.assertEquals((long)35L, (long)((Row)count3.collectAsList().get(0)).getLong(0));
    }

    @Test
    @DisabledIfSystemProperty(named="skip-multi-branch-tests", matches="true")
    void testCommitRetry() throws Exception {
        String csvSalaries1 = ITDeltaLog.class.getResource("/salaries1.csv").getPath();
        String csvSalaries2 = ITDeltaLog.class.getResource("/salaries2.csv").getPath();
        String csvSalaries3 = ITDeltaLog.class.getResource("/salaries3.csv").getPath();
        String pathSalaries = new File(this.tempPath, "salaries").getAbsolutePath();
        spark.sql(String.format("CREATE TABLE IF NOT EXISTS test_commit_retry (Season STRING, Team STRING, Salary STRING, Player STRING) USING delta LOCATION '%s'", pathSalaries));
        Dataset salariesDf1 = spark.read().option("header", true).csv(csvSalaries1);
        salariesDf1.write().format("delta").mode("overwrite").save(pathSalaries);
        Dataset count1 = spark.sql("SELECT COUNT(*) FROM test_commit_retry");
        Assertions.assertEquals((long)15L, (long)((Row)count1.collectAsList().get(0)).getLong(0));
        Reference mainBranch = nessieClient.getTreeApi().getReferenceByName("main");
        Reference devBranch = nessieClient.getTreeApi().createReference((Reference)Branch.of((String)"testCommitRetry", (String)mainBranch.getHash()));
        spark.sparkContext().getConf().set("spark.hadoop.nessie.ref", devBranch.getName());
        spark.sparkContext().hadoopConfiguration().set("nessie.ref", devBranch.getName());
        Dataset salariesDf2 = spark.read().option("header", true).csv(csvSalaries2);
        salariesDf2.write().format("delta").mode("append").save(pathSalaries);
        Dataset count2 = spark.sql("SELECT COUNT(*) FROM test_commit_retry");
        Assertions.assertEquals((long)30L, (long)((Row)count2.collectAsList().get(0)).getLong(0));
        String toHash = nessieClient.getTreeApi().getReferenceByName("main").getHash();
        String fromHash = nessieClient.getTreeApi().getReferenceByName("testCommitRetry").getHash();
        nessieClient.getTreeApi().mergeRefIntoBranch("main", toHash, (Merge)ImmutableMerge.builder().fromHash(fromHash).build());
        spark.sparkContext().getConf().set("spark.hadoop.nessie.ref", "main");
        spark.sparkContext().hadoopConfiguration().set("nessie.ref", "main");
        Dataset salariesDf3 = spark.read().option("header", true).csv(csvSalaries3);
        salariesDf3.write().format("delta").mode("append").save(pathSalaries);
        Dataset count3 = spark.sql("SELECT COUNT(*) FROM test_commit_retry");
        Assertions.assertEquals((long)50L, (long)((Row)count3.collectAsList().get(0)).getLong(0));
    }

    @Test
    void testWithoutCondition() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(3, 30), this.tuple2(4, 40)), "key", "value");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        target.delete();
        ArrayList expectedAnswer = new ArrayList();
        ITDeltaLog.assertEquals((String)"testWithoutCondition", expectedAnswer, (List)ITDeltaLog.transform((Dataset)target.toDF()));
    }

    @Test
    public void testWithCondition() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(3, 30), this.tuple2(4, 40)), "key", "value");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        target.delete("key = 1 or key = 2");
        Dataset<Row> expectedAnswer = this.createKVDataSet(Arrays.asList(this.tuple2(3, 30), this.tuple2(4, 40)));
        ITDeltaLog.assertEquals((String)"testWithCondition", (List)ITDeltaLog.transform((Dataset)target.toDF()), (List)ITDeltaLog.transform(expectedAnswer));
    }

    @Test
    public void testWithColumnCondition() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(3, 30), this.tuple2(4, 40)), "key", "value");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        target.delete(functions.expr((String)"key = 1 or key = 2"));
        Dataset<Row> expectedAnswer = this.createKVDataSet(Arrays.asList(this.tuple2(3, 30), this.tuple2(4, 40)));
        ITDeltaLog.assertEquals((String)"testWithColumnCondition", (List)ITDeltaLog.transform((Dataset)target.toDF()), (List)ITDeltaLog.transform(expectedAnswer));
    }

    private Dataset<Row> createKVDataSet(List<Tuple2<Integer, Integer>> data, String keyName, String valueName) {
        Encoder encoder = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.INT());
        return spark.createDataset(data, encoder).toDF(new String[]{keyName, valueName});
    }

    private Dataset<Row> createKVDataSet(List<Tuple2<Integer, Integer>> data) {
        Encoder encoder = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.INT());
        return spark.createDataset(data, encoder).toDF();
    }

    private <T1, T2> Tuple2<T1, T2> tuple2(T1 t1, T2 t2) {
        return new Tuple2(t1, t2);
    }

    @Test
    public void testWithoutCondition2() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(3, 30), this.tuple2(4, 40)), "key", "value");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        HashMap<String, String> set = new HashMap<String, String>(){
            {
                this.put("key", "100");
            }
        };
        target.updateExpr((Map)set);
        Dataset<Row> expectedAnswer = this.createKVDataSet(Arrays.asList(this.tuple2(100, 10), this.tuple2(100, 20), this.tuple2(100, 30), this.tuple2(100, 40)));
        ITDeltaLog.assertEquals((String)"testWithoutCondition2", (List)ITDeltaLog.transform((Dataset)target.toDF().sort("key", new String[]{"value"})), (List)ITDeltaLog.transform(expectedAnswer));
    }

    @Test
    public void testWithoutConditionUsingColumn() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(3, 30), this.tuple2(4, 40)), "key", "value");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        HashMap<String, Column> set = new HashMap<String, Column>(){
            {
                this.put("key", functions.expr((String)"100"));
            }
        };
        target.update((Map)set);
        Dataset<Row> expectedAnswer = this.createKVDataSet(Arrays.asList(this.tuple2(100, 10), this.tuple2(100, 20), this.tuple2(100, 30), this.tuple2(100, 40)));
        ITDeltaLog.assertEquals((String)"testWithoutConditionUsingColumn", (List)ITDeltaLog.transform((Dataset)target.toDF().sort("value", new String[0])), (List)ITDeltaLog.transform(expectedAnswer));
    }

    @Test
    public void testWithCondition2() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(3, 30), this.tuple2(4, 40)), "key", "value");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        HashMap<String, String> set = new HashMap<String, String>(){
            {
                this.put("key", "100");
            }
        };
        target.updateExpr("key = 1 or key = 2", (Map)set);
        Dataset<Row> expectedAnswer = this.createKVDataSet(Arrays.asList(this.tuple2(100, 10), this.tuple2(100, 20), this.tuple2(3, 30), this.tuple2(4, 40)));
        ITDeltaLog.assertEquals((String)"testWithCondition2", (List)ITDeltaLog.transform((Dataset)target.toDF()), (List)ITDeltaLog.transform(expectedAnswer));
    }

    @Test
    public void testWithConditionUsingColumn() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(3, 30), this.tuple2(4, 40)), "key", "value");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        HashMap<String, Column> set = new HashMap<String, Column>(){
            {
                this.put("key", functions.expr((String)"100"));
            }
        };
        target.update(functions.expr((String)"key = 1 or key = 2"), (Map)set);
        Dataset<Row> expectedAnswer = this.createKVDataSet(Arrays.asList(this.tuple2(100, 10), this.tuple2(100, 20), this.tuple2(3, 30), this.tuple2(4, 40)));
        ITDeltaLog.assertEquals((String)"testWithConditionUsingColumn", (List)ITDeltaLog.transform((Dataset)target.toDF()), (List)ITDeltaLog.transform(expectedAnswer));
    }

    @Test
    public void checkBasicApi() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20)), "key1", "value1");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        Dataset<Row> sourceTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 100), this.tuple2(3, 30)), "key2", "value2");
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        HashMap<String, String> updateMap = new HashMap<String, String>(){
            {
                this.put("key1", "key2");
                this.put("value1", "value2");
            }
        };
        HashMap<String, String> insertMap = new HashMap<String, String>(){
            {
                this.put("key1", "key2");
                this.put("value1", "value2");
            }
        };
        target.merge(sourceTable, "key1 = key2").whenMatched().updateExpr((Map)updateMap).whenNotMatched().insertExpr((Map)insertMap).execute();
        Dataset<Row> expectedAnswer = this.createKVDataSet(Arrays.asList(this.tuple2(1, 100), this.tuple2(2, 20), this.tuple2(3, 30)));
        ITDeltaLog.assertEquals((String)"checkBasicApi", (List)ITDeltaLog.transform((Dataset)target.toDF().sort("key1", new String[0])), (List)ITDeltaLog.transform(expectedAnswer));
    }

    @Test
    public void checkExtendedApi() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20)), "key1", "value1");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        Dataset<Row> sourceTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 100), this.tuple2(3, 30)), "key2", "value2");
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        HashMap<String, String> updateMap = new HashMap<String, String>(){
            {
                this.put("key1", "key2");
                this.put("value1", "value2");
            }
        };
        HashMap<String, String> insertMap = new HashMap<String, String>(){
            {
                this.put("key1", "key2");
                this.put("value1", "value2");
            }
        };
        target.merge(sourceTable, "key1 = key2").whenMatched("key1 = 4").delete().whenMatched("key2 = 1").updateExpr((Map)updateMap).whenNotMatched("key2 = 3").insertExpr((Map)insertMap).execute();
        Dataset<Row> expectedAnswer = this.createKVDataSet(Arrays.asList(this.tuple2(1, 100), this.tuple2(2, 20), this.tuple2(3, 30)));
        ITDeltaLog.assertEquals((String)"checkExtendedApiWithColumn", (List)ITDeltaLog.transform((Dataset)target.toDF().sort("key1", new String[0])), (List)ITDeltaLog.transform(expectedAnswer));
    }

    @Test
    public void checkExtendedApiWithColumn() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(4, 40)), "key1", "value1");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        Dataset<Row> sourceTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 100), this.tuple2(3, 30), this.tuple2(4, 41)), "key2", "value2");
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        HashMap<String, Column> updateMap = new HashMap<String, Column>(){
            {
                this.put("key1", functions.col((String)"key2"));
                this.put("value1", functions.col((String)"value2"));
            }
        };
        HashMap<String, Column> insertMap = new HashMap<String, Column>(){
            {
                this.put("key1", functions.col((String)"key2"));
                this.put("value1", functions.col((String)"value2"));
            }
        };
        target.merge(sourceTable, functions.expr((String)"key1 = key2")).whenMatched(functions.expr((String)"key1 = 4")).delete().whenMatched(functions.expr((String)"key2 = 1")).update((Map)updateMap).whenNotMatched(functions.expr((String)"key2 = 3")).insert((Map)insertMap).execute();
        Dataset<Row> expectedAnswer = this.createKVDataSet(Arrays.asList(this.tuple2(1, 100), this.tuple2(2, 20), this.tuple2(3, 30)));
        ITDeltaLog.assertEquals((String)"checkExtendedApiWithColumn", (List)ITDeltaLog.transform((Dataset)target.toDF().sort("key1", new String[0])), (List)ITDeltaLog.transform(expectedAnswer));
    }

    @Test
    public void checkUpdateAllAndInsertAll() {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(4, 40), this.tuple2(5, 50)), "key", "value");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        Dataset<Row> sourceTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 100), this.tuple2(3, 30), this.tuple2(4, 41), this.tuple2(5, 51), this.tuple2(6, 60)), "key", "value");
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        target.as("t").merge(sourceTable.as("s"), functions.expr((String)"t.key = s.key")).whenMatched().updateAll().whenNotMatched().insertAll().execute();
        Dataset<Row> expectedAnswer = this.createKVDataSet(Arrays.asList(this.tuple2(1, 100), this.tuple2(2, 20), this.tuple2(3, 30), this.tuple2(4, 41), this.tuple2(5, 51), this.tuple2(6, 60)));
        ITDeltaLog.assertEquals((String)"checkUpdateAllAndInsertAll", (List)ITDeltaLog.transform((Dataset)target.toDF().sort("key", new String[0])), (List)ITDeltaLog.transform(expectedAnswer));
    }

    @Test
    public void testAPI() {
        String input = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"input").toString();
        List<String> data = Arrays.asList("hello", "world");
        Dataset dataDF = spark.createDataset(data, Encoders.STRING()).toDF();
        dataDF.write().format("delta").mode("overwrite").save(input);
        DeltaTable table1 = DeltaTable.forPath((SparkSession)spark, (String)input);
        ITDeltaLog.assertEquals((String)"Test creating DeltaTable by path", (List)ITDeltaLog.transform((Dataset)table1.toDF().sort("value", new String[0])), (List)ITDeltaLog.transform((Dataset)dataDF));
        DeltaTable table2 = DeltaTable.forPath((String)input);
        ITDeltaLog.assertEquals((String)"Test creating DeltaTable by path picks up active SparkSession", (List)ITDeltaLog.transform((Dataset)table2.toDF().sort("value", new String[0])), (List)ITDeltaLog.transform((Dataset)dataDF));
        ITDeltaLog.assertEquals((String)"Test DeltaTable.as() creates subquery alias", (List)ITDeltaLog.transform((Dataset)table2.as("tbl").toDF().select("tbl.value", new String[0]).sort("tbl.value", new String[0])), (List)ITDeltaLog.transform((Dataset)dataDF));
        Assertions.assertTrue((boolean)DeltaTable.isDeltaTable((String)input));
    }
}

