/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.TagDefinition;
import com.databricks.spark.util.TagDefinitions$TAG_ASYNC$;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.CheckpointInstance;
import org.apache.spark.sql.delta.CheckpointInstance$;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.Checkpoints;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.InitialSnapshot;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.LogFileMeta$;
import org.apache.spark.sql.delta.LogSegment;
import org.apache.spark.sql.delta.ReadChecksum;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotManagement$;
import org.apache.spark.sql.delta.VersionChecksum;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e!C\u000e\u001d!\u0003\r\taJA3\u0011\u0015q\u0003\u0001\"\u00010\u0011\u001d\u0019\u0004\u00011A\u0005\u0012QBq\u0001\u0010\u0001A\u0002\u0013EQ\bC\u0004A\u0001\u0001\u0007I\u0011C!\t\u000f\u001d\u0003\u0001\u0019!C\t\u0011\")!\n\u0001C\t\u0017\")q\u000b\u0001C\t1\")!\u000e\u0001C\tW\"9\u0011\u000fAI\u0001\n#\u0011\b\"B?\u0001\t#\t\u0005\"\u0002@\u0001\t\u0003\t\u0005BB@\u0001\t#\t\t\u0001C\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!I\u0011\u0011\u0005\u0001\u0012\u0002\u0013\u0005\u00111\u0005\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011%\ty\u0003AI\u0001\n\u0013\t\u0019\u0003C\u0004\u00022\u0001!\t\"a\r\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!A\u0011q\n\u0001\u0012\u0002\u0013\u0005!\u000fC\u0005\u0002R\u0001\t\n\u0011\"\u0001\u0002T!9\u0011q\u000b\u0001\u0005\u0012\u0005esaBA69!\u0005\u0011Q\u000e\u0004\u00077qA\t!a\u001c\t\u000f\u0005E\u0004\u0004\"\u0001\u0002t!Q\u0011Q\u000f\r\t\u0006\u0004%\t\"a\u001e\u0003%Ms\u0017\r]:i_Rl\u0015M\\1hK6,g\u000e\u001e\u0006\u0003;y\tQ\u0001Z3mi\u0006T!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\t\u0001\u0007\u0005\u0002*c%\u0011!G\u000b\u0002\u0005+:LG/A\nmCN$X\u000b\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007/F\u00016!\tIc'\u0003\u00028U\t!Aj\u001c8hQ\t\u0011\u0011\b\u0005\u0002*u%\u00111H\u000b\u0002\tm>d\u0017\r^5mK\u00069B.Y:u+B$\u0017\r^3US6,7\u000f^1na~#S-\u001d\u000b\u0003ayBqaP\u0002\u0002\u0002\u0003\u0007Q'A\u0002yIE\nqbY;se\u0016tGo\u00158baNDw\u000e^\u000b\u0002\u0005B\u00111\tR\u0007\u00029%\u0011Q\t\b\u0002\t':\f\u0007o\u001d5pi\"\u0012A!O\u0001\u0014GV\u0014(/\u001a8u':\f\u0007o\u001d5pi~#S-\u001d\u000b\u0003a%CqaP\u0003\u0002\u0002\u0003\u0007!)A\thKRdunZ*fO6,g\u000e\u001e$s_6$\"\u0001T(\u0011\u0005\rk\u0015B\u0001(\u001d\u0005)aunZ*fO6,g\u000e\u001e\u0005\u0006!\u001a\u0001\r!U\u0001\u0013gR\f'\u000f^5oO\u000eCWmY6q_&tG\u000fE\u0002*%RK!a\u0015\u0016\u0003\r=\u0003H/[8o!\t\u0019U+\u0003\u0002W9\t\u00112\t[3dWB|\u0017N\u001c;NKR\fG)\u0019;b\u0003!a\u0017n\u001d;Ge>lGCA-i!\rQ&-\u001a\b\u00037\u0002t!\u0001X0\u000e\u0003uS!A\u0018\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0013BA1+\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\u0011%#XM]1u_JT!!\u0019\u0016\u0011\u0005\r3\u0017BA4\u001d\u0005-aun\u001a$jY\u0016lU\r^1\t\u000b%<\u0001\u0019A\u001b\u0002\u0019M$\u0018M\u001d;WKJ\u001c\u0018n\u001c8\u0002/\u001d,G\u000fT8h'\u0016<W.\u001a8u\r>\u0014h+\u001a:tS>tGc\u0001'm_\")Q\u000e\u0003a\u0001]\u0006y1\u000f^1si\u000eCWmY6q_&tG\u000fE\u0002*%VBq\u0001\u001d\u0005\u0011\u0002\u0003\u0007a.A\u0007wKJ\u001c\u0018n\u001c8U_2{\u0017\rZ\u0001\"O\u0016$Hj\\4TK\u001elWM\u001c;G_J4VM]:j_:$C-\u001a4bk2$HEM\u000b\u0002g*\u0012a\u000e^\u0016\u0002kB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u001f\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002}o\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002#\u001d,Go\u00158baNDw\u000e^!u\u0013:LG/\u0001\u0005t]\u0006\u00048\u000f[8u\u00039\u0019'/Z1uKNs\u0017\r]:i_R$rAQA\u0002\u0003\u000f\tY\u0001\u0003\u0004\u0002\u00061\u0001\r\u0001T\u0001\bg\u0016<W.\u001a8u\u0011\u0019\tI\u0001\u0004a\u0001k\u0005IR.\u001b8GS2,'+\u001a;f]RLwN\u001c+j[\u0016\u001cH/Y7q\u0011\u0019\ti\u0001\u0004a\u0001k\u0005IA/[7fgR\fW\u000e]\u0001\u0010SN\u001cf.\u00199tQ>$8\u000b^1mKV\u0011\u00111\u0003\t\u0004S\u0005U\u0011bAA\fU\t9!i\\8mK\u0006t\u0017AB;qI\u0006$X\rF\u0002C\u0003;A\u0011\"a\b\u000f!\u0003\u0005\r!a\u0005\u0002'M$\u0018\r\\3oKN\u001c\u0018iY2faR\f'\r\\3\u0002!U\u0004H-\u0019;fI\u0011,g-Y;mi\u0012\nTCAA\u0013U\r\t\u0019\u0002^\u0001\niJLX\u000b\u001d3bi\u0016$2AQA\u0016\u0011%\ti\u0003\u0005I\u0001\u0002\u0004\t\u0019\"A\u0004jg\u0006\u001b\u0018P\\2\u0002'Q\u0014\u00180\u00169eCR,G\u0005Z3gCVdG\u000fJ\u0019\u0002\u001dU\u0004H-\u0019;f\u0013:$XM\u001d8bYR\u0019!)!\u000e\t\u000f\u00055\"\u00031\u0001\u0002\u0014\u0005iq-\u001a;T]\u0006\u00048\u000f[8u\u0003R$rAQA\u001e\u0003\u007f\t\u0019\u0005\u0003\u0004\u0002>M\u0001\r!N\u0001\bm\u0016\u00148/[8o\u0011!\t\te\u0005I\u0001\u0002\u0004q\u0017aD2p[6LG\u000fV5nKN$\u0018-\u001c9\t\u0013\u0005\u00153\u0003%AA\u0002\u0005\u001d\u0013A\u00057bgR\u001c\u0005.Z2la>Lg\u000e\u001e%j]R\u0004B!\u000b*\u0002JA\u00191)a\u0013\n\u0007\u00055CD\u0001\nDQ\u0016\u001c7\u000e]8j]RLen\u001d;b]\u000e,\u0017aF4fiNs\u0017\r]:i_R\fE\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003]9W\r^*oCB\u001c\bn\u001c;Bi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002V)\u001a\u0011q\t;\u0002'Y,'/\u001b4z\t\u0016dG/\u0019,feNLwN\\:\u0015\u0007A\nY\u0006C\u0004\u0002^Y\u0001\r!a\u0018\u0002\u0011Y,'o]5p]N\u0004B!KA1k%\u0019\u00111\r\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\r\u000b9'C\u0002\u0002jq\u0011\u0001\u0002R3mi\u0006dunZ\u0001\u0013':\f\u0007o\u001d5pi6\u000bg.Y4f[\u0016tG\u000f\u0005\u0002D1M\u0011\u0001\u0004K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00055\u0014!\b3fYR\fGj\\4Bgft7-\u00169eCR,G\u000b\u001b:fC\u0012\u0004vn\u001c7\u0016\u0005\u0005e\u0004\u0003BA>\u0003\u0003k!!! \u000b\u0007\u0005}$&\u0001\u0006d_:\u001cWO\u001d:f]RLA!a!\u0002~\tyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3")
public interface SnapshotManagement {
    public long lastUpdateTimestamp();

    public void lastUpdateTimestamp_$eq(long var1);

    public Snapshot currentSnapshot();

    public void currentSnapshot_$eq(Snapshot var1);

    public static /* synthetic */ LogSegment getLogSegmentFrom$(SnapshotManagement $this, Option startingCheckpoint) {
        return $this.getLogSegmentFrom((Option<CheckpointMetaData>)startingCheckpoint);
    }

    default public LogSegment getLogSegmentFrom(Option<CheckpointMetaData> startingCheckpoint) {
        return this.getLogSegmentForVersion((Option<Object>)startingCheckpoint.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.version())), this.getLogSegmentForVersion$default$2());
    }

    public static /* synthetic */ Iterator listFrom$(SnapshotManagement $this, long startVersion) {
        return $this.listFrom(startVersion);
    }

    default public Iterator<LogFileMeta> listFrom(long startVersion) {
        return ((DeltaLog)this).logFileHandler().listFilesFrom(FileNames$.MODULE$.checkpointPrefix(((DeltaLog)this).logPath(), startVersion));
    }

    public static /* synthetic */ LogSegment getLogSegmentForVersion$(SnapshotManagement $this, Option startCheckpoint, Option versionToLoad) {
        return $this.getLogSegmentForVersion((Option<Object>)startCheckpoint, (Option<Object>)versionToLoad);
    }

    default public LogSegment getLogSegmentForVersion(Option<Object> startCheckpoint, Option<Object> versionToLoad) {
        LogSegment logSegment;
        LogFileMeta[] newFiles = (LogFileMeta[])this.listFrom(BoxesRunTime.unboxToLong((Object)startCheckpoint.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$2(file))).filterNot((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$3(file))).takeWhile((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)versionToLoad.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)v -> f.version() <= v))).toArray(ClassTag$.MODULE$.apply(LogFileMeta.class));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).isEmpty() && startCheckpoint.isEmpty()) {
            throw DeltaErrors$.MODULE$.emptyDirectoryException(((DeltaLog)this).logPath().toString());
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).isEmpty()) {
            return this.getLogSegmentForVersion((Option<Object>)None$.MODULE$, versionToLoad);
        }
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).partition((Function1 & Serializable & scala.Serializable)logFileMeta -> BoxesRunTime.boxToBoolean((boolean)LogFileMeta$.MODULE$.isCheckpointFile(logFileMeta)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogFileMeta[] checkpoints = (LogFileMeta[])tuple2._1();
        LogFileMeta[] deltas = (LogFileMeta[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)checkpoints, (Object)deltas);
        Tuple2 tuple23 = tuple22;
        LogFileMeta[] checkpoints2 = (LogFileMeta[])tuple23._1();
        LogFileMeta[] deltas2 = (LogFileMeta[])tuple23._2();
        CheckpointInstance lastChkpoint = (CheckpointInstance)versionToLoad.map((Function1 & Serializable & scala.Serializable)x$3 -> SnapshotManagement.$anonfun$getLogSegmentForVersion$7(BoxesRunTime.unboxToLong((Object)x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> CheckpointInstance$.MODULE$.MaxValue());
        CheckpointInstance[] checkpointFiles = (CheckpointInstance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkpoints2)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.asCheckpointInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CheckpointInstance.class)));
        Option<CheckpointInstance> newCheckpoint = ((Checkpoints)((Object)this)).getLatestCompleteCheckpointFromList(checkpointFiles, lastChkpoint);
        if (newCheckpoint.isDefined()) {
            long newCheckpointVersion = ((CheckpointInstance)newCheckpoint.get()).version();
            int newCheckpointCount = BoxesRunTime.unboxToInt((Object)((CheckpointInstance)newCheckpoint.get()).numParts().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            LogFileMeta[] deltasAfterCheckpoint = (LogFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$11(newCheckpointVersion, file)));
            long[] deltaVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltasAfterCheckpoint)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.version()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).nonEmpty()) {
                this.verifyDeltaVersions(deltaVersions);
                Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).head()) == newCheckpointVersion + 1L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Did not get the first delta ").append("file version: ").append(newCheckpointVersion + 1L).append(" to compute Snapshot").toString());
                versionToLoad.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).last()) == version, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Did not get the last delta file version: ").append(version).append(" to compute Snapshot").toString()));
            }
            long newVersion = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).lastOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((CheckpointInstance)newCheckpoint.get()).version()));
            LogFileMeta[] newCheckpointFiles = (LogFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkpoints2)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$17(newCheckpointVersion, newCheckpointCount, f)));
            Predef$.MODULE$.assert(newCheckpointFiles.length == newCheckpointCount, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Failed in getting the file information for:\n").append(newCheckpointVersion).append(" and ").append(newCheckpointCount).append("\n").append("among\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkpoints2)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.fileStatus().getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).mkString(" -", "\n -", "")).toString());
            long lastCommitTimestamp = ((LogFileMeta)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).last()).fileStatus().getModificationTime();
            logSegment = new LogSegment(((DeltaLog)this).logPath(), newVersion, (Seq<FileStatus>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltasAfterCheckpoint)).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.fileStatus(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), (Seq<FileStatus>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newCheckpointFiles)).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.fileStatus(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), (Option<Object>)newCheckpoint.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.version())), lastCommitTimestamp);
        } else {
            if (startCheckpoint.isDefined()) {
                ((DeltaLogging)((Object)this)).recordDeltaEvent((DeltaLog)this, "delta.checkpoint.error.partial", ((DeltaLogging)((Object)this)).recordDeltaEvent$default$3(), ((DeltaLogging)((Object)this)).recordDeltaEvent$default$4());
                throw DeltaErrors$.MODULE$.missingPartFilesException(BoxesRunTime.unboxToLong((Object)startCheckpoint.get()), new FileNotFoundException(new StringBuilder(45).append("Checkpoint file to load version: ").append(startCheckpoint.get()).append(" is missing.").toString()));
            }
            long[] deltaVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.version()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            this.verifyDeltaVersions(deltaVersions);
            if (BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).head()) != 0L) {
                throw DeltaErrors$.MODULE$.logFileNotFoundException(FileNames$.MODULE$.deltaFile(((DeltaLog)this).logPath(), 0L), BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).last()), ((DeltaLog)this).metadata());
            }
            versionToLoad.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).last()) == version, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Did not get the last delta file version: ").append(version).append(" to compute Snapshot").toString()));
            LogFileMeta latestCommit = (LogFileMeta)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).last();
            logSegment = new LogSegment(((DeltaLog)this).logPath(), latestCommit.version(), (Seq<FileStatus>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.fileStatus(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), (Seq<FileStatus>)Nil$.MODULE$, (Option<Object>)None$.MODULE$, latestCommit.fileStatus().getModificationTime());
        }
        return logSegment;
    }

    public static /* synthetic */ Option getLogSegmentForVersion$default$2$(SnapshotManagement $this) {
        return $this.getLogSegmentForVersion$default$2();
    }

    default public Option<Object> getLogSegmentForVersion$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Snapshot getSnapshotAtInit$(SnapshotManagement $this) {
        return $this.getSnapshotAtInit();
    }

    /*
     * WARNING - void declaration
     */
    default public Snapshot getSnapshotAtInit() {
        InitialSnapshot initialSnapshot;
        try {
            void var3_3;
            LogSegment segment = this.getLogSegmentFrom(((Checkpoints)((Object)this)).lastCheckpoint());
            String startCheckpoint = (String)segment.checkpointVersion().map((Function1 & Serializable & scala.Serializable)v -> SnapshotManagement.$anonfun$getSnapshotAtInit$1(BoxesRunTime.unboxToLong((Object)v))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".");
            ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Loading version ").append(segment.version()).append(startCheckpoint).toString());
            Snapshot snapshot = this.createSnapshot(segment, ((DeltaLog)this).minFileRetentionTimestamp(), segment.lastCommitTimestamp());
            this.lastUpdateTimestamp_$eq(((DeltaLog)this).clock().getTimeMillis());
            ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Returning initial snapshot ").append(snapshot).toString());
            initialSnapshot = var3_3;
        }
        catch (FileNotFoundException e) {
            ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> "Creating initial snapshot without metadata, because the directory is empty");
            initialSnapshot = new InitialSnapshot(((DeltaLog)this).logPath(), (DeltaLog)this);
        }
        return initialSnapshot;
    }

    public static /* synthetic */ Snapshot snapshot$(SnapshotManagement $this) {
        return $this.snapshot();
    }

    default public Snapshot snapshot() {
        return this.currentSnapshot();
    }

    public static /* synthetic */ Snapshot createSnapshot$(SnapshotManagement $this, LogSegment segment, long minFileRetentionTimestamp, long timestamp) {
        return $this.createSnapshot(segment, minFileRetentionTimestamp, timestamp);
    }

    default public Snapshot createSnapshot(LogSegment segment, long minFileRetentionTimestamp, long timestamp) {
        Option<VersionChecksum> checksumOpt = ((ReadChecksum)((Object)this)).readChecksum(segment.version());
        return new Snapshot(((DeltaLog)this).logPath(), segment.version(), segment, minFileRetentionTimestamp, (DeltaLog)this, timestamp, checksumOpt);
    }

    private boolean isSnapshotStale() {
        long stalenessLimit = BoxesRunTime.unboxToLong((Object)((DeltaLog)this).spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_ASYNC_UPDATE_STALENESS_TIME_LIMIT()));
        return stalenessLimit == 0L || this.lastUpdateTimestamp() < 0L || ((DeltaLog)this).clock().getTimeMillis() - this.lastUpdateTimestamp() >= stalenessLimit;
    }

    public static /* synthetic */ Snapshot update$(SnapshotManagement $this, boolean stalenessAcceptable) {
        return $this.update(stalenessAcceptable);
    }

    default public Snapshot update(boolean stalenessAcceptable) {
        Snapshot snapshot;
        boolean doAsync;
        boolean bl = doAsync = stalenessAcceptable && !this.isSnapshotStale();
        if (!doAsync) {
            snapshot = (Snapshot)((DeltaLog)this).lockInterruptibly((Function0 & Serializable & scala.Serializable)() -> this.updateInternal(false));
        } else {
            if (((DeltaLog)this).asyncUpdateTask() == null || ((DeltaLog)this).asyncUpdateTask().isCompleted()) {
                String jobGroup = ((DeltaLog)this).spark().sparkContext().getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID());
                ((DeltaLog)this).asyncUpdateTask_$eq((Future<BoxedUnit>)Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    ((DeltaLog)this).spark().sparkContext().setLocalProperty("spark.scheduler.pool", "deltaStateUpdatePool");
                    ((DeltaLog)this).spark().sparkContext().setJobGroup(jobGroup, new StringBuilder(33).append("Updating state of Delta table at ").append(this.currentSnapshot().path()).toString(), true);
                    this.tryUpdate(true);
                }, (ExecutionContext)SnapshotManagement$.MODULE$.deltaLogAsyncUpdateThreadPool()));
            }
            snapshot = this.currentSnapshot();
        }
        return snapshot;
    }

    public static /* synthetic */ boolean update$default$1$(SnapshotManagement $this) {
        return $this.update$default$1();
    }

    default public boolean update$default$1() {
        return false;
    }

    private Snapshot tryUpdate(boolean isAsync) {
        Snapshot snapshot;
        if (((DeltaLog)this).deltaLogLock().tryLock()) {
            try {
                snapshot = this.updateInternal(isAsync);
            }
            finally {
                ((DeltaLog)this).deltaLogLock().unlock();
            }
        } else {
            snapshot = this.currentSnapshot();
        }
        return snapshot;
    }

    private boolean tryUpdate$default$1() {
        return false;
    }

    public static /* synthetic */ Snapshot updateInternal$(SnapshotManagement $this, boolean isAsync) {
        return $this.updateInternal(isAsync);
    }

    default public Snapshot updateInternal(boolean isAsync) {
        Snapshot snapshot;
        Object object = new Object();
        try {
            snapshot = (Snapshot)((DeltaLogging)((Object)this)).recordDeltaOperation((DeltaLog)this, "delta.log.update", (Map<TagDefinition, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TagDefinitions$TAG_ASYNC$.MODULE$), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)isAsync)).toString())}))), (Function0 & Serializable & scala.Serializable)() -> (Snapshot)((DeltaProgressReporter)((Object)this)).withStatusCode("DELTA", "Updating the Delta table's state", ((DeltaProgressReporter)((Object)this)).withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
                try {
                    LogSegment segment;
                    LogSegment logSegment = segment = this.getLogSegmentForVersion(this.currentSnapshot().logSegment().checkpointVersion(), this.getLogSegmentForVersion$default$2());
                    LogSegment logSegment2 = this.currentSnapshot().logSegment();
                    if (!(logSegment != null ? !((Object)logSegment).equals(logSegment2) : logSegment2 != null)) {
                        this.lastUpdateTimestamp_$eq(((DeltaLog)this).clock().getTimeMillis());
                        throw new NonLocalReturnControl(object, (Object)this.currentSnapshot());
                    }
                    String startingFrom = (String)segment.checkpointVersion().map((Function1 & Serializable & scala.Serializable)v -> SnapshotManagement.$anonfun$updateInternal$3(BoxesRunTime.unboxToLong((Object)v))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".");
                    ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Loading version ").append(segment.version()).append(startingFrom).toString());
                    Snapshot newSnapshot = this.createSnapshot(segment, ((DeltaLog)this).minFileRetentionTimestamp(), segment.lastCommitTimestamp());
                    if (this.currentSnapshot().version() > -1L) {
                        String string = this.currentSnapshot().metadata().id();
                        String string2 = newSnapshot.metadata().id();
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            String msg = new StringBuilder(95).append("Change in the table id detected while updating snapshot. ").append("\nPrevious snapshot = ").append(this.currentSnapshot()).append("\nNew snapshot = ").append(newSnapshot).append(".").toString();
                            ((Logging)this).logError((Function0 & Serializable & scala.Serializable)() -> msg);
                            DeltaLog x$1 = (DeltaLog)this;
                            String x$2 = "delta.metadataCheck.update";
                            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prevSnapshotVersion"), (Object)BoxesRunTime.boxToLong((long)this.currentSnapshot().version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prevSnapshotMetadata"), (Object)this.currentSnapshot().metadata()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nextSnapshotVersion"), (Object)BoxesRunTime.boxToLong((long)newSnapshot.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nextSnapshotMetadata"), (Object)newSnapshot.metadata())}));
                            Map<TagDefinition, String> x$4 = ((DeltaLogging)((Object)this)).recordDeltaEvent$default$3();
                            ((DeltaLogging)((Object)this)).recordDeltaEvent(x$1, x$2, x$4, x$3);
                        }
                    }
                    this.currentSnapshot().uncache();
                    this.currentSnapshot_$eq(newSnapshot);
                    ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Updated snapshot to ").append(newSnapshot).toString());
                }
                catch (FileNotFoundException e) {
                    if (Option$.MODULE$.apply((Object)e.getMessage()).exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.contains("reconstruct state at version")))) {
                        throw e;
                    }
                    String message = new StringBuilder(42).append("No delta log found for the Delta table at ").append(((DeltaLog)this).logPath()).toString();
                    ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> message);
                    this.currentSnapshot().uncache();
                    this.currentSnapshot_$eq(new InitialSnapshot(((DeltaLog)this).logPath(), (DeltaLog)this));
                }
                this.lastUpdateTimestamp_$eq(((DeltaLog)this).clock().getTimeMillis());
                return this.currentSnapshot();
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                snapshot = (Snapshot)ex.value();
            }
            throw ex;
        }
        return snapshot;
    }

    public static /* synthetic */ Snapshot getSnapshotAt$(SnapshotManagement $this, long version, Option commitTimestamp, Option lastCheckpointHint) {
        return $this.getSnapshotAt(version, (Option<Object>)commitTimestamp, (Option<CheckpointInstance>)lastCheckpointHint);
    }

    default public Snapshot getSnapshotAt(long version, Option<Object> commitTimestamp, Option<CheckpointInstance> lastCheckpointHint) {
        Snapshot current = this.snapshot();
        if (current.version() == version) {
            return current;
        }
        Option startingCheckpoint = lastCheckpointHint.collect((PartialFunction)new scala.Serializable((DeltaLog)this, version){
            public static final long serialVersionUID = 0L;
            private final long version$3;

            public final <A1 extends CheckpointInstance, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.version() <= this.version$3 ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CheckpointInstance x1) {
                CheckpointInstance checkpointInstance = x1;
                boolean bl = checkpointInstance.version() <= this.version$3;
                return bl;
            }
            {
                this.version$3 = version$3;
            }
        }).orElse((Function0 & Serializable & scala.Serializable)() -> ((Checkpoints)((Object)this)).findLastCompleteCheckpoint(new CheckpointInstance(version, (Option<Object>)None$.MODULE$)));
        LogSegment segment = this.getLogSegmentForVersion((Option<Object>)startingCheckpoint.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.version())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)version)));
        return this.createSnapshot(segment, ((DeltaLog)this).minFileRetentionTimestamp(), segment.lastCommitTimestamp());
    }

    public static /* synthetic */ Option getSnapshotAt$default$2$(SnapshotManagement $this) {
        return $this.getSnapshotAt$default$2();
    }

    default public Option<Object> getSnapshotAt$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option getSnapshotAt$default$3$(SnapshotManagement $this) {
        return $this.getSnapshotAt$default$3();
    }

    default public Option<CheckpointInstance> getSnapshotAt$default$3() {
        return None$.MODULE$;
    }

    public static /* synthetic */ void verifyDeltaVersions$(SnapshotManagement $this, long[] versions) {
        $this.verifyDeltaVersions(versions);
    }

    default public void verifyDeltaVersions(long[] versions) {
        Vector deltaVersions = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).toVector();
        if (deltaVersions.nonEmpty()) {
            NumericRange.Inclusive inclusive = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)deltaVersions.head()))).to(deltaVersions.last());
            Vector vector = deltaVersions;
            if (inclusive == null ? vector != null : !inclusive.equals(vector)) {
                throw DeltaErrors$.MODULE$.deltaVersionsNotContiguousException(((DeltaLog)this).spark(), (Seq<Object>)deltaVersions);
            }
        }
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$2(LogFileMeta file) {
        return LogFileMeta$.MODULE$.isCheckpointFile(file) || LogFileMeta$.MODULE$.isDeltaFile(file);
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$3(LogFileMeta file) {
        return LogFileMeta$.MODULE$.isCheckpointFile(file) && file.fileStatus().getLen() == 0L;
    }

    public static /* synthetic */ CheckpointInstance $anonfun$getLogSegmentForVersion$7(long x$3) {
        return new CheckpointInstance(x$3, (Option<Object>)None$.MODULE$);
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$11(long newCheckpointVersion$1, LogFileMeta file) {
        return file.version() > newCheckpointVersion$1;
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$17(long newCheckpointVersion$1, int newCheckpointCount$1, LogFileMeta f) {
        return f.version() == newCheckpointVersion$1 && BoxesRunTime.unboxToInt((Object)f.numParts().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1)) == newCheckpointCount$1;
    }

    public static /* synthetic */ String $anonfun$getSnapshotAtInit$1(long v) {
        return new StringBuilder(27).append(" starting from checkpoint ").append(v).append(".").toString();
    }

    public static /* synthetic */ String $anonfun$updateInternal$3(long v) {
        return new StringBuilder(35).append(" starting from checkpoint version ").append(v).append(".").toString();
    }

    public static void $init$(SnapshotManagement $this) {
        $this.lastUpdateTimestamp_$eq(-1L);
        $this.currentSnapshot_$eq($this.getSnapshotAtInit());
    }
}

