/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u000b\u0017\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006]\u0001!\ta\f\u0005\bg\u0001\u0001\r\u0011\"\u00015\u0011\u001dA\u0004\u00011A\u0005\u0002eBaa\u0010\u0001!B\u0013)\u0004b\u0002!\u0001\u0001\u0004%\t!\u0011\u0005\b\u0005\u0002\u0001\r\u0011\"\u0001D\u0011\u0019)\u0005\u0001)Q\u0005W!9a\t\u0001a\u0001\n\u00039\u0005bB&\u0001\u0001\u0004%\t\u0001\u0014\u0005\u0007\u001d\u0002\u0001\u000b\u0015\u0002%\t\u000f=\u0003!\u0019!C\u0001!\"1q\r\u0001Q\u0001\nECq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004w\u0001\u0001\u0006IA\u001b\u0005\bo\u0002\u0011\r\u0011\"\u0003y\u0011\u0019i\b\u0001)A\u0005s\")a\u0010\u0001C\u0001\u007f\"9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0002bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0002\u0012\u0013:lU-\\8ss2{wMU3qY\u0006L(BA\f\u0019\u0003\u001d\t7\r^5p]NT!!\u0007\u000e\u0002\u000b\u0011,G\u000e^1\u000b\u0005ma\u0012aA:rY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-A\rnS:4\u0015\u000e\\3SKR,g\u000e^5p]RKW.Z:uC6\u0004\bCA\u0013-\u0013\ticE\u0001\u0003M_:<\u0017A\u0002\u001fj]&$h\b\u0006\u00021eA\u0011\u0011\u0007A\u0007\u0002-!)!F\u0001a\u0001W\u000512-\u001e:sK:$\bK]8u_\u000e|GNV3sg&|g.F\u00016!\t\td'\u0003\u00028-\tA\u0001K]8u_\u000e|G.\u0001\u000edkJ\u0014XM\u001c;Qe>$xnY8m-\u0016\u00148/[8o?\u0012*\u0017\u000f\u0006\u0002;{A\u0011QeO\u0005\u0003y\u0019\u0012A!\u00168ji\"9a\bBA\u0001\u0002\u0004)\u0014a\u0001=%c\u000592-\u001e:sK:$\bK]8u_\u000e|GNV3sg&|g\u000eI\u0001\u000fGV\u0014(/\u001a8u-\u0016\u00148/[8o+\u0005Y\u0013AE2veJ,g\u000e\u001e,feNLwN\\0%KF$\"A\u000f#\t\u000fy:\u0011\u0011!a\u0001W\u0005y1-\u001e:sK:$h+\u001a:tS>t\u0007%A\bdkJ\u0014XM\u001c;NKR\fG)\u0019;b+\u0005A\u0005CA\u0019J\u0013\tQeC\u0001\u0005NKR\fG-\u0019;b\u0003M\u0019WO\u001d:f]RlU\r^1ECR\fw\fJ3r)\tQT\nC\u0004?\u0015\u0005\u0005\t\u0019\u0001%\u0002!\r,(O]3oi6+G/\u0019#bi\u0006\u0004\u0013\u0001\u0004;sC:\u001c\u0018m\u0019;j_:\u001cX#A)\u0011\tI;\u0016\fZ\u0007\u0002'*\u0011A+V\u0001\b[V$\u0018M\u00197f\u0015\t1f%\u0001\u0006d_2dWm\u0019;j_:L!\u0001W*\u0003\u000f!\u000b7\u000f['baB\u0011!,\u0019\b\u00037~\u0003\"\u0001\u0018\u0014\u000e\u0003uS!A\u0018\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\u0001g%\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u00011'!\t\tT-\u0003\u0002g-\tq1+\u001a;Ue\u0006t7/Y2uS>t\u0017!\u0004;sC:\u001c\u0018m\u0019;j_:\u001c\b%A\u0006bGRLg/\u001a$jY\u0016\u001cX#\u00016\u0011\tI;6n\u001d\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f1A\\3u\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\u0007U\u0013\u0016\n\u0005\u00022i&\u0011QO\u0006\u0002\b\u0003\u0012$g)\u001b7f\u00031\t7\r^5wK\u001aKG.Z:!\u0003)!x.\u001c2ti>tWm]\u000b\u0002sB!!kV6{!\t\t40\u0003\u0002}-\tQ!+Z7pm\u00164\u0015\u000e\\3\u0002\u0017Q|WNY:u_:,7\u000fI\u0001\u0007CB\u0004XM\u001c3\u0015\u000bi\n\t!!\u0002\t\r\u0005\r!\u00031\u0001,\u0003\u001d1XM]:j_:Daa\u0006\nA\u0002\u0005\u001d\u0001CBA\u0005\u0003'\tIB\u0004\u0003\u0002\f\u0005=ab\u0001/\u0002\u000e%\tq%C\u0002\u0002\u0012\u0019\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005Ea\u0005E\u00022\u00037I1!!\b\u0017\u0005\u0019\t5\r^5p]\u0006iq-\u001a;U_6\u00147\u000f^8oKN,\"!a\t\u0011\r\u0005%\u0011QEA\u0015\u0013\u0011\t9#a\u0006\u0003\u0011%#XM]1cY\u0016\u00042!MA\u0016\u0013\r\tiC\u0006\u0002\u000b\r&dW-Q2uS>t\u0017AC2iK\u000e\\\u0007o\\5oiV\u0011\u0011q\u0001")
public class InMemoryLogReplay {
    private final long minFileRetentionTimestamp;
    private Protocol currentProtocolVersion;
    private long currentVersion;
    private Metadata currentMetaData;
    private final HashMap<String, SetTransaction> transactions;
    private final HashMap<URI, AddFile> activeFiles;
    private final HashMap<URI, RemoveFile> tombstones;

    public Protocol currentProtocolVersion() {
        return this.currentProtocolVersion;
    }

    public void currentProtocolVersion_$eq(Protocol x$1) {
        this.currentProtocolVersion = x$1;
    }

    public long currentVersion() {
        return this.currentVersion;
    }

    public void currentVersion_$eq(long x$1) {
        this.currentVersion = x$1;
    }

    public Metadata currentMetaData() {
        return this.currentMetaData;
    }

    public void currentMetaData_$eq(Metadata x$1) {
        this.currentMetaData = x$1;
    }

    public HashMap<String, SetTransaction> transactions() {
        return this.transactions;
    }

    public HashMap<URI, AddFile> activeFiles() {
        return this.activeFiles;
    }

    private HashMap<URI, RemoveFile> tombstones() {
        return this.tombstones;
    }

    public void append(long version, Iterator<Action> actions) {
        Predef$.MODULE$.assert(this.currentVersion() == -1L || version == this.currentVersion() + 1L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Attempted to replay version ").append(version).append(", but state is at ").append(this.currentVersion()).toString());
        this.currentVersion_$eq(version);
        actions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Action action = x0$1;
            if (action instanceof SetTransaction) {
                SetTransaction setTransaction = (SetTransaction)action;
                this.transactions().update((Object)setTransaction.appId(), (Object)setTransaction);
                boxedUnit = BoxedUnit.UNIT;
            } else if (action instanceof Metadata) {
                Metadata metadata = (Metadata)action;
                this.currentMetaData_$eq(metadata);
                boxedUnit = BoxedUnit.UNIT;
            } else if (action instanceof Protocol) {
                Protocol protocol = (Protocol)action;
                this.currentProtocolVersion_$eq(protocol);
                boxedUnit = BoxedUnit.UNIT;
            } else if (action instanceof AddFile) {
                AddFile addFile = (AddFile)action;
                boolean x$1 = false;
                String x$2 = addFile.copy$default$1();
                Map<String, String> x$3 = addFile.copy$default$2();
                long x$4 = addFile.copy$default$3();
                long x$5 = addFile.copy$default$4();
                String x$6 = addFile.copy$default$6();
                Map<String, String> x$7 = addFile.copy$default$7();
                this.activeFiles().update((Object)addFile.pathAsUri(), (Object)addFile.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7));
                boxedUnit = this.tombstones().remove((Object)addFile.pathAsUri());
            } else if (action instanceof RemoveFile) {
                RemoveFile removeFile = (RemoveFile)action;
                this.activeFiles().remove((Object)removeFile.pathAsUri());
                boolean x$8 = false;
                String x$9 = removeFile.copy$default$1();
                Option<Object> x$10 = removeFile.copy$default$2();
                this.tombstones().update((Object)removeFile.pathAsUri(), (Object)removeFile.copy(x$9, x$10, x$8));
                boxedUnit = BoxedUnit.UNIT;
            } else if (action instanceof CommitInfo) {
                boxedUnit = BoxedUnit.UNIT;
            } else if (action == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)action);
            }
            return boxedUnit;
        });
    }

    private Iterable<FileAction> getTombstones() {
        return (Iterable)this.tombstones().values().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InMemoryLogReplay.$anonfun$getTombstones$1(this, x$1)));
    }

    public Iterator<Action> checkpoint() {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.currentProtocolVersion())).toIterator().$plus$plus((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.currentMetaData())).toIterator()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> this.transactions().values().toIterator()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> ((IterableLike)((TraversableOnce)this.activeFiles().values().$plus$plus(this.getTombstones(), Iterable$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.path(), (Ordering)Ordering.String$.MODULE$)).iterator());
    }

    public static final /* synthetic */ boolean $anonfun$getTombstones$1(InMemoryLogReplay $this, RemoveFile x$1) {
        return x$1.delTimestamp() > $this.minFileRetentionTimestamp;
    }

    public InMemoryLogReplay(long minFileRetentionTimestamp) {
        this.minFileRetentionTimestamp = minFileRetentionTimestamp;
        this.currentProtocolVersion = null;
        this.currentVersion = -1L;
        this.currentMetaData = null;
        this.transactions = new HashMap();
        this.activeFiles = new HashMap();
        this.tombstones = new HashMap();
    }
}

