/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.AlterDeltaTableCommand;
import org.apache.spark.sql.delta.commands.AlterTableSetLocationDeltaCommand$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001\u0002\r\u001a\u0001\u001aB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t#\u0002\u0011\t\u0012)A\u0005\u0017\"A!\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005`\u0001\tE\t\u0015!\u0003U\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015I\b\u0001\"\u0003{\u0011%\t\t\u0002AA\u0001\n\u0003\t\u0019\u0002C\u0005\u0002\u001a\u0001\t\n\u0011\"\u0001\u0002\u001c!I\u0011\u0011\u0007\u0001\u0012\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003o\u0001\u0011\u0011!C!\u0003sA\u0011\"!\u0013\u0001\u0003\u0003%\t!a\u0013\t\u0013\u0005M\u0003!!A\u0005\u0002\u0005U\u0003\"CA1\u0001\u0005\u0005I\u0011IA2\u0011%\t\t\bAA\u0001\n\u0003\t\u0019\bC\u0005\u0002x\u0001\t\t\u0011\"\u0011\u0002z\u001dI\u0011QP\r\u0002\u0002#\u0005\u0011q\u0010\u0004\t1e\t\t\u0011#\u0001\u0002\u0002\"1\u0001M\u0005C\u0001\u0003\u001fC\u0011\"!%\u0013\u0003\u0003%)%a%\t\u0013\u0005U%#!A\u0005\u0002\u0006]\u0005\"CAO%\u0005\u0005I\u0011QAP\u0011%\t\tLEA\u0001\n\u0013\t\u0019LA\u0011BYR,'\u000fV1cY\u0016\u001cV\r\u001e'pG\u0006$\u0018n\u001c8EK2$\u0018mQ8n[\u0006tGM\u0003\u0002\u001b7\u0005A1m\\7nC:$7O\u0003\u0002\u001d;\u0005)A-\u001a7uC*\u0011adH\u0001\u0004gFd'B\u0001\u0011\"\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0004\u0001M9\u0001aJ\u0019:{\u00013\u0005C\u0001\u00150\u001b\u0005I#B\u0001\u0016,\u0003\u001dawnZ5dC2T!\u0001L\u0017\u0002\u000bAd\u0017M\\:\u000b\u00059j\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005AJ#a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\u000f\r|W.\\1oI*\u0011a'H\u0001\nKb,7-\u001e;j_:L!\u0001O\u001a\u0003\u001fI+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"AO\u001e\u000e\u0003eI!\u0001P\r\u0003-\u0005cG/\u001a:EK2$\u0018\rV1cY\u0016\u001cu.\\7b]\u0012\u0004\"\u0001\u000b \n\u0005}J#\u0001E%h]>\u0014XmQ1dQ\u0016$G)\u0019;b!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u001d\u0001&o\u001c3vGR\u0004\"!Q$\n\u0005!\u0013%\u0001D*fe&\fG.\u001b>bE2,\u0017!\u0002;bE2,W#A&\u0011\u00051{U\"A'\u000b\u00059[\u0012aB2bi\u0006dwnZ\u0005\u0003!6\u0013A\u0002R3mi\u0006$\u0016M\u00197f-J\na\u0001^1cY\u0016\u0004\u0013\u0001\u00037pG\u0006$\u0018n\u001c8\u0016\u0003Q\u0003\"!\u0016/\u000f\u0005YS\u0006CA,C\u001b\u0005A&BA-&\u0003\u0019a$o\\8u}%\u00111LQ\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\\u0005\u0006IAn\\2bi&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t\u001cG\r\u0005\u0002;\u0001!)\u0011*\u0002a\u0001\u0017\")!+\u0002a\u0001)\u0006\u0019!/\u001e8\u0015\u0005\u001d$\bc\u00015na:\u0011\u0011n\u001b\b\u0003/*L\u0011aQ\u0005\u0003Y\n\u000bq\u0001]1dW\u0006<W-\u0003\u0002o_\n\u00191+Z9\u000b\u00051\u0014\u0005CA9s\u001b\u0005i\u0012BA:\u001e\u0005\r\u0011vn\u001e\u0005\u0006k\u001a\u0001\rA^\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003c^L!\u0001_\u000f\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0019M\u001c\u0007.Z7bg\u0016\u000bX/\u00197\u0015\tmt\u0018Q\u0002\t\u0003\u0003rL!! \"\u0003\u000f\t{w\u000e\\3b]\"1qp\u0002a\u0001\u0003\u0003\t1b\u001c7e\u001b\u0016$\u0018\rZ1uCB!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\bm\tq!Y2uS>t7/\u0003\u0003\u0002\f\u0005\u0015!\u0001C'fi\u0006$\u0017\r^1\t\u000f\u0005=q\u00011\u0001\u0002\u0002\u0005Ya.Z<NKR\fG-\u0019;b\u0003\u0011\u0019w\u000e]=\u0015\u000b\t\f)\"a\u0006\t\u000f%C\u0001\u0013!a\u0001\u0017\"9!\u000b\u0003I\u0001\u0002\u0004!\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003;Q3aSA\u0010W\t\t\t\u0003\u0005\u0003\u0002$\u00055RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0016\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0012Q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003kQ3\u0001VA\u0010\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\b\t\u0005\u0003{\t9%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0013\u0001\u00026bm\u0006L1!XA \u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0005E\u0002B\u0003\u001fJ1!!\u0015C\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9&!\u0018\u0011\u0007\u0005\u000bI&C\u0002\u0002\\\t\u00131!\u00118z\u0011%\ty&DA\u0001\u0002\u0004\ti%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003K\u0002b!a\u001a\u0002n\u0005]SBAA5\u0015\r\tYGQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA8\u0003S\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u001910!\u001e\t\u0013\u0005}s\"!AA\u0002\u0005]\u0013AB3rk\u0006d7\u000fF\u0002|\u0003wB\u0011\"a\u0018\u0011\u0003\u0003\u0005\r!a\u0016\u0002C\u0005cG/\u001a:UC\ndWmU3u\u0019>\u001c\u0017\r^5p]\u0012+G\u000e^1D_6l\u0017M\u001c3\u0011\u0005i\u00122\u0003\u0002\n\u0002\u0004\u001a\u0003r!!\"\u0002\f.#&-\u0004\u0002\u0002\b*\u0019\u0011\u0011\u0012\"\u0002\u000fI,h\u000e^5nK&!\u0011QRAD\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u007f\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003w\tQ!\u00199qYf$RAYAM\u00037CQ!S\u000bA\u0002-CQAU\u000bA\u0002Q\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\"\u00065\u0006#B!\u0002$\u0006\u001d\u0016bAAS\u0005\n1q\n\u001d;j_:\u0004R!QAU\u0017RK1!a+C\u0005\u0019!V\u000f\u001d7fe!A\u0011q\u0016\f\u0002\u0002\u0003\u0007!-A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0017\t\u0005\u0003{\t9,\u0003\u0003\u0002:\u0006}\"AB(cU\u0016\u001cG\u000f")
public class AlterTableSetLocationDeltaCommand
extends LogicalPlan
implements RunnableCommand,
AlterDeltaTableCommand,
IgnoreCachedData,
Serializable {
    private final DeltaTableV2 table;
    private final String location;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<DeltaTableV2, String>> unapply(AlterTableSetLocationDeltaCommand alterTableSetLocationDeltaCommand) {
        return AlterTableSetLocationDeltaCommand$.MODULE$.unapply(alterTableSetLocationDeltaCommand);
    }

    public static Function1<Tuple2<DeltaTableV2, String>, AlterTableSetLocationDeltaCommand> tupled() {
        return AlterTableSetLocationDeltaCommand$.MODULE$.tupled();
    }

    public static Function1<DeltaTableV2, Function1<String, AlterTableSetLocationDeltaCommand>> curried() {
        return AlterTableSetLocationDeltaCommand$.MODULE$.curried();
    }

    @Override
    public OptimisticTransaction startTransaction() {
        return AlterDeltaTableCommand.startTransaction$(this);
    }

    @Override
    public Seq<Expression> parsePartitionPredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePartitionPredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public void updateAndCheckpoint(SparkSession spark, DeltaLog deltaLog, int commitSize, long attemptVersion) {
        DeltaCommand.updateAndCheckpoint$(this, spark, deltaLog, commitSize, attemptVersion);
    }

    @Override
    public long commitLarge(SparkSession spark, OptimisticTransaction txn, Iterator<Action> actions, DeltaOperations.Operation op, Map<String, String> context, Map<String, String> metrics) {
        return DeltaCommand.commitLarge$(this, spark, txn, actions, op, context, metrics);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableSetLocationDeltaCommand alterTableSetLocationDeltaCommand = this;
        synchronized (alterTableSetLocationDeltaCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    @Override
    public DeltaTableV2 table() {
        return this.table;
    }

    public String location() {
        return this.location;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        boolean x$1;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        TableIdentifier identifier = sparkSession.sessionState().sqlParser().parseTableIdentifier((String)this.table().tableIdentifier().get());
        CatalogTable catalogTable = catalog.getTableMetadata(identifier);
        URI locUri = CatalogUtils$.MODULE$.stringToURI(this.location());
        Snapshot oldTable = this.table().deltaLog().update(this.table().deltaLog().update$default$1());
        if (oldTable.version() == -1L) {
            throw DeltaErrors$.MODULE$.notADeltaTableException(this.table().name());
        }
        Metadata oldMetadata = oldTable.metadata();
        DeltaLog qual$1 = DeltaLog$.MODULE$.forTable(sparkSession, this.location());
        Snapshot newTable = qual$1.update(x$1 = qual$1.update$default$1());
        if (newTable.version() == -1L) {
            throw DeltaErrors$.MODULE$.notADeltaTableException(new DeltaTableIdentifier((Option<String>)new Some((Object)this.location()), DeltaTableIdentifier$.MODULE$.apply$default$2()));
        }
        Metadata newMetadata = newTable.metadata();
        boolean bypassSchemaCheck = BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_ALTER_LOCATION_BYPASS_SCHEMA_CHECK()));
        if (!bypassSchemaCheck && !this.schemasEqual(oldMetadata, newMetadata)) {
            throw DeltaErrors$.MODULE$.alterTableSetLocationSchemaMismatchException(oldMetadata.schema(), newMetadata.schema());
        }
        catalog.alterTable(catalogTable.withNewStorage((Option)new Some((Object)locUri), catalogTable.withNewStorage$default$2(), catalogTable.withNewStorage$default$3(), catalogTable.withNewStorage$default$4(), catalogTable.withNewStorage$default$5(), catalogTable.withNewStorage$default$6()));
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean schemasEqual(Metadata oldMetadata, Metadata newMetadata) {
        StructType structType = oldMetadata.schema();
        StructType structType2 = newMetadata.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        StructType structType3 = oldMetadata.partitionSchema();
        StructType structType4 = newMetadata.partitionSchema();
        if (structType3 == null) {
            if (structType4 == null) return true;
            return false;
        } else {
            if (!structType3.equals(structType4)) return false;
            return true;
        }
    }

    public AlterTableSetLocationDeltaCommand copy(DeltaTableV2 table, String location) {
        return new AlterTableSetLocationDeltaCommand(table, location);
    }

    public DeltaTableV2 copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.location();
    }

    public String productPrefix() {
        return "AlterTableSetLocationDeltaCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.location();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableSetLocationDeltaCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableSetLocationDeltaCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableSetLocationDeltaCommand alterTableSetLocationDeltaCommand = (AlterTableSetLocationDeltaCommand)x$1;
        DeltaTableV2 deltaTableV2 = this.table();
        DeltaTableV2 deltaTableV22 = alterTableSetLocationDeltaCommand.table();
        if (deltaTableV2 == null) {
            if (deltaTableV22 != null) {
                return false;
            }
        } else if (!((Object)deltaTableV2).equals(deltaTableV22)) return false;
        String string = this.location();
        String string2 = alterTableSetLocationDeltaCommand.location();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!alterTableSetLocationDeltaCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableSetLocationDeltaCommand(DeltaTableV2 table, String location) {
        this.table = table;
        this.location = location;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        AlterDeltaTableCommand.$init$(this);
    }
}

