/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.UpdateCommand$;
import org.apache.spark.sql.delta.commands.UpdateMetric;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tue\u0001\u0002\u0013&\u0001JB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t5\u0002\u0011\t\u0012)A\u0005)\"A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005^\u0001\tE\t\u0015!\u00034\u0011!q\u0006A!f\u0001\n\u0003y\u0006\u0002\u0003:\u0001\u0005#\u0005\u000b\u0011\u00021\t\u0011M\u0004!Q3A\u0005\u0002QD\u0001\u0002\u001f\u0001\u0003\u0012\u0003\u0006I!\u001e\u0005\u0006s\u0002!\tA\u001f\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011)\t9\u0003\u0001EC\u0002\u0013%\u0011\u0011\u0006\u0005\u000b\u0003w\u0001\u0001R1A\u0005B\u0005u\u0002bBA6\u0001\u0011\u0015\u0013Q\u000e\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\t)\u000b\u0001C\u0005\u0003OCq!a8\u0001\t\u0013\t\t\u000fC\u0005\u0002n\u0002\t\t\u0011\"\u0001\u0002p\"I\u0011\u0011 \u0001\u0012\u0002\u0013\u0005\u00111 \u0005\n\u0005#\u0001\u0011\u0013!C\u0001\u0005'A\u0011Ba\u0006\u0001#\u0003%\tA!\u0007\t\u0013\tu\u0001!%A\u0005\u0002\t}\u0001\"\u0003B\u0012\u0001\u0005\u0005I\u0011\tB\u0013\u0011%\u0011)\u0004AA\u0001\n\u0003\u00119\u0004C\u0005\u0003@\u0001\t\t\u0011\"\u0001\u0003B!I!q\t\u0001\u0002\u0002\u0013\u0005#\u0011\n\u0005\n\u0005'\u0002\u0011\u0011!C\u0001\u0005+B\u0011Ba\u0018\u0001\u0003\u0003%\tE!\u0019\b\u000f\t\u0015T\u0005#\u0001\u0003h\u00191A%\nE\u0001\u0005SBa!_\u000f\u0005\u0002\tE\u0004\"\u0003B:;\t\u0007I\u0011\u0001B\u0013\u0011!\u0011)(\bQ\u0001\n\t\u001d\u0002\"\u0003B<;\u0005\u0005I\u0011\u0011B=\u0011%\u0011\u0019)HA\u0001\n\u0003\u0013)\tC\u0005\u0003\u0014v\t\t\u0011\"\u0003\u0003\u0016\niQ\u000b\u001d3bi\u0016\u001cu.\\7b]\u0012T!AJ\u0014\u0002\u0011\r|W.\\1oINT!\u0001K\u0015\u0002\u000b\u0011,G\u000e^1\u000b\u0005)Z\u0013aA:rY*\u0011A&L\u0001\u0006gB\f'o\u001b\u0006\u0003]=\na!\u00199bG\",'\"\u0001\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0019T(R%P!\t!4(D\u00016\u0015\t1t'A\u0004m_\u001eL7-\u00197\u000b\u0005aJ\u0014!\u00029mC:\u001c(B\u0001\u001e*\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001f6\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015aB2p[6\fg\u000e\u001a\u0006\u0003\u0005&\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005\u0011{$a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005\u0019;U\"A\u0013\n\u0005!+#\u0001\u0004#fYR\f7i\\7nC:$\u0007C\u0001&N\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0015BK!!U&\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u001dQ\f\u0007n\\3GS2,\u0017J\u001c3fqV\tA\u000b\u0005\u0002V16\taK\u0003\u0002XO\u0005)a-\u001b7fg&\u0011\u0011L\u0016\u0002\u000f)\u0006Dw.\u001a$jY\u0016Le\u000eZ3y\u0003=!\u0018\r[8f\r&dW-\u00138eKb\u0004\u0013A\u0002;be\u001e,G/F\u00014\u0003\u001d!\u0018M]4fi\u0002\n\u0011#\u001e9eCR,W\t\u001f9sKN\u001c\u0018n\u001c8t+\u0005\u0001\u0007cA1jY:\u0011!m\u001a\b\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KF\na\u0001\u0010:p_Rt\u0014\"\u0001'\n\u0005!\\\u0015a\u00029bG.\fw-Z\u0005\u0003U.\u00141aU3r\u0015\tA7\n\u0005\u0002na6\taN\u0003\u0002ps\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t\thN\u0001\u0006FqB\u0014Xm]:j_:\f!#\u001e9eCR,W\t\u001f9sKN\u001c\u0018n\u001c8tA\u0005I1m\u001c8eSRLwN\\\u000b\u0002kB\u0019!J\u001e7\n\u0005]\\%AB(qi&|g.\u0001\u0006d_:$\u0017\u000e^5p]\u0002\na\u0001P5oSRtD#B>}{z|\bC\u0001$\u0001\u0011\u0015\u0011\u0016\u00021\u0001U\u0011\u0015Y\u0016\u00021\u00014\u0011\u0015q\u0016\u00021\u0001a\u0011\u0015\u0019\u0018\u00021\u0001v\u00035IgN\\3s\u0007\"LG\u000e\u001a:f]V\u0011\u0011Q\u0001\t\u0005C&\f9\u0001\r\u0003\u0002\n\u0005U\u0001CBA\u0006\u0003\u001b\t\t\"D\u00018\u0013\r\tya\u000e\u0002\n#V,'/\u001f)mC:\u0004B!a\u0005\u0002\u00161\u0001AaCA\f\u0015\u0005\u0005\t\u0011!B\u0001\u00033\u00111a\u0018\u00132#\u0011\tY\"!\t\u0011\u0007)\u000bi\"C\u0002\u0002 -\u0013qAT8uQ&tw\rE\u0002K\u0003GI1!!\nL\u0005\r\te._\u0001\u0003g\u000e,\"!a\u000b\u0011\t\u00055\u0012qF\u0007\u0002W%\u0019\u0011\u0011G\u0016\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;)\u0007-\t)\u0004E\u0002K\u0003oI1!!\u000fL\u0005%!(/\u00198tS\u0016tG/A\u0004nKR\u0014\u0018nY:\u0016\u0005\u0005}\u0002\u0003CA!\u0003\u0017\ny%a\u0018\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005%3*\u0001\u0006d_2dWm\u0019;j_:LA!!\u0014\u0002D\t\u0019Q*\u00199\u0011\t\u0005E\u0013\u0011\f\b\u0005\u0003'\n)\u0006\u0005\u0002d\u0017&\u0019\u0011qK&\u0002\rA\u0013X\rZ3g\u0013\u0011\tY&!\u0018\u0003\rM#(/\u001b8h\u0015\r\t9f\u0013\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011QM!\u0002\r5,GO]5d\u0013\u0011\tI'a\u0019\u0003\u0013M\u000bF*T3ue&\u001c\u0017a\u0001:v]R!\u0011qNA=!\u0011\t\u0017.!\u001d\u0011\t\u0005M\u0014QO\u0007\u0002S%\u0019\u0011qO\u0015\u0003\u0007I{w\u000fC\u0004\u0002|5\u0001\r!! \u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u0005M\u0014qP\u0005\u0004\u0003\u0003K#\u0001D*qCJ\\7+Z:tS>t\u0017!\u00049fe\u001a|'/\\+qI\u0006$X\r\u0006\u0005\u0002\b\u00065\u0015qRAN!\rQ\u0015\u0011R\u0005\u0004\u0003\u0017[%\u0001B+oSRDq!a\u001f\u000f\u0001\u0004\ti\bC\u0004\u0002\u0012:\u0001\r!a%\u0002\u0011\u0011,G\u000e^1M_\u001e\u0004B!!&\u0002\u00186\tq%C\u0002\u0002\u001a\u001e\u0012\u0001\u0002R3mi\u0006dun\u001a\u0005\b\u0003;s\u0001\u0019AAP\u0003\r!\bP\u001c\t\u0005\u0003+\u000b\t+C\u0002\u0002$\u001e\u0012Qc\u00149uS6L7\u000f^5d)J\fgn]1di&|g.\u0001\u0007sK^\u0014\u0018\u000e^3GS2,7\u000f\u0006\b\u0002*\u0006]\u0016\u0011XA^\u0003\u001f\f).!8\u0011\t\u0005L\u00171\u0016\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011W\u0014\u0002\u000f\u0005\u001cG/[8og&!\u0011QWAX\u0005\u001d\tE\r\u001a$jY\u0016Da\u0001L\bA\u0002\u0005u\u0004bBAO\u001f\u0001\u0007\u0011q\u0014\u0005\b\u0003{{\u0001\u0019AA`\u0003!\u0011xn\u001c;QCRD\u0007\u0003BAa\u0003\u0017l!!a1\u000b\t\u0005\u0015\u0017qY\u0001\u0003MNT1!!3.\u0003\u0019A\u0017\rZ8pa&!\u0011QZAb\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005Ew\u00021\u0001\u0002T\u0006q\u0011N\u001c9vi2+\u0017M\u001a$jY\u0016\u001c\b\u0003B1j\u0003\u001fBq!a6\u0010\u0001\u0004\tI.\u0001\toC6,Gk\\!eI\u001aKG.Z'baBA\u0011\u0011KAn\u0003\u001f\nY+\u0003\u0003\u0002N\u0005u\u0003\"B:\u0010\u0001\u0004a\u0017a\u00052vS2$W\u000b\u001d3bi\u0016$7i\u001c7v[:\u001cH\u0003BAr\u0003W\u0004B!Y5\u0002fB!\u00111OAt\u0013\r\tI/\u000b\u0002\u0007\u0007>dW/\u001c8\t\u000bM\u0004\u0002\u0019\u00017\u0002\t\r|\u0007/\u001f\u000b\nw\u0006E\u00181_A{\u0003oDqAU\t\u0011\u0002\u0003\u0007A\u000bC\u0004\\#A\u0005\t\u0019A\u001a\t\u000fy\u000b\u0002\u0013!a\u0001A\"91/\u0005I\u0001\u0002\u0004)\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003{T3\u0001VA\u0000W\t\u0011\t\u0001\u0005\u0003\u0003\u0004\t5QB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0006\u0017\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=!Q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005+Q3aMA\u0000\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa\u0007+\u0007\u0001\fy0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0005\"fA;\u0002\u0000\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\n\u0011\t\t%\"1G\u0007\u0003\u0005WQAA!\f\u00030\u0005!A.\u00198h\u0015\t\u0011\t$\u0001\u0003kCZ\f\u0017\u0002BA.\u0005W\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u000f\u0011\u0007)\u0013Y$C\u0002\u0003>-\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\t\u0003D!I!Q\t\r\u0002\u0002\u0003\u0007!\u0011H\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t-\u0003C\u0002B'\u0005\u001f\n\t#\u0004\u0002\u0002H%!!\u0011KA$\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t]#Q\f\t\u0004\u0015\ne\u0013b\u0001B.\u0017\n9!i\\8mK\u0006t\u0007\"\u0003B#5\u0005\u0005\t\u0019AA\u0011\u0003\u0019)\u0017/^1mgR!!q\u000bB2\u0011%\u0011)eGA\u0001\u0002\u0004\t\t#A\u0007Va\u0012\fG/Z\"p[6\fg\u000e\u001a\t\u0003\rv\u0019B!\bB6\u001fB\u0019!J!\u001c\n\u0007\t=4J\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005O\n\u0001CR%M\u000b~s\u0015)T#`\u0007>cU+\u0014(\u0002#\u0019KE*R0O\u00036+ulQ(M+6s\u0005%A\u0003baBd\u0017\u0010F\u0005|\u0005w\u0012iHa \u0003\u0002\")!+\ta\u0001)\")1,\ta\u0001g!)a,\ta\u0001A\")1/\ta\u0001k\u00069QO\\1qa2LH\u0003\u0002BD\u0005\u001f\u0003BA\u0013<\u0003\nB9!Ja#Ug\u0001,\u0018b\u0001BG\u0017\n1A+\u001e9mKRB\u0001B!%#\u0003\u0003\u0005\ra_\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa&\u0011\t\t%\"\u0011T\u0005\u0005\u00057\u0013YC\u0001\u0004PE*,7\r\u001e")
public class UpdateCommand
extends LogicalPlan
implements RunnableCommand,
DeltaCommand,
scala.Serializable {
    private transient SparkContext sc;
    private Map<String, SQLMetric> metrics;
    private final TahoeFileIndex tahoeFileIndex;
    private final LogicalPlan target;
    private final Seq<Expression> updateExpressions;
    private final Option<Expression> condition;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TahoeFileIndex, LogicalPlan, Seq<Expression>, Option<Expression>>> unapply(UpdateCommand updateCommand) {
        return UpdateCommand$.MODULE$.unapply(updateCommand);
    }

    public static String FILE_NAME_COLUMN() {
        return UpdateCommand$.MODULE$.FILE_NAME_COLUMN();
    }

    @Override
    public Seq<Expression> parsePartitionPredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePartitionPredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public void updateAndCheckpoint(SparkSession spark, DeltaLog deltaLog, int commitSize, long attemptVersion) {
        DeltaCommand.updateAndCheckpoint$(this, spark, deltaLog, commitSize, attemptVersion);
    }

    @Override
    public long commitLarge(SparkSession spark, OptimisticTransaction txn, Iterator<Action> actions, DeltaOperations.Operation op, Map<String, String> context, Map<String, String> metrics) {
        return DeltaCommand.commitLarge$(this, spark, txn, actions, op, context, metrics);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    public TahoeFileIndex tahoeFileIndex() {
        return this.tahoeFileIndex;
    }

    public LogicalPlan target() {
        return this.target;
    }

    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    public Option<Expression> condition() {
        return this.condition;
    }

    public Seq<QueryPlan<?>> innerChildren() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalPlan[]{this.target()}));
    }

    private SparkContext sc$lzycompute() {
        UpdateCommand updateCommand = this;
        synchronized (updateCommand) {
            if (!this.bitmap$trans$0) {
                this.sc = SparkContext$.MODULE$.getOrCreate();
                this.bitmap$trans$0 = true;
            }
        }
        return this.sc;
    }

    private SparkContext sc() {
        return !this.bitmap$trans$0 ? this.sc$lzycompute() : this.sc;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        UpdateCommand updateCommand = this;
        synchronized (updateCommand) {
            if (!this.bitmap$0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of files added.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of files removed.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numUpdatedRows"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of rows updated."))}));
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Row> run(SparkSession sparkSession) {
        this.recordDeltaOperation(this.tahoeFileIndex().deltaLog(), "delta.dml.update", this.recordDeltaOperation$default$3(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DeltaLog deltaLog = this.tahoeFileIndex().deltaLog();
            deltaLog.assertRemovable();
            deltaLog.withNewTransaction((Function1 & Serializable & scala.Serializable)txn -> {
                this.performUpdate(sparkSession, deltaLog, txn);
                return BoxedUnit.UNIT;
            });
            sparkSession.sharedState().cacheManager().recacheByPlan(sparkSession, this.target());
        });
        return (Seq)Seq$.MODULE$.empty();
    }

    private void performUpdate(SparkSession sparkSession, DeltaLog deltaLog, OptimisticTransaction txn) {
        Nil$ actions;
        Nil$ nil$;
        long numTouchedFiles = 0L;
        long numRewrittenFiles = 0L;
        long scanTimeMs = 0L;
        long rewriteTimeMs = 0L;
        long startTime = System.nanoTime();
        long numFilesTotal = deltaLog.snapshot().numOfFiles();
        Expression updateCondition = (Expression)this.condition().getOrElse((Function0 & Serializable & scala.Serializable)() -> new Literal((Object)BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$));
        Tuple2<Seq<Expression>, Seq<Expression>> tuple2 = DeltaTableUtils$.MODULE$.splitMetadataAndDataPredicates(updateCondition, txn.metadata().partitionColumns(), sparkSession);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq metadataPredicates = (Seq)tuple2._1();
        Seq dataPredicates = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metadataPredicates, (Object)dataPredicates);
        Tuple2 tuple23 = tuple22;
        Seq metadataPredicates2 = (Seq)tuple23._1();
        Seq dataPredicates2 = (Seq)tuple23._2();
        Seq<AddFile> candidateFiles = txn.filterFiles((Seq<Expression>)((Seq)metadataPredicates2.$plus$plus((GenTraversableOnce)dataPredicates2, Seq$.MODULE$.canBuildFrom())));
        Map<String, AddFile> nameToAddFile = this.generateCandidateFileMap(deltaLog.dataPath(), candidateFiles);
        scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
        if (candidateFiles.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else if (dataPredicates2.isEmpty()) {
            numTouchedFiles = candidateFiles.length();
            Seq filesToRewrite = (Seq)candidateFiles.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.path(), Seq$.MODULE$.canBuildFrom());
            long operationTimestamp = System.currentTimeMillis();
            Seq deleteActions = (Seq)candidateFiles.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.removeWithTimestamp(operationTimestamp, x$3.removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
            Seq<AddFile> rewrittenFiles = this.rewriteFiles(sparkSession, txn, this.tahoeFileIndex().path(), (Seq<String>)filesToRewrite, nameToAddFile, updateCondition);
            numRewrittenFiles = rewrittenFiles.size();
            rewriteTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L - scanTimeMs;
            nil$ = (Seq)deleteActions.$plus$plus(rewrittenFiles, Seq$.MODULE$.canBuildFrom());
        } else {
            TahoeBatchFileIndex fileIndex = new TahoeBatchFileIndex(sparkSession, "update", candidateFiles, deltaLog, this.tahoeFileIndex().path(), txn.snapshot());
            LogicalPlan newTarget = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), fileIndex);
            Dataset data = Dataset$.MODULE$.ofRows(sparkSession, newTarget);
            SQLMetric updatedRowCount = (SQLMetric)this.metrics().apply((Object)"numUpdatedRows");
            UserDefinedFunction updatedRowUdf = functions$.MODULE$.udf((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                updatedRowCount.$plus$eq(1L);
                return true;
            }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean()).asNondeterministic();
            String[] filesToRewrite = (String[])this.withStatusCode("DELTA", "Finding files to rewrite for UPDATE operation", this.withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> (String[])data.filter(new Column(updateCondition)).filter(updatedRowUdf.apply((Seq)Nil$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.input_file_name()})).distinct().as(sparkSession.implicits().newStringEncoder()).collect());
            scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
            numTouchedFiles = filesToRewrite.length;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite)).isEmpty()) {
                nil$ = Nil$.MODULE$;
            } else {
                long operationTimestamp = System.currentTimeMillis();
                Seq<RemoveFile> deleteActions = this.removeFilesFromPaths(deltaLog, nameToAddFile, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])filesToRewrite), operationTimestamp);
                Seq rewrittenFiles = (Seq)this.withStatusCode("DELTA", new StringBuilder(37).append("Rewriting ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite)).size()).append(" files for UPDATE operation").toString(), this.withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> this.rewriteFiles(sparkSession, txn, this.tahoeFileIndex().path(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])filesToRewrite), nameToAddFile, updateCondition));
                numRewrittenFiles = rewrittenFiles.size();
                rewriteTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L - scanTimeMs;
                nil$ = actions = (Seq)deleteActions.$plus$plus((GenTraversableOnce)rewrittenFiles, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (actions.nonEmpty()) {
            ((SQLMetric)this.metrics().apply((Object)"numAddedFiles")).set(numRewrittenFiles);
            ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).set(numTouchedFiles);
            txn.registerSQLMetrics(sparkSession, this.metrics());
            txn.commit((Seq<Action>)actions, new DeltaOperations.Update((Option<String>)this.condition().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString())));
            String executionId = sparkSession.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
            SQLMetrics$.MODULE$.postDriverMetricUpdates(sparkSession.sparkContext(), executionId, this.metrics().values().toSeq());
        }
        DeltaLog x$1 = deltaLog;
        String x$22 = "delta.dml.update.stats";
        UpdateMetric x$32 = new UpdateMetric((String)this.condition().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.sql()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "true"), numFilesTotal, numTouchedFiles, numRewrittenFiles, scanTimeMs, rewriteTimeMs);
        Map<TagDefinition, String> x$42 = this.recordDeltaEvent$default$3();
        this.recordDeltaEvent(x$1, x$22, x$42, x$32);
    }

    private Seq<AddFile> rewriteFiles(SparkSession spark, OptimisticTransaction txn, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap, Expression condition) {
        HadoopFsRelation baseRelation = this.buildBaseRelation(spark, txn, "update", rootPath, inputLeafFiles, nameToAddFileMap);
        LogicalPlan newTarget = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), baseRelation.location());
        Dataset targetDf = Dataset$.MODULE$.ofRows(spark, newTarget);
        Seq<Column> updatedColumns = this.buildUpdatedColumns(condition);
        Dataset updatedDataFrame = targetDf.select(updatedColumns);
        return txn.writeFiles(updatedDataFrame);
    }

    private Seq<Column> buildUpdatedColumns(Expression condition) {
        return (Seq)((TraversableLike)this.updateExpressions().zip((GenIterable)this.target().output(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            If updated;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression update = (Expression)tuple2._1();
            Attribute original = (Attribute)tuple2._2();
            If x$1 = updated = new If(condition, update, (Expression)original);
            String x$2 = original.name();
            ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
            Column column = new Column((Expression)new Alias((Expression)x$1, x$2, x$3, x$4, x$5));
            return column;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public UpdateCommand copy(TahoeFileIndex tahoeFileIndex, LogicalPlan target, Seq<Expression> updateExpressions, Option<Expression> condition) {
        return new UpdateCommand(tahoeFileIndex, target, updateExpressions, condition);
    }

    public TahoeFileIndex copy$default$1() {
        return this.tahoeFileIndex();
    }

    public LogicalPlan copy$default$2() {
        return this.target();
    }

    public Seq<Expression> copy$default$3() {
        return this.updateExpressions();
    }

    public Option<Expression> copy$default$4() {
        return this.condition();
    }

    public String productPrefix() {
        return "UpdateCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Seq<Expression> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.tahoeFileIndex();
                break;
            }
            case 1: {
                seq = this.target();
                break;
            }
            case 2: {
                seq = this.updateExpressions();
                break;
            }
            case 3: {
                seq = this.condition();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return seq;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UpdateCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UpdateCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        UpdateCommand updateCommand = (UpdateCommand)x$1;
        TahoeFileIndex tahoeFileIndex = this.tahoeFileIndex();
        TahoeFileIndex tahoeFileIndex2 = updateCommand.tahoeFileIndex();
        if (tahoeFileIndex == null) {
            if (tahoeFileIndex2 != null) {
                return false;
            }
        } else if (!tahoeFileIndex.equals(tahoeFileIndex2)) return false;
        LogicalPlan logicalPlan = this.target();
        LogicalPlan logicalPlan2 = updateCommand.target();
        if (logicalPlan == null) {
            if (logicalPlan2 != null) {
                return false;
            }
        } else if (!logicalPlan.equals(logicalPlan2)) return false;
        Seq<Expression> seq = this.updateExpressions();
        Seq<Expression> seq2 = updateCommand.updateExpressions();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.condition();
        Option<Expression> option2 = updateCommand.condition();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!updateCommand.canEqual(this)) return false;
        return true;
    }

    public UpdateCommand(TahoeFileIndex tahoeFileIndex, LogicalPlan target, Seq<Expression> updateExpressions, Option<Expression> condition) {
        this.tahoeFileIndex = tahoeFileIndex;
        this.target = target;
        this.updateExpressions = updateExpressions;
        this.condition = condition;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
    }
}

