/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.storage.LogStore;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u0007\u000f\u0003\u0003Y\u0002\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u0011-\u0002!\u0011!Q\u0001\n1BQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u000e\u0001\u0005\u0002eBQa\u0010\u0001\u0005\u0012\u0001CQ!\u0011\u0001\u0005B\tCQa\u0018\u0001\u0005B\u0001DQ\u0001\u001b\u0001\u0005B%DQa\u001b\u0001\u0005\u00121Dq!\u001f\u0001\u0012\u0002\u0013E!\u0010C\u0004\u0002\f\u0001!\t\"!\u0004\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014\tA\u0002*\u00193p_B4\u0015\u000e\\3TsN$X-\u001c'pON#xN]3\u000b\u0005=\u0001\u0012aB:u_J\fw-\u001a\u0006\u0003#I\tQ\u0001Z3mi\u0006T!a\u0005\u000b\u0002\u0007M\fHN\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111\u0005J\u0007\u0002\u001d%\u0011QE\u0004\u0002\t\u0019><7\u000b^8sK\u0006I1\u000f]1sW\u000e{gN\u001a\t\u0003Q%j\u0011\u0001F\u0005\u0003UQ\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0002.e5\taF\u0003\u00020a\u0005!1m\u001c8g\u0015\t\td#\u0001\u0004iC\u0012|w\u000e]\u0005\u0003g9\u0012QbQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\bF\u00027oa\u0002\"a\t\u0001\t\u000b\u0019\u001a\u0001\u0019A\u0014\t\u000b-\u001a\u0001\u0019\u0001\u0017\u0015\u0005YR\u0004\"B\u001e\u0005\u0001\u0004a\u0014AA:d!\tAS(\u0003\u0002?)\ta1\u000b]1sW\u000e{g\u000e^3yi\u00061r-\u001a;IC\u0012|w\u000e]\"p]\u001aLw-\u001e:bi&|g.F\u0001-\u0003\u0011\u0011X-\u00193\u0015\u0005\r;\u0006c\u0001#M\u001f:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u0011j\ta\u0001\u0010:p_Rt\u0014\"A\u0010\n\u0005-s\u0012a\u00029bG.\fw-Z\u0005\u0003\u001b:\u00131aU3r\u0015\tYe\u0004\u0005\u0002Q):\u0011\u0011K\u0015\t\u0003\rzI!a\u0015\u0010\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'zAQ\u0001\u0017\u0004A\u0002e\u000bA\u0001]1uQB\u0011!,X\u0007\u00027*\u0011A\fM\u0001\u0003MNL!AX.\u0003\tA\u000bG\u000f[\u0001\tY&\u001cHO\u0012:p[R\u0011\u0011m\u001a\t\u0004\t\n$\u0017BA2O\u0005!IE/\u001a:bi>\u0014\bC\u0001.f\u0013\t17L\u0001\u0006GS2,7\u000b^1ukNDQ\u0001W\u0004A\u0002e\u000bAD]3t_24X\rU1uQ>s\u0007\u000b[=tS\u000e\fGn\u0015;pe\u0006<W\r\u0006\u0002ZU\")\u0001\f\u0003a\u00013\u0006yqO]5uK^KG\u000f\u001b*f]\u0006lW\r\u0006\u0003naF$\bCA\u000fo\u0013\tygD\u0001\u0003V]&$\b\"\u0002-\n\u0001\u0004I\u0006\"\u0002:\n\u0001\u0004\u0019\u0018aB1di&|gn\u001d\t\u0004\t\n|\u0005bB;\n!\u0003\u0005\rA^\u0001\n_Z,'o\u001e:ji\u0016\u0004\"!H<\n\u0005at\"a\u0002\"p_2,\u0017M\\\u0001\u001aoJLG/Z,ji\"\u0014VM\\1nK\u0012\"WMZ1vYR$3'F\u0001|U\t1HpK\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0006y\t!\"\u00198o_R\fG/[8o\u0013\r\tIa \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2sK\u0006$X\rV3naB\u000bG\u000f\u001b\u000b\u00043\u0006=\u0001\"\u0002-\f\u0001\u0004I\u0016aD5om\u0006d\u0017\u000eZ1uK\u000e\u000b7\r[3\u0015\u00035\u0004")
public abstract class HadoopFileSystemLogStore
implements LogStore {
    private final Configuration hadoopConf;

    @Override
    public final Seq<String> read(String path) {
        return LogStore.read$(this, path);
    }

    @Override
    public final void write(String path, Iterator<String> actions) {
        LogStore.write$(this, path, actions);
    }

    @Override
    public boolean write$default$3() {
        return LogStore.write$default$3$(this);
    }

    @Override
    public final Iterator<FileStatus> listFrom(String path) {
        return LogStore.listFrom$(this, path);
    }

    @Override
    public Path resolveCheckpointPath(Path path) {
        return LogStore.resolveCheckpointPath$(this, path);
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return LogStore.isPartialWriteVisible$(this, path);
    }

    public Configuration getHadoopConfiguration() {
        return (Configuration)SparkSession$.MODULE$.getActiveSession().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.sessionState().newHadoopConf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.hadoopConf);
    }

    @Override
    public Seq<String> read(Path path) {
        Seq seq;
        FileSystem fs = path.getFileSystem(this.getHadoopConfiguration());
        try (FSDataInputStream stream = fs.open(path);){
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
            seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((Reader)reader)).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Buffer$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        FileSystem fs = path.getFileSystem(this.getHadoopConfiguration());
        if (!fs.exists(path.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
        }
        FileStatus[] files = fs.listStatus(path.getParent());
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HadoopFileSystemLogStore.$anonfun$listFrom$1(path, x$3))))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().getName(), (Ordering)Ordering.String$.MODULE$))).iterator();
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path) {
        return path.getFileSystem(this.getHadoopConfiguration()).makeQualified(path);
    }

    public void writeWithRename(Path path, Iterator<String> actions, boolean overwrite) {
        block15: {
            FileSystem fs = path.getFileSystem(this.getHadoopConfiguration());
            if (!fs.exists(path.getParent())) {
                throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
            }
            if (overwrite) {
                try (FSDataOutputStream stream = fs.create(path, true);){
                    actions.map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        stream.write(x$1);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (fs.exists(path)) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
            Path tempPath = this.createTempPath(path);
            boolean streamClosed = false;
            boolean renameDone = false;
            FSDataOutputStream stream = fs.create(tempPath);
            try {
                actions.map((Function1 & Serializable & scala.Serializable)x$7 -> new StringBuilder(1).append((String)x$7).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    stream.write(x$1);
                    return BoxedUnit.UNIT;
                });
                stream.close();
                streamClosed = true;
                try {
                    if (fs.rename(tempPath, path)) {
                        renameDone = true;
                        break block15;
                    }
                    if (fs.exists(path)) {
                        throw new java.nio.file.FileAlreadyExistsException(path.toString());
                    }
                    throw new IllegalStateException(new StringBuilder(18).append("Cannot rename ").append(tempPath).append(" to ").append(path).toString());
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    throw new java.nio.file.FileAlreadyExistsException(path.toString());
                }
            }
            finally {
                if (!streamClosed) {
                    stream.close();
                }
                if (!renameDone) {
                    fs.delete(tempPath, false);
                }
            }
        }
    }

    public boolean writeWithRename$default$3() {
        return false;
    }

    public Path createTempPath(Path path) {
        return new Path(path.getParent(), new StringBuilder(6).append(".").append(path.getName()).append(".").append(UUID.randomUUID()).append(".tmp").toString());
    }

    @Override
    public void invalidateCache() {
    }

    public static final /* synthetic */ boolean $anonfun$listFrom$1(Path path$1, FileStatus x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.getPath().getName())).$greater$eq((Object)path$1.getName());
    }

    public HadoopFileSystemLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
        LogStore.$init$(this);
    }

    public HadoopFileSystemLogStore(SparkContext sc) {
        this(sc.getConf(), sc.hadoopConfiguration());
    }
}

