/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import com.google.common.io.CountingOutputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.delta.storage.FileMetadata;
import org.apache.spark.sql.delta.storage.HadoopFileSystemLogStore;
import org.apache.spark.sql.delta.storage.S3SingleDriverLogStore$;
import org.apache.spark.sql.delta.util.FileNames$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u000e\u001d\u0001%B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)A\b\u0001C\u0001{!)\u0011\t\u0001C\u0005\u0005\")A\u000b\u0001C\u0005+\")\u0001\f\u0001C\u00053\")1\f\u0001C\u00059\")\u0001\u000f\u0001C\u0005c\")\u0011\u0010\u0001C\u0005u\"I\u0011Q\u0001\u0001\u0012\u0002\u0013%\u0011q\u0001\u0005\b\u0003;\u0001A\u0011IA\u0010\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KAq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u00022\u0001!\t%a\r\t\u0013\u0005]\u0003!%A\u0005\u0002\u0005\u001d\u0001bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003?\u0002A\u0011IA1\u000f\u001d\t\u0019\u0007\bE\u0001\u0003K2aa\u0007\u000f\t\u0002\u0005\u001d\u0004B\u0002\u001f\u0014\t\u0003\ty\u0007C\u0005\u0002rM\u0011\r\u0011\"\u0003\u0002t!A\u0011\u0011R\n!\u0002\u0013\t)\bC\u0005\u0002\fN\u0011\r\u0011\"\u0003\u0002\u000e\"A\u0011QV\n!\u0002\u0013\ty\tC\u0004\u00020N!I!!-\t\u000f\u0005U6\u0003\"\u0003\u00028\n12kM*j]\u001edW\r\u0012:jm\u0016\u0014Hj\\4Ti>\u0014XM\u0003\u0002\u001e=\u000591\u000f^8sC\u001e,'BA\u0010!\u0003\u0015!W\r\u001c;b\u0015\t\t#%A\u0002tc2T!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00152\u0013AB1qC\u000eDWMC\u0001(\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0006\u0005\u0002,Y5\tA$\u0003\u0002.9\tA\u0002*\u00193p_B4\u0015\u000e\\3TsN$X-\u001c'pON#xN]3\u0002\u0013M\u0004\u0018M]6D_:4\u0007C\u0001\u00192\u001b\u0005\u0011\u0013B\u0001\u001a#\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\t\r|gN\u001a\u0006\u0003s\u0011\na\u0001[1e_>\u0004\u0018BA\u001e7\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"2AP A!\tY\u0003\u0001C\u0003/\u0007\u0001\u0007q\u0006C\u00034\u0007\u0001\u0007A'\u0001\u0005sKN|GN^3e)\t\u0019%\u000b\u0005\u0003E\u000f&{U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\rQ+\b\u000f\\33!\tQU*D\u0001L\u0015\ta\u0005(\u0001\u0002gg&\u0011aj\u0013\u0002\u000b\r&dWmU=ti\u0016l\u0007C\u0001&Q\u0013\t\t6J\u0001\u0003QCRD\u0007\"B*\u0005\u0001\u0004y\u0015\u0001\u00029bi\"\f!bZ3u!\u0006$\bnS3z)\tye\u000bC\u0003X\u000b\u0001\u0007q*\u0001\u0007sKN|GN^3e!\u0006$\b.A\u0007tiJL\u0007/V:fe&sgm\u001c\u000b\u0003\u001fjCQa\u0015\u0004A\u0002=\u000b!#\\3sO\u00164\u0015\u000e\\3Ji\u0016\u0014\u0018\r^8sgR\u0019Q\f\u001c8\u0011\u0007y3\u0017N\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!\rK\u0001\u0007yI|w\u000e\u001e \n\u0003\u0019K!!Z#\u0002\u000fA\f7m[1hK&\u0011q\r\u001b\u0002\t\u0013R,'/\u0019;pe*\u0011Q-\u0012\t\u0003\u0015*L!a[&\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0003n\u000f\u0001\u0007Q,\u0001\u0003ji\u0016\u0014\b\"B8\b\u0001\u0004i\u0016AE5uKJ<\u0016\u000e\u001e5Qe\u0016\u001cW\rZ3oG\u0016\fQ\u0002\\5ti\u001a\u0013x.\\\"bG\",Gc\u0001:xqB\u00191O^5\u000e\u0003QT!!^#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002hi\")A\n\u0003a\u0001\u0013\")q\u000b\u0003a\u0001\u001f\u0006\u0001B.[:u\rJ|W.\u00138uKJt\u0017\r\u001c\u000b\u0005;ndX\u0010C\u0003M\u0013\u0001\u0007\u0011\nC\u0003X\u0013\u0001\u0007q\nC\u0004\u007f\u0013A\u0005\t\u0019A@\u0002\u0011U\u001cXmQ1dQ\u0016\u00042\u0001RA\u0001\u0013\r\t\u0019!\u0012\u0002\b\u0005>|G.Z1o\u0003ia\u0017n\u001d;Ge>l\u0017J\u001c;fe:\fG\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\tIAK\u0002\u0000\u0003\u0017Y#!!\u0004\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/)\u0015AC1o]>$\u0018\r^5p]&!\u00111DA\t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\tY&\u001cHO\u0012:p[R\u0019Q,!\t\t\u000bM[\u0001\u0019A(\u0002!%\u001c\u0018J\\5uS\u0006dg+\u001a:tS>tGcA@\u0002(!)1\u000b\u0004a\u0001\u001f\u00061Q\r_5tiN$Ra`A\u0017\u0003_AQ\u0001T\u0007A\u0002%CQaV\u0007A\u0002=\u000bQa\u001e:ji\u0016$\u0002\"!\u000e\u0002<\u0005u\u00121\u000b\t\u0004\t\u0006]\u0012bAA\u001d\u000b\n!QK\\5u\u0011\u0015\u0019f\u00021\u0001P\u0011\u001d\tyD\u0004a\u0001\u0003\u0003\nq!Y2uS>t7\u000f\u0005\u0003_M\u0006\r\u0003\u0003BA#\u0003\u001brA!a\u0012\u0002JA\u0011\u0001-R\u0005\u0004\u0003\u0017*\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002P\u0005E#AB*ue&twMC\u0002\u0002L\u0015C\u0001\"!\u0016\u000f!\u0003\u0005\ra`\u0001\n_Z,'o\u001e:ji\u0016\fqb\u001e:ji\u0016$C-\u001a4bk2$HeM\u0001\u0016SN\u0004\u0016M\u001d;jC2<&/\u001b;f-&\u001c\u0018N\u00197f)\ry\u0018Q\f\u0005\u0006'B\u0001\raT\u0001\u0010S:4\u0018\r\\5eCR,7)Y2iKR\u0011\u0011QG\u0001\u0017'N\u001a\u0016N\\4mK\u0012\u0013\u0018N^3s\u0019><7\u000b^8sKB\u00111fE\n\u0004'\u0005%\u0004c\u0001#\u0002l%\u0019\u0011QN#\u0003\r\u0005s\u0017PU3g)\t\t)'\u0001\u0005qCRDGj\\2l+\t\t)\bE\u0004\u0002x\u0005\u0015u*!\u001b\u000e\u0005\u0005e$\u0002BA>\u0003{\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\ty(!!\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0007\u000bAA[1wC&!\u0011qQA=\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r]\u0001\na\u0006$\b\u000eT8dW\u0002\n\u0001c\u001e:jiR,g\u000eU1uQ\u000e\u000b7\r[3\u0016\u0005\u0005=\u0005cBAI\u0003G{\u0015qU\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006)1-Y2iK*!\u0011\u0011TAN\u0003\u0019\u0019w.\\7p]*!\u0011QTAP\u0003\u00199wn\\4mK*\u0011\u0011\u0011U\u0001\u0004G>l\u0017\u0002BAS\u0003'\u0013QaQ1dQ\u0016\u00042aKAU\u0013\r\tY\u000b\b\u0002\r\r&dW-T3uC\u0012\fG/Y\u0001\u0012oJLG\u000f^3o!\u0006$\bnQ1dQ\u0016\u0004\u0013a\u0004:fY\u0016\f7/\u001a)bi\"dunY6\u0015\t\u0005U\u00121\u0017\u0005\u0006/f\u0001\raT\u0001\u0010C\u000e\fX/\u001b:f!\u0006$\b\u000eT8dWR!\u0011QGA]\u0011\u00159&\u00041\u0001P\u0001")
public class S3SingleDriverLogStore
extends HadoopFileSystemLogStore {
    private Tuple2<FileSystem, Path> resolved(Path path) {
        FileSystem fs = path.getFileSystem(this.getHadoopConfiguration());
        Path resolvedPath = this.stripUserInfo(fs.makeQualified(path));
        return new Tuple2((Object)fs, (Object)resolvedPath);
    }

    private Path getPathKey(Path resolvedPath) {
        return this.stripUserInfo(resolvedPath);
    }

    private Path stripUserInfo(Path path) {
        URI uri = path.toUri();
        URI newUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        return new Path(newUri);
    }

    private Iterator<FileStatus> mergeFileIterators(Iterator<FileStatus> iter, Iterator<FileStatus> iterWithPrecedence) {
        return ((IterableLike)iter.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getPath(), f)).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)iterWithPrecedence.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getPath(), f))).values().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().getName(), (Ordering)Ordering.String$.MODULE$)).iterator();
    }

    private Iterator<FileStatus> listFromCache(FileSystem fs, Path resolvedPath) {
        Path pathKey = this.getPathKey(resolvedPath);
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().asMap()).asScala()).iterator().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)S3SingleDriverLogStore.$anonfun$listFromCache$1(pathKey, x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            FileMetadata fileMetadata = (FileMetadata)tuple2._2();
            FileStatus fileStatus = new FileStatus(fileMetadata.length(), false, 1, fs.getDefaultBlockSize(path), fileMetadata.modificationTime(), path);
            return fileStatus;
        });
    }

    private Iterator<FileStatus> listFromInternal(FileSystem fs, Path resolvedPath, boolean useCache) {
        Path parentPath = resolvedPath.getParent();
        if (!fs.exists(parentPath)) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(parentPath).toString());
        }
        Iterator listedFromFs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(parentPath))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)S3SingleDriverLogStore.$anonfun$listFromInternal$1(resolvedPath, x$2))))).iterator();
        Iterator<FileStatus> listedFromCache = useCache ? this.listFromCache(fs, resolvedPath) : package$.MODULE$.Iterator().empty();
        return this.mergeFileIterators(listedFromCache, (Iterator<FileStatus>)listedFromFs);
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        Tuple2<FileSystem, Path> tuple2 = this.resolved(path);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        FileSystem fs = (FileSystem)tuple2._1();
        Path resolvedPath = (Path)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fs, (Object)resolvedPath);
        Tuple2 tuple23 = tuple22;
        FileSystem fs2 = (FileSystem)tuple23._1();
        Path resolvedPath2 = (Path)tuple23._2();
        return this.listFromInternal(fs2, resolvedPath2, this.listFromInternal$default$3());
    }

    private boolean listFromInternal$default$3() {
        return true;
    }

    private boolean isInitialVersion(Path path) {
        return FileNames$.MODULE$.isDeltaFile(path) && FileNames$.MODULE$.deltaVersion(path) == 0L;
    }

    private boolean exists(FileSystem fs, Path resolvedPath) {
        return this.listFromInternal(fs, resolvedPath, !this.isInitialVersion(resolvedPath)).take(1).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)S3SingleDriverLogStore.$anonfun$exists$1(resolvedPath, x$4)));
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        Tuple2<FileSystem, Path> tuple2 = this.resolved(path);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        FileSystem fs = (FileSystem)tuple2._1();
        Path resolvedPath = (Path)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fs, (Object)resolvedPath);
        Tuple2 tuple23 = tuple22;
        FileSystem fs2 = (FileSystem)tuple23._1();
        Path resolvedPath2 = (Path)tuple23._2();
        Path lockedPath = this.getPathKey(resolvedPath2);
        S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$acquirePathLock(lockedPath);
        try {
            try {
                if (this.exists(fs2, resolvedPath2) && !overwrite) {
                    throw new java.nio.file.FileAlreadyExistsException(resolvedPath2.toUri().toString());
                }
                CountingOutputStream stream = new CountingOutputStream((OutputStream)fs2.create(resolvedPath2, overwrite));
                actions.map((Function1 & Serializable & scala.Serializable)x$6 -> new StringBuilder(1).append((String)x$6).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    stream.write(x$1);
                    return BoxedUnit.UNIT;
                });
                stream.close();
                if (this.isInitialVersion(resolvedPath2)) {
                    java.lang.Iterable obsoleteFiles = (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().asMap()).asScala()).keys().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)S3SingleDriverLogStore.$anonfun$write$4(lockedPath, x$8)))).asJava();
                    S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().invalidateAll(obsoleteFiles);
                }
                S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().put((Object)lockedPath, (Object)new FileMetadata(stream.getCount(), System.currentTimeMillis()));
            }
            catch (FileAlreadyExistsException e) {
                throw new java.nio.file.FileAlreadyExistsException(e.getMessage());
            }
        }
        finally {
            S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$releasePathLock(lockedPath);
        }
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return false;
    }

    @Override
    public void invalidateCache() {
        S3SingleDriverLogStore$.MODULE$.org$apache$spark$sql$delta$storage$S3SingleDriverLogStore$$writtenPathCache().invalidateAll();
    }

    public static final /* synthetic */ boolean $anonfun$listFromCache$1(Path pathKey$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path path = (Path)tuple2._1();
        Path path2 = path.getParent();
        Path path3 = pathKey$1.getParent();
        boolean bl = !(path2 != null ? !path2.equals(path3) : path3 != null) && new StringOps(Predef$.MODULE$.augmentString(path.getName())).$greater$eq((Object)pathKey$1.getName());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listFromInternal$1(Path resolvedPath$1, FileStatus x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.getPath().getName())).$greater$eq((Object)resolvedPath$1.getName());
    }

    public static final /* synthetic */ boolean $anonfun$exists$1(Path resolvedPath$2, FileStatus x$4) {
        String string = x$4.getPath().getName();
        String string2 = resolvedPath$2.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$write$4(Path lockedPath$1, Path x$8) {
        Path path = x$8.getParent();
        Path path2 = lockedPath$1.getParent();
        return !(path != null ? !path.equals(path2) : path2 != null);
    }

    public S3SingleDriverLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        super(sparkConf, hadoopConf);
    }
}

