/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;

public class CommitLogParams {
    @Parameter(description="maximum number of commit-log entries to return, just a hint for the server")
    @QueryParam(value="max")
    private Integer maxRecords;
    @Parameter(description="pagination continuation token, as returned in the previous LogResponse.token")
    @QueryParam(value="pageToken")
    private String pageToken;
    @Parameter(description="List of authors to filter by. The author is the original committer. No filtering by author will happen if this is set to null/empty")
    @QueryParam(value="authors")
    private List<String> authors;
    @Parameter(description="List of committers to filter by. This is the logged in user/account who performed the commit. No filtering by committer will happen if this is set to null/empty")
    @QueryParam(value="committers")
    private List<String> committers;
    @Parameter(description="Only include commits newer than the specified date in ISO-8601 format. No filtering will happen if this is set to null", examples={@ExampleObject(ref="javaInstant")})
    @QueryParam(value="after")
    private Instant after;
    @Parameter(description="Only include commits older than the specified date in ISO-8601 format. No filtering will happen if this is set to null", examples={@ExampleObject(ref="javaInstant")})
    @QueryParam(value="before")
    private Instant before;

    public CommitLogParams() {
    }

    private CommitLogParams(Integer maxRecords, String pageToken, List<String> authors, List<String> committers, Instant after, Instant before) {
        this.maxRecords = maxRecords;
        this.pageToken = pageToken;
        this.authors = authors;
        this.committers = committers;
        this.after = after;
        this.before = before;
    }

    private CommitLogParams(Builder builder) {
        this(builder.maxRecords, builder.pageToken, new ArrayList<String>(builder.authors), new ArrayList<String>(builder.committers), builder.after, builder.before);
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public List<String> getCommitters() {
        return this.committers;
    }

    public Instant getAfter() {
        return this.after;
    }

    public Instant getBefore() {
        return this.before;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CommitLogParams empty() {
        return new Builder().build();
    }

    public String toString() {
        return new StringJoiner(", ", CommitLogParams.class.getSimpleName() + "[", "]").add("maxRecords=" + this.maxRecords).add("pageToken='" + this.pageToken + "'").add("authors=" + this.authors).add("committers=" + this.committers).add("after=" + this.after).add("before=" + this.before).toString();
    }

    public static class Builder {
        private Integer maxRecords;
        private String pageToken;
        private List<String> authors = Collections.emptyList();
        private List<String> committers = Collections.emptyList();
        private Instant after;
        private Instant before;

        private Builder() {
        }

        public Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public Builder authors(List<String> authors) {
            this.authors = authors;
            return this;
        }

        public Builder committers(List<String> committers) {
            this.committers = committers;
            return this;
        }

        public Builder after(Instant after) {
            this.after = after;
            return this;
        }

        public Builder before(Instant before) {
            this.before = before;
            return this;
        }

        public Builder from(CommitLogParams params) {
            return this.maxRecords(params.maxRecords).pageToken(params.pageToken).authors(params.authors).committers(params.committers).after(params.after).before(params.before);
        }

        private void validate() {
            Objects.requireNonNull(this.authors, "authors must be non-null");
            Objects.requireNonNull(this.committers, "committers must be non-null");
        }

        public CommitLogParams build() {
            this.validate();
            return new CommitLogParams(this);
        }
    }
}

