/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Transplant;

class ClientTreeApi
implements TreeApi {
    private static final TypeReference<List<Reference>> REFERENCE_LIST = new TypeReference<List<Reference>>(){};
    private final HttpClient client;

    public ClientTreeApi(HttpClient client) {
        this.client = client;
    }

    @Override
    public List<Reference> getAllReferences() {
        return this.client.newRequest().path("trees").get().readEntity(REFERENCE_LIST);
    }

    @Override
    public Reference createReference(@NotNull Reference reference) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/tree").post(reference).readEntity(Reference.class);
    }

    @Override
    public Reference getReferenceByName(@NotNull String refName) throws NessieNotFoundException {
        return this.client.newRequest().path("trees/tree/{ref}").resolveTemplate("ref", refName).get().readEntity(Reference.class);
    }

    @Override
    public void assignTag(@NotNull String tagName, @NotNull String expectedHash, @NotNull Tag tag) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", tagName).queryParam("expectedHash", expectedHash).put(tag);
    }

    @Override
    public void deleteTag(@NotNull String tagName, @NotNull String expectedHash) throws NessieConflictException, NessieNotFoundException {
        this.client.newRequest().path("trees/tag/{tagName}").resolveTemplate("tagName", tagName).queryParam("expectedHash", expectedHash).delete();
    }

    @Override
    public void assignBranch(@NotNull String branchName, @NotNull String expectedHash, @NotNull Branch branch) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("trees/branch/{branchName}").resolveTemplate("branchName", branchName).queryParam("expectedHash", expectedHash).put(branch);
    }

    @Override
    public void deleteBranch(@NotNull String branchName, @NotNull String expectedHash) throws NessieConflictException, NessieNotFoundException {
        this.client.newRequest().path("trees/branch/{branchName}").resolveTemplate("branchName", branchName).queryParam("expectedHash", expectedHash).delete();
    }

    @Override
    public Branch getDefaultBranch() {
        return this.client.newRequest().path("trees/tree").get().readEntity(Branch.class);
    }

    @Override
    public LogResponse getCommitLog(String ref, CommitLogParams params) throws NessieNotFoundException {
        HttpRequest builder = this.client.newRequest().path("trees/tree/{ref}/log").resolveTemplate("ref", ref);
        if (null != params.getAuthors()) {
            params.getAuthors().forEach(x -> builder.queryParam("authors", (String)x));
        }
        if (null != params.getCommitters()) {
            params.getCommitters().forEach(x -> builder.queryParam("committers", (String)x));
        }
        return builder.queryParam("max", params.getMaxRecords() != null ? params.getMaxRecords().toString() : null).queryParam("pageToken", params.getPageToken()).queryParam("before", null != params.getBefore() ? params.getBefore().toString() : null).queryParam("after", null != params.getAfter() ? params.getAfter().toString() : null).get().readEntity(LogResponse.class);
    }

    @Override
    public void transplantCommitsIntoBranch(@NotNull String branchName, @NotNull String expectedHash, String message, @Valid Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("trees/branch/{branchName}/transplant").resolveTemplate("branchName", branchName).queryParam("expectedHash", expectedHash).queryParam("message", message).post(transplant);
    }

    @Override
    public void mergeRefIntoBranch(@NotNull String branchName, @NotNull String expectedHash, @NotNull @Valid Merge merge) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("trees/branch/{branchName}/merge").resolveTemplate("branchName", branchName).queryParam("expectedHash", expectedHash).post(merge);
    }

    @Override
    public EntriesResponse getEntries(@NotNull String refName, @NotNull EntriesParams params) throws NessieNotFoundException {
        HttpRequest builder = this.client.newRequest().path("trees/tree/{ref}/entries").resolveTemplate("ref", refName);
        params.getTypes().forEach(x -> builder.queryParam("types", (String)x));
        return builder.queryParam("max", params.getMaxRecords() != null ? params.getMaxRecords().toString() : null).queryParam("pageToken", params.getPageToken()).queryParam("namespace", params.getNamespace()).get().readEntity(EntriesResponse.class);
    }

    @Override
    public Branch commitMultipleOperations(String branch, @NotNull String expectedHash, @NotNull Operations operations) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/branch/{branchName}/commit").resolveTemplate("branchName", branch).queryParam("expectedHash", expectedHash).post(operations).readEntity(Branch.class);
    }
}

