/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.List;
import java.util.OptionalInt;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.validation.constraints.NotNull;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.PaginatedResponse;

final class ResultStreamPaginator<R extends PaginatedResponse, E> {
    private final Function<R, List<E>> entriesFromResponse;
    private final Fetcher<R> fetcher;

    ResultStreamPaginator(Function<R, List<E>> entriesFromResponse, Fetcher<R> fetcher) {
        this.entriesFromResponse = entriesFromResponse;
        this.fetcher = fetcher;
    }

    Stream<E> generateStream(final @NotNull String ref, final OptionalInt pageSizeHint) throws NessieNotFoundException {
        final PaginatedResponse firstPage = (PaginatedResponse)this.fetcher.fetch(ref, pageSizeHint.isPresent() ? Integer.valueOf(pageSizeHint.getAsInt()) : null, null);
        Spliterator spliterator = new Spliterator<E>(){
            private String pageToken;
            private boolean eof;
            private int offsetInPage;
            private R currentPage;
            {
                this.currentPage = firstPage;
            }

            @Override
            public boolean tryAdvance(Consumer<? super E> action) {
                if (this.eof) {
                    return false;
                }
                if (this.currentPage != null && ((List)ResultStreamPaginator.this.entriesFromResponse.apply(this.currentPage)).size() == this.offsetInPage) {
                    if (!this.currentPage.hasMore()) {
                        this.eof = true;
                        return false;
                    }
                    this.pageToken = this.currentPage.getToken();
                    this.currentPage = null;
                    this.offsetInPage = 0;
                }
                if (this.currentPage == null) {
                    try {
                        this.currentPage = (PaginatedResponse)ResultStreamPaginator.this.fetcher.fetch(ref, pageSizeHint.isPresent() ? Integer.valueOf(pageSizeHint.getAsInt()) : null, this.pageToken);
                        this.offsetInPage = 0;
                        if (((List)ResultStreamPaginator.this.entriesFromResponse.apply(this.currentPage)).isEmpty()) {
                            if (this.currentPage.hasMore()) {
                                throw new IllegalStateException("Backend returned empty page, but indicates there are more results");
                            }
                            this.eof = true;
                            return false;
                        }
                    }
                    catch (NessieNotFoundException e) {
                        this.eof = true;
                        throw new RuntimeException(e);
                    }
                }
                action.accept(((List)ResultStreamPaginator.this.entriesFromResponse.apply(this.currentPage)).get(this.offsetInPage++));
                return true;
            }

            @Override
            public Spliterator<E> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return 0L;
            }

            @Override
            public int characteristics() {
                return 0;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    @FunctionalInterface
    static interface Fetcher<R> {
        public R fetch(@NotNull String var1, Integer var2, String var3) throws NessieNotFoundException;
    }
}

