/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.deltalake;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.DeltaFileType;
import org.apache.spark.sql.delta.DeltaFileType$CHECKPOINT$;
import org.apache.spark.sql.delta.DeltaFileType$CHECKSUM$;
import org.apache.spark.sql.delta.DeltaFileType$DELTA$;
import org.apache.spark.sql.delta.DeltaFileType$UNKNOWN$;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.FileNames$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.projectnessie.client.NessieClient;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005f\u0001\u0002\u00180\u0001YB\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005/\")q\f\u0001C\u0001A\"9Q\r\u0001b\u0001\n\u00031\u0007BB9\u0001A\u0003%q\rC\u0004s\u0001\t\u0007I\u0011\u00014\t\rM\u0004\u0001\u0015!\u0003h\u0011\u001d!\bA1A\u0005\u0002\u0019Da!\u001e\u0001!\u0002\u00139\u0007b\u0002<\u0001\u0001\u0004%\ta\u001e\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0001\u0003\u001fAq!a\u0007\u0001A\u0003&\u0001\u0010C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003\u0002 !A\u00111\u0006\u0001!\u0002\u0013\t\t\u0003C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020!A\u0011Q\t\u0001!\u0002\u0013\t\t\u0004C\u0004\u0002H\u0001!I!!\u0013\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\ti\t\u0001C\u0005\u0003\u001fCq!!'\u0001\t\u0003\nY\nC\u0005\u00020\u0002\t\n\u0011\"\u0001\u00022\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007\"CAn\u0001E\u0005I\u0011BAo\u0011\u001d\t\t\u000f\u0001C\u0005\u0003GDq!a?\u0001\t\u0013\ti\u0010C\u0004\u0003\n\u0001!IAa\u0003\t\u0013\tm\u0001!%A\u0005\n\u0005u\u0007\"\u0003B\u000f\u0001E\u0005I\u0011BAo\u0011\u001d\u0011y\u0002\u0001C\t\u0005CAqAa\u000b\u0001\t\u0003\u0011i\u0003C\u0004\u0003,\u0001!\tAa\u000e\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!\u0011\n\u0001\u0005\u0002\t-\u0003b\u0002B,\u0001\u0011\u0005!\u0011\f\u0005\b\u0005K\u0002A\u0011\u0001B4\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005[BqAa\u001d\u0001\t\u0013\u0011)\bC\u0004\u0003\u0000\u0001!IA!!\t\u000f\t-\u0005\u0001\"\u0011\u0003\u000e\"9!\u0011\u0013\u0001\u0005B\tM\u0005b\u0002BK\u0001\u0011\u0005#q\u0013\u0005\b\u00057\u0003A\u0011\tBO\u00059qUm]:jK2{wm\u0015;pe\u0016T!\u0001M\u0019\u0002\u0013\u0011,G\u000e^1mC.,'B\u0001\u001a4\u00035\u0001(o\u001c6fGRtWm]:jK*\tA'A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001ouZ\u0005C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g\r\u0005\u0002?\u00136\tqH\u0003\u0002A\u0003\u000691\u000f^8sC\u001e,'B\u0001\"D\u0003\u0015!W\r\u001c;b\u0015\t!U)A\u0002tc2T!AR$\u0002\u000bM\u0004\u0018M]6\u000b\u0005!\u001b\u0014AB1qC\u000eDW-\u0003\u0002K\u007f\tAAj\\4Ti>\u0014X\r\u0005\u0002M\u001f6\tQJ\u0003\u0002O\u000b\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002Q\u001b\n9Aj\\4hS:<\u0017!C:qCJ\\7i\u001c8g!\t\u0019F+D\u0001F\u0013\t)VIA\u0005Ta\u0006\u00148nQ8oM\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005akV\"A-\u000b\u0005i[\u0016\u0001B2p]\u001aT!\u0001X$\u0002\r!\fGm\\8q\u0013\tq\u0016LA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0005\u001cG\r\u0005\u0002c\u00015\tq\u0006C\u0003R\u0007\u0001\u0007!\u000bC\u0003W\u0007\u0001\u0007q+\u0001\teK2$\u0018MR5mKB\u000bG\u000f^3s]V\tq\r\u0005\u0002i_6\t\u0011N\u0003\u0002kW\u0006)!/Z4fq*\u0011A.\\\u0001\u0005kRLGNC\u0001o\u0003\u0011Q\u0017M^1\n\u0005AL'a\u0002)biR,'O\\\u0001\u0012I\u0016dG/\u0019$jY\u0016\u0004\u0016\r\u001e;fe:\u0004\u0013aE2iK\u000e\\7/^7GS2,\u0007+\u0019;uKJt\u0017\u0001F2iK\u000e\\7/^7GS2,\u0007+\u0019;uKJt\u0007%A\u000bdQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3QCR$XM\u001d8\u0002-\rDWmY6q_&tGOR5mKB\u000bG\u000f^3s]\u0002\n\u0001\u0003\\1tiNs\u0017\r]:i_R,V/\u001b3\u0016\u0003a\u00042\u0001O=|\u0013\tQ\u0018H\u0001\u0004PaRLwN\u001c\t\u0004y\u0006\u001dabA?\u0002\u0004A\u0011a0O\u0007\u0002\u007f*\u0019\u0011\u0011A\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\t)!O\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00111\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015\u0011(\u0001\u000bmCN$8K\\1qg\"|G/V;jI~#S-\u001d\u000b\u0005\u0003#\t9\u0002E\u00029\u0003'I1!!\u0006:\u0005\u0011)f.\u001b;\t\u0011\u0005e1\"!AA\u0002a\f1\u0001\u001f\u00132\u0003Ea\u0017m\u001d;T]\u0006\u00048\u000f[8u+VLG\rI\u0001\u0007G2LWM\u001c;\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003Oi!!!\n\u000b\u0007\u0005u\u0011'\u0003\u0003\u0002*\u0005\u0015\"\u0001\u0004(fgNLWm\u00117jK:$\u0018aB2mS\u0016tG\u000fI\u0001\re\u00164WM]3oG\u0016l\u0015\r]\u000b\u0003\u0003c\u0001r!a\r\u00026m\fI$D\u0001l\u0013\r\t9d\u001b\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}\u0012'A\u0003n_\u0012,G.\u0003\u0003\u0002D\u0005u\"!\u0003*fM\u0016\u0014XM\\2f\u00035\u0011XMZ3sK:\u001cW-T1qA\u0005i1m\u001c8gS\u001e,(/\u001a3SK\u001a$\"!!\u000f\u0002\u001fI,g-\u001a:f]\u000e,')\u001f(b[\u0016$B!!\u000f\u0002P!1\u0011\u0011\u000b\nA\u0002m\fqA]3g\u001d\u0006lW-A\bva\u0012\fG/\u001a*fM\u0016\u0014XM\\2f)\u0011\t\t\"a\u0016\t\u000f\u0005e3\u00031\u0001\u0002:\u0005\u0019!/\u001a4\u0002!I,gM]3tQJ+g-\u001a:f]\u000e,G\u0003BA\t\u0003?Ba!!\u0015\u0015\u0001\u0004Y\u0018\u0001\u00037jgR4%o\\7\u0015\t\u0005\u0015\u00141\u0011\t\u0007\u0003O\n\t(a\u001e\u000f\t\u0005%\u0014Q\u000e\b\u0004}\u0006-\u0014\"\u0001\u001e\n\u0007\u0005=\u0014(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0014Q\u000f\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011qN\u001d\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! \\\u0003\t17/\u0003\u0003\u0002\u0002\u0006m$A\u0003$jY\u0016\u001cF/\u0019;vg\"9\u0011QQ\u000bA\u0002\u0005\u001d\u0015\u0001\u00029bi\"\u0004B!!\u001f\u0002\n&!\u00111RA>\u0005\u0011\u0001\u0016\r\u001e5\u0002)A\f'o]3UC\ndW-\u00133f]RLg-[3s)\u0011\t\t*a&\u0011\ra\n\u0019j_>|\u0013\r\t)*\u000f\u0002\u0007)V\u0004H.Z\u001a\t\r\u0005\u0015e\u00031\u0001|\u0003\u00159(/\u001b;f)!\t\t\"!(\u0002 \u0006\u0015\u0006bBAC/\u0001\u0007\u0011q\u0011\u0005\b\u0003C;\u0002\u0019AAR\u0003\u001d\t7\r^5p]N\u0004R!a\u001a\u0002rmD\u0011\"a*\u0018!\u0003\u0005\r!!+\u0002\u0013=4XM]<sSR,\u0007c\u0001\u001d\u0002,&\u0019\u0011QV\u001d\u0003\u000f\t{w\u000e\\3b]\u0006yqO]5uK\u0012\"WMZ1vYR$3'\u0006\u0002\u00024*\"\u0011\u0011VA[W\t\t9\f\u0005\u0003\u0002:\u0006\rWBAA^\u0015\u0011\ti,a0\u0002\u0013Ut7\r[3dW\u0016$'bAAas\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00171\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E;qI\u0006$X\rR3mi\u0006$\u0016M\u00197f)!\tY-!5\u0002T\u0006]\u0007\u0003BA\u001e\u0003\u001bLA!a4\u0002>\tqA)\u001a7uC2\u000b7.\u001a+bE2,\u0007bBAC3\u0001\u0007\u0011q\u0011\u0005\u0007\u0003+L\u0002\u0019A>\u0002\u0013Q\f'oZ3u%\u00164\u0007\u0002CAm3A\u0005\t\u0019A>\u0002\u001d1\f7\u000f^\"iK\u000e\\\u0007o\\5oi\u0006QR\u000f\u001d3bi\u0016$U\r\u001c;b)\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u001c\u0016\u0004w\u0006U\u0016!E3yiJ\f7\r^\"iK\u000e\\\u0007o\\5oiR1\u0011Q]A|\u0003s\u0004r\u0001OAt\u0003W\f\t0C\u0002\u0002jf\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001\u001d\u0002n&\u0019\u0011q^\u001d\u0003\t1{gn\u001a\t\u0006\u0003O\n\u0019p_\u0005\u0005\u0003k\f)HA\u0002TKFDa!!7\u001c\u0001\u0004Y\bbBAC7\u0001\u0007\u0011qQ\u0001\u0014[>4Xm\u00115fG.\u0004x.\u001b8u\r&dWm\u001d\u000b\u0007\u0003c\fyP!\u0002\t\u000f\t\u0005A\u00041\u0001\u0003\u0004\u0005)a-\u001b7fgB1\u0011qMAz\u0003\u000fCqAa\u0002\u001d\u0001\u0004\t9)A\u0004eKN$H)\u001b:\u0002\r\r|W.\\5u)1\tIK!\u0004\u0003\u0010\tE!Q\u0003B\r\u0011\u001d\t))\ba\u0001\u0003\u000fCa!!\u0017\u001e\u0001\u0004Y\bB\u0002B\n;\u0001\u000710\u0001\u0003iCND\u0007\u0002\u0003B\f;A\u0005\t\u0019A>\u0002\u000f5,7o]1hK\"A\u0011\u0011\\\u000f\u0011\u0002\u0003\u000710\u0001\td_6l\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u00012m\\7nSR$C-\u001a4bk2$H%N\u0001\u000eoJLG/Z%oi\u0016\u0014h.\u00197\u0015\u0015\u0005E!1\u0005B\u0013\u0005O\u0011I\u0003C\u0004\u0002\u0006\u0002\u0002\r!a\"\t\u000f\u0005\u0005\u0006\u00051\u0001\u0002$\"1\u0011\u0011\f\u0011A\u0002mDaAa\u0005!\u0001\u0004Y\u0018!\u00039bi\"$vnS3z)\u0011\u0011yC!\u000e\u0011\t\u0005m\"\u0011G\u0005\u0005\u0005g\tiDA\u0006D_:$XM\u001c;t\u0017\u0016L\bbBACC\u0001\u0007\u0011q\u0011\u000b\u0005\u0005_\u0011I\u0004\u0003\u0004\u0002\u0006\n\u0002\ra_\u0001\u0013]Vl7\t[3dWB|\u0017N\u001c;QCJ$8\u000f\u0006\u0003\u0003@\t\u001d\u0003\u0003\u0002\u001dz\u0005\u0003\u00022\u0001\u000fB\"\u0013\r\u0011)%\u000f\u0002\u0004\u0013:$\bbBACG\u0001\u0007\u0011qQ\u0001\fO\u0016$h)\u001b7f)f\u0004X\r\u0006\u0003\u0003N\tU\u0003\u0003\u0002B(\u0005#j\u0011!Q\u0005\u0004\u0005'\n%!\u0004#fYR\fg)\u001b7f)f\u0004X\rC\u0004\u0002\u0006\u0012\u0002\r!a\"\u0002\u0017\u0015DHO]1di6+G/\u0019\u000b\u0005\u00057\u0012\t\u0007\u0005\u0003\u0003P\tu\u0013b\u0001B0\u0003\nYAj\\4GS2,W*\u001a;b\u0011\u001d\u0011\u0019'\na\u0001\u0003o\n!BZ5mKN#\u0018\r^;t\u00039)\u0007\u0010\u001e:bGR4VM]:j_:$B!a;\u0003j!9\u0011Q\u0011\u0014A\u0002\u0005\u001d\u0015!\u00047jgR4\u0015\u000e\\3t\rJ|W\u000e\u0006\u0003\u0003p\tE\u0004CBA4\u0003c\u0012Y\u0006C\u0004\u0002\u0006\u001e\u0002\r!a\"\u0002\u001f\u0015l\u0007\u000f^=DQ\u0016\u001c7\u000e]8j]R$bAa\u0017\u0003x\tm\u0004b\u0002B=Q\u0001\u0007\u00111^\u0001\bm\u0016\u00148/[8o\u0011\u001d\u0011i\b\u000ba\u0001\u00057\n1\u0002\\8h\r&dW-T3uC\u0006Aq-\u001a;UC\ndW\r\u0006\u0004\u0003\u0004\n\u0015%q\u0011\t\u0005qe\fY\rC\u0004\u0002\u0006&\u0002\r!a\"\t\r\t%\u0015\u00061\u0001|\u0003\u0019\u0011'/\u00198dQ\u0006!!/Z1e)\u0011\t\tPa$\t\u000f\u0005\u0015%\u00061\u0001\u0002\b\u0006y\u0011N\u001c<bY&$\u0017\r^3DC\u000eDW\r\u0006\u0002\u0002\u0012\u0005)\u0012n\u001d)beRL\u0017\r\\,sSR,g+[:jE2,G\u0003BAU\u00053Cq!!\"-\u0001\u0004\t9)A\u000bsKN|GN^3DQ\u0016\u001c7\u000e]8j]R\u0004\u0016\r\u001e5\u0015\t\u0005\u001d%q\u0014\u0005\b\u0003\u000bk\u0003\u0019AAD\u0001")
public class NessieLogStore
implements LogStore,
Logging {
    private final SparkConf sparkConf;
    private final Configuration hadoopConf;
    private final Pattern deltaFilePattern;
    private final Pattern checksumFilePattern;
    private final Pattern checkpointFilePattern;
    private Option<String> lastSnapshotUuid;
    private final NessieClient client;
    private final Map<String, Reference> referenceMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public final Seq<String> read(String path) {
        return LogStore.read$(this, path);
    }

    @Override
    public final void write(String path, Iterator<String> actions) {
        LogStore.write$(this, path, actions);
    }

    @Override
    public final Iterator<FileStatus> listFrom(String path) {
        return LogStore.listFrom$(this, path);
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path) {
        return LogStore.resolvePathOnPhysicalStorage$(this, path);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Pattern deltaFilePattern() {
        return this.deltaFilePattern;
    }

    public Pattern checksumFilePattern() {
        return this.checksumFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public Option<String> lastSnapshotUuid() {
        return this.lastSnapshotUuid;
    }

    public void lastSnapshotUuid_$eq(Option<String> x$1) {
        this.lastSnapshotUuid = x$1;
    }

    private NessieClient client() {
        return this.client;
    }

    private Map<String, Reference> referenceMap() {
        return this.referenceMap;
    }

    private Reference configuredRef() {
        String refName = this.hadoopConf.get("nessie.ref");
        return this.referenceByName(refName);
    }

    /*
     * WARNING - void declaration
     */
    private Reference referenceByName(String refName) {
        void var2_2;
        Object object;
        Reference ref = this.referenceMap().get(refName);
        if (ref == null) {
            ref = this.client().getTreeApi().getReferenceByName(refName);
            object = this.referenceMap().put(refName, ref);
        } else {
            object = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    private void updateReference(Reference ref) {
        this.referenceMap().put(ref.getName(), ref);
    }

    private void refreshReference(String refName) {
        this.referenceMap().remove(refName);
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        throw new UnsupportedOperationException("listFrom from Nessie does not work.");
    }

    private Tuple3<String, String, String> parseTableIdentifier(String path) {
        if (path.contains("@") && path.contains("#")) {
            String[] tableRef = path.split("@");
            String[] refHash = tableRef[1].split("#");
            return new Tuple3((Object)tableRef[0], (Object)refHash[0], (Object)refHash[0]);
        }
        if (path.contains("@")) {
            String[] tableRef = path.split("@");
            return new Tuple3((Object)tableRef[0], (Object)tableRef[1], null);
        }
        return new Tuple3((Object)path, (Object)this.hadoopConf.get("nessie.ref"), (Object)this.hadoopConf.get("nessie.hash"));
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        if (path.getName().equals("_last_checkpoint")) {
            Path x$1 = path;
            String x$2 = this.configuredRef().getName();
            String x$3 = this.configuredRef().getHash();
            String x$4 = actions.mkString();
            String x$5 = this.commit$default$4();
            this.commit(x$1, x$2, x$3, x$5, x$4);
            return;
        }
        Path parent = path.getParent();
        String[] nameSplit = path.getName().split("\\.", 2);
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(nameSplit[0]);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        Tuple3 tuple33 = tuple32;
        String tableName2 = (String)tuple33._1();
        String ref2 = (String)tuple33._2();
        String hash2 = (String)tuple33._3();
        String name = new StringBuilder(2).append(tableName2).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(nameSplit[1]).toString();
        Path nessiePath = new Path(parent, name);
        if (overwrite) {
            throw new IllegalStateException(new StringBuilder(32).append("Nessie won't overwrite for path ").append(path).toString());
        }
        this.writeInternal(nessiePath, actions, ref2, hash2);
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    private DeltaLakeTable updateDeltaTable(Path path, String targetRef, String lastCheckpoint) {
        ImmutableDeltaLakeTable immutableDeltaLakeTable;
        Option<DeltaLakeTable> currentTable = this.getTable(path.getParent(), targetRef);
        ImmutableDeltaLakeTable table = (ImmutableDeltaLakeTable)currentTable.map((Function1 & Serializable & scala.Serializable)instance -> ImmutableDeltaLakeTable.copyOf(instance)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableDeltaLakeTable.builder().build());
        DeltaFileType deltaFileType = this.getFileType(path);
        if (((Object)DeltaFileType$DELTA$.MODULE$).equals(deltaFileType)) {
            String string = path.toString();
            immutableDeltaLakeTable = table.withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(table.getMetadataLocationHistory()).asScala()).toList().$colon$colon((Object)string)).asJava());
        } else {
            if (((Object)DeltaFileType$CHECKPOINT$.MODULE$).equals(deltaFileType)) {
                throw new UnsupportedOperationException("Can't write checkpoints from LogStore");
            }
            if (((Object)DeltaFileType$CHECKSUM$.MODULE$).equals(deltaFileType)) {
                immutableDeltaLakeTable = table;
            } else if (((Object)DeltaFileType$UNKNOWN$.MODULE$).equals(deltaFileType)) {
                ImmutableDeltaLakeTable immutableDeltaLakeTable2;
                if (!path.getName().equals("_last_checkpoint")) {
                    immutableDeltaLakeTable2 = table;
                } else {
                    Tuple2<Object, Seq<String>> tuple2 = this.extractCheckpoint(lastCheckpoint, path.getParent());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long version = tuple2._1$mcJ$sp();
                    Seq parts = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)version), (Object)parts);
                    Tuple2 tuple23 = tuple22;
                    long version2 = tuple23._1$mcJ$sp();
                    Seq parts2 = (Seq)tuple23._2();
                    immutableDeltaLakeTable2 = table.withCheckpointLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(parts2).asJava()).withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(table.getCheckpointLocationHistory()).asScala()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$updateDeltaTable$3(this, version2, x)))).asJava()).withLastCheckpoint(lastCheckpoint);
                }
                immutableDeltaLakeTable = immutableDeltaLakeTable2;
            } else {
                immutableDeltaLakeTable = table;
            }
        }
        return immutableDeltaLakeTable;
    }

    private String updateDeltaTable$default$3() {
        return null;
    }

    private Tuple2<Object, Seq<String>> extractCheckpoint(String lastCheckpoint, Path path) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        CheckpointMetaData checkpoint = (CheckpointMetaData)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(lastCheckpoint), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(CheckpointMetaData.class));
        long version = checkpoint.version();
        Option<Object> parts = checkpoint.parts();
        Path tempPath = new Path(path, (String)this.lastSnapshotUuid().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("didn't write the correct checkpoint dir");
        }));
        Seq files = parts.isEmpty() ? (Seq)new .colon.colon((Object)FileNames$.MODULE$.checkpointFileSingular(tempPath, version), (List)Nil$.MODULE$) : FileNames$.MODULE$.checkpointFileWithParts(tempPath, version, BoxesRunTime.unboxToInt((Object)checkpoint.parts().get()));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)version), this.moveCheckpointFiles((Seq<Path>)files, path));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<String> moveCheckpointFiles(Seq<Path> files, Path destDir) {
        void var3_3;
        Seq movedFiles = (Seq)files.map((Function1 & Serializable & scala.Serializable)f -> {
            FileSystem fs = f.getFileSystem($this.hadoopConf);
            String[] parts = f.getName().split("\\.", 2);
            String destFile = new StringBuilder(2).append(parts[0]).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(parts[1]).toString();
            Path dest = new Path(destDir, destFile);
            fs.rename(f, dest);
            return dest.toString();
        }, Seq$.MODULE$.canBuildFrom());
        ((Path)files.head()).getFileSystem(this.hadoopConf).delete(((Path)files.head()).getParent(), true);
        return var3_3;
    }

    private boolean commit(Path path, String ref, String hash, String message, String lastCheckpoint) {
        int retries = hash == null ? 1 : 0;
        while (true) {
            String targetRef = ref == null ? this.configuredRef().getName() : ref;
            String targetHash = hash == null ? this.referenceByName(targetRef).getHash() : hash;
            DeltaLakeTable table = this.updateDeltaTable(path, targetRef, lastCheckpoint);
            Operation.Put put = Operation.Put.of(this.pathToKey(path.getParent()), table);
            ImmutableCommitMeta meta = CommitMeta.builder().message(message).putProperties("spark.app.id", this.sparkConf.get("spark.app.id")).putProperties("application.type", "delta").build();
            ImmutableOperations op = ImmutableOperations.builder().addOperations((Operation)put).commitMeta(meta).build();
            try {
                Branch updated = this.client().getTreeApi().commitMultipleOperations(targetRef, targetHash, op);
                this.updateReference(updated != null ? updated : this.client().getTreeApi().getReferenceByName(targetRef));
                return true;
            }
            catch (NessieConflictException ex) {
                this.refreshReference(targetRef);
                if (retries <= 0) {
                    throw ex;
                }
                --retries;
                continue;
            }
            break;
        }
    }

    private String commit$default$4() {
        return "delta commit";
    }

    private String commit$default$5() {
        return null;
    }

    public void writeInternal(Path path, Iterator<String> actions, String ref, String hash) {
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        if (!fs.exists(path.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
        }
        if (fs.exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        boolean streamClosed = false;
        boolean commitDone = false;
        FSDataOutputStream stream = fs.create(path);
        try {
            actions.map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                stream.write(x$1);
                return BoxedUnit.UNIT;
            });
            stream.close();
            streamClosed = true;
            try {
                commitDone = this.commit(path, ref, hash, this.commit$default$4(), this.commit$default$5());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!commitDone) {
                fs.delete(path, false);
            }
        }
    }

    public ContentsKey pathToKey(Path path) {
        return this.pathToKey(path.toUri().getPath());
    }

    public ContentsKey pathToKey(String path) {
        List parts = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).toList();
        return ContentsKey.of((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)parts).asJava());
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] stringArray;
        String[] segments = path.getName().split("\\.");
        String[] stringArray2 = segments;
        Object object = stringArray2 != null && (stringArray = stringArray2).length == 6 ? new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[4])).toInt())) : None$.MODULE$;
        return object;
    }

    public DeltaFileType getFileType(Path path) {
        Path path2 = path;
        DeltaFileType deltaFileType = this.checkpointFilePattern().matcher(path.getName()).matches() ? DeltaFileType$CHECKPOINT$.MODULE$ : (this.deltaFilePattern().matcher(path.getName()).matches() ? DeltaFileType$DELTA$.MODULE$ : (this.checksumFilePattern().matcher(path.getName()).matches() ? DeltaFileType$CHECKSUM$.MODULE$ : DeltaFileType$UNKNOWN$.MODULE$));
        return deltaFileType;
    }

    public LogFileMeta extractMeta(FileStatus fileStatus) {
        return new LogFileMeta(fileStatus, this.extractVersion(fileStatus.getPath()), this.getFileType(fileStatus.getPath()), this.numCheckpointParts(fileStatus.getPath()));
    }

    public long extractVersion(Path path) {
        DeltaFileType deltaFileType = this.getFileType(path);
        long l = ((Object)DeltaFileType$DELTA$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".json").split("-")[0])).toLong() : (((Object)DeltaFileType$CHECKPOINT$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0].split("-")[0])).toLong() : (((Object)DeltaFileType$CHECKSUM$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".crc").split("-")[0])).toLong() : -1L));
        return l;
    }

    public Iterator<LogFileMeta> listFilesFrom(Path path2) {
        FileSystem fs = path2.getFileSystem(this.hadoopConf);
        if (!fs.exists(path2.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path2.getParent()).toString());
        }
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(path2.toUri().getPath());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        Tuple3 tuple33 = tuple32;
        String tableName2 = (String)tuple33._1();
        String ref2 = (String)tuple33._2();
        String hash2 = (String)tuple33._3();
        String name = null;
        name = hash2 != null ? hash2 : (ref2 != null ? ref2 : this.configuredRef().getName());
        Option<DeltaLakeTable> currentTable = this.getTable(new Path(tableName2).getParent(), name);
        Set currentMetadataPath = (Set)currentTable.map((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8.getMetadataLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> new Path(x$9), Buffer$.MODULE$.canBuildFrom())).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FileNotFoundException(new StringBuilder(15).append("No such table: ").append(path2).toString());
        });
        Set currentPath = ((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory() != null ? (Set)currentMetadataPath.$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> new Path(x$10), Buffer$.MODULE$.canBuildFrom())) : currentMetadataPath;
        long requestedVersion = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> FileNames$.MODULE$.getFileVersion(path2)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path2.getName())).stripSuffix(".checkpoint"))).toLong()));
        FileStatus[] files = fs.listStatus(path2.getParent());
        LogFileMeta[] filteredFiles = (LogFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)fileStatus -> this.extractMeta((FileStatus)fileStatus), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)currentPath.contains((Object)x.fileStatus().getPath()))))).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$9(requestedVersion, x$11))))).sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.version()), (Ordering)Ordering.Long$.MODULE$);
        None$ maxExpected = currentPath.nonEmpty() ? new Some(((TraversableOnce)currentPath.map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)this.extractVersion(path)), Set$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        None$ maxFound = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).nonEmpty() ? new Some(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.version()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)maxFound.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) == BoxesRunTime.unboxToLong((Object)maxExpected.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), () -> NessieLogStore.$anonfun$listFilesFrom$15((Option)maxFound, (Option)maxExpected));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.fileType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DeltaFileType.class))))).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$19(x$15))) == filteredFiles.length ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.emptyCheckpoint(requestedVersion, (LogFileMeta)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).head()), (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).iterator() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).iterator();
    }

    private LogFileMeta emptyCheckpoint(long version, LogFileMeta logFileMeta) {
        FileStatus fileStatus = new FileStatus(0L, false, 0, 0L, logFileMeta.fileStatus().getModificationTime(), FileNames$.MODULE$.deltaFile(logFileMeta.fileStatus().getPath().getParent(), version));
        return new LogFileMeta(fileStatus, version, DeltaFileType$DELTA$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    private Option<DeltaLakeTable> getTable(Path path, String branch) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.client().getContentsApi().getContents(this.pathToKey(path), branch)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$getTable$2(x))).map((Function1 & Serializable & scala.Serializable)x$16 -> (DeltaLakeTable)x$16).toOption();
    }

    @Override
    public Seq<String> read(Path path) {
        Seq seq;
        if (path.getName().equals("_last_checkpoint")) {
            Option<DeltaLakeTable> table = this.getTable(path.getParent(), this.configuredRef().getName());
            String data = (String)table.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.getLastCheckpoint()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new FileNotFoundException();
            });
            if (data == null) {
                throw new FileNotFoundException();
            }
            seq = (Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$);
        } else {
            FileSystem fs = path.getFileSystem(this.hadoopConf);
            try (FSDataInputStream stream = fs.open(path);){
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((Reader)reader)).asScala()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.trim(), Buffer$.MODULE$.canBuildFrom());
            }
        }
        return seq;
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return true;
    }

    @Override
    public Path resolveCheckpointPath(Path path) {
        this.lastSnapshotUuid_$eq((Option<String>)new Some((Object)UUID.randomUUID().toString()));
        return path.getFileSystem(this.hadoopConf).makeQualified(new Path(path, (String)this.lastSnapshotUuid().get()));
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Map liftedTree1$1(String requestedRef$1) {
        void v0;
        try {
            void var3_3;
            Reference ref = (Reference)Option$.MODULE$.apply((Object)requestedRef$1).map((Function1 & Serializable & scala.Serializable)x$1 -> this.client().getTreeApi().getReferenceByName((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.client().getTreeApi().getDefaultBranch());
            HashMap<String, Reference> map = new HashMap<String, Reference>();
            map.put(requestedRef$1, ref);
            v0 = var3_3;
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef$1 != null) {
                throw new IllegalArgumentException(new StringBuilder(104).append("Nessie ref ").append(requestedRef$1).append(" provided ").append("via ").append("nessie.ref").append(" does not exist. This ref must exist before creating a NessieCatalog.").toString(), ex);
            }
            throw new IllegalArgumentException(new StringBuilder(143).append("Nessie does not have an existing default branch. Either configure ").append("an alternative ref via ").append("nessie.ref").append(" or create the default branch on the server.").toString(), ex);
        }
        return v0;
    }

    public static final /* synthetic */ boolean $anonfun$updateDeltaTable$3(NessieLogStore $this, long version$1, String x) {
        return $this.extractVersion(new Path(x)) < version$1;
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$9(long requestedVersion$1, LogFileMeta x$11) {
        return x$11.version() >= requestedVersion$1;
    }

    public static final /* synthetic */ String $anonfun$listFilesFrom$15(Option maxFound$1, Option maxExpected$1) {
        return new StringBuilder(27).append("maxFound(").append(maxFound$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)).append(") != maxExpected(").append(maxExpected$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$19(DeltaFileType x$15) {
        DeltaFileType deltaFileType = x$15;
        DeltaFileType$CHECKPOINT$ deltaFileType$CHECKPOINT$ = DeltaFileType$CHECKPOINT$.MODULE$;
        return !(deltaFileType != null ? !((Object)deltaFileType).equals(deltaFileType$CHECKPOINT$) : deltaFileType$CHECKPOINT$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTable$2(Contents x) {
        return x != null && x instanceof DeltaLakeTable;
    }

    public NessieLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        this.sparkConf = sparkConf;
        this.hadoopConf = hadoopConf;
        LogStore.$init$(this);
        Logging.$init$((Logging)this);
        this.deltaFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.json")).r().pattern();
        this.checksumFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.crc")).r().pattern();
        this.checkpointFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet")).r().pattern();
        this.lastSnapshotUuid = None$.MODULE$;
        this.client = NessieClient.builder().fromConfig(c -> $this.hadoopConf.get(c)).build();
        String requestedRef = hadoopConf.get("nessie.ref");
        this.referenceMap = this.liftedTree1$1(requestedRef);
    }
}

