/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.MultiGetContentsResponse;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MultiGetContentsResponse.ContentsWithKey", generator="Immutables")
@Immutable
public final class ImmutableContentsWithKey
implements MultiGetContentsResponse.ContentsWithKey {
    private final ContentsKey key;
    private final Contents contents;
    private final transient int hashCode;

    private ImmutableContentsWithKey(ContentsKey key, Contents contents) {
        this.key = key;
        this.contents = contents;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="key")
    public ContentsKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="contents")
    public Contents getContents() {
        return this.contents;
    }

    public final ImmutableContentsWithKey withKey(ContentsKey value) {
        if (this.key == value) {
            return this;
        }
        ContentsKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableContentsWithKey(newValue, this.contents);
    }

    public final ImmutableContentsWithKey withContents(Contents value) {
        if (this.contents == value) {
            return this;
        }
        Contents newValue = Objects.requireNonNull(value, "contents");
        return new ImmutableContentsWithKey(this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentsWithKey && this.equalTo((ImmutableContentsWithKey)another);
    }

    private boolean equalTo(ImmutableContentsWithKey another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.key.equals(another.key) && this.contents.equals(another.contents);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.contents.hashCode();
        return h;
    }

    public String toString() {
        return "ContentsWithKey{key=" + this.key + ", contents=" + this.contents + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableContentsWithKey fromJson(Json json) {
        Builder builder = ImmutableContentsWithKey.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.contents != null) {
            builder.contents(json.contents);
        }
        return builder.build();
    }

    public static ImmutableContentsWithKey copyOf(MultiGetContentsResponse.ContentsWithKey instance) {
        if (instance instanceof ImmutableContentsWithKey) {
            return (ImmutableContentsWithKey)instance;
        }
        return ImmutableContentsWithKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MultiGetContentsResponse.ContentsWithKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENTS = 2L;
        private long initBits = 3L;
        @Nullable
        private ContentsKey key;
        @Nullable
        private Contents contents;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MultiGetContentsResponse.ContentsWithKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.contents(instance.getContents());
            return this;
        }

        @JsonProperty(value="key")
        @CanIgnoreReturnValue
        public final Builder key(ContentsKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="contents")
        @CanIgnoreReturnValue
        public final Builder contents(Contents contents) {
            this.contents = Objects.requireNonNull(contents, "contents");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableContentsWithKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentsWithKey(this.key, this.contents);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contents");
            }
            return "Cannot build ContentsWithKey, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MultiGetContentsResponse.ContentsWithKey", generator="Immutables")
    static final class Json
    implements MultiGetContentsResponse.ContentsWithKey {
        @Nullable
        ContentsKey key;
        @Nullable
        Contents contents;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(ContentsKey key) {
            this.key = key;
        }

        @JsonProperty(value="contents")
        public void setContents(Contents contents) {
            this.contents = contents;
        }

        @Override
        public ContentsKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Contents getContents() {
            throw new UnsupportedOperationException();
        }
    }
}

