/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableNamespace;

@JsonSerialize(as=ImmutableNamespace.class)
@JsonDeserialize(as=ImmutableNamespace.class)
@Value.Immutable(prehash=true)
public abstract class Namespace {
    private static final String DOT = ".";
    static final String ERROR_MSG_TEMPLATE = "'%s' is not a valid namespace identifier (should not end with '.')";

    @JsonValue
    public abstract String name();

    public boolean isEmpty() {
        return "".equals(this.name());
    }

    public static Namespace of(String ... elements) {
        Objects.requireNonNull(elements, "elements must be non-null");
        if (elements.length == 0) {
            return ImmutableNamespace.builder().name("").build();
        }
        if (DOT.equals(elements[elements.length - 1])) {
            throw new IllegalArgumentException(String.format(ERROR_MSG_TEMPLATE, Arrays.toString(elements)));
        }
        StringJoiner joiner = new StringJoiner(DOT);
        for (int i = 0; i < elements.length - 1; ++i) {
            joiner.add(elements[i]);
        }
        return ImmutableNamespace.builder().name(joiner.toString()).build();
    }

    public static Namespace of(List<String> elements) {
        Objects.requireNonNull(elements, "elements must be non-null");
        return Namespace.of(elements.toArray(new String[0]));
    }

    public static Namespace parse(String identifier) {
        Objects.requireNonNull(identifier, "identifier must be non-null");
        if (identifier.endsWith(DOT)) {
            throw new IllegalArgumentException(String.format(ERROR_MSG_TEMPLATE, identifier));
        }
        return Namespace.of(identifier.split("\\."));
    }
}

