/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.gc.base.GCUtil;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableLogEntry;
import org.projectnessie.model.LogResponse;

public class TestLiveCommitsSpliterator {
    AtomicInteger commitId = new AtomicInteger();

    @Test
    void testFoundCommitsWithinIndex() {
        ArrayList<LogResponse.LogEntry> allCommits = new ArrayList<LogResponse.LogEntry>(this.generateCommits(10));
        ArrayList traversedCommits = new ArrayList();
        Collections.reverse(allCommits);
        MutableBoolean foundAllCommitHeads = new MutableBoolean(false);
        Consumer<LogResponse.LogEntry> commitHandler = entry -> this.commitHandler((LogResponse.LogEntry)entry, foundAllCommitHeads, 8, traversedCommits);
        GCUtil.traverseLiveCommits((MutableBoolean)foundAllCommitHeads, allCommits.stream(), commitHandler);
        Assertions.assertThat(allCommits.subList(0, 2)).isEqualTo(traversedCommits);
    }

    @Test
    void testFoundCommitsOutsideIndex() {
        ArrayList<LogResponse.LogEntry> allCommits = new ArrayList<LogResponse.LogEntry>(this.generateCommits(5));
        ArrayList traversedCommits = new ArrayList();
        Collections.reverse(allCommits);
        MutableBoolean foundAllCommitHeads = new MutableBoolean(false);
        Consumer<LogResponse.LogEntry> commitHandler = entry -> this.commitHandler((LogResponse.LogEntry)entry, foundAllCommitHeads, 12, traversedCommits);
        GCUtil.traverseLiveCommits((MutableBoolean)foundAllCommitHeads, allCommits.stream(), commitHandler);
        Assertions.assertThat(allCommits).isEqualTo(traversedCommits);
    }

    private List<LogResponse.LogEntry> generateCommits(int num) {
        ArrayList<LogResponse.LogEntry> entries = new ArrayList<LogResponse.LogEntry>();
        IntStream.range(0, num).forEach(i -> {
            ImmutableCommitMeta commitMeta = CommitMeta.builder().hash(String.valueOf(this.commitId.get())).message("commit id: " + this.commitId.getAndIncrement()).commitTime(Instant.now()).build();
            entries.add((LogResponse.LogEntry)ImmutableLogEntry.builder().commitMeta((CommitMeta)commitMeta).build());
        });
        return entries;
    }

    private void commitHandler(LogResponse.LogEntry entry, MutableBoolean foundAllCommitHeads, int lastLiveCommitHeadIndex, List<LogResponse.LogEntry> traversedCommits) {
        if (String.valueOf(lastLiveCommitHeadIndex).equals(entry.getCommitMeta().getHash())) {
            foundAllCommitHeads.setTrue();
        }
        traversedCommits.add(entry);
    }
}

