/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.spark.sql.SparkSession;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.GetRefLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.gc.base.ContentBloomFilter;
import org.projectnessie.gc.base.DistributedIdentifyContents;
import org.projectnessie.gc.base.GCParams;
import org.projectnessie.gc.base.GCUtil;
import org.projectnessie.gc.base.IdentifiedResult;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(GCImpl.class);
    private final GCParams gcParams;

    public GCImpl(GCParams gcParams) {
        this.gcParams = gcParams;
        LOGGER.info("GCImpl with params: {}", (Object)gcParams);
    }

    public IdentifiedResult identifyExpiredContents(SparkSession session) {
        try (NessieApiV1 api = GCUtil.getApi(this.gcParams.getNessieClientConfigs());){
            DistributedIdentifyContents distributedIdentifyContents = new DistributedIdentifyContents(session, this.gcParams);
            List liveReferences = api.getAllReferences().get().getReferences();
            Map<Reference, Instant> droppedReferenceTimeMap = GCImpl.collectDeadReferences(api);
            ArrayList<Reference> allRefs = new ArrayList<Reference>(liveReferences);
            if (droppedReferenceTimeMap.size() > 0) {
                allRefs.addAll(droppedReferenceTimeMap.keySet());
            }
            long bloomFilterSize = this.gcParams.getBloomFilterExpectedEntries() == null ? this.getTotalCommitsInDefaultReference(api) : this.gcParams.getBloomFilterExpectedEntries().longValue();
            Map<String, ContentBloomFilter> liveContentsBloomFilterMap = distributedIdentifyContents.getLiveContentsBloomFilters(allRefs, bloomFilterSize, droppedReferenceTimeMap);
            IdentifiedResult identifiedResult = distributedIdentifyContents.getIdentifiedResults(liveContentsBloomFilterMap, allRefs);
            return identifiedResult;
        }
    }

    private long getTotalCommitsInDefaultReference(NessieApiV1 api) {
        ReferenceMetadata defaultRefMetadata;
        try {
            defaultRefMetadata = api.getReference().refName(api.getDefaultBranch().getName()).fetch(FetchOption.ALL).get().getMetadata();
        }
        catch (NessieNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return defaultRefMetadata.getNumTotalCommits();
    }

    private static Map<Reference, Instant> collectDeadReferences(NessieApiV1 api) {
        Stream reflogStream;
        HashMap<Reference, Instant> droppedReferenceTimeMap = new HashMap<Reference, Instant>();
        try {
            reflogStream = StreamingUtil.getReflogStream((NessieApiV1)api, builder -> (GetRefLogBuilder)builder.filter(String.format("reflog.operation == '%s' || reflog.operation == '%s'", "DELETE_REFERENCE", "ASSIGN_REFERENCE")), (OptionalInt)OptionalInt.empty());
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException(e);
        }
        reflogStream.forEach(entry -> {
            String hash;
            switch (entry.getOperation()) {
                case "DELETE_REFERENCE": {
                    hash = entry.getCommitHash();
                    break;
                }
                case "ASSIGN_REFERENCE": {
                    hash = (String)entry.getSourceHashes().get(0);
                    break;
                }
                default: {
                    throw new RuntimeException(entry.getOperation() + " operation found in dead reflog query");
                }
            }
            switch (entry.getRefType()) {
                case "Branch": {
                    droppedReferenceTimeMap.put((Reference)Branch.of((String)entry.getRefName(), (String)hash), GCImpl.getInstantFromMicros(entry.getOperationTime()));
                    break;
                }
                case "Tag": {
                    droppedReferenceTimeMap.put((Reference)Tag.of((String)entry.getRefName(), (String)hash), GCImpl.getInstantFromMicros(entry.getOperationTime()));
                    break;
                }
                default: {
                    throw new RuntimeException(entry.getRefType() + " type reference is found in dead reflog query");
                }
            }
        });
        return droppedReferenceTimeMap;
    }

    private static Instant getInstantFromMicros(Long microsSinceEpoch) {
        return Instant.ofEpochSecond(TimeUnit.MICROSECONDS.toSeconds(microsSinceEpoch), TimeUnit.MICROSECONDS.toNanos(Math.floorMod((long)microsSinceEpoch, TimeUnit.SECONDS.toMicros(1L))));
    }
}

