/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.model.LogResponse;

public final class GCUtil {
    private GCUtil() {
    }

    static void traverseLiveCommits(final MutableBoolean foundAllLiveCommitHeadsBeforeCutoffTime, Stream<LogResponse.LogEntry> commits, Consumer<LogResponse.LogEntry> commitHandler) {
        final Spliterator src = commits.spliterator();
        new Spliterators.AbstractSpliterator<LogResponse.LogEntry>(src.estimateSize(), 0){
            private boolean more;
            {
                super(arg0, arg1);
                this.more = true;
            }

            @Override
            public boolean tryAdvance(Consumer<? super LogResponse.LogEntry> action) {
                if (!this.more) {
                    return false;
                }
                this.more = src.tryAdvance((? super T logEntry) -> {
                    if (foundAllLiveCommitHeadsBeforeCutoffTime.isTrue()) {
                        this.more = false;
                    } else {
                        action.accept((LogResponse.LogEntry)logEntry);
                    }
                });
                return this.more;
            }
        }.forEachRemaining(commitHandler);
    }

    static NessieApiV1 getApi(Map<String, String> configuration) {
        HttpClientBuilder builder;
        String clientBuilderClassName = configuration.get("nessie.client-builder-impl");
        if (clientBuilderClassName == null) {
            builder = HttpClientBuilder.builder();
        } else {
            try {
                builder = (NessieClientBuilder)Class.forName(clientBuilderClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("No custom client builder class found for '%s' ", clientBuilderClassName));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Could not initialize '%s': ", clientBuilderClassName), e);
            }
        }
        return (NessieApiV1)builder.fromConfig(configuration::get).build(NessieApiV1.class);
    }
}

