/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.spark.api.java.function.Function;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.gc.base.ContentBloomFilter;
import org.projectnessie.gc.base.GCParams;
import org.projectnessie.gc.base.GCStateParamsPerTask;
import org.projectnessie.gc.base.GCUtil;
import org.projectnessie.gc.base.IdentifiedResult;
import org.projectnessie.gc.base.ImmutableGCStateParamsPerTask;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public class IdentifyContentsPerExecutor
implements Serializable {
    private final GCParams gcParams;

    public IdentifyContentsPerExecutor(GCParams gcParams) {
        this.gcParams = gcParams;
    }

    protected Function<Reference, Map<String, ContentBloomFilter>> computeLiveContentsFunc(long bloomFilterSize, Map<Reference, Instant> droppedRefTimeMap) {
        return (Function & Serializable)reference -> this.computeLiveContents(this.getCutoffTimeForRef((Reference)reference, droppedRefTimeMap), (Reference)reference, (Instant)droppedRefTimeMap.get(reference), bloomFilterSize);
    }

    protected Function<Reference, IdentifiedResult> computeExpiredContentsFunc(Map<String, ContentBloomFilter> liveContentsBloomFilterMap) {
        return (Function & Serializable)reference -> this.computeExpiredContents(liveContentsBloomFilterMap, (Reference)reference);
    }

    private Map<String, ContentBloomFilter> computeLiveContents(Instant cutOffTimestamp, Reference reference, Instant droppedRefTime, long bloomFilterSize) {
        try (NessieApiV1 api = GCUtil.getApi(this.gcParams.getNessieClientConfigs());){
            boolean isRefDroppedAfterCutoffTimeStamp;
            boolean bl = isRefDroppedAfterCutoffTimeStamp = droppedRefTime == null || droppedRefTime.compareTo(cutOffTimestamp) >= 0;
            if (!isRefDroppedAfterCutoffTimeStamp) {
                HashMap<String, ContentBloomFilter> hashMap = new HashMap<String, ContentBloomFilter>();
                return hashMap;
            }
            Predicate<CommitMeta> liveCommitPredicate = commitMeta -> commitMeta.getCommitTime().compareTo(cutOffTimestamp) >= 0;
            ImmutableGCStateParamsPerTask gcStateParamsPerTask = ImmutableGCStateParamsPerTask.builder().api(api).reference(reference).liveCommitPredicate(liveCommitPredicate).bloomFilterSize(bloomFilterSize).build();
            Map<String, ContentBloomFilter> map = this.walkLiveCommitsInReference(gcStateParamsPerTask);
            return map;
        }
    }

    private IdentifiedResult computeExpiredContents(Map<String, ContentBloomFilter> liveContentsBloomFilterMap, Reference reference) {
        try (NessieApiV1 api = GCUtil.getApi(this.gcParams.getNessieClientConfigs());){
            IdentifiedResult identifiedResult = this.walkAllCommitsInReference(api, reference, liveContentsBloomFilterMap);
            return identifiedResult;
        }
    }

    private Map<String, ContentBloomFilter> walkLiveCommitsInReference(GCStateParamsPerTask gcStateParamsPerTask) {
        HashMap<String, ContentBloomFilter> bloomFilterMap = new HashMap<String, ContentBloomFilter>();
        HashSet liveContentKeys = new HashSet();
        try (Stream commits = StreamingUtil.getCommitLogStream((NessieApiV1)gcStateParamsPerTask.getApi(), builder -> ((GetCommitLogBuilder)((GetCommitLogBuilder)builder.hashOnRef(gcStateParamsPerTask.getReference().getHash())).refName("DETACHED")).fetch(FetchOption.ALL), (OptionalInt)OptionalInt.empty());){
            MutableBoolean foundAllLiveCommitHeadsBeforeCutoffTime = new MutableBoolean(false);
            Consumer<LogResponse.LogEntry> commitHandler = logEntry -> this.handleLiveCommit(gcStateParamsPerTask, (LogResponse.LogEntry)logEntry, (Map<String, ContentBloomFilter>)bloomFilterMap, foundAllLiveCommitHeadsBeforeCutoffTime, liveContentKeys);
            GCUtil.traverseLiveCommits(foundAllLiveCommitHeadsBeforeCutoffTime, commits, commitHandler);
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException(e);
        }
        return bloomFilterMap;
    }

    private IdentifiedResult walkAllCommitsInReference(NessieApiV1 api, Reference reference, Map<String, ContentBloomFilter> liveContentsBloomFilterMap) {
        IdentifiedResult result = new IdentifiedResult();
        Instant commitProtectionTime = Instant.now().minus(this.gcParams.getCommitProtectionDuration());
        try (Stream commits = StreamingUtil.getCommitLogStream((NessieApiV1)api, builder -> ((GetCommitLogBuilder)((GetCommitLogBuilder)builder.hashOnRef(reference.getHash())).refName("DETACHED")).fetch(FetchOption.ALL), (OptionalInt)OptionalInt.empty());){
            commits.forEach(logEntry -> {
                if (logEntry.getCommitMeta().getCommitTime().compareTo(commitProtectionTime) < 0) {
                    IdentifyContentsPerExecutor.handleCommitForExpiredContents(reference, logEntry, liveContentsBloomFilterMap, result);
                }
            });
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void handleLiveCommit(GCStateParamsPerTask gcStateParamsPerTask, LogResponse.LogEntry logEntry, Map<String, ContentBloomFilter> bloomFilterMap, MutableBoolean foundAllLiveCommitHeadsBeforeCutoffTime, Set<ContentKey> liveContentKeys) {
        if (logEntry.getOperations() != null) {
            boolean isExpired;
            boolean bl = isExpired = !gcStateParamsPerTask.getLiveCommitPredicate().test(logEntry.getCommitMeta());
            if (isExpired && liveContentKeys.isEmpty()) {
                try {
                    ((GetEntriesBuilder)((GetEntriesBuilder)gcStateParamsPerTask.getApi().getEntries().refName("DETACHED")).hashOnRef(logEntry.getCommitMeta().getHash())).get().getEntries().forEach(entries -> liveContentKeys.add(entries.getName()));
                }
                catch (NessieNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            logEntry.getOperations().stream().filter(operation -> operation instanceof Operation.Put).forEach(operation -> {
                boolean addContent;
                if (liveContentKeys.contains(operation.getKey())) {
                    addContent = true;
                    liveContentKeys.remove(operation.getKey());
                    if (liveContentKeys.isEmpty()) {
                        foundAllLiveCommitHeadsBeforeCutoffTime.setTrue();
                    }
                } else {
                    boolean bl = addContent = !isExpired;
                }
                if (addContent) {
                    Content content = ((Operation.Put)operation).getContent();
                    bloomFilterMap.computeIfAbsent(content.getId(), k -> new ContentBloomFilter(gcStateParamsPerTask.getBloomFilterSize(), this.gcParams.getBloomFilterFpp())).put(content);
                }
            });
        }
    }

    private static void handleCommitForExpiredContents(Reference reference, LogResponse.LogEntry logEntry, Map<String, ContentBloomFilter> liveContentsBloomFilterMap, IdentifiedResult result) {
        if (logEntry.getOperations() != null) {
            logEntry.getOperations().stream().filter(operation -> operation instanceof Operation.Put).forEach(operation -> {
                Content content = ((Operation.Put)operation).getContent();
                ContentBloomFilter bloomFilter = (ContentBloomFilter)liveContentsBloomFilterMap.get(content.getId());
                if (bloomFilter == null || !bloomFilter.mightContain(content)) {
                    result.addContent(reference.getName(), content);
                }
            });
        }
    }

    private Instant getCutoffTimeForRef(Reference reference, Map<Reference, Instant> droppedRefTimeMap) {
        if (droppedRefTimeMap.containsKey(reference) && this.gcParams.getDeadReferenceCutOffTimeStamp() != null) {
            return this.gcParams.getDeadReferenceCutOffTimeStamp();
        }
        return this.gcParams.getCutOffTimestampPerRef() == null ? this.gcParams.getDefaultCutOffTimestamp() : this.gcParams.getCutOffTimestampPerRef().getOrDefault(reference.getName(), this.gcParams.getDefaultCutOffTimestamp());
    }
}

