package org.projectnessie.gc.base;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Reference;

/**
 * Immutable implementation of {@link GCStateParamsPerTask}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGCStateParamsPerTask.builder()}.
 */
@Generated(from = "GCStateParamsPerTask", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableGCStateParamsPerTask implements GCStateParamsPerTask {
  private final NessieApiV1 api;
  private final Reference reference;
  private final Predicate<CommitMeta> liveCommitPredicate;
  private final long bloomFilterSize;

  private ImmutableGCStateParamsPerTask(
      NessieApiV1 api,
      Reference reference,
      Predicate<CommitMeta> liveCommitPredicate,
      long bloomFilterSize) {
    this.api = api;
    this.reference = reference;
    this.liveCommitPredicate = liveCommitPredicate;
    this.bloomFilterSize = bloomFilterSize;
  }

  /**
   * @return The value of the {@code api} attribute
   */
  @Override
  public NessieApiV1 getApi() {
    return api;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @Override
  public Reference getReference() {
    return reference;
  }

  /**
   * @return The value of the {@code liveCommitPredicate} attribute
   */
  @Override
  public Predicate<CommitMeta> getLiveCommitPredicate() {
    return liveCommitPredicate;
  }

  /**
   * @return The value of the {@code bloomFilterSize} attribute
   */
  @Override
  public long getBloomFilterSize() {
    return bloomFilterSize;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCStateParamsPerTask#getApi() api} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for api
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCStateParamsPerTask withApi(NessieApiV1 value) {
    if (this.api == value) return this;
    NessieApiV1 newValue = Objects.requireNonNull(value, "api");
    return new ImmutableGCStateParamsPerTask(newValue, this.reference, this.liveCommitPredicate, this.bloomFilterSize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCStateParamsPerTask#getReference() reference} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCStateParamsPerTask withReference(Reference value) {
    if (this.reference == value) return this;
    Reference newValue = Objects.requireNonNull(value, "reference");
    return new ImmutableGCStateParamsPerTask(this.api, newValue, this.liveCommitPredicate, this.bloomFilterSize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCStateParamsPerTask#getLiveCommitPredicate() liveCommitPredicate} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for liveCommitPredicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCStateParamsPerTask withLiveCommitPredicate(Predicate<CommitMeta> value) {
    if (this.liveCommitPredicate == value) return this;
    Predicate<CommitMeta> newValue = Objects.requireNonNull(value, "liveCommitPredicate");
    return new ImmutableGCStateParamsPerTask(this.api, this.reference, newValue, this.bloomFilterSize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCStateParamsPerTask#getBloomFilterSize() bloomFilterSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bloomFilterSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCStateParamsPerTask withBloomFilterSize(long value) {
    if (this.bloomFilterSize == value) return this;
    return new ImmutableGCStateParamsPerTask(this.api, this.reference, this.liveCommitPredicate, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGCStateParamsPerTask} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGCStateParamsPerTask
        && equalTo(0, (ImmutableGCStateParamsPerTask) another);
  }

  private boolean equalTo(int synthetic, ImmutableGCStateParamsPerTask another) {
    return api.equals(another.api)
        && reference.equals(another.reference)
        && liveCommitPredicate.equals(another.liveCommitPredicate)
        && bloomFilterSize == another.bloomFilterSize;
  }

  /**
   * Computes a hash code from attributes: {@code api}, {@code reference}, {@code liveCommitPredicate}, {@code bloomFilterSize}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + api.hashCode();
    h += (h << 5) + reference.hashCode();
    h += (h << 5) + liveCommitPredicate.hashCode();
    h += (h << 5) + Longs.hashCode(bloomFilterSize);
    return h;
  }

  /**
   * Prints the immutable value {@code GCStateParamsPerTask} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GCStateParamsPerTask")
        .omitNullValues()
        .add("api", api)
        .add("reference", reference)
        .add("liveCommitPredicate", liveCommitPredicate)
        .add("bloomFilterSize", bloomFilterSize)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GCStateParamsPerTask} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GCStateParamsPerTask instance
   */
  public static ImmutableGCStateParamsPerTask copyOf(GCStateParamsPerTask instance) {
    if (instance instanceof ImmutableGCStateParamsPerTask) {
      return (ImmutableGCStateParamsPerTask) instance;
    }
    return ImmutableGCStateParamsPerTask.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGCStateParamsPerTask ImmutableGCStateParamsPerTask}.
   * <pre>
   * ImmutableGCStateParamsPerTask.builder()
   *    .api(org.projectnessie.client.api.NessieApiV1) // required {@link GCStateParamsPerTask#getApi() api}
   *    .reference(org.projectnessie.model.Reference) // required {@link GCStateParamsPerTask#getReference() reference}
   *    .liveCommitPredicate(function.Predicate&amp;lt;org.projectnessie.model.CommitMeta&amp;gt;) // required {@link GCStateParamsPerTask#getLiveCommitPredicate() liveCommitPredicate}
   *    .bloomFilterSize(long) // required {@link GCStateParamsPerTask#getBloomFilterSize() bloomFilterSize}
   *    .build();
   * </pre>
   * @return A new ImmutableGCStateParamsPerTask builder
   */
  public static ImmutableGCStateParamsPerTask.Builder builder() {
    return new ImmutableGCStateParamsPerTask.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGCStateParamsPerTask ImmutableGCStateParamsPerTask}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GCStateParamsPerTask", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_API = 0x1L;
    private static final long INIT_BIT_REFERENCE = 0x2L;
    private static final long INIT_BIT_LIVE_COMMIT_PREDICATE = 0x4L;
    private static final long INIT_BIT_BLOOM_FILTER_SIZE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable NessieApiV1 api;
    private @Nullable Reference reference;
    private @Nullable Predicate<CommitMeta> liveCommitPredicate;
    private long bloomFilterSize;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GCStateParamsPerTask} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GCStateParamsPerTask instance) {
      Objects.requireNonNull(instance, "instance");
      api(instance.getApi());
      reference(instance.getReference());
      liveCommitPredicate(instance.getLiveCommitPredicate());
      bloomFilterSize(instance.getBloomFilterSize());
      return this;
    }

    /**
     * Initializes the value for the {@link GCStateParamsPerTask#getApi() api} attribute.
     * @param api The value for api 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder api(NessieApiV1 api) {
      this.api = Objects.requireNonNull(api, "api");
      initBits &= ~INIT_BIT_API;
      return this;
    }

    /**
     * Initializes the value for the {@link GCStateParamsPerTask#getReference() reference} attribute.
     * @param reference The value for reference 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder reference(Reference reference) {
      this.reference = Objects.requireNonNull(reference, "reference");
      initBits &= ~INIT_BIT_REFERENCE;
      return this;
    }

    /**
     * Initializes the value for the {@link GCStateParamsPerTask#getLiveCommitPredicate() liveCommitPredicate} attribute.
     * @param liveCommitPredicate The value for liveCommitPredicate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder liveCommitPredicate(Predicate<CommitMeta> liveCommitPredicate) {
      this.liveCommitPredicate = Objects.requireNonNull(liveCommitPredicate, "liveCommitPredicate");
      initBits &= ~INIT_BIT_LIVE_COMMIT_PREDICATE;
      return this;
    }

    /**
     * Initializes the value for the {@link GCStateParamsPerTask#getBloomFilterSize() bloomFilterSize} attribute.
     * @param bloomFilterSize The value for bloomFilterSize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bloomFilterSize(long bloomFilterSize) {
      this.bloomFilterSize = bloomFilterSize;
      initBits &= ~INIT_BIT_BLOOM_FILTER_SIZE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGCStateParamsPerTask ImmutableGCStateParamsPerTask}.
     * @return An immutable instance of GCStateParamsPerTask
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGCStateParamsPerTask build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGCStateParamsPerTask(api, reference, liveCommitPredicate, bloomFilterSize);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_API) != 0) attributes.add("api");
      if ((initBits & INIT_BIT_REFERENCE) != 0) attributes.add("reference");
      if ((initBits & INIT_BIT_LIVE_COMMIT_PREDICATE) != 0) attributes.add("liveCommitPredicate");
      if ((initBits & INIT_BIT_BLOOM_FILTER_SIZE) != 0) attributes.add("bloomFilterSize");
      return "Cannot build GCStateParamsPerTask, some of required attributes are not set " + attributes;
    }
  }
}
