/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
public interface GCParams
extends Serializable {
    public Map<String, String> getNessieClientConfigs();

    @Nullable
    public Map<String, Instant> getCutOffTimestampPerRef();

    public Instant getDefaultCutOffTimestamp();

    @Nullable
    public Instant getDeadReferenceCutOffTimeStamp();

    @Nullable
    public Integer getSparkPartitionsCount();

    @Value.Default
    default public Duration getCommitProtectionDuration() {
        return Duration.ofHours(2L);
    }

    @Nullable
    public Long getBloomFilterExpectedEntries();

    @Value.Default
    default public double getBloomFilterFpp() {
        return 0.03;
    }

    @Value.Check
    default public void validate() {
        Integer taskCount = this.getSparkPartitionsCount();
        if (taskCount != null && taskCount <= 0) {
            throw new IllegalArgumentException("taskCount has invalid value: " + taskCount);
        }
        Duration commitProtectionDuration = this.getCommitProtectionDuration();
        if (commitProtectionDuration.isNegative()) {
            throw new IllegalArgumentException("commitProtectionDuration has invalid value: " + commitProtectionDuration);
        }
        Long bloomFilterExpectedEntries = this.getBloomFilterExpectedEntries();
        if (bloomFilterExpectedEntries != null && bloomFilterExpectedEntries < 0L) {
            throw new IllegalArgumentException("bloomFilterExpectedEntries has invalid value: " + bloomFilterExpectedEntries);
        }
        double bloomFilterFpp = this.getBloomFilterFpp();
        if (!(bloomFilterFpp > 0.0) || !(bloomFilterFpp < 1.0)) {
            throw new IllegalArgumentException("bloomFilterFpp has invalid value: " + bloomFilterFpp);
        }
    }
}

