/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.base.GCParams;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GCParams", generator="Immutables")
@Immutable
public final class ImmutableGCParams
implements GCParams {
    private final ImmutableMap<String, String> nessieClientConfigs;
    @Nullable
    private final ImmutableMap<String, Instant> cutOffTimestampPerRef;
    private final Instant defaultCutOffTimestamp;
    @Nullable
    private final Instant deadReferenceCutOffTimeStamp;
    @Nullable
    private final Integer sparkPartitionsCount;
    private final Duration commitProtectionDuration;
    @Nullable
    private final Long bloomFilterExpectedEntries;
    private final double bloomFilterFpp;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGCParams(Builder builder) {
        this.nessieClientConfigs = builder.nessieClientConfigs.build();
        this.cutOffTimestampPerRef = builder.cutOffTimestampPerRef == null ? null : builder.cutOffTimestampPerRef.build();
        this.defaultCutOffTimestamp = builder.defaultCutOffTimestamp;
        this.deadReferenceCutOffTimeStamp = builder.deadReferenceCutOffTimeStamp;
        this.sparkPartitionsCount = builder.sparkPartitionsCount;
        this.bloomFilterExpectedEntries = builder.bloomFilterExpectedEntries;
        if (builder.commitProtectionDuration != null) {
            this.initShim.commitProtectionDuration(builder.commitProtectionDuration);
        }
        if (builder.bloomFilterFppIsSet()) {
            this.initShim.bloomFilterFpp(builder.bloomFilterFpp);
        }
        this.commitProtectionDuration = this.initShim.getCommitProtectionDuration();
        this.bloomFilterFpp = this.initShim.getBloomFilterFpp();
        this.initShim = null;
    }

    private ImmutableGCParams(ImmutableMap<String, String> nessieClientConfigs, @Nullable ImmutableMap<String, Instant> cutOffTimestampPerRef, Instant defaultCutOffTimestamp, @Nullable Instant deadReferenceCutOffTimeStamp, @Nullable Integer sparkPartitionsCount, Duration commitProtectionDuration, @Nullable Long bloomFilterExpectedEntries, double bloomFilterFpp) {
        this.nessieClientConfigs = nessieClientConfigs;
        this.cutOffTimestampPerRef = cutOffTimestampPerRef;
        this.defaultCutOffTimestamp = defaultCutOffTimestamp;
        this.deadReferenceCutOffTimeStamp = deadReferenceCutOffTimeStamp;
        this.sparkPartitionsCount = sparkPartitionsCount;
        this.commitProtectionDuration = commitProtectionDuration;
        this.bloomFilterExpectedEntries = bloomFilterExpectedEntries;
        this.bloomFilterFpp = bloomFilterFpp;
        this.initShim = null;
    }

    private Duration getCommitProtectionDurationInitialize() {
        return GCParams.super.getCommitProtectionDuration();
    }

    private double getBloomFilterFppInitialize() {
        return GCParams.super.getBloomFilterFpp();
    }

    public ImmutableMap<String, String> getNessieClientConfigs() {
        return this.nessieClientConfigs;
    }

    @Nullable
    public ImmutableMap<String, Instant> getCutOffTimestampPerRef() {
        return this.cutOffTimestampPerRef;
    }

    @Override
    public Instant getDefaultCutOffTimestamp() {
        return this.defaultCutOffTimestamp;
    }

    @Override
    @Nullable
    public Instant getDeadReferenceCutOffTimeStamp() {
        return this.deadReferenceCutOffTimeStamp;
    }

    @Override
    @Nullable
    public Integer getSparkPartitionsCount() {
        return this.sparkPartitionsCount;
    }

    @Override
    public Duration getCommitProtectionDuration() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommitProtectionDuration() : this.commitProtectionDuration;
    }

    @Override
    @Nullable
    public Long getBloomFilterExpectedEntries() {
        return this.bloomFilterExpectedEntries;
    }

    @Override
    public double getBloomFilterFpp() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBloomFilterFpp() : this.bloomFilterFpp;
    }

    public final ImmutableGCParams withNessieClientConfigs(Map<String, ? extends String> entries) {
        if (this.nessieClientConfigs == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return ImmutableGCParams.validate(new ImmutableGCParams((ImmutableMap<String, String>)newValue, this.cutOffTimestampPerRef, this.defaultCutOffTimestamp, this.deadReferenceCutOffTimeStamp, this.sparkPartitionsCount, this.commitProtectionDuration, this.bloomFilterExpectedEntries, this.bloomFilterFpp));
    }

    public final ImmutableGCParams withCutOffTimestampPerRef(@Nullable Map<String, ? extends Instant> entries) {
        if (this.cutOffTimestampPerRef == entries) {
            return this;
        }
        ImmutableMap newValue = entries == null ? null : ImmutableMap.copyOf(entries);
        return ImmutableGCParams.validate(new ImmutableGCParams(this.nessieClientConfigs, (ImmutableMap<String, Instant>)newValue, this.defaultCutOffTimestamp, this.deadReferenceCutOffTimeStamp, this.sparkPartitionsCount, this.commitProtectionDuration, this.bloomFilterExpectedEntries, this.bloomFilterFpp));
    }

    public final ImmutableGCParams withDefaultCutOffTimestamp(Instant value) {
        if (this.defaultCutOffTimestamp == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "defaultCutOffTimestamp");
        return ImmutableGCParams.validate(new ImmutableGCParams(this.nessieClientConfigs, this.cutOffTimestampPerRef, newValue, this.deadReferenceCutOffTimeStamp, this.sparkPartitionsCount, this.commitProtectionDuration, this.bloomFilterExpectedEntries, this.bloomFilterFpp));
    }

    public final ImmutableGCParams withDeadReferenceCutOffTimeStamp(@Nullable Instant value) {
        if (this.deadReferenceCutOffTimeStamp == value) {
            return this;
        }
        return ImmutableGCParams.validate(new ImmutableGCParams(this.nessieClientConfigs, this.cutOffTimestampPerRef, this.defaultCutOffTimestamp, value, this.sparkPartitionsCount, this.commitProtectionDuration, this.bloomFilterExpectedEntries, this.bloomFilterFpp));
    }

    public final ImmutableGCParams withSparkPartitionsCount(@Nullable Integer value) {
        if (Objects.equals(this.sparkPartitionsCount, value)) {
            return this;
        }
        return ImmutableGCParams.validate(new ImmutableGCParams(this.nessieClientConfigs, this.cutOffTimestampPerRef, this.defaultCutOffTimestamp, this.deadReferenceCutOffTimeStamp, value, this.commitProtectionDuration, this.bloomFilterExpectedEntries, this.bloomFilterFpp));
    }

    public final ImmutableGCParams withCommitProtectionDuration(Duration value) {
        if (this.commitProtectionDuration == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "commitProtectionDuration");
        return ImmutableGCParams.validate(new ImmutableGCParams(this.nessieClientConfigs, this.cutOffTimestampPerRef, this.defaultCutOffTimestamp, this.deadReferenceCutOffTimeStamp, this.sparkPartitionsCount, newValue, this.bloomFilterExpectedEntries, this.bloomFilterFpp));
    }

    public final ImmutableGCParams withBloomFilterExpectedEntries(@Nullable Long value) {
        if (Objects.equals(this.bloomFilterExpectedEntries, value)) {
            return this;
        }
        return ImmutableGCParams.validate(new ImmutableGCParams(this.nessieClientConfigs, this.cutOffTimestampPerRef, this.defaultCutOffTimestamp, this.deadReferenceCutOffTimeStamp, this.sparkPartitionsCount, this.commitProtectionDuration, value, this.bloomFilterFpp));
    }

    public final ImmutableGCParams withBloomFilterFpp(double value) {
        if (Double.doubleToLongBits(this.bloomFilterFpp) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableGCParams.validate(new ImmutableGCParams(this.nessieClientConfigs, this.cutOffTimestampPerRef, this.defaultCutOffTimestamp, this.deadReferenceCutOffTimeStamp, this.sparkPartitionsCount, this.commitProtectionDuration, this.bloomFilterExpectedEntries, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGCParams && this.equalTo(0, (ImmutableGCParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableGCParams another) {
        return this.nessieClientConfigs.equals(another.nessieClientConfigs) && Objects.equals(this.cutOffTimestampPerRef, another.cutOffTimestampPerRef) && this.defaultCutOffTimestamp.equals(another.defaultCutOffTimestamp) && Objects.equals(this.deadReferenceCutOffTimeStamp, another.deadReferenceCutOffTimeStamp) && Objects.equals(this.sparkPartitionsCount, another.sparkPartitionsCount) && this.commitProtectionDuration.equals(another.commitProtectionDuration) && Objects.equals(this.bloomFilterExpectedEntries, another.bloomFilterExpectedEntries) && Double.doubleToLongBits(this.bloomFilterFpp) == Double.doubleToLongBits(another.bloomFilterFpp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nessieClientConfigs.hashCode();
        h += (h << 5) + Objects.hashCode(this.cutOffTimestampPerRef);
        h += (h << 5) + this.defaultCutOffTimestamp.hashCode();
        h += (h << 5) + Objects.hashCode(this.deadReferenceCutOffTimeStamp);
        h += (h << 5) + Objects.hashCode(this.sparkPartitionsCount);
        h += (h << 5) + this.commitProtectionDuration.hashCode();
        h += (h << 5) + Objects.hashCode(this.bloomFilterExpectedEntries);
        h += (h << 5) + Doubles.hashCode((double)this.bloomFilterFpp);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GCParams").omitNullValues().add("nessieClientConfigs", this.nessieClientConfigs).add("cutOffTimestampPerRef", this.cutOffTimestampPerRef).add("defaultCutOffTimestamp", (Object)this.defaultCutOffTimestamp).add("deadReferenceCutOffTimeStamp", (Object)this.deadReferenceCutOffTimeStamp).add("sparkPartitionsCount", (Object)this.sparkPartitionsCount).add("commitProtectionDuration", (Object)this.commitProtectionDuration).add("bloomFilterExpectedEntries", (Object)this.bloomFilterExpectedEntries).add("bloomFilterFpp", this.bloomFilterFpp).toString();
    }

    private static ImmutableGCParams validate(ImmutableGCParams instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableGCParams copyOf(GCParams instance) {
        if (instance instanceof ImmutableGCParams) {
            return (ImmutableGCParams)instance;
        }
        return ImmutableGCParams.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableGCParams.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GCParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DEFAULT_CUT_OFF_TIMESTAMP = 1L;
        private static final long OPT_BIT_BLOOM_FILTER_FPP = 1L;
        private long initBits = 1L;
        private long optBits;
        private ImmutableMap.Builder<String, String> nessieClientConfigs = ImmutableMap.builder();
        private ImmutableMap.Builder<String, Instant> cutOffTimestampPerRef = null;
        @Nullable
        private Instant defaultCutOffTimestamp;
        @Nullable
        private Instant deadReferenceCutOffTimeStamp;
        @Nullable
        private Integer sparkPartitionsCount;
        @Nullable
        private Duration commitProtectionDuration;
        @Nullable
        private Long bloomFilterExpectedEntries;
        private double bloomFilterFpp;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GCParams instance) {
            Integer sparkPartitionsCountValue;
            Objects.requireNonNull(instance, "instance");
            this.putAllNessieClientConfigs(instance.getNessieClientConfigs());
            Map<String, Instant> cutOffTimestampPerRefValue = instance.getCutOffTimestampPerRef();
            if (cutOffTimestampPerRefValue != null) {
                this.putAllCutOffTimestampPerRef(cutOffTimestampPerRefValue);
            }
            this.defaultCutOffTimestamp(instance.getDefaultCutOffTimestamp());
            Instant deadReferenceCutOffTimeStampValue = instance.getDeadReferenceCutOffTimeStamp();
            if (deadReferenceCutOffTimeStampValue != null) {
                this.deadReferenceCutOffTimeStamp(deadReferenceCutOffTimeStampValue);
            }
            if ((sparkPartitionsCountValue = instance.getSparkPartitionsCount()) != null) {
                this.sparkPartitionsCount(sparkPartitionsCountValue);
            }
            this.commitProtectionDuration(instance.getCommitProtectionDuration());
            Long bloomFilterExpectedEntriesValue = instance.getBloomFilterExpectedEntries();
            if (bloomFilterExpectedEntriesValue != null) {
                this.bloomFilterExpectedEntries(bloomFilterExpectedEntriesValue);
            }
            this.bloomFilterFpp(instance.getBloomFilterFpp());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNessieClientConfigs(String key, String value) {
            this.nessieClientConfigs.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putNessieClientConfigs(Map.Entry<String, ? extends String> entry) {
            this.nessieClientConfigs.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nessieClientConfigs(Map<String, ? extends String> entries) {
            this.nessieClientConfigs = ImmutableMap.builder();
            return this.putAllNessieClientConfigs(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllNessieClientConfigs(Map<String, ? extends String> entries) {
            this.nessieClientConfigs.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCutOffTimestampPerRef(String key, Instant value) {
            if (this.cutOffTimestampPerRef == null) {
                this.cutOffTimestampPerRef = ImmutableMap.builder();
            }
            this.cutOffTimestampPerRef.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCutOffTimestampPerRef(Map.Entry<String, ? extends Instant> entry) {
            if (this.cutOffTimestampPerRef == null) {
                this.cutOffTimestampPerRef = ImmutableMap.builder();
            }
            this.cutOffTimestampPerRef.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cutOffTimestampPerRef(@Nullable Map<String, ? extends Instant> entries) {
            if (entries == null) {
                this.cutOffTimestampPerRef = null;
                return this;
            }
            this.cutOffTimestampPerRef = ImmutableMap.builder();
            return this.putAllCutOffTimestampPerRef(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCutOffTimestampPerRef(Map<String, ? extends Instant> entries) {
            if (this.cutOffTimestampPerRef == null) {
                this.cutOffTimestampPerRef = ImmutableMap.builder();
            }
            this.cutOffTimestampPerRef.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultCutOffTimestamp(Instant defaultCutOffTimestamp) {
            this.defaultCutOffTimestamp = Objects.requireNonNull(defaultCutOffTimestamp, "defaultCutOffTimestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deadReferenceCutOffTimeStamp(@Nullable Instant deadReferenceCutOffTimeStamp) {
            this.deadReferenceCutOffTimeStamp = deadReferenceCutOffTimeStamp;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sparkPartitionsCount(@Nullable Integer sparkPartitionsCount) {
            this.sparkPartitionsCount = sparkPartitionsCount;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitProtectionDuration(Duration commitProtectionDuration) {
            this.commitProtectionDuration = Objects.requireNonNull(commitProtectionDuration, "commitProtectionDuration");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bloomFilterExpectedEntries(@Nullable Long bloomFilterExpectedEntries) {
            this.bloomFilterExpectedEntries = bloomFilterExpectedEntries;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bloomFilterFpp(double bloomFilterFpp) {
            this.bloomFilterFpp = bloomFilterFpp;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableGCParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableGCParams.validate(new ImmutableGCParams(this));
        }

        private boolean bloomFilterFppIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("defaultCutOffTimestamp");
            }
            return "Cannot build GCParams, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GCParams", generator="Immutables")
    private final class InitShim {
        private byte commitProtectionDurationBuildStage = 0;
        private Duration commitProtectionDuration;
        private byte bloomFilterFppBuildStage = 0;
        private double bloomFilterFpp;

        private InitShim() {
        }

        Duration getCommitProtectionDuration() {
            if (this.commitProtectionDurationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitProtectionDurationBuildStage == 0) {
                this.commitProtectionDurationBuildStage = (byte)-1;
                this.commitProtectionDuration = Objects.requireNonNull(ImmutableGCParams.this.getCommitProtectionDurationInitialize(), "commitProtectionDuration");
                this.commitProtectionDurationBuildStage = 1;
            }
            return this.commitProtectionDuration;
        }

        void commitProtectionDuration(Duration commitProtectionDuration) {
            this.commitProtectionDuration = commitProtectionDuration;
            this.commitProtectionDurationBuildStage = 1;
        }

        double getBloomFilterFpp() {
            if (this.bloomFilterFppBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bloomFilterFppBuildStage == 0) {
                this.bloomFilterFppBuildStage = (byte)-1;
                this.bloomFilterFpp = ImmutableGCParams.this.getBloomFilterFppInitialize();
                this.bloomFilterFppBuildStage = 1;
            }
            return this.bloomFilterFpp;
        }

        void bloomFilterFpp(double bloomFilterFpp) {
            this.bloomFilterFpp = bloomFilterFpp;
            this.bloomFilterFppBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.commitProtectionDurationBuildStage == -1) {
                attributes.add("commitProtectionDuration");
            }
            if (this.bloomFilterFppBuildStage == -1) {
                attributes.add("bloomFilterFpp");
            }
            return "Cannot build GCParams, attribute initializers form cycle " + attributes;
        }
    }
}

