/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.gc.base.ContentValues;
import org.projectnessie.gc.base.GCImpl;
import org.projectnessie.gc.base.GCParams;
import org.projectnessie.gc.base.IdentifiedResult;
import org.projectnessie.gc.base.ImmutableGCParams;
import org.projectnessie.jaxrs.AbstractRest;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestGC
extends AbstractRest {
    @NotNull
    List<LogResponse.LogEntry> fetchLogEntries(Branch branch, int numCommits) throws NessieNotFoundException {
        return ((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).hashOnRef(branch.getHash())).fetch(FetchOption.ALL).maxRecords(numCommits)).get().getLogEntries();
    }

    void fillExpectedContents(Branch branch, int numCommits, IdentifiedResult expected) throws NessieNotFoundException {
        this.fetchLogEntries(branch, numCommits).stream().map(LogResponse.LogEntry::getOperations).filter(Objects::nonNull).flatMap(Collection::stream).filter(op -> op instanceof Operation.Put).forEach(op -> {
            Content content = ((Operation.Put)op).getContent();
            expected.addContent(branch.getName(), content);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performGc(Instant cutoffTimeStamp, Map<String, Instant> cutOffTimeStampPerRef, IdentifiedResult expectedExpired, List<String> involvedRefs, boolean disableCommitProtection, Instant deadReferenceCutoffTime) {
        spark.sparkContext().setLogLevel("WARN");
        try (SparkSession spark = SparkSession.builder().appName("test-nessie-gc").master("local[2]").getOrCreate();){
            ImmutableGCParams.Builder builder = ImmutableGCParams.builder();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("nessie.uri", this.getUri().toString());
            if (disableCommitProtection) {
                builder.commitProtectionDuration(Duration.ZERO);
            }
            ImmutableGCParams gcParams = builder.bloomFilterExpectedEntries(Long.valueOf(5L)).nessieClientConfigs(options).deadReferenceCutOffTimeStamp(deadReferenceCutoffTime).cutOffTimestampPerRef(cutOffTimeStampPerRef).defaultCutOffTimestamp(cutoffTimeStamp).build();
            GCImpl gc = new GCImpl((GCParams)gcParams);
            IdentifiedResult identifiedResult = gc.identifyExpiredContents(spark);
            this.verify(identifiedResult, expectedExpired, involvedRefs);
        }
    }

    private void verify(IdentifiedResult identifiedResult, IdentifiedResult expectedExpired, List<String> involvedRefs) {
        Assertions.assertThat((Map)identifiedResult.getContentValues()).isNotNull();
        involvedRefs.forEach(ref -> this.compareContentsPerRef(identifiedResult.getContentValuesForReference(ref), expectedExpired.getContentValuesForReference(ref)));
    }

    void compareContentsPerRef(Map<String, ContentValues> actualMap, Map<String, ContentValues> expectedMap) {
        Assertions.assertThat((int)actualMap.size()).isEqualTo(expectedMap.size());
        actualMap.keySet().forEach(contentId -> this.compareContents((ContentValues)actualMap.get(contentId), (ContentValues)expectedMap.get(contentId)));
    }

    void compareContents(ContentValues actual, ContentValues expected) {
        if (actual == null && expected == null) {
            return;
        }
        Assertions.assertThat((Object)actual).isNotNull();
        Assertions.assertThat((Object)expected).isNotNull();
        Assertions.assertThat((int)actual.getExpiredContents().size()).isEqualTo(expected.getExpiredContents().size());
        ArrayList<Content> expectedContents = new ArrayList<Content>(expected.getExpiredContents());
        expectedContents.sort(new ContentComparator());
        ArrayList<Content> actualContents = new ArrayList<Content>(actual.getExpiredContents());
        actualContents.sort(new ContentComparator());
        for (int i = 0; i < expectedContents.size(); ++i) {
            this.compareContent((Content)expectedContents.get(i), (Content)actualContents.get(i));
        }
    }

    void compareContent(Content actual, Content expected) {
        switch (expected.getType()) {
            case ICEBERG_TABLE: {
                Assertions.assertThat((Object)((IcebergTable)actual)).extracting(IcebergTable::getSnapshotId).isEqualTo((Object)((IcebergTable)expected).getSnapshotId());
                break;
            }
            case ICEBERG_VIEW: {
                Assertions.assertThat((Object)((IcebergView)actual)).extracting(IcebergView::getVersionId).isEqualTo((Object)((IcebergView)expected).getVersionId());
                break;
            }
            default: {
                Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
            }
        }
    }

    CommitOutput commitSingleOp(String prefix, Reference branch, String currentHash, long snapshotId, String contentId, String contentKey, String metadataFile, IcebergTable previous, String beforeRename) throws NessieNotFoundException, NessieConflictException {
        IcebergTable meta = IcebergTable.of((String)(prefix + "_" + metadataFile), (long)snapshotId, (int)42, (int)42, (int)42, (String)(prefix + "_" + contentId));
        CommitMultipleOperationsBuilder multiOp = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(currentHash)).commitMeta((CommitMeta)CommitMeta.builder().author("someone").message("some commit").properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{prefix + "_" + contentKey}), (Content)meta, (Content)previous));
        if (beforeRename != null) {
            multiOp.operation((Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{prefix + "_" + beforeRename})));
        }
        String nextHash = multiOp.commit().getHash();
        Assertions.assertThat((String)currentHash).isNotEqualTo((Object)nextHash);
        return new CommitOutput(nextHash, meta);
    }

    CommitOutput dropTableCommit(String prefix, Reference branch, String currentHash, String contentKey) throws NessieNotFoundException, NessieConflictException {
        String nextHash = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(currentHash)).commitMeta((CommitMeta)CommitMeta.builder().author("someone").message("some commit").properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{prefix + "_" + contentKey}))).commit().getHash();
        Assertions.assertThat((String)currentHash).isNotEqualTo((Object)nextHash);
        return new CommitOutput(nextHash, null);
    }

    static final class CommitOutput {
        final String hash;
        final IcebergTable content;

        CommitOutput(String hash, IcebergTable content) {
            this.hash = hash;
            this.content = content;
        }
    }

    static class ContentComparator
    implements Comparator<Content> {
        ContentComparator() {
        }

        @Override
        public int compare(Content c1, Content c2) {
            switch (c1.getType()) {
                case ICEBERG_TABLE: {
                    return Long.compare(((IcebergTable)c1).getSnapshotId(), ((IcebergTable)c2).getSnapshotId());
                }
                case ICEBERG_VIEW: {
                    return Integer.compare(((IcebergView)c1).getVersionId(), ((IcebergView)c2).getVersionId());
                }
            }
            return c1.getId().compareTo(c2.getId());
        }
    }
}

