/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.io.TempDir;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.gc.base.GCImpl;
import org.projectnessie.gc.base.GCParams;
import org.projectnessie.gc.base.IdentifiedResultsRepo;
import org.projectnessie.gc.base.ImmutableGCParams;
import org.projectnessie.jaxrs.AbstractRest;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;

public abstract class AbstractRestGC
extends AbstractRest {
    @TempDir
    File tempDir;

    @NotNull
    List<LogResponse.LogEntry> fetchLogEntries(Branch branch, int numCommits) throws NessieNotFoundException {
        return ((GetCommitLogBuilder)((GetCommitLogBuilder)((GetCommitLogBuilder)this.getApi().getCommitLog().refName(branch.getName())).hashOnRef(branch.getHash())).fetch(FetchOption.ALL).maxRecords(numCommits)).get().getLogEntries();
    }

    void fillExpectedContents(Branch branch, int numCommits, List<Row> expected) throws NessieNotFoundException {
        this.fetchLogEntries(branch, numCommits).stream().map(LogResponse.LogEntry::getOperations).filter(Objects::nonNull).flatMap(Collection::stream).filter(op -> op instanceof Operation.Put).forEach(op -> {
            IcebergTable content = (IcebergTable)((Operation.Put)op).getContent();
            expected.add(RowFactory.create((Object[])new Object[]{Timestamp.from(Instant.now()), "dummyRunId", content.getId(), null, content.getSnapshotId(), branch.getName(), null}));
        });
    }

    protected void performGc(String prefix, Instant cutoffTimeStamp, Map<String, Instant> cutOffTimeStampPerRef, List<Row> expectedDataSet, boolean disableCommitProtection, Instant deadReferenceCutoffTime) {
        try (SparkSession sparkSession = this.getSparkSession();){
            ImmutableGCParams.Builder builder = ImmutableGCParams.builder();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("nessie.uri", this.getUri().toString());
            if (disableCommitProtection) {
                builder.commitProtectionDuration(Duration.ZERO);
            }
            ImmutableGCParams gcParams = builder.bloomFilterExpectedEntries(Long.valueOf(5L)).nessieClientConfigs(options).deadReferenceCutOffTimeStamp(deadReferenceCutoffTime).cutOffTimestampPerRef(cutOffTimeStampPerRef).defaultCutOffTimestamp(cutoffTimeStamp).nessieCatalogName("nessie").outputBranchName("gcBranch").outputTableIdentifier(prefix + ".gc_results").build();
            GCImpl gc = new GCImpl((GCParams)gcParams);
            String runId = gc.identifyExpiredContents(sparkSession);
            IdentifiedResultsRepo actualIdentifiedResultsRepo = new IdentifiedResultsRepo(sparkSession, gcParams.getNessieCatalogName(), gcParams.getOutputBranchName(), gcParams.getOutputTableIdentifier());
            Dataset actualRowDataset = actualIdentifiedResultsRepo.collectExpiredContentsAsDataSet(runId);
            this.verify((Dataset<Row>)actualRowDataset, expectedDataSet, sparkSession, actualIdentifiedResultsRepo.getSchema());
        }
    }

    protected SparkSession getSparkSession() {
        SparkConf conf = new SparkConf();
        conf.set("spark.sql.catalog.nessie.uri", this.getUri().toString()).set("spark.sql.catalog.nessie.ref", "main").set("spark.sql.catalog.nessie.warehouse", this.tempDir.toURI().toString()).set("spark.sql.catalog.nessie.catalog-impl", "org.apache.iceberg.nessie.NessieCatalog").set("spark.sql.catalog.nessie", "org.apache.iceberg.spark.SparkCatalog").set("spark.sql.extensions", "org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions,org.projectnessie.spark.extensions.NessieSparkSessionExtensions");
        SparkSession spark = SparkSession.builder().appName("test-nessie-gc").master("local[2]").config(conf).getOrCreate();
        spark.sparkContext().setLogLevel("WARN");
        return spark;
    }

    protected void verify(Dataset<Row> actual, List<Row> expectedRows, SparkSession session, StructType schema) {
        Dataset expected = session.createDataFrame(expectedRows, schema);
        Dataset dfActual = actual.select("referenceName", new String[]{"contentId", "snapshotId"});
        Dataset dfExpected = expected.select("referenceName", new String[]{"contentId", "snapshotId"});
        Assertions.assertThat((long)dfExpected.count()).isEqualTo(dfActual.count());
        Assertions.assertThat((List)dfExpected.except(dfActual).collectAsList()).isEmpty();
    }

    CommitOutput commitSingleOp(String prefix, Reference branch, String currentHash, long snapshotId, String contentId, String contentKey, String metadataFile, IcebergTable previous, String beforeRename) throws NessieNotFoundException, NessieConflictException {
        IcebergTable meta = IcebergTable.of((String)(prefix + "_" + metadataFile), (long)snapshotId, (int)42, (int)42, (int)42, (String)(prefix + "_" + contentId));
        CommitMultipleOperationsBuilder multiOp = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(currentHash)).commitMeta((CommitMeta)CommitMeta.builder().author("someone").message("some commit").properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Put.of((ContentKey)ContentKey.of((String[])new String[]{prefix + "_" + contentKey}), (Content)meta, (Content)previous));
        if (beforeRename != null) {
            multiOp.operation((Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{prefix + "_" + beforeRename})));
        }
        String nextHash = multiOp.commit().getHash();
        Assertions.assertThat((String)currentHash).isNotEqualTo((Object)nextHash);
        return new CommitOutput(nextHash, meta);
    }

    CommitOutput dropTableCommit(String prefix, Reference branch, String currentHash, String contentKey) throws NessieNotFoundException, NessieConflictException {
        String nextHash = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.getApi().commitMultipleOperations().branchName(branch.getName())).hash(currentHash)).commitMeta((CommitMeta)CommitMeta.builder().author("someone").message("some commit").properties((Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2")).build()).operation((Operation)Operation.Delete.of((ContentKey)ContentKey.of((String[])new String[]{prefix + "_" + contentKey}))).commit().getHash();
        Assertions.assertThat((String)currentHash).isNotEqualTo((Object)nextHash);
        return new CommitOutput(nextHash, null);
    }

    static final class CommitOutput {
        final String hash;
        final IcebergTable content;

        CommitOutput(String hash, IcebergTable content) {
            this.hash = hash;
            this.content = content;
        }
    }
}

