/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;

public class ContentBloomFilter
implements Serializable {
    private static final long serialVersionUID = -693336833916979221L;
    private final BloomFilter<String> filter;
    private boolean wasMerged = false;

    public ContentBloomFilter(long expectedEntries, double bloomFilterFpp) {
        this.filter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)StandardCharsets.UTF_8), (long)expectedEntries, (double)bloomFilterFpp);
    }

    public void put(Content content) {
        this.filter.put((Object)this.getValue(content));
    }

    public boolean mightContain(Content content) {
        return this.filter.mightContain((Object)this.getValue(content));
    }

    public void merge(ContentBloomFilter filter) {
        if (filter.filter != null) {
            this.filter.putAll(filter.filter);
            this.wasMerged = true;
        }
    }

    public double getExpectedFpp() {
        return this.filter.expectedFpp();
    }

    public boolean wasMerged() {
        return this.wasMerged;
    }

    private String getValue(Content content) {
        switch (content.getType()) {
            case ICEBERG_TABLE: {
                return Content.Type.ICEBERG_TABLE.name() + ((IcebergTable)content).getSnapshotId();
            }
            case ICEBERG_VIEW: {
                return Content.Type.ICEBERG_VIEW.name() + ((IcebergView)content).getVersionId();
            }
        }
        throw new RuntimeException("Unsupported type " + content.getType());
    }
}

