package org.projectnessie.gc.base;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.ObjectStreamException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GCParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGCParams.builder()}.
 */
@Generated(from = "GCParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGCParams implements GCParams {
  private final ImmutableMap<String, String> nessieClientConfigs;
  private final @Nullable ImmutableMap<String, Instant> cutOffTimestampPerRef;
  private final Instant defaultCutOffTimestamp;
  private final @Nullable Instant deadReferenceCutOffTimeStamp;
  private final @Nullable Integer sparkPartitionsCount;
  private final Duration commitProtectionDuration;
  private final @Nullable Long bloomFilterExpectedEntries;
  private final double bloomFilterFpp;
  private final String nessieCatalogName;
  private final String outputBranchName;
  private final String outputTableIdentifier;

  private ImmutableGCParams(ImmutableGCParams.Builder builder) {
    this.nessieClientConfigs = builder.nessieClientConfigs.build();
    this.cutOffTimestampPerRef = builder.cutOffTimestampPerRef == null ? null : builder.cutOffTimestampPerRef.build();
    this.defaultCutOffTimestamp = builder.defaultCutOffTimestamp;
    this.deadReferenceCutOffTimeStamp = builder.deadReferenceCutOffTimeStamp;
    this.sparkPartitionsCount = builder.sparkPartitionsCount;
    this.bloomFilterExpectedEntries = builder.bloomFilterExpectedEntries;
    this.nessieCatalogName = builder.nessieCatalogName;
    this.outputBranchName = builder.outputBranchName;
    this.outputTableIdentifier = builder.outputTableIdentifier;
    if (builder.commitProtectionDuration != null) {
      initShim.commitProtectionDuration(builder.commitProtectionDuration);
    }
    if (builder.bloomFilterFppIsSet()) {
      initShim.bloomFilterFpp(builder.bloomFilterFpp);
    }
    this.commitProtectionDuration = initShim.getCommitProtectionDuration();
    this.bloomFilterFpp = initShim.getBloomFilterFpp();
    this.initShim = null;
  }

  private ImmutableGCParams(
      ImmutableMap<String, String> nessieClientConfigs,
      @Nullable ImmutableMap<String, Instant> cutOffTimestampPerRef,
      Instant defaultCutOffTimestamp,
      @Nullable Instant deadReferenceCutOffTimeStamp,
      @Nullable Integer sparkPartitionsCount,
      Duration commitProtectionDuration,
      @Nullable Long bloomFilterExpectedEntries,
      double bloomFilterFpp,
      String nessieCatalogName,
      String outputBranchName,
      String outputTableIdentifier) {
    this.nessieClientConfigs = nessieClientConfigs;
    this.cutOffTimestampPerRef = cutOffTimestampPerRef;
    this.defaultCutOffTimestamp = defaultCutOffTimestamp;
    this.deadReferenceCutOffTimeStamp = deadReferenceCutOffTimeStamp;
    this.sparkPartitionsCount = sparkPartitionsCount;
    this.commitProtectionDuration = commitProtectionDuration;
    this.bloomFilterExpectedEntries = bloomFilterExpectedEntries;
    this.bloomFilterFpp = bloomFilterFpp;
    this.nessieCatalogName = nessieCatalogName;
    this.outputBranchName = outputBranchName;
    this.outputTableIdentifier = outputTableIdentifier;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GCParams", generator = "Immutables")
  private final class InitShim {
    private byte commitProtectionDurationBuildStage = STAGE_UNINITIALIZED;
    private Duration commitProtectionDuration;

    Duration getCommitProtectionDuration() {
      if (commitProtectionDurationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (commitProtectionDurationBuildStage == STAGE_UNINITIALIZED) {
        commitProtectionDurationBuildStage = STAGE_INITIALIZING;
        this.commitProtectionDuration = Objects.requireNonNull(getCommitProtectionDurationInitialize(), "commitProtectionDuration");
        commitProtectionDurationBuildStage = STAGE_INITIALIZED;
      }
      return this.commitProtectionDuration;
    }

    void commitProtectionDuration(Duration commitProtectionDuration) {
      this.commitProtectionDuration = commitProtectionDuration;
      commitProtectionDurationBuildStage = STAGE_INITIALIZED;
    }

    private byte bloomFilterFppBuildStage = STAGE_UNINITIALIZED;
    private double bloomFilterFpp;

    double getBloomFilterFpp() {
      if (bloomFilterFppBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (bloomFilterFppBuildStage == STAGE_UNINITIALIZED) {
        bloomFilterFppBuildStage = STAGE_INITIALIZING;
        this.bloomFilterFpp = getBloomFilterFppInitialize();
        bloomFilterFppBuildStage = STAGE_INITIALIZED;
      }
      return this.bloomFilterFpp;
    }

    void bloomFilterFpp(double bloomFilterFpp) {
      this.bloomFilterFpp = bloomFilterFpp;
      bloomFilterFppBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (commitProtectionDurationBuildStage == STAGE_INITIALIZING) attributes.add("commitProtectionDuration");
      if (bloomFilterFppBuildStage == STAGE_INITIALIZING) attributes.add("bloomFilterFpp");
      return "Cannot build GCParams, attribute initializers form cycle " + attributes;
    }
  }

  private Duration getCommitProtectionDurationInitialize() {
    return GCParams.super.getCommitProtectionDuration();
  }

  private double getBloomFilterFppInitialize() {
    return GCParams.super.getBloomFilterFpp();
  }

  /**
   *Nessie client configurations from {@link org.projectnessie.client.NessieConfigConstants}. 
   */
  @Override
  public ImmutableMap<String, String> getNessieClientConfigs() {
    return nessieClientConfigs;
  }

  /**
   *Optional cutoff time per live reference. 
   */
  @Override
  public @Nullable ImmutableMap<String, Instant> getCutOffTimestampPerRef() {
    return cutOffTimestampPerRef;
  }

  /**
   *Default cutoff time for all the references. 
   */
  @Override
  public Instant getDefaultCutOffTimestamp() {
    return defaultCutOffTimestamp;
  }

  /**
   *Optional cutoff time for all the dead references. 
   */
  @Override
  public @Nullable Instant getDeadReferenceCutOffTimeStamp() {
    return deadReferenceCutOffTimeStamp;
  }

  /**
   * Optional spark partitions count to be used for distributing references. Default total reference
   * count (live + dead) will be used.
   */
  @Override
  public @Nullable Integer getSparkPartitionsCount() {
    return sparkPartitionsCount;
  }

  /**
   * Commit protection duration to avoid expiring on going or recent commits. Default is 2 hours.
   */
  @Override
  public Duration getCommitProtectionDuration() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCommitProtectionDuration()
        : this.commitProtectionDuration;
  }

  /**
   * Optional bloom filter expected live commits entries per reference. Default is total commits in
   * the default reference.
   */
  @Override
  public @Nullable Long getBloomFilterExpectedEntries() {
    return bloomFilterExpectedEntries;
  }

  /**
   *Optional bloom filter fpp. Default value is 0.03d. 
   */
  @Override
  public double getBloomFilterFpp() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getBloomFilterFpp()
        : this.bloomFilterFpp;
  }

  /**
   *Nessie catalog name to be used with spark to create the output results table. 
   */
  @Override
  public String getNessieCatalogName() {
    return nessieCatalogName;
  }

  /**
   * Branch's name to be used for creating the output table.
   * <p>If the branch doesn't exist for this name, branch with this name pointing to beginning of
   * time (aka NO_ANCESTOR hash) will be created.
   */
  @Override
  public String getOutputBranchName() {
    return outputBranchName;
  }

  /**
   * Output table identifier (namespace and table name) to be used for storing the results in {@link
   * #getOutputBranchName()}.
   */
  @Override
  public String getOutputTableIdentifier() {
    return outputTableIdentifier;
  }

  /**
   * Copy the current immutable object by replacing the {@link GCParams#getNessieClientConfigs() nessieClientConfigs} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the nessieClientConfigs map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGCParams withNessieClientConfigs(Map<String, ? extends String> entries) {
    if (this.nessieClientConfigs == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return validate(new ImmutableGCParams(
        newValue,
        this.cutOffTimestampPerRef,
        this.defaultCutOffTimestamp,
        this.deadReferenceCutOffTimeStamp,
        this.sparkPartitionsCount,
        this.commitProtectionDuration,
        this.bloomFilterExpectedEntries,
        this.bloomFilterFpp,
        this.nessieCatalogName,
        this.outputBranchName,
        this.outputTableIdentifier));
  }

  /**
   * Copy the current immutable object by replacing the {@link GCParams#getCutOffTimestampPerRef() cutOffTimestampPerRef} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the cutOffTimestampPerRef map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGCParams withCutOffTimestampPerRef(@Nullable Map<String, ? extends Instant> entries) {
    if (this.cutOffTimestampPerRef == entries) return this;
    @Nullable ImmutableMap<String, Instant> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return validate(new ImmutableGCParams(
        this.nessieClientConfigs,
        newValue,
        this.defaultCutOffTimestamp,
        this.deadReferenceCutOffTimeStamp,
        this.sparkPartitionsCount,
        this.commitProtectionDuration,
        this.bloomFilterExpectedEntries,
        this.bloomFilterFpp,
        this.nessieCatalogName,
        this.outputBranchName,
        this.outputTableIdentifier));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCParams#getDefaultCutOffTimestamp() defaultCutOffTimestamp} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultCutOffTimestamp
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCParams withDefaultCutOffTimestamp(Instant value) {
    if (this.defaultCutOffTimestamp == value) return this;
    Instant newValue = Objects.requireNonNull(value, "defaultCutOffTimestamp");
    return validate(new ImmutableGCParams(
        this.nessieClientConfigs,
        this.cutOffTimestampPerRef,
        newValue,
        this.deadReferenceCutOffTimeStamp,
        this.sparkPartitionsCount,
        this.commitProtectionDuration,
        this.bloomFilterExpectedEntries,
        this.bloomFilterFpp,
        this.nessieCatalogName,
        this.outputBranchName,
        this.outputTableIdentifier));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCParams#getDeadReferenceCutOffTimeStamp() deadReferenceCutOffTimeStamp} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deadReferenceCutOffTimeStamp (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCParams withDeadReferenceCutOffTimeStamp(@Nullable Instant value) {
    if (this.deadReferenceCutOffTimeStamp == value) return this;
    return validate(new ImmutableGCParams(
        this.nessieClientConfigs,
        this.cutOffTimestampPerRef,
        this.defaultCutOffTimestamp,
        value,
        this.sparkPartitionsCount,
        this.commitProtectionDuration,
        this.bloomFilterExpectedEntries,
        this.bloomFilterFpp,
        this.nessieCatalogName,
        this.outputBranchName,
        this.outputTableIdentifier));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCParams#getSparkPartitionsCount() sparkPartitionsCount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sparkPartitionsCount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCParams withSparkPartitionsCount(@Nullable Integer value) {
    if (Objects.equals(this.sparkPartitionsCount, value)) return this;
    return validate(new ImmutableGCParams(
        this.nessieClientConfigs,
        this.cutOffTimestampPerRef,
        this.defaultCutOffTimestamp,
        this.deadReferenceCutOffTimeStamp,
        value,
        this.commitProtectionDuration,
        this.bloomFilterExpectedEntries,
        this.bloomFilterFpp,
        this.nessieCatalogName,
        this.outputBranchName,
        this.outputTableIdentifier));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCParams#getCommitProtectionDuration() commitProtectionDuration} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitProtectionDuration
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCParams withCommitProtectionDuration(Duration value) {
    if (this.commitProtectionDuration == value) return this;
    Duration newValue = Objects.requireNonNull(value, "commitProtectionDuration");
    return validate(new ImmutableGCParams(
        this.nessieClientConfigs,
        this.cutOffTimestampPerRef,
        this.defaultCutOffTimestamp,
        this.deadReferenceCutOffTimeStamp,
        this.sparkPartitionsCount,
        newValue,
        this.bloomFilterExpectedEntries,
        this.bloomFilterFpp,
        this.nessieCatalogName,
        this.outputBranchName,
        this.outputTableIdentifier));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCParams#getBloomFilterExpectedEntries() bloomFilterExpectedEntries} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bloomFilterExpectedEntries (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCParams withBloomFilterExpectedEntries(@Nullable Long value) {
    if (Objects.equals(this.bloomFilterExpectedEntries, value)) return this;
    return validate(new ImmutableGCParams(
        this.nessieClientConfigs,
        this.cutOffTimestampPerRef,
        this.defaultCutOffTimestamp,
        this.deadReferenceCutOffTimeStamp,
        this.sparkPartitionsCount,
        this.commitProtectionDuration,
        value,
        this.bloomFilterFpp,
        this.nessieCatalogName,
        this.outputBranchName,
        this.outputTableIdentifier));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCParams#getBloomFilterFpp() bloomFilterFpp} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bloomFilterFpp
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCParams withBloomFilterFpp(double value) {
    if (Double.doubleToLongBits(this.bloomFilterFpp) == Double.doubleToLongBits(value)) return this;
    return validate(new ImmutableGCParams(
        this.nessieClientConfigs,
        this.cutOffTimestampPerRef,
        this.defaultCutOffTimestamp,
        this.deadReferenceCutOffTimeStamp,
        this.sparkPartitionsCount,
        this.commitProtectionDuration,
        this.bloomFilterExpectedEntries,
        value,
        this.nessieCatalogName,
        this.outputBranchName,
        this.outputTableIdentifier));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCParams#getNessieCatalogName() nessieCatalogName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nessieCatalogName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCParams withNessieCatalogName(String value) {
    String newValue = Objects.requireNonNull(value, "nessieCatalogName");
    if (this.nessieCatalogName.equals(newValue)) return this;
    return validate(new ImmutableGCParams(
        this.nessieClientConfigs,
        this.cutOffTimestampPerRef,
        this.defaultCutOffTimestamp,
        this.deadReferenceCutOffTimeStamp,
        this.sparkPartitionsCount,
        this.commitProtectionDuration,
        this.bloomFilterExpectedEntries,
        this.bloomFilterFpp,
        newValue,
        this.outputBranchName,
        this.outputTableIdentifier));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCParams#getOutputBranchName() outputBranchName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputBranchName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCParams withOutputBranchName(String value) {
    String newValue = Objects.requireNonNull(value, "outputBranchName");
    if (this.outputBranchName.equals(newValue)) return this;
    return validate(new ImmutableGCParams(
        this.nessieClientConfigs,
        this.cutOffTimestampPerRef,
        this.defaultCutOffTimestamp,
        this.deadReferenceCutOffTimeStamp,
        this.sparkPartitionsCount,
        this.commitProtectionDuration,
        this.bloomFilterExpectedEntries,
        this.bloomFilterFpp,
        this.nessieCatalogName,
        newValue,
        this.outputTableIdentifier));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GCParams#getOutputTableIdentifier() outputTableIdentifier} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputTableIdentifier
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGCParams withOutputTableIdentifier(String value) {
    String newValue = Objects.requireNonNull(value, "outputTableIdentifier");
    if (this.outputTableIdentifier.equals(newValue)) return this;
    return validate(new ImmutableGCParams(
        this.nessieClientConfigs,
        this.cutOffTimestampPerRef,
        this.defaultCutOffTimestamp,
        this.deadReferenceCutOffTimeStamp,
        this.sparkPartitionsCount,
        this.commitProtectionDuration,
        this.bloomFilterExpectedEntries,
        this.bloomFilterFpp,
        this.nessieCatalogName,
        this.outputBranchName,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGCParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGCParams
        && equalTo(0, (ImmutableGCParams) another);
  }

  private boolean equalTo(int synthetic, ImmutableGCParams another) {
    return nessieClientConfigs.equals(another.nessieClientConfigs)
        && Objects.equals(cutOffTimestampPerRef, another.cutOffTimestampPerRef)
        && defaultCutOffTimestamp.equals(another.defaultCutOffTimestamp)
        && Objects.equals(deadReferenceCutOffTimeStamp, another.deadReferenceCutOffTimeStamp)
        && Objects.equals(sparkPartitionsCount, another.sparkPartitionsCount)
        && commitProtectionDuration.equals(another.commitProtectionDuration)
        && Objects.equals(bloomFilterExpectedEntries, another.bloomFilterExpectedEntries)
        && Double.doubleToLongBits(bloomFilterFpp) == Double.doubleToLongBits(another.bloomFilterFpp)
        && nessieCatalogName.equals(another.nessieCatalogName)
        && outputBranchName.equals(another.outputBranchName)
        && outputTableIdentifier.equals(another.outputTableIdentifier);
  }

  /**
   * Computes a hash code from attributes: {@code nessieClientConfigs}, {@code cutOffTimestampPerRef}, {@code defaultCutOffTimestamp}, {@code deadReferenceCutOffTimeStamp}, {@code sparkPartitionsCount}, {@code commitProtectionDuration}, {@code bloomFilterExpectedEntries}, {@code bloomFilterFpp}, {@code nessieCatalogName}, {@code outputBranchName}, {@code outputTableIdentifier}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + nessieClientConfigs.hashCode();
    h += (h << 5) + Objects.hashCode(cutOffTimestampPerRef);
    h += (h << 5) + defaultCutOffTimestamp.hashCode();
    h += (h << 5) + Objects.hashCode(deadReferenceCutOffTimeStamp);
    h += (h << 5) + Objects.hashCode(sparkPartitionsCount);
    h += (h << 5) + commitProtectionDuration.hashCode();
    h += (h << 5) + Objects.hashCode(bloomFilterExpectedEntries);
    h += (h << 5) + Doubles.hashCode(bloomFilterFpp);
    h += (h << 5) + nessieCatalogName.hashCode();
    h += (h << 5) + outputBranchName.hashCode();
    h += (h << 5) + outputTableIdentifier.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GCParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GCParams")
        .omitNullValues()
        .add("nessieClientConfigs", nessieClientConfigs)
        .add("cutOffTimestampPerRef", cutOffTimestampPerRef)
        .add("defaultCutOffTimestamp", defaultCutOffTimestamp)
        .add("deadReferenceCutOffTimeStamp", deadReferenceCutOffTimeStamp)
        .add("sparkPartitionsCount", sparkPartitionsCount)
        .add("commitProtectionDuration", commitProtectionDuration)
        .add("bloomFilterExpectedEntries", bloomFilterExpectedEntries)
        .add("bloomFilterFpp", bloomFilterFpp)
        .add("nessieCatalogName", nessieCatalogName)
        .add("outputBranchName", outputBranchName)
        .add("outputTableIdentifier", outputTableIdentifier)
        .toString();
  }

  private static ImmutableGCParams validate(ImmutableGCParams instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link GCParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GCParams instance
   */
  public static ImmutableGCParams copyOf(GCParams instance) {
    if (instance instanceof ImmutableGCParams) {
      return (ImmutableGCParams) instance;
    }
    return ImmutableGCParams.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link ImmutableGCParams ImmutableGCParams}.
   * <pre>
   * ImmutableGCParams.builder()
   *    .putNessieClientConfigs|putAllNessieClientConfigs(String =&gt; String) // {@link GCParams#getNessieClientConfigs() nessieClientConfigs} mappings
   *    .cutOffTimestampPerRef(Map&amp;lt;String, java.time.Instant&amp;gt; | null) // nullable {@link GCParams#getCutOffTimestampPerRef() cutOffTimestampPerRef}
   *    .defaultCutOffTimestamp(java.time.Instant) // required {@link GCParams#getDefaultCutOffTimestamp() defaultCutOffTimestamp}
   *    .deadReferenceCutOffTimeStamp(java.time.Instant | null) // nullable {@link GCParams#getDeadReferenceCutOffTimeStamp() deadReferenceCutOffTimeStamp}
   *    .sparkPartitionsCount(Integer | null) // nullable {@link GCParams#getSparkPartitionsCount() sparkPartitionsCount}
   *    .commitProtectionDuration(java.time.Duration) // optional {@link GCParams#getCommitProtectionDuration() commitProtectionDuration}
   *    .bloomFilterExpectedEntries(Long | null) // nullable {@link GCParams#getBloomFilterExpectedEntries() bloomFilterExpectedEntries}
   *    .bloomFilterFpp(double) // optional {@link GCParams#getBloomFilterFpp() bloomFilterFpp}
   *    .nessieCatalogName(String) // required {@link GCParams#getNessieCatalogName() nessieCatalogName}
   *    .outputBranchName(String) // required {@link GCParams#getOutputBranchName() outputBranchName}
   *    .outputTableIdentifier(String) // required {@link GCParams#getOutputTableIdentifier() outputTableIdentifier}
   *    .build();
   * </pre>
   * @return A new ImmutableGCParams builder
   */
  public static ImmutableGCParams.Builder builder() {
    return new ImmutableGCParams.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGCParams ImmutableGCParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GCParams", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DEFAULT_CUT_OFF_TIMESTAMP = 0x1L;
    private static final long INIT_BIT_NESSIE_CATALOG_NAME = 0x2L;
    private static final long INIT_BIT_OUTPUT_BRANCH_NAME = 0x4L;
    private static final long INIT_BIT_OUTPUT_TABLE_IDENTIFIER = 0x8L;
    private static final long OPT_BIT_BLOOM_FILTER_FPP = 0x1L;
    private long initBits = 0xfL;
    private long optBits;

    private ImmutableMap.Builder<String, String> nessieClientConfigs = ImmutableMap.builder();
    private ImmutableMap.Builder<String, Instant> cutOffTimestampPerRef = null;
    private @Nullable Instant defaultCutOffTimestamp;
    private @Nullable Instant deadReferenceCutOffTimeStamp;
    private @Nullable Integer sparkPartitionsCount;
    private @Nullable Duration commitProtectionDuration;
    private @Nullable Long bloomFilterExpectedEntries;
    private double bloomFilterFpp;
    private @Nullable String nessieCatalogName;
    private @Nullable String outputBranchName;
    private @Nullable String outputTableIdentifier;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GCParams} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GCParams instance) {
      Objects.requireNonNull(instance, "instance");
      putAllNessieClientConfigs(instance.getNessieClientConfigs());
      @Nullable Map<String, Instant> cutOffTimestampPerRefValue = instance.getCutOffTimestampPerRef();
      if (cutOffTimestampPerRefValue != null) {
        putAllCutOffTimestampPerRef(cutOffTimestampPerRefValue);
      }
      defaultCutOffTimestamp(instance.getDefaultCutOffTimestamp());
      @Nullable Instant deadReferenceCutOffTimeStampValue = instance.getDeadReferenceCutOffTimeStamp();
      if (deadReferenceCutOffTimeStampValue != null) {
        deadReferenceCutOffTimeStamp(deadReferenceCutOffTimeStampValue);
      }
      @Nullable Integer sparkPartitionsCountValue = instance.getSparkPartitionsCount();
      if (sparkPartitionsCountValue != null) {
        sparkPartitionsCount(sparkPartitionsCountValue);
      }
      commitProtectionDuration(instance.getCommitProtectionDuration());
      @Nullable Long bloomFilterExpectedEntriesValue = instance.getBloomFilterExpectedEntries();
      if (bloomFilterExpectedEntriesValue != null) {
        bloomFilterExpectedEntries(bloomFilterExpectedEntriesValue);
      }
      bloomFilterFpp(instance.getBloomFilterFpp());
      nessieCatalogName(instance.getNessieCatalogName());
      outputBranchName(instance.getOutputBranchName());
      outputTableIdentifier(instance.getOutputTableIdentifier());
      return this;
    }

    /**
     * Put one entry to the {@link GCParams#getNessieClientConfigs() nessieClientConfigs} map.
     * @param key The key in the nessieClientConfigs map
     * @param value The associated value in the nessieClientConfigs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putNessieClientConfigs(String key, String value) {
      this.nessieClientConfigs.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GCParams#getNessieClientConfigs() nessieClientConfigs} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putNessieClientConfigs(Map.Entry<String, ? extends String> entry) {
      this.nessieClientConfigs.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GCParams#getNessieClientConfigs() nessieClientConfigs} map. Nulls are not permitted
     * @param entries The entries that will be added to the nessieClientConfigs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nessieClientConfigs(Map<String, ? extends String> entries) {
      this.nessieClientConfigs = ImmutableMap.builder();
      return putAllNessieClientConfigs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GCParams#getNessieClientConfigs() nessieClientConfigs} map. Nulls are not permitted
     * @param entries The entries that will be added to the nessieClientConfigs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllNessieClientConfigs(Map<String, ? extends String> entries) {
      this.nessieClientConfigs.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link GCParams#getCutOffTimestampPerRef() cutOffTimestampPerRef} map.
     * @param key The key in the cutOffTimestampPerRef map
     * @param value The associated value in the cutOffTimestampPerRef map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCutOffTimestampPerRef(String key, Instant value) {
      if (this.cutOffTimestampPerRef == null) {
        this.cutOffTimestampPerRef = ImmutableMap.builder();
      }
      this.cutOffTimestampPerRef.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GCParams#getCutOffTimestampPerRef() cutOffTimestampPerRef} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putCutOffTimestampPerRef(Map.Entry<String, ? extends Instant> entry) {
      if (this.cutOffTimestampPerRef == null) {
        this.cutOffTimestampPerRef = ImmutableMap.builder();
      }
      this.cutOffTimestampPerRef.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GCParams#getCutOffTimestampPerRef() cutOffTimestampPerRef} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the cutOffTimestampPerRef map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder cutOffTimestampPerRef(@Nullable Map<String, ? extends Instant> entries) {
      if (entries == null) {
        this.cutOffTimestampPerRef = null;
        return this;
      }
      this.cutOffTimestampPerRef = ImmutableMap.builder();
      return putAllCutOffTimestampPerRef(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GCParams#getCutOffTimestampPerRef() cutOffTimestampPerRef} map. Nulls are not permitted
     * @param entries The entries that will be added to the cutOffTimestampPerRef map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllCutOffTimestampPerRef(Map<String, ? extends Instant> entries) {
      if (this.cutOffTimestampPerRef == null) {
        this.cutOffTimestampPerRef = ImmutableMap.builder();
      }
      this.cutOffTimestampPerRef.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link GCParams#getDefaultCutOffTimestamp() defaultCutOffTimestamp} attribute.
     * @param defaultCutOffTimestamp The value for defaultCutOffTimestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultCutOffTimestamp(Instant defaultCutOffTimestamp) {
      this.defaultCutOffTimestamp = Objects.requireNonNull(defaultCutOffTimestamp, "defaultCutOffTimestamp");
      initBits &= ~INIT_BIT_DEFAULT_CUT_OFF_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link GCParams#getDeadReferenceCutOffTimeStamp() deadReferenceCutOffTimeStamp} attribute.
     * @param deadReferenceCutOffTimeStamp The value for deadReferenceCutOffTimeStamp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deadReferenceCutOffTimeStamp(@Nullable Instant deadReferenceCutOffTimeStamp) {
      this.deadReferenceCutOffTimeStamp = deadReferenceCutOffTimeStamp;
      return this;
    }

    /**
     * Initializes the value for the {@link GCParams#getSparkPartitionsCount() sparkPartitionsCount} attribute.
     * @param sparkPartitionsCount The value for sparkPartitionsCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sparkPartitionsCount(@Nullable Integer sparkPartitionsCount) {
      this.sparkPartitionsCount = sparkPartitionsCount;
      return this;
    }

    /**
     * Initializes the value for the {@link GCParams#getCommitProtectionDuration() commitProtectionDuration} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GCParams#getCommitProtectionDuration() commitProtectionDuration}.</em>
     * @param commitProtectionDuration The value for commitProtectionDuration 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitProtectionDuration(Duration commitProtectionDuration) {
      this.commitProtectionDuration = Objects.requireNonNull(commitProtectionDuration, "commitProtectionDuration");
      return this;
    }

    /**
     * Initializes the value for the {@link GCParams#getBloomFilterExpectedEntries() bloomFilterExpectedEntries} attribute.
     * @param bloomFilterExpectedEntries The value for bloomFilterExpectedEntries (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bloomFilterExpectedEntries(@Nullable Long bloomFilterExpectedEntries) {
      this.bloomFilterExpectedEntries = bloomFilterExpectedEntries;
      return this;
    }

    /**
     * Initializes the value for the {@link GCParams#getBloomFilterFpp() bloomFilterFpp} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GCParams#getBloomFilterFpp() bloomFilterFpp}.</em>
     * @param bloomFilterFpp The value for bloomFilterFpp 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bloomFilterFpp(double bloomFilterFpp) {
      this.bloomFilterFpp = bloomFilterFpp;
      optBits |= OPT_BIT_BLOOM_FILTER_FPP;
      return this;
    }

    /**
     * Initializes the value for the {@link GCParams#getNessieCatalogName() nessieCatalogName} attribute.
     * @param nessieCatalogName The value for nessieCatalogName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nessieCatalogName(String nessieCatalogName) {
      this.nessieCatalogName = Objects.requireNonNull(nessieCatalogName, "nessieCatalogName");
      initBits &= ~INIT_BIT_NESSIE_CATALOG_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link GCParams#getOutputBranchName() outputBranchName} attribute.
     * @param outputBranchName The value for outputBranchName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder outputBranchName(String outputBranchName) {
      this.outputBranchName = Objects.requireNonNull(outputBranchName, "outputBranchName");
      initBits &= ~INIT_BIT_OUTPUT_BRANCH_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link GCParams#getOutputTableIdentifier() outputTableIdentifier} attribute.
     * @param outputTableIdentifier The value for outputTableIdentifier 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder outputTableIdentifier(String outputTableIdentifier) {
      this.outputTableIdentifier = Objects.requireNonNull(outputTableIdentifier, "outputTableIdentifier");
      initBits &= ~INIT_BIT_OUTPUT_TABLE_IDENTIFIER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGCParams ImmutableGCParams}.
     * @return An immutable instance of GCParams
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGCParams build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableGCParams.validate(new ImmutableGCParams(this));
    }

    private boolean bloomFilterFppIsSet() {
      return (optBits & OPT_BIT_BLOOM_FILTER_FPP) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DEFAULT_CUT_OFF_TIMESTAMP) != 0) attributes.add("defaultCutOffTimestamp");
      if ((initBits & INIT_BIT_NESSIE_CATALOG_NAME) != 0) attributes.add("nessieCatalogName");
      if ((initBits & INIT_BIT_OUTPUT_BRANCH_NAME) != 0) attributes.add("outputBranchName");
      if ((initBits & INIT_BIT_OUTPUT_TABLE_IDENTIFIER) != 0) attributes.add("outputTableIdentifier");
      return "Cannot build GCParams, some of required attributes are not set " + attributes;
    }
  }
}
