/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.gc.base.GCUtil;

public class TestInstantConversion {
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testInstantConversion(boolean isNanoPrecision) {
        Instant instant = isNanoPrecision ? Instant.parse("2018-08-19T16:02:42.123456789Z") : Instant.parse("2018-08-19T16:02:42.123456Z");
        long time = instant.getEpochSecond();
        long nano = instant.getNano();
        long micro = TimeUnit.SECONDS.toMicros(time) + TimeUnit.NANOSECONDS.toMicros(nano);
        Instant instantFromMicros = GCUtil.getInstantFromMicros((Long)micro);
        Instant instantInMicros = instant.truncatedTo(ChronoUnit.MICROS);
        Assertions.assertThat((Instant)instantFromMicros).isEqualTo((Object)instantInMicros);
    }
}

