/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.spark.sql.Row;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.api.AssignBranchBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.gc.base.AbstractRestGC;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;

public abstract class AbstractRestGCTest
extends AbstractRestGC {
    static final String CID_ONE = "cid_1";
    static final String CID_TWO = "cid_2";
    static final String CID_THREE = "cid_3";
    static final String TABLE_ONE = "table_1";
    static final String TABLE_TWO = "table_2";
    static final String TABLE_THREE = "table_3";
    static final String TABLE_TWO_RENAMED = "table_2_renamed";
    static final String METADATA_ZERO = "file0";
    static final String METADATA_ONE = "file1";
    static final String METADATA_TWO = "file2";
    static final String METADATA_THREE = "file3";
    static final String METADATA_FOUR = "file4";
    static final String METADATA_FIVE = "file5";

    @Test
    public void testSingleRefMultiTable() throws BaseNessieClientServerException {
        String prefix = "singleRefMultiTable";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch branch1 = this.createBranch(prefix);
        AbstractRestGC.CommitOutput table1 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_ONE, TABLE_ONE, METADATA_ONE, null, null);
        AbstractRestGC.CommitOutput table2 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_TWO, TABLE_TWO, METADATA_ONE, null, null);
        this.fillExpectedContents(Branch.of((String)branch1.getName(), (String)table2.hash), 2, expectedResult);
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 43L, CID_TWO, TABLE_TWO, METADATA_TWO, table2.content, null);
        this.commitSingleOp(prefix, (Reference)branch1, table1.hash, 43L, CID_ONE, TABLE_ONE, METADATA_TWO, table1.content, null);
        Instant cutoffTime = Instant.now();
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 44L, CID_TWO, TABLE_TWO, METADATA_THREE, table2.content, null);
        this.dropTableCommit(prefix, (Reference)branch1, table2.hash, TABLE_TWO);
        this.performGc(prefix, cutoffTime, null, Collections.emptyList(), false, null);
        this.performGc(prefix, cutoffTime, null, expectedResult, true, null);
    }

    @Test
    public void testSingleRefRenameTable() throws BaseNessieClientServerException {
        String prefix = "singleRefRenameTable";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch branch1 = this.createBranch(prefix);
        AbstractRestGC.CommitOutput table2 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_TWO, TABLE_TWO, METADATA_ONE, null, null);
        this.fillExpectedContents(Branch.of((String)branch1.getName(), (String)table2.hash), 1, expectedResult);
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 43L, CID_TWO, TABLE_TWO, METADATA_TWO, table2.content, null);
        Instant cutoffTime = Instant.now();
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 44L, CID_TWO, TABLE_TWO, METADATA_THREE, table2.content, null);
        this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 44L, CID_TWO, TABLE_TWO_RENAMED, METADATA_THREE, table2.content, TABLE_TWO);
        this.performGc(prefix, cutoffTime, null, expectedResult, true, null);
    }

    @Test
    public void testSingleRefRenameTableBeforeCutoff() throws BaseNessieClientServerException {
        String prefix = "singleRefRenameTableBeforeCutoff";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch branch1 = this.createBranch(prefix);
        AbstractRestGC.CommitOutput table2 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_TWO, TABLE_TWO, METADATA_ONE, null, null);
        this.fillExpectedContents(Branch.of((String)branch1.getName(), (String)table2.hash), 1, expectedResult);
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 43L, CID_TWO, TABLE_TWO, METADATA_TWO, table2.content, null);
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 43L, CID_TWO, TABLE_TWO_RENAMED, METADATA_TWO, table2.content, TABLE_TWO);
        Instant cutoffTime = Instant.now();
        this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 44L, CID_TWO, TABLE_TWO_RENAMED, METADATA_THREE, table2.content, null);
        this.performGc(prefix, cutoffTime, null, expectedResult, true, null);
    }

    @Test
    public void testSingleRefDropTable() throws BaseNessieClientServerException {
        String prefix = "singleRefDropTable";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch branch1 = this.createBranch(prefix);
        AbstractRestGC.CommitOutput table1 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_ONE, TABLE_ONE, METADATA_ONE, null, null);
        AbstractRestGC.CommitOutput table2 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_TWO, TABLE_TWO, METADATA_ONE, null, null);
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 43L, CID_TWO, TABLE_TWO, METADATA_TWO, table2.content, null);
        this.fillExpectedContents(Branch.of((String)branch1.getName(), (String)table2.hash), 2, expectedResult);
        this.dropTableCommit(prefix, (Reference)branch1, table2.hash, TABLE_TWO);
        Instant cutoffTime = Instant.now();
        this.commitSingleOp(prefix, (Reference)branch1, table1.hash, 43L, CID_ONE, TABLE_ONE, METADATA_TWO, table1.content, null);
        this.performGc(prefix, cutoffTime, null, expectedResult, true, null);
    }

    @Test
    public void testSingleRefDropRefBeforeCutoff() throws BaseNessieClientServerException {
        String prefix = "singleRefDropRefBeforeCutoff";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch branch1 = this.createBranch(prefix);
        this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_ONE, TABLE_ONE, METADATA_ONE, null, null);
        AbstractRestGC.CommitOutput table2 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_TWO, TABLE_TWO, METADATA_ONE, null, null);
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 43L, CID_TWO, TABLE_TWO, METADATA_TWO, table2.content, null);
        this.fillExpectedContents(Branch.of((String)branch1.getName(), (String)table2.hash), 3, expectedResult);
        this.deleteBranch(branch1.getName(), table2.hash);
        Instant cutoffTime = Instant.now();
        this.performGc(prefix, cutoffTime, null, expectedResult, true, null);
    }

    @Test
    public void testSingleRefDropRefAfterCutoff() throws BaseNessieClientServerException {
        String prefix = "singleRefDropRefAfterCutoff";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch branch1 = this.createBranch(prefix);
        this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_ONE, TABLE_ONE, METADATA_ONE, null, null);
        AbstractRestGC.CommitOutput table2 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_TWO, TABLE_TWO, METADATA_ONE, null, null);
        this.fillExpectedContents(Branch.of((String)branch1.getName(), (String)table2.hash), 1, expectedResult);
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 43L, CID_TWO, TABLE_TWO, METADATA_TWO, table2.content, null);
        Instant cutoffTime = Instant.now();
        this.deleteBranch(branch1.getName(), table2.hash);
        this.performGc(prefix, cutoffTime, null, expectedResult, true, null);
    }

    @Test
    public void testSingleRefDeadRefCutoff() throws BaseNessieClientServerException {
        String prefix = "singleRefDeadRefCutoff";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch branch1 = this.createBranch(prefix);
        this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_ONE, TABLE_ONE, METADATA_ONE, null, null);
        Instant cutoffTime = Instant.now();
        AbstractRestGC.CommitOutput table2 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_TWO, TABLE_TWO, METADATA_ONE, null, null);
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 43L, CID_TWO, TABLE_TWO, METADATA_TWO, table2.content, null);
        this.fillExpectedContents(Branch.of((String)branch1.getName(), (String)table2.hash), 2, expectedResult);
        table2 = this.commitSingleOp(prefix, (Reference)branch1, table2.hash, 44L, CID_TWO, TABLE_TWO, METADATA_THREE, table2.content, null);
        Instant deadRefCutoffTime = Instant.now();
        this.deleteBranch(branch1.getName(), table2.hash);
        this.performGc(prefix, cutoffTime, null, expectedResult, true, deadRefCutoffTime);
    }

    @Test
    public void testMultiRefSharedTable() throws BaseNessieClientServerException {
        String prefix = "multiRefSharedTable";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch branch1 = this.createBranch(prefix + "_1");
        AbstractRestGC.CommitOutput b1table1 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 41L, CID_ONE, TABLE_ONE, METADATA_ZERO, null, null);
        this.fillExpectedContents(Branch.of((String)branch1.getName(), (String)b1table1.hash), 1, expectedResult);
        String firstCommitHash = b1table1.hash;
        b1table1 = this.commitSingleOp(prefix, (Reference)branch1, b1table1.hash, 42L, CID_ONE, TABLE_ONE, METADATA_ONE, b1table1.content, null);
        Branch branch2 = this.createBranch(prefix + "_2", Branch.of((String)branch1.getName(), (String)b1table1.hash));
        this.fillExpectedContents(Branch.of((String)branch2.getName(), (String)firstCommitHash), 1, expectedResult);
        Branch branch3 = this.createBranch(prefix + "_3", Branch.of((String)branch1.getName(), (String)b1table1.hash));
        this.fillExpectedContents(Branch.of((String)branch3.getName(), (String)firstCommitHash), 1, expectedResult);
        AbstractRestGC.CommitOutput b2table1 = this.commitSingleOp(prefix, (Reference)branch2, branch2.getHash(), 43L, CID_ONE, TABLE_ONE, METADATA_TWO, b1table1.content, null);
        Instant cutoffTime = Instant.now();
        b1table1 = this.commitSingleOp(prefix, (Reference)branch1, b1table1.hash, 44L, CID_ONE, TABLE_ONE, METADATA_THREE, b2table1.content, null);
        b2table1 = this.commitSingleOp(prefix, (Reference)branch2, b2table1.hash, 45L, CID_ONE, TABLE_ONE, METADATA_FOUR, b1table1.content, null);
        AbstractRestGC.CommitOutput b3table1 = this.commitSingleOp(prefix, (Reference)branch3, branch3.getHash(), 46L, CID_ONE, TABLE_ONE, METADATA_FIVE, b2table1.content, null);
        this.deleteBranch(branch3.getName(), b3table1.hash);
        this.dropTableCommit(prefix, (Reference)branch1, b1table1.hash, TABLE_ONE);
        this.performGc(prefix, cutoffTime, null, expectedResult, true, null);
    }

    @Test
    public void testMultiRefMultipleSharedTables() throws BaseNessieClientServerException {
        String prefix = "multiRefMultipleSharedTables";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch branch1 = this.createBranch(prefix + "_1");
        AbstractRestGC.CommitOutput b1table1 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_ONE, TABLE_ONE, METADATA_ONE, null, null);
        Branch branch2 = this.createBranch(prefix + "_2", Branch.of((String)branch1.getName(), (String)b1table1.hash));
        AbstractRestGC.CommitOutput b1table2 = this.commitSingleOp(prefix, (Reference)branch1, b1table1.hash, 42L, CID_TWO, TABLE_TWO, METADATA_ONE, null, null);
        Branch branch3 = this.createBranch(prefix + "_3", Branch.of((String)branch1.getName(), (String)b1table2.hash));
        AbstractRestGC.CommitOutput b3table3 = this.commitSingleOp(prefix, (Reference)branch3, branch3.getHash(), 42L, CID_THREE, TABLE_THREE, METADATA_ONE, null, null);
        this.fillExpectedContents(Branch.of((String)branch3.getName(), (String)b3table3.hash), 1, expectedResult);
        AbstractRestGC.CommitOutput b2table1 = this.commitSingleOp(prefix, (Reference)branch2, branch2.getHash(), 43L, CID_ONE, TABLE_ONE, METADATA_TWO, b1table1.content, null);
        AbstractRestGC.CommitOutput b1 = this.dropTableCommit(prefix, (Reference)branch1, b1table2.hash, TABLE_ONE);
        AbstractRestGC.CommitOutput b3 = this.dropTableCommit(prefix, (Reference)branch3, b3table3.hash, TABLE_TWO);
        b3 = this.dropTableCommit(prefix, (Reference)branch3, b3.hash, TABLE_THREE);
        Instant cutoffTime = Instant.now();
        this.commitSingleOp(prefix, (Reference)branch1, b1.hash, 44L, CID_TWO, TABLE_TWO, METADATA_THREE, b1table2.content, null);
        this.commitSingleOp(prefix, (Reference)branch3, b3.hash, 44L, CID_ONE, TABLE_ONE, METADATA_FIVE, b2table1.content, null);
        this.performGc(prefix, cutoffTime, null, expectedResult, true, null);
    }

    @Test
    public void testMultiRefCutoffTimeStampPerRef() throws BaseNessieClientServerException {
        String prefix = "multiRefCutoffTimeStampPerRef";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch branch1 = this.createBranch(prefix + "_1");
        Branch branch2 = this.createBranch(prefix + "_2");
        AbstractRestGC.CommitOutput table1 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_ONE, TABLE_ONE, METADATA_ONE, null, null);
        AbstractRestGC.CommitOutput table2 = this.commitSingleOp(prefix, (Reference)branch2, branch2.getHash(), 42L, CID_TWO, TABLE_TWO, METADATA_ONE, null, null);
        this.fillExpectedContents(Branch.of((String)branch2.getName(), (String)table2.hash), 1, expectedResult);
        Instant defaultCutoffTime = Instant.now();
        table1 = this.commitSingleOp(prefix, (Reference)branch1, table1.hash, 44L, CID_ONE, TABLE_ONE, METADATA_THREE, table1.content, null);
        this.commitSingleOp(prefix, (Reference)branch1, table1.hash, 45L, CID_ONE, TABLE_ONE, METADATA_FOUR, table1.content, null);
        table2 = this.commitSingleOp(prefix, (Reference)branch2, table2.hash, 44L, CID_TWO, TABLE_TWO, METADATA_THREE, table2.content, null);
        Instant branch2CutoffTime = Instant.now();
        HashMap<String, Instant> perRefCutoffTime = new HashMap<String, Instant>();
        perRefCutoffTime.put(branch2.getName(), branch2CutoffTime);
        this.commitSingleOp(prefix, (Reference)branch2, table2.hash, 45L, CID_TWO, TABLE_TWO, METADATA_FOUR, table2.content, null);
        this.performGc(prefix, defaultCutoffTime, perRefCutoffTime, expectedResult, true, null);
    }

    @Test
    public void testMultiRefAssignAndDropRef() throws BaseNessieClientServerException {
        String prefix = "multiRefAssignAndDropRef";
        ArrayList<Row> expectedResult = new ArrayList<Row>();
        Branch before = this.createBranch(prefix + "_0");
        Branch branch1 = this.createBranch(prefix + "_1");
        Branch branch2 = this.createBranch(prefix + "_2");
        AbstractRestGC.CommitOutput table1 = this.commitSingleOp(prefix, (Reference)branch1, branch1.getHash(), 42L, CID_ONE, TABLE_ONE, METADATA_ONE, null, null);
        this.fillExpectedContents(Branch.of((String)branch1.getName(), (String)table1.hash), 1, expectedResult);
        AbstractRestGC.CommitOutput table2 = this.commitSingleOp(prefix, (Reference)branch2, branch2.getHash(), 42L, CID_TWO, TABLE_TWO, METADATA_ONE, null, null);
        this.fillExpectedContents(Branch.of((String)branch2.getName(), (String)table2.hash), 1, expectedResult);
        table1 = this.commitSingleOp(prefix, (Reference)branch1, table1.hash, 43L, CID_ONE, TABLE_ONE, METADATA_TWO, table1.content, null);
        table2 = this.commitSingleOp(prefix, (Reference)branch2, table2.hash, 43L, CID_TWO, TABLE_TWO, METADATA_TWO, table2.content, null);
        Instant cutoffTime = Instant.now();
        table1 = this.commitSingleOp(prefix, (Reference)branch1, table1.hash, 44L, CID_ONE, TABLE_ONE, METADATA_THREE, table1.content, null);
        table2 = this.commitSingleOp(prefix, (Reference)branch2, table2.hash, 44L, CID_TWO, TABLE_TWO, METADATA_THREE, table2.content, null);
        ((AssignBranchBuilder)this.getApi().assignBranch().branch(Branch.of((String)branch2.getName(), (String)table2.hash))).assignTo((Reference)before).assign();
        this.deleteBranch(branch1.getName(), table1.hash);
        this.performGc(prefix, cutoffTime, null, expectedResult, true, null);
    }
}

