/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import com.google.errorprone.annotations.FormatMethod;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.nessie.NessieCatalog;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.types.StructType;
import org.projectnessie.model.Content;
import org.projectnessie.model.ImmutableTableReference;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public final class IdentifiedResultsRepo {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiedResultsRepo.class);
    private static final String COL_GC_RUN_START = "gcRunStart";
    private static final String COL_GC_RUN_ID = "gcRunId";
    private static final String COL_CONTENT_ID = "contentId";
    private static final String COL_CONTENT_TYPE = "contentType";
    private static final String COL_SNAPSHOT_ID = "snapshotId";
    private static final String COL_REFERENCE_NAME = "referenceName";
    private static final String COL_HASH_ON_REFERENCE = "hashOnReference";
    private final Schema icebergSchema = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"gcRunStart", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)2, (String)"gcRunId", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"contentId", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"contentType", (Type)Types.StringType.get()), Types.NestedField.optional((int)5, (String)"snapshotId", (Type)Types.LongType.get()), Types.NestedField.optional((int)6, (String)"referenceName", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"hashOnReference", (Type)Types.StringType.get())}).fields());
    private final StructType schema = SparkSchemaUtil.convert((Schema)this.icebergSchema);
    private final SparkSession sparkSession;
    private final String catalogAndTableWithRefName;

    public IdentifiedResultsRepo(SparkSession sparkSession, String catalog, String gcRefName, String gcTableIdentifier) {
        this.sparkSession = sparkSession;
        this.catalogAndTableWithRefName = IdentifiedResultsRepo.withRefName(catalog, gcTableIdentifier, gcRefName);
        this.createTableIfAbsent(sparkSession, catalog, TableIdentifier.parse((String)gcTableIdentifier), gcRefName);
    }

    public StructType getSchema() {
        return this.schema;
    }

    public Dataset<Row> collectExpiredContentsAsDataSet(String runId) {
        return this.sql("SELECT * FROM %s WHERE %s = '%s'", this.catalogAndTableWithRefName, COL_GC_RUN_ID, runId);
    }

    public Optional<String> getLatestCompletedRunID() {
        List rows = this.sql("SELECT %s FROM %s WHERE %s = (SELECT MAX(%s) FROM %s) LIMIT 1", COL_GC_RUN_ID, this.catalogAndTableWithRefName, COL_GC_RUN_START, COL_GC_RUN_START, this.catalogAndTableWithRefName).collectAsList();
        return rows.isEmpty() ? Optional.empty() : Optional.of(((Row)rows.get(0)).getString(0));
    }

    void writeToOutputTable(Dataset<Row> rowDataset) {
        try {
            rowDataset.writeTo(this.catalogAndTableWithRefName).append();
        }
        catch (NoSuchTableException e) {
            throw new RuntimeException("Problem while writing gc output rows to the table: " + this.catalogAndTableWithRefName, e);
        }
    }

    static Row createContentRow(Content content, String runId, Timestamp startedAt, long snapshotId, Reference ref) {
        return RowFactory.create((Object[])new Object[]{startedAt, runId, content.getId(), content.getType().name(), snapshotId, ref.getName(), ref.getHash()});
    }

    private void createTableIfAbsent(SparkSession sparkSession, String catalogName, TableIdentifier tableIdentifier, String gcRefName) {
        Catalog nessieCatalog = CatalogUtil.loadCatalog((String)NessieCatalog.class.getName(), (String)catalogName, IdentifiedResultsRepo.catalogConfWithRef(sparkSession, catalogName, gcRefName), (Object)sparkSession.sparkContext().hadoopConfiguration());
        try {
            nessieCatalog.createTable(tableIdentifier, this.icebergSchema);
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    private static String withRefName(String catalog, String identifier, String refName) {
        int tableNameIndex = identifier.lastIndexOf(".");
        String namespace = identifier.substring(0, tableNameIndex);
        String tableName = identifier.substring(tableNameIndex + 1);
        return catalog + "." + namespace + "." + ImmutableTableReference.builder().name(tableName).reference(refName).build();
    }

    private static Map<String, String> catalogConfWithRef(SparkSession spark, String catalog, String branchName) {
        Stream<Tuple2> conf = Arrays.stream(spark.sparkContext().conf().getAllWithPrefix(String.format("spark.sql.catalog.%s.", catalog)));
        return conf.map(t -> ((String)t._1).equals("ref") ? Tuple2.apply((Object)((String)t._1), (Object)branchName) : t).collect(Collectors.toMap(t -> (String)t._1, t -> (String)t._2));
    }

    @FormatMethod
    private Dataset<Row> sql(String sqlStatement, Object ... args) {
        String sql = String.format(sqlStatement, args);
        LOGGER.debug("Executing the sql -> {}", (Object)sql);
        return this.sparkSession.sql(sql);
    }
}

