/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.gc.base.AbstractRestGCTest;
import org.projectnessie.gc.base.IdentifiedResultsRepo;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableTableReference;

public abstract class AbstractRestGCRepoTest
extends AbstractRestGCTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGCRepoMultipleRuns() {
        String catalogName = "nessie";
        String namespace = "db2";
        String tableName = "identified_results";
        String identifier = namespace + "." + tableName;
        String gcBranchName = "someGcBranch";
        String catalogAndIdentifierWithReference = AbstractRestGCRepoTest.getCatalogAndIdentifierWithReference(catalogName, namespace, tableName, gcBranchName);
        AbstractRestGCRepoTest.getOrCreateEmptyBranch((NessieApiV1)this.getApi(), (String)gcBranchName);
        try (SparkSession sparkSession = this.getSparkSession();){
            IdentifiedResultsRepo identifiedResultsRepo = new IdentifiedResultsRepo(sparkSession, catalogName, gcBranchName, identifier);
            try {
                ArrayList<String> runIds = new ArrayList<String>();
                for (int i = 0; i < 5; ++i) {
                    String runId2 = UUID.randomUUID().toString();
                    Timestamp startAt = Timestamp.from(Instant.now());
                    runIds.add(runId2);
                    List<Row> rows = this.createRows(runId2, startAt, i + 1);
                    Dataset dataset = sparkSession.createDataFrame(rows, identifiedResultsRepo.getSchema());
                    identifiedResultsRepo.writeToOutputTable(dataset);
                }
                AtomicInteger expectedRowCount = new AtomicInteger(1);
                runIds.forEach(runId -> {
                    Dataset identifiedResult = identifiedResultsRepo.collectExpiredContentsAsDataSet(runId);
                    Assertions.assertThat((int)identifiedResult.collectAsList().size()).isEqualTo(expectedRowCount.get());
                    expectedRowCount.getAndIncrement();
                });
                Assertions.assertThat((String)((String)identifiedResultsRepo.getLatestCompletedRunID().get())).isEqualTo((String)runIds.get(runIds.size() - 1));
            }
            catch (Throwable throwable) {
                sparkSession.sql(String.format("DROP TABLE %s", catalogAndIdentifierWithReference));
                throw throwable;
            }
            sparkSession.sql(String.format("DROP TABLE %s", catalogAndIdentifierWithReference));
        }
    }

    private List<Row> createRows(String runId, Timestamp startAt, int rowCount) {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int i = 0; i < rowCount; ++i) {
            String contentId = "SomeContentId_" + i;
            String metadata = "file1";
            IcebergTable content = IcebergTable.of((String)metadata, (long)42L, (int)42, (int)42, (int)42, (String)contentId);
            String refName = "someRef";
            rows.add(RowFactory.create((Object[])new Object[]{startAt, runId, contentId, content.getType().name(), content.getSnapshotId(), refName, null}));
        }
        return rows;
    }

    private static String getCatalogAndIdentifierWithReference(String catalogName, String namespace, String tableName, String gcBranchName) {
        return catalogName + "." + namespace + "." + ImmutableTableReference.builder().name(tableName).reference(gcBranchName).build();
    }
}

