/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.gc.base.ContentBloomFilter;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableDeltaLakeTable;

public class TestContentBloomFilter {
    @Test
    void testBasic() {
        ContentBloomFilter filter = new ContentBloomFilter(10L, 0.03);
        List<Content> contents = this.generateContents(0, Content.Type.ICEBERG_TABLE);
        contents.addAll(this.generateContents(0, Content.Type.ICEBERG_VIEW));
        contents.forEach(arg_0 -> ((ContentBloomFilter)filter).put(arg_0));
        Assertions.assertThat((boolean)filter.mightContain(contents.get(5))).isTrue();
        Assertions.assertThat((boolean)filter.mightContain(contents.get(12))).isTrue();
    }

    @Test
    void testMerge() {
        ContentBloomFilter filter1 = new ContentBloomFilter(10L, 0.03);
        List<Content> contents1 = this.generateContents(0, Content.Type.ICEBERG_TABLE);
        contents1.addAll(this.generateContents(0, Content.Type.ICEBERG_VIEW));
        contents1.forEach(arg_0 -> ((ContentBloomFilter)filter1).put(arg_0));
        ContentBloomFilter filter2 = new ContentBloomFilter(10L, 0.03);
        List<Content> contents2 = this.generateContents(5, Content.Type.ICEBERG_TABLE);
        contents2.addAll(this.generateContents(0, Content.Type.ICEBERG_VIEW));
        contents2.forEach(arg_0 -> ((ContentBloomFilter)filter2).put(arg_0));
        filter1.merge(filter2);
        Assertions.assertThat((boolean)filter1.mightContain(contents1.get(4))).isTrue();
        Assertions.assertThat((boolean)filter1.mightContain(contents2.get(2))).isTrue();
        Assertions.assertThat((boolean)filter1.mightContain(contents2.get(8))).isTrue();
    }

    @Test
    void testDeltaLakeContent() {
        ContentBloomFilter filter = new ContentBloomFilter(10L, 0.03);
        List<Content> contents = this.generateContents(0, Content.Type.DELTA_LAKE_TABLE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> contents.forEach(arg_0 -> ((ContentBloomFilter)filter).put(arg_0))).isInstanceOf(RuntimeException.class)).hasMessageContaining("Unsupported type DELTA_LAKE_TABLE");
    }

    private List<Content> generateContents(int index, Content.Type contentType) {
        ArrayList<Content> contents = new ArrayList<Content>();
        block5: for (int i = index; i < 10 + index; ++i) {
            switch (contentType) {
                case ICEBERG_TABLE: {
                    contents.add((Content)IcebergTable.of((String)("temp" + i), (long)i, (int)42, (int)42, (int)42));
                    continue block5;
                }
                case ICEBERG_VIEW: {
                    contents.add((Content)IcebergView.of((String)("temp" + i), (int)i, (int)42, (String)("dialect" + i), (String)("sql" + i)));
                    continue block5;
                }
                case DELTA_LAKE_TABLE: {
                    contents.add((Content)ImmutableDeltaLakeTable.builder().id(String.valueOf(i)).addAllCheckpointLocationHistory(Collections.emptyList()).addAllMetadataLocationHistory(Collections.emptyList()).build());
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Unsupported type: " + contentType);
                }
            }
        }
        return contents;
    }
}

