/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.gc.base.GCStateParamsPerTask;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Reference;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GCStateParamsPerTask", generator="Immutables")
@Immutable
final class ImmutableGCStateParamsPerTask
implements GCStateParamsPerTask {
    private final NessieApiV1 api;
    private final Reference reference;
    private final Predicate<CommitMeta> liveCommitPredicate;
    private final long bloomFilterSize;

    private ImmutableGCStateParamsPerTask(NessieApiV1 api, Reference reference, Predicate<CommitMeta> liveCommitPredicate, long bloomFilterSize) {
        this.api = api;
        this.reference = reference;
        this.liveCommitPredicate = liveCommitPredicate;
        this.bloomFilterSize = bloomFilterSize;
    }

    @Override
    public NessieApiV1 getApi() {
        return this.api;
    }

    @Override
    public Reference getReference() {
        return this.reference;
    }

    @Override
    public Predicate<CommitMeta> getLiveCommitPredicate() {
        return this.liveCommitPredicate;
    }

    @Override
    public long getBloomFilterSize() {
        return this.bloomFilterSize;
    }

    public final ImmutableGCStateParamsPerTask withApi(NessieApiV1 value) {
        if (this.api == value) {
            return this;
        }
        NessieApiV1 newValue = Objects.requireNonNull(value, "api");
        return new ImmutableGCStateParamsPerTask(newValue, this.reference, this.liveCommitPredicate, this.bloomFilterSize);
    }

    public final ImmutableGCStateParamsPerTask withReference(Reference value) {
        if (this.reference == value) {
            return this;
        }
        Reference newValue = Objects.requireNonNull(value, "reference");
        return new ImmutableGCStateParamsPerTask(this.api, newValue, this.liveCommitPredicate, this.bloomFilterSize);
    }

    public final ImmutableGCStateParamsPerTask withLiveCommitPredicate(Predicate<CommitMeta> value) {
        if (this.liveCommitPredicate == value) {
            return this;
        }
        Predicate<CommitMeta> newValue = Objects.requireNonNull(value, "liveCommitPredicate");
        return new ImmutableGCStateParamsPerTask(this.api, this.reference, newValue, this.bloomFilterSize);
    }

    public final ImmutableGCStateParamsPerTask withBloomFilterSize(long value) {
        if (this.bloomFilterSize == value) {
            return this;
        }
        return new ImmutableGCStateParamsPerTask(this.api, this.reference, this.liveCommitPredicate, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGCStateParamsPerTask && this.equalTo(0, (ImmutableGCStateParamsPerTask)another);
    }

    private boolean equalTo(int synthetic, ImmutableGCStateParamsPerTask another) {
        return this.api.equals(another.api) && this.reference.equals(another.reference) && this.liveCommitPredicate.equals(another.liveCommitPredicate) && this.bloomFilterSize == another.bloomFilterSize;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.api.hashCode();
        h += (h << 5) + this.reference.hashCode();
        h += (h << 5) + this.liveCommitPredicate.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.bloomFilterSize);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GCStateParamsPerTask").omitNullValues().add("api", (Object)this.api).add("reference", (Object)this.reference).add("liveCommitPredicate", this.liveCommitPredicate).add("bloomFilterSize", this.bloomFilterSize).toString();
    }

    public static ImmutableGCStateParamsPerTask copyOf(GCStateParamsPerTask instance) {
        if (instance instanceof ImmutableGCStateParamsPerTask) {
            return (ImmutableGCStateParamsPerTask)instance;
        }
        return ImmutableGCStateParamsPerTask.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GCStateParamsPerTask", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_API = 1L;
        private static final long INIT_BIT_REFERENCE = 2L;
        private static final long INIT_BIT_LIVE_COMMIT_PREDICATE = 4L;
        private static final long INIT_BIT_BLOOM_FILTER_SIZE = 8L;
        private long initBits = 15L;
        @Nullable
        private NessieApiV1 api;
        @Nullable
        private Reference reference;
        @Nullable
        private Predicate<CommitMeta> liveCommitPredicate;
        private long bloomFilterSize;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GCStateParamsPerTask instance) {
            Objects.requireNonNull(instance, "instance");
            this.api(instance.getApi());
            this.reference(instance.getReference());
            this.liveCommitPredicate(instance.getLiveCommitPredicate());
            this.bloomFilterSize(instance.getBloomFilterSize());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder api(NessieApiV1 api) {
            this.api = Objects.requireNonNull(api, "api");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reference(Reference reference) {
            this.reference = Objects.requireNonNull(reference, "reference");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder liveCommitPredicate(Predicate<CommitMeta> liveCommitPredicate) {
            this.liveCommitPredicate = Objects.requireNonNull(liveCommitPredicate, "liveCommitPredicate");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bloomFilterSize(long bloomFilterSize) {
            this.bloomFilterSize = bloomFilterSize;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGCStateParamsPerTask build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGCStateParamsPerTask(this.api, this.reference, this.liveCommitPredicate, this.bloomFilterSize);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("api");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reference");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("liveCommitPredicate");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("bloomFilterSize");
            }
            return "Cannot build GCStateParamsPerTask, some of required attributes are not set " + attributes;
        }
    }
}

