/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.base;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.sql.SparkSession;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.GetRefLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.gc.base.ContentBloomFilter;
import org.projectnessie.gc.base.DistributedIdentifyContents;
import org.projectnessie.gc.base.GCParams;
import org.projectnessie.gc.base.GCUtil;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;
import org.projectnessie.model.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(GCImpl.class);
    private final GCParams gcParams;

    public GCImpl(GCParams gcParams) {
        this.gcParams = gcParams;
        LOGGER.info("GCImpl with params: {}", (Object)gcParams);
    }

    public String identifyExpiredContents(SparkSession session) throws NessieNotFoundException {
        Map<String, ContentBloomFilter> liveContentsBloomFilterMap;
        List<String> allRefs;
        DistributedIdentifyContents distributedIdentifyContents;
        try (NessieApiV1 api = GCUtil.getApi(this.gcParams.getNessieClientConfigs());){
            distributedIdentifyContents = new DistributedIdentifyContents(session, this.gcParams);
            Stream liveReferences = api.getAllReferences().stream();
            Map<String, Instant> droppedReferenceTimeMap = GCImpl.collectDeadReferences(api);
            allRefs = liveReferences.map(GCUtil::serializeReference).collect(Collectors.toList());
            if (droppedReferenceTimeMap.size() > 0) {
                allRefs.addAll(droppedReferenceTimeMap.keySet());
            }
            long bloomFilterSize = this.gcParams.getBloomFilterExpectedEntries() == null ? this.getTotalCommitsInDefaultReference(api) : this.gcParams.getBloomFilterExpectedEntries().longValue();
            liveContentsBloomFilterMap = distributedIdentifyContents.getLiveContentsBloomFilters(allRefs, bloomFilterSize, droppedReferenceTimeMap);
            GCImpl.getOrCreateEmptyBranch(api, this.gcParams.getOutputBranchName());
        }
        return distributedIdentifyContents.identifyExpiredContents(liveContentsBloomFilterMap, allRefs);
    }

    private long getTotalCommitsInDefaultReference(NessieApiV1 api) {
        ReferenceMetadata defaultRefMetadata;
        try {
            defaultRefMetadata = api.getReference().refName(api.getDefaultBranch().getName()).fetch(FetchOption.ALL).get().getMetadata();
        }
        catch (NessieNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return defaultRefMetadata.getNumTotalCommits();
    }

    private static Map<String, Instant> collectDeadReferences(NessieApiV1 api) {
        Stream reflogStream;
        HashMap<String, Instant> droppedReferenceTimeMap = new HashMap<String, Instant>();
        try {
            reflogStream = StreamingUtil.getReflogStream((NessieApiV1)api, builder -> (GetRefLogBuilder)builder.filter(String.format("reflog.operation == '%s' || reflog.operation == '%s'", "DELETE_REFERENCE", "ASSIGN_REFERENCE")), (OptionalInt)OptionalInt.empty());
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException(e);
        }
        reflogStream.forEach(entry -> {
            String hash;
            switch (entry.getOperation()) {
                case "DELETE_REFERENCE": {
                    hash = entry.getCommitHash();
                    break;
                }
                case "ASSIGN_REFERENCE": {
                    hash = (String)entry.getSourceHashes().get(0);
                    break;
                }
                default: {
                    throw new RuntimeException(entry.getOperation() + " operation found in dead reflog query");
                }
            }
            switch (entry.getRefType()) {
                case "Branch": {
                    droppedReferenceTimeMap.put(GCUtil.serializeReference((Reference)Branch.of((String)entry.getRefName(), (String)hash)), GCUtil.getInstantFromMicros(entry.getOperationTime()));
                    break;
                }
                case "Tag": {
                    droppedReferenceTimeMap.put(GCUtil.serializeReference((Reference)Tag.of((String)entry.getRefName(), (String)hash)), GCUtil.getInstantFromMicros(entry.getOperationTime()));
                    break;
                }
                default: {
                    throw new RuntimeException(entry.getRefType() + " type reference is found in dead reflog query");
                }
            }
        });
        return droppedReferenceTimeMap;
    }

    private static void getOrCreateEmptyBranch(NessieApiV1 api, String branchName) {
        try {
            api.getReference().refName(branchName).get();
        }
        catch (NessieNotFoundException e) {
            try {
                api.createReference().reference((Reference)Branch.of((String)branchName, null)).create();
            }
            catch (NessieConflictException | NessieNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

