/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.contents;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.gc.contents.LiveContentSetsRepository;
import org.projectnessie.gc.contents.spi.PersistenceSpi;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LiveContentSetsRepository", generator="Immutables")
@Immutable
public final class ImmutableLiveContentSetsRepository
extends LiveContentSetsRepository {
    private final PersistenceSpi persistenceSpi;
    private final Clock clock;
    private final Supplier<UUID> idGenerator;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLiveContentSetsRepository(Builder builder) {
        this.persistenceSpi = builder.persistenceSpi;
        if (builder.clock != null) {
            this.initShim.clock(builder.clock);
        }
        if (builder.idGenerator != null) {
            this.initShim.idGenerator(builder.idGenerator);
        }
        this.clock = this.initShim.clock();
        this.idGenerator = this.initShim.idGenerator();
        this.initShim = null;
    }

    private ImmutableLiveContentSetsRepository(PersistenceSpi persistenceSpi, Clock clock, Supplier<UUID> idGenerator) {
        this.persistenceSpi = persistenceSpi;
        this.clock = clock;
        this.idGenerator = idGenerator;
        this.initShim = null;
    }

    @Override
    PersistenceSpi persistenceSpi() {
        return this.persistenceSpi;
    }

    @Override
    Clock clock() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clock() : this.clock;
    }

    @Override
    Supplier<UUID> idGenerator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.idGenerator() : this.idGenerator;
    }

    public final ImmutableLiveContentSetsRepository withPersistenceSpi(PersistenceSpi value) {
        if (this.persistenceSpi == value) {
            return this;
        }
        PersistenceSpi newValue = Objects.requireNonNull(value, "persistenceSpi");
        return new ImmutableLiveContentSetsRepository(newValue, this.clock, this.idGenerator);
    }

    public final ImmutableLiveContentSetsRepository withClock(Clock value) {
        if (this.clock == value) {
            return this;
        }
        Clock newValue = Objects.requireNonNull(value, "clock");
        return new ImmutableLiveContentSetsRepository(this.persistenceSpi, newValue, this.idGenerator);
    }

    public final ImmutableLiveContentSetsRepository withIdGenerator(Supplier<UUID> value) {
        if (this.idGenerator == value) {
            return this;
        }
        Supplier<UUID> newValue = Objects.requireNonNull(value, "idGenerator");
        return new ImmutableLiveContentSetsRepository(this.persistenceSpi, this.clock, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLiveContentSetsRepository && this.equalTo(0, (ImmutableLiveContentSetsRepository)another);
    }

    private boolean equalTo(int synthetic, ImmutableLiveContentSetsRepository another) {
        return this.persistenceSpi.equals(another.persistenceSpi) && this.clock.equals(another.clock) && this.idGenerator.equals(another.idGenerator);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.persistenceSpi.hashCode();
        h += (h << 5) + this.clock.hashCode();
        h += (h << 5) + this.idGenerator.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LiveContentSetsRepository").omitNullValues().add("persistenceSpi", (Object)this.persistenceSpi).add("clock", (Object)this.clock).add("idGenerator", this.idGenerator).toString();
    }

    public static ImmutableLiveContentSetsRepository copyOf(LiveContentSetsRepository instance) {
        if (instance instanceof ImmutableLiveContentSetsRepository) {
            return (ImmutableLiveContentSetsRepository)instance;
        }
        return ImmutableLiveContentSetsRepository.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LiveContentSetsRepository", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements LiveContentSetsRepository.Builder {
        private static final long INIT_BIT_PERSISTENCE_SPI = 1L;
        private long initBits = 1L;
        @Nullable
        private PersistenceSpi persistenceSpi;
        @Nullable
        private Clock clock;
        @Nullable
        private Supplier<UUID> idGenerator;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LiveContentSetsRepository instance) {
            Objects.requireNonNull(instance, "instance");
            this.persistenceSpi(instance.persistenceSpi());
            this.clock(instance.clock());
            this.idGenerator(instance.idGenerator());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder persistenceSpi(PersistenceSpi persistenceSpi) {
            this.persistenceSpi = Objects.requireNonNull(persistenceSpi, "persistenceSpi");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock, "clock");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder idGenerator(Supplier<UUID> idGenerator) {
            this.idGenerator = Objects.requireNonNull(idGenerator, "idGenerator");
            return this;
        }

        @Override
        public ImmutableLiveContentSetsRepository build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLiveContentSetsRepository(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("persistenceSpi");
            }
            return "Cannot build LiveContentSetsRepository, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="LiveContentSetsRepository", generator="Immutables")
    private final class InitShim {
        private byte clockBuildStage = 0;
        private Clock clock;
        private byte idGeneratorBuildStage = 0;
        private Supplier<UUID> idGenerator;

        private InitShim() {
        }

        Clock clock() {
            if (this.clockBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clockBuildStage == 0) {
                this.clockBuildStage = (byte)-1;
                this.clock = Objects.requireNonNull(ImmutableLiveContentSetsRepository.super.clock(), "clock");
                this.clockBuildStage = 1;
            }
            return this.clock;
        }

        void clock(Clock clock) {
            this.clock = clock;
            this.clockBuildStage = 1;
        }

        Supplier<UUID> idGenerator() {
            if (this.idGeneratorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idGeneratorBuildStage == 0) {
                this.idGeneratorBuildStage = (byte)-1;
                this.idGenerator = Objects.requireNonNull(ImmutableLiveContentSetsRepository.super.idGenerator(), "idGenerator");
                this.idGeneratorBuildStage = 1;
            }
            return this.idGenerator;
        }

        void idGenerator(Supplier<UUID> idGenerator) {
            this.idGenerator = idGenerator;
            this.idGeneratorBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.clockBuildStage == -1) {
                attributes.add("clock");
            }
            if (this.idGeneratorBuildStage == -1) {
                attributes.add("idGenerator");
            }
            return "Cannot build LiveContentSetsRepository, attribute initializers form cycle " + attributes;
        }
    }
}

