/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.expire;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.PrimitiveSink;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.MustBeClosed;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.projectnessie.gc.contents.ContentReference;
import org.projectnessie.gc.expire.ExpireParameters;
import org.projectnessie.gc.expire.ImmutablePerContentDeleteExpired;
import org.projectnessie.gc.files.DeleteSummary;
import org.projectnessie.gc.files.FileReference;
import org.projectnessie.gc.files.NessieFileIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class PerContentDeleteExpired {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerContentDeleteExpired.class);

    public static Builder builder() {
        return ImmutablePerContentDeleteExpired.builder();
    }

    public DeleteSummary expire() {
        BloomFilter<URI> filter = this.createBloomFilter();
        HashSet<URI> baseLocations = new HashSet<URI>();
        Consumer<URI> addBaseLocation = l -> {
            Set set = baseLocations;
            synchronized (set) {
                if (baseLocations.add((URI)l)) {
                    LOGGER.debug("live-set#{} content#{}: Identified base location {}", new Object[]{this.expireParameters().liveContentSet().id(), this.contentId(), l});
                }
            }
        };
        long identifiedLiveFiles = this.identifyLiveFiles(filter, addBaseLocation);
        double expectedFpp = filter.expectedFpp();
        long approximateElementCount = filter.approximateElementCount();
        if (filter.expectedFpp() > this.expireParameters().allowedFalsePositiveProbability()) {
            LOGGER.warn("live-set#{} content#{}: Aborting expire - expected FPP {} is higher than the allowed FPP {}. Approximate files count is {}, expected is {}, real is {} live (probably less).", new Object[]{this.expireParameters().liveContentSet().id(), this.contentId(), expectedFpp, this.expireParameters().allowedFalsePositiveProbability(), approximateElementCount, this.expireParameters().expectedFileCount(), identifiedLiveFiles});
            return DeleteSummary.EMPTY;
        }
        this.expireParameters().liveContentSet().associateBaseLocations(this.contentId(), baseLocations);
        return baseLocations.stream().map(baseLocation -> {
            DeleteSummary deleteSummary;
            block8: {
                Stream<FileReference> fileObjects = this.identifyExpiredFiles(filter, (URI)baseLocation);
                try {
                    deleteSummary = this.expireParameters().fileDeleter().deleteMultiple((URI)baseLocation, fileObjects);
                    if (fileObjects == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (fileObjects != null) {
                            try {
                                fileObjects.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NessieFileIOException e) {
                        throw new RuntimeException(e);
                    }
                }
                fileObjects.close();
            }
            return deleteSummary;
        }).reduce(DeleteSummary.EMPTY, DeleteSummary::add, DeleteSummary::add);
    }

    private long identifyLiveFiles(BloomFilter<URI> filter, Consumer<URI> addBaseLocation) {
        long liveFileCount;
        LOGGER.debug("live-set#{} content#{}: Start collecting files and base locations, max file modification time: {}.", new Object[]{this.expireParameters().liveContentSet().id(), this.contentId(), this.expireParameters().maxFileModificationTime()});
        try (Stream contents = this.expireParameters().liveContentSet().fetchContentReferences(this.contentId()).flatMap(c -> {
            Stream<FileReference> r = this.expireParameters().contentToFiles().extractFiles((ContentReference)c);
            return r;
        });){
            liveFileCount = contents.peek(f -> addBaseLocation.accept(f.base())).map(FileReference::path).peek(arg_0 -> filter.put(arg_0)).count();
        }
        LOGGER.debug("live-set#{} content#{}: Identified {} live files (configured: {}), with an expected false-positive-probability of {} (configured: {}).", new Object[]{this.expireParameters().liveContentSet().id(), this.contentId(), liveFileCount, this.expireParameters().expectedFileCount(), filter.expectedFpp(), this.expireParameters().falsePositiveProbability()});
        return liveFileCount;
    }

    @MustBeClosed
    private Stream<FileReference> identifyExpiredFiles(BloomFilter<URI> filter, URI baseLocation) throws NessieFileIOException {
        ExpireStats expireStats = new ExpireStats();
        long maxFileTime = this.expireParameters().maxFileModificationTime().toEpochMilli();
        LOGGER.debug("live-set#{} content#{}: Start walking base location {}.", new Object[]{this.expireParameters().liveContentSet().id(), this.contentId(), baseLocation});
        Stream<FileReference> list = this.expireParameters().filesLister().listRecursively(baseLocation);
        return (Stream)list.filter(f -> {
            ++expireStats.totalFiles;
            if (filter.mightContain((Object)f.path())) {
                ++expireStats.liveFiles;
                return false;
            }
            if (f.modificationTimeMillisEpoch() > maxFileTime) {
                ++expireStats.newFiles;
                return false;
            }
            ++expireStats.expiredFiles;
            return true;
        }).onClose(() -> LOGGER.info("live-set#{} content#{}: Found {} total files in base location {}, {} files considered expired, {} files considered live, {} files are newer than max-file-modification-time.", new Object[]{this.expireParameters().liveContentSet().id(), this.contentId(), expireStats.totalFiles, baseLocation, expireStats.expiredFiles, expireStats.liveFiles, expireStats.newFiles}));
    }

    BloomFilter<URI> createBloomFilter() {
        return BloomFilter.create(PerContentDeleteExpired::funnel, (long)this.expireParameters().expectedFileCount(), (double)this.expireParameters().falsePositiveProbability());
    }

    private static void funnel(URI uri, PrimitiveSink sink) {
        PerContentDeleteExpired.funnelString(uri.getScheme(), sink);
        PerContentDeleteExpired.funnelString(uri.getHost(), sink);
        int port = uri.getPort();
        if (port != 0) {
            sink.putInt(uri.getPort());
        }
        PerContentDeleteExpired.funnelString(uri.getRawPath(), sink);
    }

    private static void funnelString(String s, PrimitiveSink sink) {
        if (s != null) {
            sink.putUnencodedChars((CharSequence)s);
        }
    }

    abstract ExpireParameters expireParameters();

    abstract String contentId();

    private static final class ExpireStats {
        long totalFiles = 0L;
        long expiredFiles = 0L;
        long liveFiles = 0L;
        long newFiles = 0L;

        private ExpireStats() {
        }
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder expireParameters(ExpireParameters var1);

        @CanIgnoreReturnValue
        public Builder contentId(String var1);

        public PerContentDeleteExpired build();
    }
}

