/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.gc.identify;

import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.projectnessie.gc.identify.CutoffPolicy;

final class NumCommitsCutoffPolicy
implements CutoffPolicy {
    private final int commits;

    NumCommitsCutoffPolicy(int commits) {
        this.commits = commits;
    }

    @Override
    public boolean isCutoff(@Nonnull Instant commitTime, int numCommits) {
        return numCommits >= this.commits;
    }

    public String toString() {
        return "cutoff after " + this.commits + " commits";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumCommitsCutoffPolicy)) {
            return false;
        }
        NumCommitsCutoffPolicy that = (NumCommitsCutoffPolicy)o;
        return this.commits == that.commits;
    }

    public int hashCode() {
        return Objects.hash(this.commits);
    }
}

